#include "stdafx.h"
#include "Emu/Cell/PPUModule.h"
#include "Emu/IdManager.h"

#include "cellHttpUtil.h"
#include "cellHttp.h"
#include "cellSsl.h"

LOG_CHANNEL(cellHttp);

template<>
void fmt_class_string<CellHttpError>::format(std::string& out, u64 arg)
{
	format_enum(out, arg, [](auto error)
	{
		switch (error)
		{
			STR_CASE(CELL_HTTP_ERROR_ALREADY_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_NOT_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_NO_MEMORY);
			STR_CASE(CELL_HTTP_ERROR_NO_BUFFER);
			STR_CASE(CELL_HTTP_ERROR_NO_STRING);
			STR_CASE(CELL_HTTP_ERROR_INSUFFICIENT);
			STR_CASE(CELL_HTTP_ERROR_INVALID_URI);
			STR_CASE(CELL_HTTP_ERROR_INVALID_HEADER);
			STR_CASE(CELL_HTTP_ERROR_BAD_METHOD);
			STR_CASE(CELL_HTTP_ERROR_BAD_CLIENT);
			STR_CASE(CELL_HTTP_ERROR_BAD_TRANS);
			STR_CASE(CELL_HTTP_ERROR_NO_CONNECTION);
			STR_CASE(CELL_HTTP_ERROR_NO_REQUEST_SENT);
			STR_CASE(CELL_HTTP_ERROR_ALREADY_BUILT);
			STR_CASE(CELL_HTTP_ERROR_ALREADY_SENT);
			STR_CASE(CELL_HTTP_ERROR_NO_HEADER);
			STR_CASE(CELL_HTTP_ERROR_NO_CONTENT_LENGTH);
			STR_CASE(CELL_HTTP_ERROR_TOO_MANY_REDIRECTS);
			STR_CASE(CELL_HTTP_ERROR_TOO_MANY_AUTHS);
			STR_CASE(CELL_HTTP_ERROR_TRANS_NO_CONNECTION);
			STR_CASE(CELL_HTTP_ERROR_CB_FAILED);
			STR_CASE(CELL_HTTP_ERROR_NOT_PIPED);
			STR_CASE(CELL_HTTP_ERROR_OUT_OF_ORDER_PIPE);
			STR_CASE(CELL_HTTP_ERROR_TRANS_ABORTED);
			STR_CASE(CELL_HTTP_ERROR_BROKEN_PIPELINE);
			STR_CASE(CELL_HTTP_ERROR_UNAVAILABLE);
			STR_CASE(CELL_HTTP_ERROR_INVALID_VALUE);
			STR_CASE(CELL_HTTP_ERROR_CANNOT_AUTHENTICATE);
			STR_CASE(CELL_HTTP_ERROR_COOKIE_NOT_FOUND);
			STR_CASE(CELL_HTTP_ERROR_COOKIE_INVALID_DOMAIN);
			STR_CASE(CELL_HTTP_ERROR_CACHE_ALREADY_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_LINE_EXCEEDS_MAX);
			STR_CASE(CELL_HTTP_ERROR_REQUIRES_BASIC_AUTH);
			STR_CASE(CELL_HTTP_ERROR_UNKNOWN);
			STR_CASE(CELL_HTTP_ERROR_INTERNAL);
			STR_CASE(CELL_HTTP_ERROR_NONREMOVABLE);
			STR_CASE(CELL_HTTP_ERROR_BAD_CONN);
			STR_CASE(CELL_HTTP_ERROR_BAD_MAN);
			STR_CASE(CELL_HTTP_ERROR_NO_POOL);
			STR_CASE(CELL_HTTP_ERROR_NO_REQUEST);
			STR_CASE(CELL_HTTP_ERROR_LOCK_FAILED);
			STR_CASE(CELL_HTTP_ERROR_INVALID_DATA);
			STR_CASE(CELL_HTTP_ERROR_BROKEN_CHUNK);
			STR_CASE(CELL_HTTP_ERROR_DECODE_SETUP);
			STR_CASE(CELL_HTTP_ERROR_DECODE_STREAM);
			STR_CASE(CELL_HTTP_ERROR_BROKEN_DECODE_STREAM);
			STR_CASE(CELL_HTTP_ERROR_INVALID_DCACHE_PATH);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_ALREADY_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_NOT_INITIALIZED);
			STR_CASE(CELL_HTTP_ERROR_TOO_MANY_DCACHE_ENTRY);
			STR_CASE(CELL_HTTP_ERROR_DUP_DCACHE_ENTRY);
			STR_CASE(CELL_HTTP_ERROR_WRITE_DCACHE);
			STR_CASE(CELL_HTTP_ERROR_READ_DCACHE);
			STR_CASE(CELL_HTTP_ERROR_CACHE_TOO_LARGE);
			STR_CASE(CELL_HTTP_ERROR_INVALID_DCACHE_VERSION);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_FILE_BROKEN);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_EXCEEDS_MAX);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_BUSY);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_INDEX_BROKEN);
			STR_CASE(CELL_HTTP_ERROR_INVALID_DCACHE_INDEX_NODE);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_FILE_INCONSISTENCY);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_URI_TOO_LONG);
			STR_CASE(CELL_HTTP_ERROR_READ_DCACHE_EOF);
			STR_CASE(CELL_HTTP_ERROR_END_OF_DCACHE_INDEX_NODE);
			STR_CASE(CELL_HTTP_ERROR_NO_CACHE_MEMORY);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_BROKEN);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_TOO_MANY_WRITE);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_TOO_MANY_READ);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_FATAL);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_UNSUPPORTED_FEATURE);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_INDEX_IS_ALREADY_OPEN);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_INDEX_IS_OPENING);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_UNKNOWN);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_INDEX_IS_CLOSED);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_ABORTED);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_INDEX_IS_CLOSING);
			STR_CASE(CELL_HTTP_ERROR_DCACHE_UNKNOWN_INDEX_STATE);
			STR_CASE(CELL_HTTP_ERROR_NET_FIN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_TIMEOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_TIMEOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_TIMEOUT);
		}

		return unknown;
	});
}

template<>
void fmt_class_string<CellHttpsError>::format(std::string& out, u64 arg)
{
	format_enum(out, arg, [](auto error)
	{
		switch (error)
		{
			STR_CASE(CELL_HTTPS_ERROR_CERTIFICATE_LOAD);
			STR_CASE(CELL_HTTPS_ERROR_BAD_MEMORY);
			STR_CASE(CELL_HTTPS_ERROR_CONTEXT_CREATION);
			STR_CASE(CELL_HTTPS_ERROR_CONNECTION_CREATION);
			STR_CASE(CELL_HTTPS_ERROR_SOCKET_ASSOCIATION);
			STR_CASE(CELL_HTTPS_ERROR_HANDSHAKE);
			STR_CASE(CELL_HTTPS_ERROR_LOOKUP_CERTIFICATE);
			STR_CASE(CELL_HTTPS_ERROR_NO_SSL);
			STR_CASE(CELL_HTTPS_ERROR_KEY_LOAD);
			STR_CASE(CELL_HTTPS_ERROR_CERT_KEY_MISMATCH);
			STR_CASE(CELL_HTTPS_ERROR_KEY_NEEDS_CERT);
			STR_CASE(CELL_HTTPS_ERROR_CERT_NEEDS_KEY);
			STR_CASE(CELL_HTTPS_ERROR_RETRY_CONNECTION);
			STR_CASE(CELL_HTTPS_ERROR_NET_SSL_CONNECT);
			STR_CASE(CELL_HTTPS_ERROR_NET_SSL_SEND);
			STR_CASE(CELL_HTTPS_ERROR_NET_SSL_RECV);
		}

		return unknown;
	});
}

template<>
void fmt_class_string<CellHttpErrorNet>::format(std::string& out, u64 arg)
{
	format_enum(out, arg, [](auto error)
	{
		switch (error)
		{
			STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_NETDB_INTERNAL);
			STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_HOST_NOT_FOUND);
			STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_TRY_AGAIN);
			STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_NO_RECOVERY);
			STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_NO_DATA);
			//STR_CASE(CELL_HTTP_ERROR_NET_RESOLVER_NO_ADDRESS);

			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_ABORT_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_OPTION_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SOCKET_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_CONNECT_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SEND_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SEND_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_RECV_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_RECV_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SELECT_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_SEND_ETIME);

			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPERM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOENT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ESRCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EINTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENXIO);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_E2BIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOEXC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EBADF);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ECHILD);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EDEADLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOMEM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EACCES);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EFAULT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTBLK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EBUSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EEXIST);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EXDEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENODEV);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EISDIR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EINVAL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EMFILE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ETXTBSY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EFBIG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOSPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ESPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EROFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EMLINK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPIPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EDOM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ERANGE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EAGAIN);
			//STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EWOULDBLOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EINPROGRESS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EALREADY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSOCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EDESTADDRREQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EMSGSIZE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROTOTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOPROTOOPT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROTONOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ESOCKTNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EOPNOTSUPP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EAFNOSUPPORT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EADDRINUSE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EADDRNOTAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENETDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENETUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENETRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ECONNABORTED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ECONNRESET);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOBUFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EISCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTCONN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ESHUTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ETOOMANYREFS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ETIMEDOUT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ECONNREFUSED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ELOOP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENAMETOOLONG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTDOWN);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTUNREACH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTEMPTY);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROCLIM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EUSERS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EDQUOT);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ESTALE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EREMOTE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EBADRPC);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ERPCMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROGUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROGMISMATCH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EPROCUNAVAIL);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOLCK);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOSYS);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EFTYPE);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENEEDAUTH);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EIDRM);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EOVERFLOW);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EILSEQ);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSUP);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ECANCELED);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_EBADMSG);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENODATA);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOSR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ENOSTR);
			STR_CASE(CELL_HTTP_ERROR_NET_SSL_RECV_ETIME);
		}

		return unknown;
	});
}

error_code cellHttpAuthCacheExport(vm::ptr<u32> buf, u32 len, vm::ptr<u32> outsize)
{
	cellHttp.todo("cellHttpAuthCacheExport(buf=*0x%x, len=%d, outsize=*0x%x)", buf, len, outsize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (!buf)
	{
		if (!outsize)
		{
			return CELL_HTTP_ERROR_NO_BUFFER;
		}
	}
	else
	{
		if (len < 9)
		{
			return CELL_HTTP_ERROR_INSUFFICIENT;
		}

		// TODO
	}

	[[maybe_unused]] u32 size = 0;

	// TODO

	if (outsize)
	{
		*outsize = 0;
	}

	return CELL_OK;
}

error_code cellHttpAuthCacheFlush()
{
	cellHttp.todo("cellHttpAuthCacheFlush()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpAuthCacheGetEntryMax(u32 unk_ptr)
{
	cellHttp.todo("cellHttpAuthCacheGetEntryMax(unk_ptr=*0x%x)", unk_ptr);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (!unk_ptr)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpAuthCacheImport(vm::ptr<char> unk1, u32 unk2)
{
	cellHttp.todo("cellHttpAuthCacheImport(unk1=*0x%x, unk2=0x%x)", unk1, unk2);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (!unk1 || !unk2)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	if (unk2 < 9)
	{
		return CELL_HTTP_ERROR_INSUFFICIENT;
	}

	if (unk1[0] != '\x01')
	{
		return CELL_HTTP_ERROR_INVALID_DATA;
	}

	return CELL_OK;
}

error_code cellHttpAuthCacheSetEntryMax(u32 unk)
{
	cellHttp.todo("cellHttpAuthCacheSetEntryMax(unk=0x%x)", unk);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpInit(vm::ptr<void> pool, u32 poolSize)
{
	cellHttp.notice("cellHttpInit(pool=*0x%x, poolSize=0x%x)", pool, poolSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (man.initialized)
	{
		return CELL_HTTP_ERROR_ALREADY_INITIALIZED;
	}

	if (!pool || !poolSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	man.initialized = true;
	return CELL_OK;
}

error_code cellHttpEnd()
{
	cellHttp.notice("cellHttpEnd()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	man.initialized = false;
	return CELL_OK;
}

error_code cellHttpsInit(u32 caCertNum, vm::cptr<CellHttpsData> caList)
{
	cellHttp.todo("cellHttpsInit(caCertNum=0x%x, caList=*0x%x)", caCertNum, caList);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (man.https_initialized)
	{
		return CELL_HTTP_ERROR_ALREADY_INITIALIZED;
	}

	man.https_initialized = true;
	return CELL_OK;
}

error_code cellHttpsEnd()
{
	cellHttp.todo("cellHttpsEnd()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.https_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (!_cellSslIsInitd())
	{
		return CELL_SSL_ERROR_NOT_INITIALIZED;
	}

	man.https_initialized = false;

	return CELL_OK;
}

error_code cellHttpSetProxy(vm::cptr<CellHttpUri> proxy)
{
	cellHttp.todo("cellHttpSetProxy(proxy=*0x%x)", proxy);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (proxy)
	{
		if (!proxy->hostname || !proxy->hostname[0])
		{
			return CELL_HTTP_ERROR_INVALID_URI;
		}
	}

	return CELL_OK;
}

error_code cellHttpGetCookie(vm::ptr<void> buf)
{
	cellHttp.todo("cellHttpGetCookie(buf=*0x%x)", buf);

	if (!buf)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_COOKIE_NOT_FOUND;
	}

	return CELL_OK;
}

error_code cellHttpGetProxy(vm::ptr<CellHttpUri> proxy, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpGetProxy(proxy=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", proxy, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	//if (todo)
	//{
	//	return cellHttpUtilCopyUri(proxy, some CellHttpUri, pool, poolSize, required);
	//}

	if (required)
	{
		*required = 0;
	}

	return CELL_OK;
}

error_code cellHttpInitCookie(vm::ptr<void> pool, u32 poolSize)
{
	cellHttp.todo("cellHttpInitCookie(pool=*0x%x, poolSize=0x%x)", pool, poolSize);

	if (!pool || !poolSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_ALREADY_INITIALIZED;
	}

	man.cookie_initialized = true;
	return CELL_OK;
}

error_code cellHttpEndCookie()
{
	cellHttp.todo("cellHttpEndCookie()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	man.cookie_initialized = false;
	return CELL_OK;
}

error_code cellHttpAddCookieWithClientId(vm::cptr<CellHttpUri> uri, vm::cptr<char> cookie, CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpAddCookieWithClientId(uri=*0x%x, cookie=%s, clientId=0x%x)", uri, cookie, clientId);

	if (!uri)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	if (!cookie || !uri->hostname || !uri->path)
	{
		return CELL_HTTP_ERROR_NO_STRING;
	}

	return CELL_OK;
}

error_code cellHttpSessionCookieFlush(CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpSessionCookieFlush(clientId=0x%x)", clientId);
	return CELL_OK;
}

error_code cellHttpCookieExport(vm::ptr<void> buffer, u32 size, vm::ptr<u32> exportSize)
{
	cellHttp.todo("cellHttpCookieExport(buffer=*0x%x, size=0x%x, exportSize=*0x%x)", buffer, size, exportSize);

	if (buffer && size < 0x14)
	{
		return CELL_HTTP_ERROR_INSUFFICIENT;
	}

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpCookieExportWithClientId(vm::ptr<void> buffer, u32 size, vm::ptr<u32> exportSize, CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpCookieExportWithClientId(buffer=*0x%x, size=0x%x, exportSize=*0x%x, clientId=0x%x)", buffer, size, exportSize, clientId);

	if (buffer && size < 0x14)
	{
		return CELL_HTTP_ERROR_INSUFFICIENT;
	}

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpCookieFlush()
{
	cellHttp.todo("cellHttpCookieFlush()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpCookieImport(vm::cptr<void> buffer, u32 size)
{
	cellHttp.todo("cellHttpCookieImport(buffer=*0x%x, size=0x%x)", buffer, size);

	if (error_code error = cellHttpCookieFlush())
	{
		cellHttp.error("cellHttpCookieImport: cellHttpCookieFlush returned 0x%x", +error);
		// No return
	}

	return CELL_OK;
}

error_code cellHttpCookieImportWithClientId(vm::cptr<void> buffer, u32 size, CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpCookieImportWithClientId(buffer=*0x%x, size=0x%x, clientId=0x%x)", buffer, size, clientId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cookie_initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpClientSetCookieSendCallback(CellHttpClientId clientId, vm::ptr<CellHttpCookieSendCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetCookieSendCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetCookieRecvCallback(CellHttpClientId clientId, vm::ptr<CellHttpsSslCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetCookieRecvCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpCreateClient(vm::ptr<CellHttpClientId> clientId)
{
	cellHttp.todo("cellHttpCreateClient(clientId=*0x%x)", clientId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (!clientId)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpDestroyClient(CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpDestroyClient(clientId=0x%x)", clientId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetAuthenticationCallback(CellHttpClientId clientId, vm::ptr<CellHttpAuthenticationCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetAuthenticationCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetCacheStatus(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetCacheStatus(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetTransactionStateCallback(CellHttpClientId clientId, vm::ptr<CellHttpTransactionStateCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetTransactionStateCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetRedirectCallback(CellHttpClientId clientId, vm::ptr<CellHttpRedirectCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetRedirectCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetProxy(CellHttpClientId clientId, vm::cptr<CellHttpUri> proxy)
{
	cellHttp.todo("cellHttpClientSetProxy(clientId=0x%x, proxy=*0x%x)", clientId, proxy);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (proxy)
	{
		if (!proxy->hostname || !proxy->hostname[0])
		{
			return CELL_HTTP_ERROR_INVALID_URI;
		}
	}

	return CELL_OK;
}

error_code cellHttpClientGetProxy(CellHttpClientId clientId, vm::ptr<CellHttpUri> proxy, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpClientGetProxy(clientId=0x%x, proxy=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", clientId, proxy, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetVersion(CellHttpClientId clientId, u32 major, u32 minor)
{
	cellHttp.todo("cellHttpClientSetPipeline(clientId=0x%x, major=0x%x, minor=0x%x)", clientId, major, minor);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetVersion(CellHttpClientId clientId, vm::ptr<u32> major, vm::ptr<u32> minor)
{
	cellHttp.todo("cellHttpClientGetVersion(clientId=0x%x, major=*0x%x, minor=*0x%x)", clientId, major, minor);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!major || !minor)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetPipeline(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetPipeline(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetPipeline(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetPipeline(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetKeepAlive(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetKeepAlive(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetKeepAlive(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetKeepAlive(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetAutoRedirect(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetAutoRedirect(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetAutoRedirect(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetAutoRedirect(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetAutoAuthentication(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetAutoAuthentication(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetAutoAuthentication(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetAutoAuthentication(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetAuthenticationCacheStatus(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetAuthenticationCacheStatus(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetAuthenticationCacheStatus(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetAuthenticationCacheStatus(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetCookieStatus(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetCookieStatus(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetCookieStatus(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetCookieStatus(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetUserAgent(CellHttpClientId clientId, vm::cptr<char> userAgent)
{
	cellHttp.todo("cellHttpClientSetUserAgent(clientId=0x%x, userAgent=%s)", clientId, userAgent);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!userAgent)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientGetUserAgent(CellHttpClientId clientId, vm::ptr<char> userAgent, u32 size, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpClientGetUserAgent(clientId=0x%x, userAgent=*0x%x, size=%d, required=*0x%x)", clientId, size, userAgent, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!userAgent || !size)
	{
		if (!required)
		{
			return CELL_HTTP_ERROR_NO_BUFFER;
		}
	}

	return CELL_OK;
}

error_code cellHttpClientSetResponseBufferMax(CellHttpClientId clientId, u32 max)
{
	cellHttp.todo("cellHttpClientSetResponseBufferMax(clientId=0x%x, max=%d)", clientId, max);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (max < 1500)
	{
		max = 1500;
	}

	return CELL_OK;
}

error_code cellHttpClientGetResponseBufferMax(CellHttpClientId clientId, vm::ptr<u32> max)
{
	cellHttp.todo("cellHttpClientGetResponseBufferMax(clientId=0x%x, max=*0x%x)", clientId, max);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!max)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientCloseAllConnections(CellHttpClientId clientId)
{
	cellHttp.todo("cellHttpClientCloseAllConnections(clientId=0x%x)", clientId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientCloseConnections(CellHttpClientId clientId, vm::cptr<CellHttpUri> uri)
{
	cellHttp.todo("cellHttpClientCloseConnections(clientId=0x%x, uri=*0x%x)", clientId, uri);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientPollConnections(CellHttpClientId clientId, vm::ptr<CellHttpTransId> transId, s64 usec)
{
	cellHttp.todo("cellHttpClientPollConnections(clientId=0x%x, transId=*0x%x, usec=%d)", clientId, transId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetConnectionStateCallback(CellHttpClientId clientId, vm::ptr<void> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetConnectionStateCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetConnectionWaitStatus(CellHttpClientId clientId, b8 enable)
{
	cellHttp.todo("cellHttpClientSetConnectionWaitStatus(clientId=0x%x, enable=%d)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetConnectionWaitStatus(CellHttpClientId clientId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpClientGetConnectionWaitStatus(clientId=0x%x, enable=*0x%x)", clientId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetConnectionWaitTimeout(CellHttpClientId clientId, s64 usec)
{
	cellHttp.todo("cellHttpClientSetConnectionWaitTimeout(clientId=0x%x, usec=%d)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetConnectionWaitTimeout(CellHttpClientId clientId, vm::ptr<s64> usec)
{
	cellHttp.todo("cellHttpClientGetConnectionWaitTimeout(clientId=0x%x, usec=*0x%x)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!usec)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetRecvTimeout(CellHttpClientId clientId, s64 usec)
{
	cellHttp.todo("cellHttpClientSetRecvTimeout(clientId=0x%x, usec=%d)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetRecvTimeout(CellHttpClientId clientId, vm::ptr<s64> usec)
{
	cellHttp.todo("cellHttpClientGetRecvTimeout(clientId=0x%x, usec=*0x%x)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!usec) // TODO
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSendTimeout(CellHttpClientId clientId, s64 usec)
{
	cellHttp.todo("cellHttpClientSetSendTimeout(clientId=0x%x, usec=%d)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetSendTimeout(CellHttpClientId clientId, vm::ptr<s64> usec)
{
	cellHttp.todo("cellHttpClientGetSendTimeout(clientId=0x%x, usec=*0x%x)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!usec) // TODO
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetConnTimeout(CellHttpClientId clientId, s64 usec)
{
	cellHttp.todo("cellHttpClientSetConnTimeout(clientId=0x%x, usec=%d)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetConnTimeout(CellHttpClientId clientId, vm::ptr<s64> usec)
{
	cellHttp.todo("cellHttpClientGetConnTimeout(clientId=0x%x, usec=*0x%x)", clientId, usec);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!usec)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetTotalPoolSize(CellHttpClientId clientId, u32 poolSize)
{
	cellHttp.todo("cellHttpClientSetTotalPoolSize(clientId=0x%x, poolSize=%d)", clientId, poolSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetTotalPoolSize(CellHttpClientId clientId, vm::ptr<u32> poolSize)
{
	cellHttp.todo("cellHttpClientGetTotalPoolSize(clientId=0x%x, poolSize=*0x%x)", clientId, poolSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!poolSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetPerHostPoolSize(CellHttpClientId clientId, u32 poolSize)
{
	cellHttp.todo("cellHttpClientSetPerHostPoolSize(clientId=0x%x, poolSize=%d)", clientId, poolSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetPerHostPoolSize(CellHttpClientId clientId, vm::ptr<u32> poolSize)
{
	cellHttp.todo("cellHttpClientGetPerHostPoolSize(clientId=0x%x, poolSize=*0x%x)", clientId, poolSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!poolSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetPerHostKeepAliveMax(CellHttpClientId clientId, u32 maxSize)
{
	cellHttp.todo("cellHttpClientSetPerHostKeepAliveMax(clientId=0x%x, maxSize=%d)", clientId, maxSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetPerHostKeepAliveMax(CellHttpClientId clientId, vm::ptr<u32> maxSize)
{
	cellHttp.todo("cellHttpClientGetPerHostKeepAliveMax(clientId=0x%x, maxSize=*0x%x)", clientId, maxSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!maxSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetPerPipelineMax(CellHttpClientId clientId, u32 pipeMax)
{
	cellHttp.todo("cellHttpClientSetPerPipelineMax(clientId=0x%x, pipeMax=%d)", clientId, pipeMax);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetPerPipelineMax(CellHttpClientId clientId, vm::ptr<u32> pipeMax)
{
	cellHttp.todo("cellHttpClientGetPerPipelineMax(clientId=0x%x, pipeMax=*0x%x)", clientId, pipeMax);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!pipeMax)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetRecvBufferSize(CellHttpClientId clientId, s32 size)
{
	cellHttp.todo("cellHttpClientSetRecvBufferSize(clientId=0x%x, size=%d)", clientId, size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetRecvBufferSize(CellHttpClientId clientId, vm::ptr<s32> size)
{
	cellHttp.todo("cellHttpClientGetRecvBufferSize(clientId=0x%x, size=*0x%x)", clientId, size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!size)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSendBufferSize(CellHttpClientId clientId, s32 size)
{
	cellHttp.todo("cellHttpClientSetSendBufferSize(clientId=0x%x, size=%d)", clientId, size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetSendBufferSize(CellHttpClientId clientId, vm::ptr<s32> size)
{
	cellHttp.todo("cellHttpClientGetSendBufferSize(clientId=0x%x, size=*0x%x)", clientId, size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!size)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientGetAllHeaders(CellHttpClientId clientId, vm::pptr<CellHttpHeader> headers, vm::ptr<u32> items, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpClientGetAllHeaders(clientId=0x%x, headers=*0x%x, items=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", clientId, headers, items, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if ((!pool || !headers) && !required)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetHeader(CellHttpClientId clientId, vm::cptr<CellHttpHeader> header)
{
	cellHttp.todo("cellHttpClientSetHeader(clientId=0x%x, header=*0x%x)", clientId, header);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!header)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientGetHeader(CellHttpClientId clientId, vm::ptr<CellHttpHeader> header, vm::cptr<char> name, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpClientGetHeader(clientId=0x%x, header=*0x%x, name=%s, pool=*0x%x, poolSize=0x%x, required=*0x%x)", clientId, header, name, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!name)
	{
		return CELL_HTTP_ERROR_NO_STRING;
	}

	return CELL_OK;
}

error_code cellHttpClientAddHeader(CellHttpClientId clientId, vm::cptr<CellHttpHeader> header)
{
	cellHttp.todo("cellHttpClientAddHeader(clientId=0x%x, header=*0x%x)", clientId, header);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientDeleteHeader(CellHttpClientId clientId, vm::cptr<char> name)
{
	cellHttp.todo("cellHttpClientDeleteHeader(clientId=0x%x, name=%s)", clientId, name);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSslCallback(CellHttpClientId clientId, vm::ptr<CellHttpsSslCallback> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetSslCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSslClientCertificate(CellHttpClientId clientId, vm::cptr<CellHttpsData> cert, vm::cptr<CellHttpsData> privKey)
{
	cellHttp.todo("cellHttpClientSetSslClientCertificate(clientId=0x%x, cert=*0x%x, privKey=*0x%x)", clientId, cert, privKey);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!cert && privKey)
	{
		return CELL_HTTPS_ERROR_KEY_NEEDS_CERT;
	}

	if (cert && !privKey)
	{
		return CELL_HTTPS_ERROR_CERT_NEEDS_KEY;
	}

	return CELL_OK;
}

error_code cellHttpCreateTransaction(vm::ptr<CellHttpTransId> transId, CellHttpClientId clientId, vm::cptr<char> method, vm::cptr<CellHttpUri> uri)
{
	cellHttp.todo("cellHttpCreateTransaction(transId=*0x%x, clientId=0x%x, method=%s, uri=*0x%x)", transId, clientId, method, uri);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	//if (error_code error = syscall_sys_memory_get_page_attribute(clientId))
	//{
	//	return error;
	//}

	if (!uri || !uri->hostname || !uri->hostname[0])
	{
		return CELL_HTTP_ERROR_INVALID_URI;
	}

	return CELL_OK;
}

error_code cellHttpDestroyTransaction(CellHttpTransId transId)
{
	cellHttp.todo("cellHttpDestroyTransaction(transId=0x%x)", transId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetUri(CellHttpTransId transId, vm::ptr<CellHttpUri> uri, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpTransactionGetUri(transId=0x%x, uri=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, uri, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionSetUri(CellHttpTransId transId, vm::cptr<CellHttpUri> uri) // TODO: more params?
{
	cellHttp.todo("cellHttpTransactionSetUri(transId=0x%x, uri=*0x%x)", transId, uri);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!uri || !uri->hostname || !uri->hostname[0])
	{
		return CELL_HTTP_ERROR_INVALID_URI;
	}

	if (uri->scheme && false) // TODO
	{
		return CELL_HTTP_ERROR_INVALID_URI;
	}

	return CELL_OK;
}

error_code cellHttpTransactionCloseConnection(CellHttpTransId transId)
{
	cellHttp.todo("cellHttpTransactionCloseConnection(transId=0x%x)", transId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionReleaseConnection(CellHttpTransId transId, vm::ptr<s32> sid)
{
	cellHttp.todo("cellHttpTransactionReleaseConnection(transId=0x%x, sid=*0x%x)", transId, sid);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!sid)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpTransactionAbortConnection(CellHttpTransId transId)
{
	cellHttp.todo("cellHttpTransactionAbortConnection(transId=0x%x)", transId);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpSendRequest(CellHttpTransId transId, vm::cptr<char> buf, u32 size, vm::ptr<u32> sent)
{
	cellHttp.todo("cellHttpSendRequest(transId=0x%x, buf=*0x%x, size=0x%x, sent=*0x%x)", transId, buf, size, sent);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpRequestSetContentLength(CellHttpTransId transId, u64 totalSize)
{
	cellHttp.todo("cellHttpRequestSetContentLength(transId=0x%x, totalSize=0x%x)", transId, totalSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpRequestGetContentLength(CellHttpTransId transId, vm::ptr<u64> totalSize)
{
	cellHttp.todo("cellHttpRequestGetContentLength(transId=0x%x, totalSize=*0x%x)", transId, totalSize);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!totalSize)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_NO_CONTENT_LENGTH;
	}

	return CELL_OK;
}

error_code cellHttpRequestSetChunkedTransferStatus(CellHttpTransId transId, b8 enable)
{
	cellHttp.todo("cellHttpRequestSetChunkedTransferStatus(transId=0x%x, enable=%d)", transId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpRequestGetChunkedTransferStatus(CellHttpTransId transId, vm::ptr<b8> enable)
{
	cellHttp.todo("cellHttpRequestGetChunkedTransferStatus(transId=0x%x, enable=*0x%x)", transId, enable);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!enable)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpRequestGetAllHeaders(CellHttpTransId transId, vm::pptr<CellHttpHeader> headers, vm::ptr<u32> items, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpRequestGetAllHeaders(transId=0x%x, headers=*0x%x, items=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, headers, items, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!required && (!pool || !headers))
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpRequestSetHeader(CellHttpTransId transId, vm::cptr<CellHttpHeader> header)
{
	cellHttp.todo("cellHttpRequestSetHeader(transId=0x%x, header=*0x%x)", transId, header);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!header)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpRequestGetHeader(CellHttpTransId transId, vm::ptr<CellHttpHeader> header, vm::cptr<char> name, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpRequestGetHeader(transId=0x%x, header=*0x%x, name=%s, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, header, name, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!name)
	{
		return CELL_HTTP_ERROR_NO_STRING;
	}

	return CELL_OK;
}

error_code cellHttpRequestAddHeader(CellHttpTransId transId, vm::cptr<CellHttpHeader> header)
{
	cellHttp.todo("cellHttpRequestAddHeader(transId=0x%x, header=*0x%x)", transId, header);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!header)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpRequestDeleteHeader(CellHttpTransId transId, vm::cptr<char> name)
{
	cellHttp.todo("cellHttpRequestDeleteHeader(transId=0x%x, name=%s)", transId, name);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!name)
	{
		return CELL_HTTP_ERROR_NO_STRING;
	}

	return CELL_OK;
}

error_code cellHttpRecvResponse(CellHttpTransId transId, vm::ptr<char> buf, u32 size, vm::ptr<u32> recvd)
{
	cellHttp.todo("cellHttpRecvResponse(transId=0x%x, buf=*0x%x, size=0x%x, recvd=*0x%x)", transId, buf, size, recvd);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpResponseGetAllHeaders(CellHttpTransId transId, vm::pptr<CellHttpHeader> headers, vm::ptr<u32> items, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpResponseGetAllHeaders(transId=0x%x, headers=*0x%x, items=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, headers, items, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!required && (!pool || !headers))
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpResponseGetHeader(CellHttpTransId transId, vm::ptr<CellHttpHeader> header, vm::cptr<char> name, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpResponseGetHeader(transId=0x%x, header=*0x%x, name=%s, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, header, name, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!name)
	{
		return CELL_HTTP_ERROR_NO_STRING;
	}

	return CELL_OK;
}

error_code cellHttpResponseGetContentLength(CellHttpTransId transId, vm::ptr<u64> length)
{
	cellHttp.todo("cellHttpResponseGetContentLength(transId=0x%x, length=*0x%x)", transId, length);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!length)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_NO_CONTENT_LENGTH;
	}

	return CELL_OK;
}

error_code cellHttpResponseGetStatusCode(CellHttpTransId transId, vm::ptr<s32> code)
{
	cellHttp.todo("cellHttpResponseGetStatusCode(transId=0x%x, code=*0x%x)", transId, code);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	if (!code)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpResponseGetStatusLine(CellHttpTransId transId, vm::ptr<CellHttpStatusLine> status, vm::ptr<void> pool, u32 poolSize, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpResponseGetStatusLine(transId=0x%x, status=*0x%x, pool=*0x%x, poolSize=0x%x, required=*0x%x)", transId, status, pool, poolSize, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslCipherName(CellHttpTransId transId, vm::ptr<char> name, u32 size, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpTransactionGetSslCipherName(transId=0x%x, name=*0x%x, size=0x%x, required=*0x%x)", transId, name, size, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslCipherId(CellHttpTransId transId, vm::ptr<s32> id)
{
	cellHttp.todo("cellHttpTransactionGetSslCipherId(transId=0x%x, id=*0x%x)", transId, id);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslCipherVersion(CellHttpTransId transId, vm::ptr<char> version, u32 size, vm::ptr<u32> required)
{
	cellHttp.todo("cellHttpTransactionGetSslCipherVersion(transId=0x%x, version=*0x%x, size=0x%x, required=*0x%x)", transId, version, size, required);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslCipherBits(CellHttpTransId transId, vm::ptr<s32> effectiveBits, vm::ptr<s32> algorithmBits)
{
	cellHttp.todo("cellHttpTransactionGetSslCipherBits(transId=0x%x, effectiveBits=*0x%x, effectiveBits=*0x%x)", transId, effectiveBits, algorithmBits);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslCipherString(CellHttpTransId transId, vm::ptr<char> buffer, u32 size)
{
	cellHttp.todo("cellHttpTransactionGetSslCipherString(transId=0x%x, buffer=*0x%x, size=0x%x)", transId, buffer, size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslVersion(CellHttpTransId transId, vm::ptr<s32> version)
{
	cellHttp.todo("cellHttpTransactionGetSslVersion(transId=0x%x, version=*0x%x)", transId, version);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpTransactionGetSslId(CellHttpTransId transId, vm::pptr<void> id)
{
	cellHttp.todo("cellHttpTransactionGetSslId(transId=0x%x, id=*0x%x)", transId, id);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_TRANS;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSslVersion(CellHttpClientId clientId, s32 version)
{
	cellHttp.todo("cellHttpClientSetSslVersion(clientId=0x%x, version=%d)", clientId, version);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpClientGetSslVersion(CellHttpClientId clientId, vm::ptr<s32> version)
{
	cellHttp.todo("cellHttpClientGetSslVersion(clientId=0x%x, version=*0x%x)", clientId, version);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	if (!version)
	{
		return CELL_HTTP_ERROR_NO_BUFFER;
	}

	return CELL_OK;
}

error_code cellHttpClientSetMinSslVersion(CellHttpClientId clientId, s32 version)
{
	cellHttp.todo("cellHttpClientSetMinSslVersion(clientId=0x%x, version=%d)", clientId, version);

	if (version != CELL_SSL_VERSION_TLS1)
	{
		if (version != CELL_SSL_VERSION_SSL3)
		{
			return CELL_HTTP_ERROR_INVALID_VALUE;
		}

		version = 2; // TODO: this can't be right, can it ?
	}

	return cellHttpClientSetSslVersion(clientId, version);
}

error_code cellHttpClientGetMinSslVersion(CellHttpClientId clientId, vm::ptr<s32> version)
{
	cellHttp.todo("cellHttpClientGetMinSslVersion(clientId=0x%x, version=*0x%x)", clientId, version);

	if (error_code error = cellHttpClientGetSslVersion(clientId, version))
	{
		return error;
	}

	if (*version == 2)
	{
		*version = CELL_SSL_VERSION_SSL3;
	}

	return CELL_OK;
}

error_code cellHttpClientSetSslIdDestroyCallback(CellHttpClientId clientId, vm::ptr<void> cbfunc, vm::ptr<void> userArg)
{
	cellHttp.todo("cellHttpClientSetSslIdDestroyCallback(clientId=0x%x, cbfunc=*0x%x, userArg=*0x%x)", clientId, cbfunc, userArg);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.initialized)
	{
		return CELL_HTTP_ERROR_NOT_INITIALIZED;
	}

	if (false) // TODO
	{
		return CELL_HTTP_ERROR_BAD_CLIENT;
	}

	return CELL_OK;
}

error_code cellHttpFlushCache()
{
	cellHttp.todo("cellHttpFlushCache()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpEndCache()
{
	cellHttp.todo("cellHttpEndCache()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED;
	}

	man.cache_initialized = false;
	return CELL_OK;
}

error_code cellHttpInitCache(u32 unk)
{
	cellHttp.todo("cellHttpInitCache(unk=0x%x)", unk);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (man.cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_ALREADY_INITIALIZED;
	}

	man.cache_initialized = true;
	return CELL_OK;
}

error_code cellHttpEndExternalCache()
{
	cellHttp.todo("cellHttpEndExternalCache()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.ext_cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED;
	}

	man.ext_cache_initialized = false;
	return CELL_OK;
}

error_code cellHttpInitExternalCache(vm::ptr<void> buf, u32 size)
{
	cellHttp.todo("cellHttpInitExternalCache(buf=*0x%x, size=0x%x)", size);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (man.ext_cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_ALREADY_INITIALIZED;
	}

	if (buf)
	{
		std::memset(buf.get_ptr(), 0, size);
	}

	if (size >= 512)
	{
		// TODO
	}

	man.ext_cache_initialized = true;
	return CELL_OK;
}

error_code cellHttpFlushExternalCache()
{
	cellHttp.todo("cellHttpFlushExternalCache()");

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.ext_cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpGetCacheInfo(vm::ptr<void> buf)
{
	cellHttp.todo("cellHttpGetCacheInfo(buf=*0x%x)", buf);

	auto& man = g_fxo->get<http_manager>();
	std::lock_guard lock(man.mtx);

	if (!man.cache_initialized)
	{
		return CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED;
	}

	return CELL_OK;
}

error_code cellHttpGetMemoryInfo(vm::ptr<u32> heapSize, vm::ptr<u32> param_2, vm::ptr<u32> param_3)
{
	cellHttp.todo("cellHttpGetMemoryInfo(heapSize=*0x%x, param_2=*0x%x, param_3=*0x%x)", heapSize, param_2, param_3);

	if (heapSize)
	{
		//*heapSize = _sys_heap_get_total_free_size();
	}

	if (!param_2 && !param_3)
	{
		return CELL_OK;
	}

	if (param_2)
	{
		*param_2 = *param_3;
	}

	//*param_3 = _sys_heap_get_mallinfo();

	return CELL_OK;
}

DECLARE(ppu_module_manager::cellHttp)("cellHttp", []()
{
	REG_FUNC(cellHttp, cellHttpAuthCacheExport);
	REG_FUNC(cellHttp, cellHttpAuthCacheFlush);
	REG_FUNC(cellHttp, cellHttpAuthCacheGetEntryMax);
	REG_FUNC(cellHttp, cellHttpAuthCacheImport);
	REG_FUNC(cellHttp, cellHttpAuthCacheSetEntryMax);
	REG_FUNC(cellHttp, cellHttpInit);
	REG_FUNC(cellHttp, cellHttpEnd);
	REG_FUNC(cellHttp, cellHttpsInit);
	REG_FUNC(cellHttp, cellHttpsEnd);
	REG_FUNC(cellHttp, cellHttpSetProxy);
	REG_FUNC(cellHttp, cellHttpGetCookie);
	REG_FUNC(cellHttp, cellHttpGetProxy);

	REG_FUNC(cellHttp, cellHttpInitCookie);
	REG_FUNC(cellHttp, cellHttpEndCookie);
	REG_FUNC(cellHttp, cellHttpAddCookieWithClientId);
	REG_FUNC(cellHttp, cellHttpSessionCookieFlush);

	REG_FUNC(cellHttp, cellHttpCookieExport);
	REG_FUNC(cellHttp, cellHttpCookieExportWithClientId);
	REG_FUNC(cellHttp, cellHttpCookieFlush);
	REG_FUNC(cellHttp, cellHttpCookieImport);
	REG_FUNC(cellHttp, cellHttpCookieImportWithClientId);

	REG_FUNC(cellHttp, cellHttpClientSetCookieSendCallback);
	REG_FUNC(cellHttp, cellHttpClientSetCookieRecvCallback);

	REG_FUNC(cellHttp, cellHttpCreateClient);
	REG_FUNC(cellHttp, cellHttpDestroyClient);
	REG_FUNC(cellHttp, cellHttpClientSetAuthenticationCallback);
	REG_FUNC(cellHttp, cellHttpClientSetTransactionStateCallback);
	REG_FUNC(cellHttp, cellHttpClientSetRedirectCallback);
	REG_FUNC(cellHttp, cellHttpClientSetCacheStatus);

	REG_FUNC(cellHttp, cellHttpClientSetProxy);
	REG_FUNC(cellHttp, cellHttpClientGetProxy);
	REG_FUNC(cellHttp, cellHttpClientSetVersion);
	REG_FUNC(cellHttp, cellHttpClientGetVersion);
	REG_FUNC(cellHttp, cellHttpClientSetPipeline);
	REG_FUNC(cellHttp, cellHttpClientGetPipeline);
	REG_FUNC(cellHttp, cellHttpClientSetKeepAlive);
	REG_FUNC(cellHttp, cellHttpClientGetKeepAlive);
	REG_FUNC(cellHttp, cellHttpClientSetAutoRedirect);
	REG_FUNC(cellHttp, cellHttpClientGetAutoRedirect);
	REG_FUNC(cellHttp, cellHttpClientSetAutoAuthentication);
	REG_FUNC(cellHttp, cellHttpClientGetAutoAuthentication);
	REG_FUNC(cellHttp, cellHttpClientSetAuthenticationCacheStatus);
	REG_FUNC(cellHttp, cellHttpClientGetAuthenticationCacheStatus);
	REG_FUNC(cellHttp, cellHttpClientSetCookieStatus);
	REG_FUNC(cellHttp, cellHttpClientGetCookieStatus);
	REG_FUNC(cellHttp, cellHttpClientSetUserAgent);
	REG_FUNC(cellHttp, cellHttpClientGetUserAgent);
	REG_FUNC(cellHttp, cellHttpClientSetResponseBufferMax);
	REG_FUNC(cellHttp, cellHttpClientGetResponseBufferMax);

	REG_FUNC(cellHttp, cellHttpClientCloseAllConnections);
	REG_FUNC(cellHttp, cellHttpClientCloseConnections);
	REG_FUNC(cellHttp, cellHttpClientPollConnections);

	REG_FUNC(cellHttp, cellHttpClientSetConnectionStateCallback);
	REG_FUNC(cellHttp, cellHttpClientGetConnectionWaitStatus);
	REG_FUNC(cellHttp, cellHttpClientSetConnectionWaitStatus);
	REG_FUNC(cellHttp, cellHttpClientGetConnectionWaitTimeout);
	REG_FUNC(cellHttp, cellHttpClientSetConnectionWaitTimeout);
	REG_FUNC(cellHttp, cellHttpClientSetRecvTimeout);
	REG_FUNC(cellHttp, cellHttpClientGetRecvTimeout);
	REG_FUNC(cellHttp, cellHttpClientSetSendTimeout);
	REG_FUNC(cellHttp, cellHttpClientGetSendTimeout);
	REG_FUNC(cellHttp, cellHttpClientSetConnTimeout);
	REG_FUNC(cellHttp, cellHttpClientGetConnTimeout);
	REG_FUNC(cellHttp, cellHttpClientSetTotalPoolSize);
	REG_FUNC(cellHttp, cellHttpClientGetTotalPoolSize);
	REG_FUNC(cellHttp, cellHttpClientSetPerHostPoolSize);
	REG_FUNC(cellHttp, cellHttpClientGetPerHostPoolSize);
	REG_FUNC(cellHttp, cellHttpClientSetPerHostKeepAliveMax);
	REG_FUNC(cellHttp, cellHttpClientGetPerHostKeepAliveMax);
	REG_FUNC(cellHttp, cellHttpClientSetPerPipelineMax);
	REG_FUNC(cellHttp, cellHttpClientGetPerPipelineMax);
	REG_FUNC(cellHttp, cellHttpClientSetRecvBufferSize);
	REG_FUNC(cellHttp, cellHttpClientGetRecvBufferSize);
	REG_FUNC(cellHttp, cellHttpClientSetSendBufferSize);
	REG_FUNC(cellHttp, cellHttpClientGetSendBufferSize);

	REG_FUNC(cellHttp, cellHttpClientGetAllHeaders);
	REG_FUNC(cellHttp, cellHttpClientSetHeader);
	REG_FUNC(cellHttp, cellHttpClientGetHeader);
	REG_FUNC(cellHttp, cellHttpClientAddHeader);
	REG_FUNC(cellHttp, cellHttpClientDeleteHeader);

	REG_FUNC(cellHttp, cellHttpClientSetSslCallback);
	REG_FUNC(cellHttp, cellHttpClientSetSslClientCertificate);

	REG_FUNC(cellHttp, cellHttpCreateTransaction);
	REG_FUNC(cellHttp, cellHttpDestroyTransaction);
	REG_FUNC(cellHttp, cellHttpTransactionGetUri);
	REG_FUNC(cellHttp, cellHttpTransactionSetUri);
	REG_FUNC(cellHttp, cellHttpTransactionCloseConnection);
	REG_FUNC(cellHttp, cellHttpTransactionReleaseConnection);
	REG_FUNC(cellHttp, cellHttpTransactionAbortConnection);

	REG_FUNC(cellHttp, cellHttpSendRequest);
	REG_FUNC(cellHttp, cellHttpRequestSetContentLength);
	REG_FUNC(cellHttp, cellHttpRequestGetContentLength);
	REG_FUNC(cellHttp, cellHttpRequestSetChunkedTransferStatus);
	REG_FUNC(cellHttp, cellHttpRequestGetChunkedTransferStatus);
	REG_FUNC(cellHttp, cellHttpRequestGetAllHeaders);
	REG_FUNC(cellHttp, cellHttpRequestSetHeader);
	REG_FUNC(cellHttp, cellHttpRequestGetHeader);
	REG_FUNC(cellHttp, cellHttpRequestAddHeader);
	REG_FUNC(cellHttp, cellHttpRequestDeleteHeader);

	REG_FUNC(cellHttp, cellHttpRecvResponse);
	REG_FUNC(cellHttp, cellHttpResponseGetAllHeaders);
	REG_FUNC(cellHttp, cellHttpResponseGetHeader);
	REG_FUNC(cellHttp, cellHttpResponseGetContentLength);
	REG_FUNC(cellHttp, cellHttpResponseGetStatusCode);
	REG_FUNC(cellHttp, cellHttpResponseGetStatusLine);

	REG_FUNC(cellHttp, cellHttpTransactionGetSslCipherName);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslCipherId);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslCipherVersion);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslCipherBits);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslCipherString);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslVersion);
	REG_FUNC(cellHttp, cellHttpTransactionGetSslId);

	REG_FUNC(cellHttp, cellHttpClientSetMinSslVersion);
	REG_FUNC(cellHttp, cellHttpClientGetMinSslVersion);
	REG_FUNC(cellHttp, cellHttpClientSetSslVersion);
	REG_FUNC(cellHttp, cellHttpClientGetSslVersion);
	REG_FUNC(cellHttp, cellHttpClientSetSslIdDestroyCallback);

	REG_FUNC(cellHttp, cellHttpFlushCache);
	REG_FUNC(cellHttp, cellHttpEndCache);
	REG_FUNC(cellHttp, cellHttpEndExternalCache);
	REG_FUNC(cellHttp, cellHttpInitCache);
	REG_FUNC(cellHttp, cellHttpGetCacheInfo);
	REG_FUNC(cellHttp, cellHttpGetMemoryInfo);
});

DECLARE(ppu_module_manager::cellHttps)("cellHttps", []()
{
	// cellHttps doesn't have functions (cellHttpsInit belongs to cellHttp, for example)
});
