#pragma once



// L10nResult
enum
{
	ConversionOK,
	SRCIllegal,
	DSTExhausted,
	ConverterUnknown,
};

// detection result
enum
{
	L10N_STR_UNKNOWN = (1 << 0),
	L10N_STR_ASCII   = (1 << 1),
	L10N_STR_JIS     = (1 << 2),
	L10N_STR_EUCJP   = (1 << 3),
	L10N_STR_SJIS    = (1 << 4),
	L10N_STR_UTF8    = (1 << 5),
	L10N_STR_ILLEGAL = (1 << 16),
	L10N_STR_ERROR   = (1 << 17),
};

// CodePages
enum
{
	L10N_UTF8 = 0,
	L10N_UTF16,
	L10N_UTF32,
	L10N_UCS2,
	L10N_UCS4,
	L10N_ISO_8859_1,
	L10N_ISO_8859_2,
	L10N_ISO_8859_3,
	L10N_ISO_8859_4,
	L10N_ISO_8859_5,
	L10N_ISO_8859_6,
	L10N_ISO_8859_7,
	L10N_ISO_8859_8,
	L10N_ISO_8859_9,
	L10N_ISO_8859_10,
	L10N_ISO_8859_11,
	L10N_ISO_8859_13,
	L10N_ISO_8859_14,
	L10N_ISO_8859_15,
	L10N_ISO_8859_16,
	L10N_CODEPAGE_437,
	L10N_CODEPAGE_850,
	L10N_CODEPAGE_863,
	L10N_CODEPAGE_866,
	L10N_CODEPAGE_932,
	L10N_SHIFT_JIS = L10N_CODEPAGE_932,
	L10N_CODEPAGE_936,
	L10N_GBK = L10N_CODEPAGE_936,
	L10N_CODEPAGE_949,
	L10N_UHC = L10N_CODEPAGE_949,
	L10N_CODEPAGE_950,
	L10N_BIG5 = L10N_CODEPAGE_950,
	L10N_CODEPAGE_1251,
	L10N_CODEPAGE_1252,
	L10N_EUC_CN,
	L10N_EUC_JP,
	L10N_EUC_KR,
	L10N_ISO_2022_JP,
	L10N_JIS = L10N_ISO_2022_JP,
	L10N_ARIB,
	L10N_HZ,
	L10N_GB18030,
	L10N_RIS_506,
	L10N_MUSIC_SHIFT_JIS = L10N_RIS_506,
	//FW 3.10 and below
	L10N_CODEPAGE_852,
	L10N_CODEPAGE_1250,
	L10N_CODEPAGE_737,
	L10N_CODEPAGE_1253,
	L10N_CODEPAGE_857,
	L10N_CODEPAGE_1254,
	L10N_CODEPAGE_775,
	L10N_CODEPAGE_1257,
	L10N_CODEPAGE_855,
	L10N_CODEPAGE_858,
	L10N_CODEPAGE_860,
	L10N_CODEPAGE_861,
	L10N_CODEPAGE_865,
	L10N_CODEPAGE_869,
	_L10N_CODE_
};

enum
{
	UTF16_SURROGATES_MASK1 = 0xf800,
	UTF16_SURROGATES_MASK2 = 0xfc00,
	UTF16_SURROGATES       = 0xd800,
	UTF16_HIGH_SURROGATES  = 0xd800,
	UTF16_LOW_SURROGATES   = 0xdc00,
};
