import type { TagNodeObject, TagNodeTree, TagPosition } from "@bbob/types";
export declare class TagNode<TagValue extends any = any> implements TagNodeObject {
    readonly tag: string | TagValue;
    attrs: Record<string, unknown>;
    content: TagNodeTree;
    start?: TagPosition;
    end?: TagPosition;
    constructor(tag: string | TagValue, attrs: Record<string, unknown>, content: TagNodeTree, start?: TagPosition, end?: TagPosition);
    get length(): number;
    attr(name: string, value?: unknown): unknown;
    append(value: string): void;
    setStart(value: TagPosition): void;
    setEnd(value: TagPosition): void;
    toTagStart({ openTag, closeTag }?: {
        openTag?: string | undefined;
        closeTag?: string | undefined;
    }): string;
    toTagEnd({ openTag, closeTag }?: {
        openTag?: string | undefined;
        closeTag?: string | undefined;
    }): string;
    toTagNode(): TagNode<TagValue>;
    toString({ openTag, closeTag }?: {
        openTag?: string | undefined;
        closeTag?: string | undefined;
    }): string;
    toJSON(): {
        tag: string | TagValue;
        attrs: Record<string, unknown>;
        content: TagNodeTree;
        start: TagPosition | undefined;
        end: TagPosition | undefined;
    };
    static create(tag: string, attrs?: Record<string, unknown>, content?: TagNodeTree, start?: TagPosition): TagNode<string>;
    static isOf(node: TagNode, type: string): boolean;
}
//# sourceMappingURL=TagNode.d.ts.map