import { s as UserSearchResult } from './narou-search-results-DT0YdaBn.js';
export { j as BigGenre, k as BigGenreNotation, B as BooleanNumber, m as BuntaiParam, D as DateParam, E as End, F as Fields, G as Genre, l as GenreNotation, q as GzipLevel, r as NarouSearchResult, N as NarouSearchResults, t as NovelType, o as NovelTypeParam, O as OptionalFields, g as Order, P as ParamsBase, a as ParamsBaseWithOrder, y as PickedNarouSearchResult, e as R18Fields, h as R18Site, i as R18SiteNotation, c as RankingHistoryParams, b as RankingParams, R as RankingType, S as SearchParams, d as SearchResultFieldNames, u as SearchResultFields, v as SearchResultOptionalFields, w as SearchResultR18Fields, n as StopParam, f as UserFields, p as UserOrder, U as UserSearchParams, x as UserSearchResultFields } from './narou-search-results-DT0YdaBn.js';
import { N as NarouNovel, S as SearchBuilder } from './narou-DBa12V_l.js';
export { D as DefaultSearchResultFields, a as NarouParams, b as NarouRankingResult, d as NovelSearchBuilderBase, R as RankingResult, c as SearchBuilderBase } from './narou-DBa12V_l.js';
export { default as NarouNovelFetch } from './narou-fetch.js';
export { default as NarouNovelJsonp } from './narou-jsonp.js';
import RankingBuilder from './ranking.js';
import { RankingHistoryResult } from './ranking-history.js';
export { RankingHistoryRawResult, formatRankingHistory } from './ranking-history.js';
import SearchBuilderR18 from './search-builder-r18.js';
export { DefaultR18SearchResultFields } from './search-builder-r18.js';
import UserSearchBuilder from './user-search.js';
import './util/type.js';

/**
 * なろう小説 API で小説を検索する
 * @param {string} [word] 検索ワード
 * @returns {SearchBuilder}
 * @see https://dev.syosetu.com/man/api/
 */
declare function search(word?: string, api?: NarouNovel): SearchBuilder;
/**
 * 18禁小説 API で小説を検索する
 * @param {string} [word] 検索ワード
 * @returns {SearchBuilder}
 * @see https://dev.syosetu.com/xman/api/
 */
declare function searchR18(word?: string, api?: NarouNovel): SearchBuilderR18;
/**
 * なろうユーザ検索 API でユーザを検索する
 * @param {string} [word] - 検索ワード
 * @returns {UserSearchBuilder}
 * @see https://dev.syosetu.com/man/userapi/
 */
declare function searchUser(word?: string, api?: NarouNovel): UserSearchBuilder<keyof UserSearchResult>;
/**
 * なろう小説ランキング API でランキングを取得する
 * @returns {RankingBuilder}
 * @see https://dev.syosetu.com/man/rankapi/
 */
declare function ranking(api?: NarouNovel): RankingBuilder;
/**
 * なろう殿堂入り API でランキング履歴を取得する
 * @param {string} ncode 小説のNコード
 * @see https://dev.syosetu.com/man/rankinapi/
 */
declare function rankingHistory(ncode: string, api?: NarouNovel): Promise<RankingHistoryResult[]>;
declare const _default: {
    search: typeof search;
    searchR18: typeof searchR18;
    searchUser: typeof searchUser;
    ranking: typeof ranking;
    rankingHistory: typeof rankingHistory;
};

export { NarouNovel, RankingBuilder, RankingHistoryResult, SearchBuilder, SearchBuilderR18, UserSearchResult, _default as default, ranking, rankingHistory, search, searchR18, searchUser };
