"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.modifyNumberedListObject = exports.getBlockChildren = void 0;
const getBlockChildren = async (notionClient, block_id, totalPage) => {
    let result = [];
    let pageCount = 0;
    let start_cursor = undefined;
    do {
        const response = (await notionClient.blocks.children.list({
            start_cursor: start_cursor,
            block_id: block_id,
        }));
        result.push(...response.results);
        start_cursor = response === null || response === void 0 ? void 0 : response.next_cursor;
        pageCount += 1;
    } while (start_cursor != null &&
        (totalPage == null || pageCount < totalPage));
    (0, exports.modifyNumberedListObject)(result);
    return result;
};
exports.getBlockChildren = getBlockChildren;
const modifyNumberedListObject = (blocks) => {
    let numberedListIndex = 0;
    for (const block of blocks) {
        if ("type" in block && block.type === "numbered_list_item") {
            // add numbers
            // @ts-ignore
            block.numbered_list_item.number = ++numberedListIndex;
        }
        else {
            numberedListIndex = 0;
        }
    }
};
exports.modifyNumberedListObject = modifyNumberedListObject;
//# sourceMappingURL=notion.js.map