import {
  unzipp
} from "./chunk-VUZIISP2.js";
import {
  NarouNovel
} from "./chunk-6BZWV4ZC.js";

// src/narou-fetch.ts
var NarouNovelFetch = class extends NarouNovel {
  /**
   * コンストラクタ
   * @param fetch fetch関数（デフォルトはネイティブのfetch）
   */
  constructor(fetch2) {
    super();
    this.fetch = fetch2;
  }
  async execute(params, endpoint) {
    const query = { ...params, out: "json" };
    if (query.gzip === void 0) {
      query.gzip = 5;
    }
    if (query.gzip === 0) {
      delete query.gzip;
    }
    const url = new URL(endpoint);
    Object.entries(query).forEach(([key, value]) => {
      if (value !== void 0) {
        url.searchParams.append(key, value.toString());
      }
    });
    const res = await (this.fetch ?? fetch)(url);
    if (!query.gzip) {
      return await res.json();
    }
    const buffer = await res.arrayBuffer();
    return await unzipp(buffer);
  }
};

export {
  NarouNovelFetch
};
//# sourceMappingURL=chunk-PLEM2AOH.js.map