"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/narou-fetch.ts
var narou_fetch_exports = {};
__export(narou_fetch_exports, {
  default: () => NarouNovelFetch
});
module.exports = __toCommonJS(narou_fetch_exports);

// src/util/unzipp.ts
var import_zlib = require("zlib");
var import_util = require("util");
var gunzipAsync = (0, import_util.promisify)(import_zlib.gunzip);
var decoder = new TextDecoder();
async function unzipp(data) {
  try {
    const buffer = await gunzipAsync(data);
    try {
      return JSON.parse(decoder.decode(buffer));
    } catch {
      throw decoder.decode(buffer);
    }
  } catch (e) {
    if (typeof e === "string") throw e;
    throw decoder.decode(data);
  }
}

// src/narou-search-results.ts
var NarouSearchResults = class {
  /**
   * @constractor
   * @private
   */
  constructor([header, ...result], params) {
    const count = header.allcount;
    const limit = params.lim ?? 20;
    const start = params.st ?? 0;
    this.allcount = count;
    this.limit = limit;
    this.start = start;
    this.page = start / limit;
    this.length = result.length;
    this.values = result;
  }
};

// src/narou.ts
var NarouNovel = class {
  /**
   * APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @param endpoint APIエンドポイント
   * @returns 検索結果
   */
  async executeSearch(params, endpoint = "https://api.syosetu.com/novelapi/api/") {
    return new NarouSearchResults(await this.execute(params, endpoint), params);
  }
  /**
   * 小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/api/
   */
  async executeNovel(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novelapi/api/"
    );
  }
  /**
   * R18小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/xman/api/
   */
  async executeNovel18(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novel18api/api/"
    );
  }
  /**
   * ランキングAPIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング結果
   * @see https://dev.syosetu.com/man/rankapi/
   */
  async executeRanking(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankget/");
  }
  /**
   * 殿堂入りAPiへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング履歴結果
   * @see https://dev.syosetu.com/man/rankinapi/
   */
  async executeRankingHistory(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankin/");
  }
  /**
   * ユーザー検索APIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/userapi/
   */
  async executeUserSearch(params) {
    return new NarouSearchResults(
      await this.execute(params, "https://api.syosetu.com/userapi/api/"),
      params
    );
  }
};

// src/narou-fetch.ts
var NarouNovelFetch = class extends NarouNovel {
  /**
   * コンストラクタ
   * @param fetch fetch関数（デフォルトはネイティブのfetch）
   */
  constructor(fetch2) {
    super();
    this.fetch = fetch2;
  }
  async execute(params, endpoint) {
    const query = { ...params, out: "json" };
    if (query.gzip === void 0) {
      query.gzip = 5;
    }
    if (query.gzip === 0) {
      delete query.gzip;
    }
    const url = new URL(endpoint);
    Object.entries(query).forEach(([key, value]) => {
      if (value !== void 0) {
        url.searchParams.append(key, value.toString());
      }
    });
    const res = await (this.fetch ?? fetch)(url);
    if (!query.gzip) {
      return await res.json();
    }
    const buffer = await res.arrayBuffer();
    return await unzipp(buffer);
  }
};
//# sourceMappingURL=narou-fetch.cjs.map