"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.table = exports.toggle = exports.divider = exports.addTabSpace = exports.image = exports.todo = exports.bullet = exports.callout = exports.quote = exports.heading3 = exports.heading2 = exports.heading1 = exports.equation = exports.codeBlock = exports.link = exports.underline = exports.strikethrough = exports.italic = exports.bold = exports.inlineEquation = exports.inlineCode = void 0;
const markdown_table_1 = __importDefault(require("markdown-table"));
const node_fetch_1 = __importDefault(require("node-fetch"));
const inlineCode = (text) => {
    return `\`${text}\``;
};
exports.inlineCode = inlineCode;
const inlineEquation = (text) => {
    return `$${text}$`;
};
exports.inlineEquation = inlineEquation;
const bold = (text) => {
    return `**${text}**`;
};
exports.bold = bold;
const italic = (text) => {
    return `_${text}_`;
};
exports.italic = italic;
const strikethrough = (text) => {
    return `~~${text}~~`;
};
exports.strikethrough = strikethrough;
const underline = (text) => {
    return `<u>${text}</u>`;
};
exports.underline = underline;
const link = (text, href) => {
    return `[${text}](${href})`;
};
exports.link = link;
const codeBlock = (text, language) => {
    if (!text)
        return "";
    // Ensure a valid language, default to "plaintext" if missing
    const lang = language && language.trim() ? language.toLowerCase() : "plaintext";
    return `\`\`\`${lang}
${text.trim()}
\`\`\``;
};
exports.codeBlock = codeBlock;
const equation = (text) => {
    return `$$
${text}
$$`;
};
exports.equation = equation;
const heading1 = (text) => {
    return `# ${text}`;
};
exports.heading1 = heading1;
const heading2 = (text) => {
    return `## ${text}`;
};
exports.heading2 = heading2;
const heading3 = (text) => {
    return `### ${text}`;
};
exports.heading3 = heading3;
const quote = (text) => {
    // the replace is done to handle multiple lines
    return `> ${text.replace(/\n/g, "  \n> ")}`;
};
exports.quote = quote;
const callout = (text, icon) => {
    let emoji;
    if ((icon === null || icon === void 0 ? void 0 : icon.type) === "emoji") {
        emoji = icon.emoji;
    }
    // the replace is done to handle multiple lines
    const formattedText = text.replace(/\n/g, "  \n> ");
    const formattedEmoji = emoji ? emoji + " " : "";
    const headingMatch = formattedText.match(/^(#{1,6})\s+([.*\s\S]+)/);
    if (headingMatch) {
        const headingLevel = headingMatch[1].length;
        const headingContent = headingMatch[2];
        return `> ${"#".repeat(headingLevel)} ${formattedEmoji}${headingContent}`;
    }
    return `> ${formattedEmoji}${formattedText}`;
};
exports.callout = callout;
const bullet = (text, count) => {
    let renderText = text.trim();
    return count ? `${count}. ${renderText}` : `- ${renderText}`;
};
exports.bullet = bullet;
const todo = (text, checked) => {
    return checked ? `- [x] ${text}` : `- [ ] ${text}`;
};
exports.todo = todo;
const image = async (alt, href, convertToBase64 = false) => {
    // In case the user does not want to convert the images to Base64
    // or the image is already base64
    if (!convertToBase64 || href.startsWith("data:")) {
        if (href.startsWith("data:")) {
            // Extract base64 data, i.e. the string after 'data:mime/type;base64,'
            const base64 = href.split(",").pop();
            // This overrides incorrect data: string format to png
            // so that browsers can correctly render the data
            return `![${alt}](data:image/png;base64,${base64})`;
        }
        return `![${alt}](${href})`;
    }
    else {
        // Otherwise, download the image and convert it to base64
        const res = await (0, node_fetch_1.default)(href);
        const buf = await res.arrayBuffer();
        const base64 = Buffer.from(buf).toString("base64");
        return `![${alt}](data:image/png;base64,${base64})`;
    }
};
exports.image = image;
const addTabSpace = (text, n = 0) => {
    const tab = "    ";
    for (let i = 0; i < n; i++) {
        if (text.includes("\n")) {
            const multiLineText = text.split(/(?:^|\n)/).join(`\n${tab}`);
            text = tab + multiLineText;
        }
        else
            text = tab + text;
    }
    return text;
};
exports.addTabSpace = addTabSpace;
const divider = () => {
    return "---";
};
exports.divider = divider;
const toggle = (summary, children) => {
    if (!summary)
        return children || "";
    return `<details>
<summary>${summary}</summary>
${children || ""}
</details>\n\n`;
};
exports.toggle = toggle;
const table = (cells) => {
    return (0, markdown_table_1.default)(cells);
};
exports.table = table;
//# sourceMappingURL=md.js.map