"use strict";Object.defineProperty(exports, "__esModule", {value: true});var _lowercasejs = require('./lower-case.js');
var _specialsjs = require('./specials.js');
const word = `[^\\s'\u2019\\(\\)!?;:"-]`;
const regex = new RegExp(`(?:(?:(\\s?(?:^|[.\\(\\)!?;:"-])\\s*)(${word}))|(${word}))(${word}*[\u2019']*${word}*)`, "g");
const convertToRegExp = (specials2) => specials2.map((s) => [new RegExp(`\\b${s}\\b`, "gi"), s]);
function parseMatch(match) {
  const firstCharacter = match[0];
  if (/\s/.test(firstCharacter)) {
    return match.slice(1);
  }
  if (/[\(\)]/.test(firstCharacter)) {
    return null;
  }
  return match;
}
var src_default = (str, options = {}) => {
  str = str.toLowerCase().replace(regex, (m, lead = "", forced, lower, rest, offset, string) => {
    const isLastWord = m.length + offset >= string.length;
    const parsedMatch = parseMatch(m);
    if (!parsedMatch) {
      return m;
    }
    if (!forced) {
      const fullLower = lower + rest;
      if (_lowercasejs.lowerCase.has(fullLower) && !isLastWord) {
        return parsedMatch;
      }
    }
    return lead + (lower || forced).toUpperCase() + rest;
  });
  const customSpecials = options.special || [];
  const replace = [..._specialsjs.specials, ...customSpecials];
  const replaceRegExp = convertToRegExp(replace);
  replaceRegExp.forEach(([pattern, s]) => {
    str = str.replace(pattern, s);
  });
  return str;
};


exports.default = src_default;
