import { _ as Logger, c as ResolvedOptions, g as ReportPlugin } from "./types-XjcKkhrO.mjs";
import { Plugin } from "rolldown";
import { PackageJson } from "pkg-types";

//#region src/features/external.d.ts
declare function ExternalPlugin({
  pkg,
  noExternal,
  inlineOnly,
  skipNodeModulesBundle
}: ResolvedOptions): Plugin;
//#endregion
//#region src/features/shebang.d.ts
declare function ShebangPlugin(logger: Logger, cwd: string, name?: string, isMultiFormat?: boolean): Plugin;
//#endregion
//#region src/features/node-protocol.d.ts
/**
* The `node:` protocol was added in Node.js v14.18.0.
* @see https://nodejs.org/api/esm.html#node-imports
*/
declare function NodeProtocolPlugin(nodeProtocolOption: "strip" | true): Plugin;
//#endregion
export { ExternalPlugin, NodeProtocolPlugin, ReportPlugin, ShebangPlugin };