import { YTNode } from '../helpers.js';
import { Parser } from '../index.js';
import Button from './Button.js';
import Text from './misc/Text.js';
export default class UpsellDialog extends YTNode {
    static type = 'UpsellDialog';
    message_title;
    message_text;
    action_button;
    dismiss_button;
    is_visible;
    constructor(data) {
        super();
        this.message_title = new Text(data.dialogMessageTitle);
        this.message_text = new Text(data.dialogMessageText);
        this.action_button = Parser.parseItem(data.actionButton, Button);
        this.dismiss_button = Parser.parseItem(data.dismissButton, Button);
        this.is_visible = data.isVisible;
    }
}
//# sourceMappingURL=UpsellDialog.js.map