import { load } from 'cheerio';

import type { Route } from '@/types';
import cache from '@/utils/cache';
import got from '@/utils/got';
import { parseDate } from '@/utils/parse-date';

const host = 'http://www.sim.cas.cn/';

export const route: Route = {
    path: '/sim/kyjz',
    categories: ['university'],
    example: '/cas/sim/kyjz',
    parameters: {},
    features: {
        requireConfig: false,
        requirePuppeteer: false,
        antiCrawler: false,
        supportBT: false,
        supportPodcast: false,
        supportScihub: false,
    },
    radar: [
        {
            source: ['www.sim.cas.cn/xwzx2016/kyjz', 'www.sim.cas.cn/'],
        },
    ],
    name: '上海微系统与信息技术研究所 科技进展',
    maintainers: ['HenryQW'],
    handler,
    url: 'www.sim.cas.cn/xwzx2016/kyjz',
};

async function handler() {
    const link = new URL('xwzx2016/kyjz/', host).href;
    const response = await got(link);

    const $ = load(response.data);

    const list = $('.list-news li')
        .toArray()
        .filter((e) => !$(e).attr('style'))
        .map((e) => {
            e = $(e);
            return {
                link: new URL(e.find('a').attr('href'), link).href,
                pubDate: e.find('span').text().replace('[', '').replace(']', ''),
            };
        });

    const out = await Promise.all(
        list.map((item) =>
            cache.tryGet(item.link, async () => {
                const response = await got(item.link);
                const $ = load(response.data);

                const author = $('.qtinfo.hidden-lg.hidden-md.hidden-sm').text();
                const reg = /文章来源：(.*?)\|/g;

                item.title = $('p.wztitle').text().trim();
                item.author = reg.exec(author)[1].toString().trim();
                item.description = $('.TRS_Editor').html();
                item.pubDate = parseDate(item.pubDate);
                return item;
            })
        )
    );

    return {
        title: '中国科学院上海微系统与信息技术研究所 -- 科技进展',
        link,
        item: out,
    };
}
