import { TransactionTransfer, TransactionApproval, TransactionBridge, CollectibleTransfer, CollectibleApproval, CollectibleTrade, ExchangeSwap, ExchangeLiquidity, SocialPost, SocialProfile, SocialProxy, MetaverseTransfer, MetaverseTrade } from '@rss3/api-core';

type MetadataDoc = typeof metadataDoc;
declare const metadataDoc: {
    "transaction-transfer": {
        ref: TransactionTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
        }[];
    };
    "transaction-approval": {
        ref: TransactionApproval;
        tag: string;
        type: string;
        actions: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "transaction-mint": {
        ref: TransactionTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "transaction-burn": {
        ref: TransactionTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "transaction-bridge": {
        ref: TransactionBridge;
        tag: string;
        type: string;
        actions: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "collectible-transfer": {
        ref: CollectibleTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "collectible-approval": {
        ref: CollectibleApproval;
        tag: string;
        type: string;
        actions: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "collectible-mint": {
        ref: CollectibleTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "collectible-burn": {
        ref: CollectibleTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "collectible-trade": {
        ref: CollectibleTrade;
        tag: string;
        type: string;
        actions: string[];
        platforms: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "exchange-swap": {
        ref: ExchangeSwap;
        tag: string;
        type: string;
        platforms: string[];
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "exchange-liquidity": {
        ref: ExchangeLiquidity;
        tag: string;
        type: string;
        actions: string[];
        platforms: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "social-post": {
        ref: SocialPost;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "social-comment": {
        ref: SocialPost;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "social-share": {
        ref: SocialPost;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "social-mint": {
        ref: SocialPost;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "social-profile": {
        ref: SocialProfile;
        tag: string;
        type: string;
        actions: string[];
        platforms: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "social-proxy": {
        ref: SocialProxy;
        tag: string;
        type: string;
        actions: string[];
        platforms: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
    "social-revise": {
        ref: SocialPost;
        tag: string;
        type: string;
        platforms: string[];
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "social-delete": {
        ref: SocialPost;
        tag: string;
        type: string;
        platforms: string[];
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "metaverse-transfer": {
        ref: MetaverseTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "metaverse-mint": {
        ref: MetaverseTransfer;
        tag: string;
        type: string;
        examples: {
            id: string;
            comment: string;
        }[];
    };
    "metaverse-burn": {
        ref: MetaverseTransfer;
        tag: string;
        type: string;
    };
    "metaverse-trade": {
        ref: MetaverseTrade;
        tag: string;
        type: string;
        actions: string[];
        platforms: string[];
        examples: {
            actionType: string;
            id: string;
            comment: string;
        }[];
    };
};

export { type MetadataDoc, metadataDoc };
