/**
 * Handler method wrapping for MCP server instrumentation
 *
 * Provides automatic error capture and span correlation for tool, resource,
 * and prompt handlers.
 */
import type { MCPServerInstance } from './types';
/**
 * Wraps tool handlers to associate them with request spans
 * @param serverInstance - MCP server instance
 */
export declare function wrapToolHandlers(serverInstance: MCPServerInstance): void;
/**
 * Wraps resource handlers to associate them with request spans
 * @param serverInstance - MCP server instance
 */
export declare function wrapResourceHandlers(serverInstance: MCPServerInstance): void;
/**
 * Wraps prompt handlers to associate them with request spans
 * @param serverInstance - MCP server instance
 */
export declare function wrapPromptHandlers(serverInstance: MCPServerInstance): void;
/**
 * Wraps all MCP handler types (tool, resource, prompt) for span correlation
 * @param serverInstance - MCP server instance
 */
export declare function wrapAllMCPHandlers(serverInstance: MCPServerInstance): void;
//# sourceMappingURL=handlers.d.ts.map