import {
  NarouSearchResults
} from "./chunk-3A5MHPWL.js";

// src/narou.ts
var NarouNovel = class {
  /**
   * APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @param endpoint APIエンドポイント
   * @returns 検索結果
   */
  async executeSearch(params, endpoint = "https://api.syosetu.com/novelapi/api/") {
    return new NarouSearchResults(await this.execute(params, endpoint), params);
  }
  /**
   * 小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/api/
   */
  async executeNovel(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novelapi/api/"
    );
  }
  /**
   * R18小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/xman/api/
   */
  async executeNovel18(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novel18api/api/"
    );
  }
  /**
   * ランキングAPIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング結果
   * @see https://dev.syosetu.com/man/rankapi/
   */
  async executeRanking(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankget/");
  }
  /**
   * 殿堂入りAPiへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング履歴結果
   * @see https://dev.syosetu.com/man/rankinapi/
   */
  async executeRankingHistory(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankin/");
  }
  /**
   * ユーザー検索APIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/userapi/
   */
  async executeUserSearch(params) {
    return new NarouSearchResults(
      await this.execute(params, "https://api.syosetu.com/userapi/api/"),
      params
    );
  }
};

export {
  NarouNovel
};
//# sourceMappingURL=chunk-6BZWV4ZC.js.map