import {
  SearchBuilderBase
} from "./chunk-HOBLKBZ6.js";

// src/user-search.ts
var UserSearchBuilder = class _UserSearchBuilder extends SearchBuilderBase {
  /**
   * 単語を指定できます。
   * 半角または全角スペースで区切るとAND抽出になります。
   * 部分一致でHITします。検索の対象はユーザ名とユーザ名のフリガナです。
   */
  word(word) {
    this.set({ word });
    return this;
  }
  /**
   * 含みたくない単語を指定できます。
   * スペースで区切ることにより含ませない単語を増やせます。部分一致で除外されます。
   * 除外の対象はユーザ名とユーザ名のフリガナです。
   */
  notWord(notword) {
    this.set({ notword });
    return this;
  }
  /**
   * ユーザIDで抽出可能。
   */
  userId(userid) {
    this.set({ userid });
    return this;
  }
  /**
   * 抽出するユーザのユーザ名のフリガナの頭文字を指定できます。
   * 頭文字はユーザ名のフリガナをひらがなに変換し、最初の1文字が「ぁ」～「ん」の場合に対象となります。
   * 「ぱ」や「ば」等の半濁音や濁音は清音として扱われます。
   * 漢字や英数字が頭文字のユーザは対象外です。
   */
  name1st(name1st) {
    this.set({ name1st });
    return this;
  }
  /**
   * 抽出するユーザの小説投稿数の下限を指定できます。
   * 小説投稿件数が指定された数値以上のユーザを抽出します。
   */
  minNovel(minnovel) {
    this.set({ minnovel });
    return this;
  }
  /**
   * 抽出するユーザの小説投稿数の上限を指定できます。
   * 小説投稿件数が指定された数値以下のユーザを抽出します。
   */
  maxNovel(maxnovel) {
    this.set({ maxnovel });
    return this;
  }
  /**
   * 抽出するユーザのレビュー投稿数の下限を指定できます。
   * レビュー投稿件数が指定された数値以上のユーザを抽出します。
   */
  minReview(minreview) {
    this.set({ minreview });
    return this;
  }
  /**
   * 抽出するユーザのレビュー投稿数の上限を指定できます。
   * レビュー投稿件数が指定された数値以下のユーザを抽出します。
   */
  maxReview(maxreview) {
    this.set({ maxreview });
    return this;
  }
  /**
   * 出力する項目を個別に指定できます。未指定時は全項目出力されます。転送量軽減のため、このパラメータの使用が推奨されます。
   * @return {SearchBuilder} this
   */
  fields(fields) {
    this.set({ of: _UserSearchBuilder.array2string(fields) });
    return this;
  }
  /**
   * なろう小説APIへのリクエストを実行する
   * @returns ランキング
   */
  execute() {
    return this.api.executeUserSearch(this.params);
  }
};

export {
  UserSearchBuilder
};
//# sourceMappingURL=chunk-DEQICAN3.js.map