import { Annotations, CustomTransformer, ListBlockChildrenResponseResult, ListBlockChildrenResponseResults, MdBlock, NotionToMarkdownOptions, MdStringObject, BlockType } from "./types";
/**
 * Converts a Notion page to Markdown.
 */
export declare class NotionToMarkdown {
    private notionClient;
    private config;
    private customTransformers;
    constructor(options: NotionToMarkdownOptions);
    setCustomTransformer(type: BlockType, transformer: CustomTransformer): NotionToMarkdown;
    /**
     * Converts Markdown Blocks to string
     * @param {MdBlock[]} mdBlocks - Array of markdown blocks
     * @param {number} nestingLevel - Defines max depth of nesting
     * @returns {MdStringObject} - Returns markdown string with child pages separated
     */
    toMarkdownString(mdBlocks?: MdBlock[], pageIdentifier?: string, nestingLevel?: number): MdStringObject;
    /**
     * Retrieves Notion Blocks based on ID and converts them to Markdown Blocks
     * @param {string} id - notion page id (not database id)
     * @param {number} totalPage - Retrieve block children request number, page_size Maximum = totalPage * 100 (Default=null)
     * @returns {Promise<MdBlock[]>} - List of markdown blocks
     */
    pageToMarkdown(id: string, totalPage?: number | null): Promise<MdBlock[]>;
    /**
     * Converts list of Notion Blocks to Markdown Blocks
     * @param {ListBlockChildrenResponseResults | undefined} blocks - List of notion blocks
     * @param {number} totalPage - Retrieve block children request number, page_size Maximum = totalPage * 100
     * @param {MdBlock[]} mdBlocks - Array of markdown blocks
     * @returns {Promise<MdBlock[]>} - Array of markdown blocks with their children
     */
    blocksToMarkdown(blocks?: ListBlockChildrenResponseResults, totalPage?: number | null, mdBlocks?: MdBlock[]): Promise<MdBlock[]>;
    /**
     * Converts a Notion Block to a Markdown Block
     * @param {ListBlockChildrenResponseResult} block - single notion block
     * @returns {string} corresponding markdown string of the passed block
     */
    blockToMarkdown(block: ListBlockChildrenResponseResult): Promise<string>;
    /**
     * Annoate text using provided annotations
     * @param {string} text - String to be annotated
     * @param {Annotations} annotations - Annotation object of a notion block
     * @returns {string} - Annotated text
     */
    annotatePlainText(text: string, annotations: Annotations): string;
}
//# sourceMappingURL=notion-to-md.d.ts.map