import { YTNode } from '../helpers.js';
import { Parser } from '../index.js';
import NavigationEndpoint from './NavigationEndpoint.js';
import Text from './misc/Text.js';
export default class PlaylistSidebarPrimaryInfo extends YTNode {
    static type = 'PlaylistSidebarPrimaryInfo';
    stats;
    thumbnail_renderer;
    title;
    menu;
    endpoint;
    description;
    constructor(data) {
        super();
        this.stats = data.stats.map((stat) => new Text(stat));
        this.thumbnail_renderer = Parser.parseItem(data.thumbnailRenderer);
        this.title = new Text(data.title);
        this.menu = Parser.parseItem(data.menu);
        this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
        this.description = new Text(data.description);
    }
}
//# sourceMappingURL=PlaylistSidebarPrimaryInfo.js.map