import type { Token as TokenInterface } from "@bbob/types";
export declare const TYPE_ID = "t";
export declare const VALUE_ID = "v";
export declare const LINE_ID = "l";
export declare const COLUMN_ID = "r";
export declare const START_POS_ID = "s";
export declare const END_POS_ID = "e";
export declare const TYPE_WORD = 1;
export declare const TYPE_TAG = 2;
export declare const TYPE_ATTR_NAME = 3;
export declare const TYPE_ATTR_VALUE = 4;
export declare const TYPE_SPACE = 5;
export declare const TYPE_NEW_LINE = 6;
/**
 * @export
 * @class Token
 */
declare class Token<TokenValue = string> implements TokenInterface {
    readonly t: number;
    readonly v: string;
    readonly l: number;
    readonly r: number;
    readonly s: number;
    readonly e: number;
    constructor(type?: number, value?: TokenValue, row?: number, col?: number, start?: number, end?: number);
    get type(): number;
    isEmpty(): boolean;
    isText(): boolean;
    isTag(): boolean;
    isAttrName(): boolean;
    isAttrValue(): boolean;
    isStart(): boolean;
    isEnd(): boolean;
    getName(): string;
    getValue(): string;
    getLine(): number;
    getColumn(): number;
    getStart(): number;
    getEnd(): number;
    toString({ openTag, closeTag }?: {
        openTag?: string | undefined;
        closeTag?: string | undefined;
    }): string;
}
export { Token };
export default Token;
//# sourceMappingURL=Token.d.mts.map