import { isTagNode } from "@bbob/plugin-helper";
export function process(tags, tree, core, options) {
    return tree.walk((node)=>{
        if (isTagNode(node)) {
            const tag = node.tag;
            const tagCallback = tags[tag];
            if (typeof tagCallback === "function") {
                return tagCallback(node, core, options);
            }
        }
        return node;
    });
}
/**
 * Create a preset plugin for @bbob/core
 */ function createPreset(defTags, processor = process) {
    const presetFactory = (opts)=>{
        presetFactory.options = Object.assign(presetFactory.options || {}, opts);
        function presetExecutor(tree, core) {
            return processor(defTags, tree, core, presetFactory.options || {});
        }
        presetExecutor.options = presetFactory.options;
        return presetExecutor;
    };
    presetFactory.extend = function presetExtend(callback) {
        const newTags = callback(defTags, presetFactory.options);
        return createPreset(newTags, processor);
    };
    return presetFactory;
}
export { createPreset };
export default createPreset;
