"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createPreset: function() {
        return createPreset;
    },
    default: function() {
        return _default;
    },
    process: function() {
        return process;
    }
});
var _pluginhelper = require("@bbob/plugin-helper");
function process(tags, tree, core, options) {
    return tree.walk(function(node) {
        if ((0, _pluginhelper.isTagNode)(node)) {
            var tag = node.tag;
            var tagCallback = tags[tag];
            if (typeof tagCallback === "function") {
                return tagCallback(node, core, options);
            }
        }
        return node;
    });
}
/**
 * Create a preset plugin for @bbob/core
 */ function createPreset(defTags, processor) {
    if (processor === void 0) processor = process;
    var presetFactory = function(opts) {
        var presetExecutor = function presetExecutor(tree, core) {
            return processor(defTags, tree, core, presetFactory.options || {});
        };
        presetFactory.options = Object.assign(presetFactory.options || {}, opts);
        presetExecutor.options = presetFactory.options;
        return presetExecutor;
    };
    presetFactory.extend = function presetExtend(callback) {
        var newTags = callback(defTags, presetFactory.options);
        return createPreset(newTags, processor);
    };
    return presetFactory;
}
var _default = createPreset;
