import * as openapi_fetch from 'openapi-fetch';
import { ClientOptions } from 'openapi-fetch';
import { paths } from './schema.cjs';

type Client = Readonly<{
    baseUrl: string;
} & ReturnType<typeof createClient>>;
declare function getDefaultClient(): Client;
declare function setDefaultClient(newClient: Client): void;
declare function createClient({ baseUrl, ...options }?: ClientOptions): Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>;

export { type Client, createClient, getDefaultClient, setDefaultClient };
