import { Activity, Action } from '@rss3/api-core';
import { Theme } from './theme.cjs';
export { themePlain } from './theme.cjs';
import { Token } from './token.cjs';

declare function getSummaryActions({ actions, tag, type }: Activity): Action[];
declare function formatPlain(activity: Activity): string;
/**
 * Format an activity into a list of tokens that can be used to custom render the output of a activity, such as CLI output.
 */
declare function format<T>(activity: Activity, theme: Theme<T>): T[];
/**
 * Returns a list of tokens that can be used to custom render the output of a activity, such as CLI output
 * all the symbols in blue color.
 */
declare function tokenizeActivity(activity: Activity): Token[];
declare function tokenizeToActions(activity: Activity): Token[][];
declare function tokenizeToSummaryActions(activity: Activity): Token[][];
/**
 * Returns a list of tokens that can be used to custom render the output of an action, such as CLI output
 */
declare function tokenizeAction(activity: Activity, action: Action): Token[];
declare function hasMultiPrimaryActions(activity: Activity): boolean;
declare function flatActivity(activity: Activity): {
    actions: {
        from: string;
        metadata: {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action: "approve" | "revoke";
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action: "deposit" | "withdraw";
            sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
            targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
            token?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action: "approve" | "revoke";
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
            address?: string | undefined;
            cost?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            from?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            to?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
        } | {
            action: "withdraw" | "add" | "remove" | "collect" | "supply" | "borrow" | "repay";
            tokens: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            }[];
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: any | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            action?: "update" | "create" | "renew" | "wrap" | "unwrap" | undefined;
            address?: string | undefined;
            bio?: string | undefined;
            expiry?: string | undefined;
            handle?: string | undefined;
            imageUri?: string | undefined;
            key?: string | undefined;
            name?: string | undefined;
            profileId?: string | undefined;
            value?: string | undefined;
        } | {
            action?: "remove" | "appoint" | undefined;
            profile?: {
                action?: "update" | "create" | "renew" | "wrap" | "unwrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | undefined;
            proxyAddress: string;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action?: "buy" | "sell" | "list" | undefined;
            address?: string | undefined;
            cost?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            authors?: {
                name: string;
            }[] | undefined;
            description: string;
            pubDate?: string | undefined;
            title: string;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            action: "stake" | "unstake" | "claim";
            period?: {
                end?: {
                    ext: number;
                    loc?: {
                        cacheEnd: number;
                        cacheStart: number;
                        cacheZone?: {
                            isDST: boolean;
                            name: string;
                            offset: number;
                        } | undefined;
                        extend: string;
                        name: string;
                        tx: {
                            index: number;
                            isstd: boolean;
                            isutc: boolean;
                            when: number;
                        }[];
                        zone: {
                            isDST: boolean;
                            name: string;
                            offset: number;
                        }[];
                    } | undefined;
                    wall: number;
                } | undefined;
                start?: {
                    ext: number;
                    loc?: {
                        cacheEnd: number;
                        cacheStart: number;
                        cacheZone?: {
                            isDST: boolean;
                            name: string;
                            offset: number;
                        } | undefined;
                        extend: string;
                        name: string;
                        tx: {
                            index: number;
                            isstd: boolean;
                            isutc: boolean;
                            when: number;
                        }[];
                        zone: {
                            isDST: boolean;
                            name: string;
                            offset: number;
                        }[];
                    } | undefined;
                    wall: number;
                } | undefined;
            } | undefined;
            token?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            authorUrl?: string | undefined;
            body?: string | undefined;
            contentUri?: string | undefined;
            handle?: string | undefined;
            media?: {
                address: string;
                mimeType: string;
            }[] | undefined;
            profileId?: string | undefined;
            publicationId?: string | undefined;
            reward?: {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | undefined;
            summary?: string | undefined;
            tags?: string[] | undefined;
            target?: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | undefined;
            targetUrl?: string | undefined;
            timestamp?: number | undefined;
            title?: string | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        } | {
            address?: string | undefined;
            decimals?: number | undefined;
            id?: string | undefined;
            name?: string | undefined;
            parsedImageUrl?: string | undefined;
            standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
            symbol?: string | undefined;
            uri?: string | undefined;
            value?: string | undefined;
        };
        platform?: "Nouns" | "OpenSea" | "1inch" | "Cow" | "Rainbow" | "Uniswap" | "Zerion" | "Lido" | "Crossbell" | "Lens" | "ENS" | "Mirror" | "Aavegotchi" | "AAVE" | "Arbitrum" | "Base" | "BendDAO" | "Curve" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "LiNEAR" | "Linea" | "LooksRare" | "Matters" | "NearSocial" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "SAVM" | "Stargate" | "Unknown" | "VSL" | undefined;
        relatedUrls: string[];
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        to: string;
        type: string;
    }[];
    calldata?: {
        functionHash?: string | undefined;
        parsedFunction?: string | undefined;
        raw?: string | undefined;
    } | undefined;
    direction?: "in" | "out" | "self" | undefined;
    fee?: {
        address?: string | undefined;
        amount: string;
        decimal?: number | undefined;
    } | undefined;
    from: string;
    id: string;
    index: number;
    network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
    owner: string;
    platform?: "Nouns" | "OpenSea" | "1inch" | "Cow" | "Rainbow" | "Uniswap" | "Zerion" | "Lido" | "Crossbell" | "Lens" | "ENS" | "Mirror" | "Aavegotchi" | "AAVE" | "Arbitrum" | "Base" | "BendDAO" | "Curve" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "LiNEAR" | "Linea" | "LooksRare" | "Matters" | "NearSocial" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "SAVM" | "Stargate" | "Unknown" | "VSL" | undefined;
    success: boolean;
    tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
    timestamp: number;
    to: string;
    totalActions: number;
    type?: "unknown" | "transfer" | "approval" | "mint" | "burn" | "bridge" | "trade" | "swap" | "liquidity" | "reward" | "post" | "comment" | "share" | "profile" | "proxy" | "revise" | "delete" | "staking" | "auction" | "feed" | "loan" | "proposal" | "vote" | undefined;
}[];

export { Theme, flatActivity, format, formatPlain, getSummaryActions, hasMultiPrimaryActions, tokenizeAction, tokenizeActivity, tokenizeToActions, tokenizeToSummaryActions };
