import { Action, CollectibleTransfer, CollectibleTrade, CollectibleApproval } from '@rss3/api-core';

type BriefAsset = {
    contract?: string | null;
    id?: string | null;
    url?: string;
    title?: string;
    description?: string;
};
declare function extractAsset(action: Action): BriefAsset | undefined;
declare function extractNFT(m: CollectibleTransfer | CollectibleTrade | CollectibleApproval): {
    address: string | undefined;
    id: string | undefined;
    url: string | undefined;
    title: string | undefined;
    standard: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
};

export { type BriefAsset, extractAsset, extractNFT };
