import type { ApiReferenceConfigurationWithSource, HtmlRenderingConfiguration } from '@scalar/types/api-reference';
export type { HtmlRenderingConfiguration };
/**
 * The HTML document to render the Scalar API reference.
 *
 * We must check the passed in configuration and not the configuration for the theme as the configuration will have it
 * defaulted to 'default'
 */
export declare const getHtmlDocument: (givenConfiguration: Partial<HtmlRenderingConfiguration>, customTheme?: string) => string;
/**
 * The script tags to load the @scalar/api-reference package from the CDN.
 */
export declare function getScriptTags(configuration: Partial<ApiReferenceConfigurationWithSource>, cdn?: string): string;
/**
 * The configuration to pass to the @scalar/api-reference package.
 */
export declare const getConfiguration: (givenConfiguration: Partial<ApiReferenceConfigurationWithSource>) => Partial<ApiReferenceConfigurationWithSource>;
//# sourceMappingURL=html-rendering.d.ts.map