# dts-resolver

[![npm version][npm-version-src]][npm-version-href]
[![npm downloads][npm-downloads-src]][npm-downloads-href]
[![Unit Test][unit-test-src]][unit-test-href]

Resolves TypeScript declaration files for dependencies, powered by [oxc-resolver](https://oxc.rs/docs/guide/usage/resolver.html).

## Install

```bash
npm i dts-resolver
```

## Usage

```ts
import { createResolver } from 'dts-resolver'

const resolver = createResolver({
  // optional
  cwd: process.cwd(),
})

resolver('fast-glob') // .../node_modules/fast-glob/out/index.d.ts
```

## Sponsors

<p align="center">
  <a href="https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg">
    <img src='https://cdn.jsdelivr.net/gh/sxzz/sponsors/sponsors.svg'/>
  </a>
</p>

## License

[MIT](./LICENSE) License © 2025-PRESENT [Kevin Deng](https://github.com/sxzz)

<!-- Badges -->

[npm-version-src]: https://img.shields.io/npm/v/dts-resolver.svg
[npm-version-href]: https://npmjs.com/package/dts-resolver
[npm-downloads-src]: https://img.shields.io/npm/dm/dts-resolver
[npm-downloads-href]: https://www.npmcharts.com/compare/dts-resolver?interval=30
[unit-test-src]: https://github.com/sxzz/dts-resolver/actions/workflows/unit-test.yml/badge.svg
[unit-test-href]: https://github.com/sxzz/dts-resolver/actions/workflows/unit-test.yml
