import camelcaseKeys from 'camelcase-keys';
import decamelizedKeys from 'decamelize-keys';
import FormData from 'form-data';
import got from 'got';
import hmacsha1 from 'hmacsha1';
import OAuth from 'oauth-1.0a';
import queryString from 'query-string';
import * as api from './api.js';
import FanfouError from './ff-error.js';
class Fanfou {
    consumerKey;
    consumerSecret;
    oauthToken;
    oauthTokenSecret;
    username;
    password;
    protocol;
    apiDomain;
    oauthDomain;
    hooks;
    apiEndPoint;
    oauthEndPoint;
    o;
    constructor(options = {}) {
        this.consumerKey = options.consumerKey ?? '';
        this.consumerSecret = options.consumerSecret ?? '';
        this.oauthToken = options.oauthToken ?? '';
        this.oauthTokenSecret = options.oauthTokenSecret ?? '';
        this.username = options.username ?? '';
        this.password = options.password ?? '';
        this.protocol = options.protocol ?? 'http:';
        this.apiDomain = options.apiDomain ?? 'api.fanfou.com';
        this.oauthDomain = options.oauthDomain ?? 'fanfou.com';
        this.hooks = options.hooks ?? {};
        this.apiEndPoint = `${this.protocol}//${this.apiDomain}`;
        this.oauthEndPoint = `${this.protocol}//${this.oauthDomain}`;
        this.o = new OAuth({
            consumer: { key: this.consumerKey, secret: this.consumerSecret },
            // eslint-disable-next-line @typescript-eslint/naming-convention
            signature_method: 'HMAC-SHA1',
            // eslint-disable-next-line @typescript-eslint/naming-convention
            parameter_seperator: ',',
            /* c8 ignore start  */
            // eslint-disable-next-line @typescript-eslint/naming-convention
            hash_function: (baseString, key) => {
                const { baseString: baseStringHook } = this.hooks;
                if (baseStringHook) {
                    baseString = baseStringHook(baseString);
                }
                return hmacsha1(key, baseString);
            },
            /* c8 ignore stop  */
        });
    }
    async getRequestToken() {
        const url = `${this.oauthEndPoint}/oauth/request_token`;
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const { Authorization } = this.o.toHeader(this.o.authorize({ url, method: 'GET' }));
        try {
            const response = await got.get(url, {
                // eslint-disable-next-line @typescript-eslint/naming-convention
                headers: { Authorization },
            });
            const { body } = response;
            const result = queryString.parse(body);
            this.oauthToken = result['oauth_token'];
            this.oauthTokenSecret = result['oauth_token_secret'];
            return this;
            /* c8 ignore start */
        }
        catch (error) {
            throw new FanfouError(error);
        }
        /* c8 ignore stop */
    }
    async getAccessToken(token) {
        const url = `${this.oauthEndPoint}/oauth/access_token`;
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const { Authorization } = this.o.toHeader(this.o.authorize({ url, method: 'GET' }, { key: token.oauthToken, secret: token.oauthTokenSecret }));
        try {
            const response = await got.get(url, {
                // eslint-disable-next-line @typescript-eslint/naming-convention
                headers: { Authorization },
            });
            const { body } = response;
            const result = queryString.parse(body);
            this.oauthToken = result['oauth_token'];
            this.oauthTokenSecret = result['oauth_token_secret'];
            return this;
            /* c8 ignore start */
        }
        catch (error) {
            throw new FanfouError(error);
        }
        /* c8 ignore stop */
    }
    async xauth() {
        const url = `${this.oauthEndPoint}/oauth/access_token`;
        const parameters = {
            // eslint-disable-next-line @typescript-eslint/naming-convention
            x_auth_mode: 'client_auth',
            // eslint-disable-next-line @typescript-eslint/naming-convention
            x_auth_password: this.password,
            // eslint-disable-next-line @typescript-eslint/naming-convention
            x_auth_username: this.username,
        };
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const { Authorization } = this.o.toHeader(this.o.authorize({ url, method: 'POST' }));
        try {
            const response = await got.post(url, {
                headers: {
                    // eslint-disable-next-line @typescript-eslint/naming-convention
                    Authorization,
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: queryString.stringify(parameters),
            });
            const { body } = response;
            const result = queryString.parse(body);
            this.oauthToken = result['oauth_token'];
            this.oauthTokenSecret = result['oauth_token_secret'];
            return this;
            /* c8 ignore start */
        }
        catch (error) {
            throw new FanfouError(error);
        }
        /* c8 ignore stop */
    }
    async get(uri, parameters = {}) {
        parameters = decamelizedKeys(parameters);
        const query = queryString.stringify(parameters);
        const url = `${this.apiEndPoint}${uri}.json${query ? `?${query}` : ''}`;
        const token = { key: this.oauthToken, secret: this.oauthTokenSecret };
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const { Authorization } = this.o.toHeader(this.o.authorize({ url, method: 'GET' }, token));
        try {
            const { body } = await got.get(url, {
                headers: {
                    // eslint-disable-next-line @typescript-eslint/naming-convention
                    Authorization,
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
            });
            // eslint-disable-next-line @typescript-eslint/no-unsafe-return
            return camelcaseKeys(JSON.parse(body), { deep: true });
            /* c8 ignore start */
        }
        catch (error) {
            throw new FanfouError(error);
        }
        /* c8 ignore stop */
    }
    async post(uri, parameters = {}) {
        parameters = decamelizedKeys(parameters);
        const url = `${this.apiEndPoint}${uri}.json`;
        const token = { key: this.oauthToken, secret: this.oauthTokenSecret };
        const isUpload = [
            '/photos/upload',
            '/account/update_profile_image',
        ].includes(uri);
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const { Authorization } = this.o.toHeader(this.o.authorize({ url, method: 'POST', data: isUpload ? null : parameters }, token));
        let form;
        const headers = {
            // eslint-disable-next-line @typescript-eslint/naming-convention
            Authorization,
            'Content-Type': 'application/x-www-form-urlencoded',
        };
        if (isUpload) {
            form = new FormData();
            for (const key of Object.keys(parameters)) {
                form.append(key, parameters[key]);
            }
            // @ts-expect-error: Drop `Content-Type`
            delete headers['Content-Type'];
        }
        try {
            const { body } = await got.post(url, {
                headers,
                // @ts-expect-error: Can be `undefined`
                body: isUpload ? form : queryString.stringify(parameters),
            });
            // eslint-disable-next-line @typescript-eslint/no-unsafe-return
            return camelcaseKeys(JSON.parse(body), { deep: true });
            /* c8 ignore start */
        }
        catch (error) {
            throw new FanfouError(error);
        }
        /* c8 ignore stop */
    }
    /* c8 ignore start */
    acceptFriendship = async (options) => api.acceptFriendship(this, options);
    checkBlockExists = async (options) => api.checkBlockExists(this, options);
    checkFriendship = async (options) => api.checkFriendship(this, options);
    checkFriendshipDetail = async (options) => api.checkFriendshipDetail(this, options);
    checkFriendshipRequests = async (options) => api.checkFriendshipRequests(this, options);
    createBlockedUser = async (options) => api.createBlockedUser(this, options);
    createDirectMessage = async (options) => api.createDirectMessage(this, options);
    createFavorite = async (options) => api.createFavorite(this, options);
    createFriendship = async (options) => api.createFriendship(this, options);
    createSavedSearch = async (options) => api.createSavedSearch(this, options);
    createStatus = async (options) => api.createStatus(this, options);
    denyFriendship = async (options) => api.denyFriendship(this, options);
    dismissRecommendedUser = async (options) => api.dismissRecommendedUser(this, options);
    dropBlockedUser = async (options) => api.dropBlockedUser(this, options);
    dropDirectMessage = async (options) => api.dropDirectMessage(this, options);
    dropFavorite = async (options) => api.dropFavorite(this, options);
    dropFriendship = async (options) => api.dropFriendship(this, options);
    dropSavedSearch = async (options) => api.dropSavedSearch(this, options);
    dropStatus = async (options) => api.dropStatus(this, options);
    getBlockedIds = async () => api.getBlockedIds(this);
    getBlockedUsers = async (options) => api.getBlockedUsers(this, options);
    getContextTimeline = async (options) => api.getContextTimeline(this, options);
    getConversation = async (options) => api.getConversation(this, options);
    getConversations = async (options) => api.getConversations(this, options);
    getFavorites = async (options) => api.getFavorites(this, options);
    getFollowerIds = async (options) => api.getFollowerIds(this, options);
    getFollowers = async (options) => api.getFollowers(this, options);
    getFollowingIds = async (options) => api.getFollowingIds(this, options);
    getFollowings = async (options) => api.getFollowings(this, options);
    getHomeTimeline = async (options) => api.getHomeTimeline(this, options);
    getInbox = async (options) => api.getInbox(this, options);
    getMentions = async (options) => api.getMentions(this, options);
    getNotification = async () => api.getNotification(this);
    getPublicTimeline = async (options) => api.getPublicTimeline(this, options);
    getRateLimitStatus = async (options) => api.getRateLimitStatus(this, options);
    getRecentFollowers = async (options) => api.getRecentFollowers(this, options);
    getRecentUsers = async (options) => api.getRecentUsers(this, options);
    getRecommendedUsers = async (options) => api.getRecommendedUsers(this, options);
    getReplies = async (options) => api.getReplies(this, options);
    getSavedSearch = async (options) => api.getSavedSearch(this, options);
    getSavedSearches = async (options) => api.getSavedSearches(this, options);
    getSent = async (options) => api.getSent(this, options);
    getStatus = async (options) => api.getStatus(this, options);
    getTaggedUsers = async (options) => api.getTaggedUsers(this, options);
    getTrends = async (options) => api.getTrends(this, options);
    getUser = async (options) => api.getUser(this, options);
    getUserPhotos = async (options) => api.getUserPhotos(this, options);
    getUserTags = async (options) => api.getUserTags(this, options);
    getUserTimeline = async (options) => api.getUserTimeline(this, options);
    searchPublicTimeline = async (options) => api.searchPublicTimeline(this, options);
    searchUserTimeline = async (options) => api.searchUserTimeline(this, options);
    searchUsers = async (options) => api.searchUsers(this, options);
    updateNotifyNumber = async (options) => api.updateNotifyNumber(this, options);
    updateProfile = async (options) => api.updateProfile(this, options);
    updateProfileImage = async (options) => api.updateProfileImage(this, options);
    uploadPhoto = async (options) => api.uploadPhoto(this, options);
    verifyCredentials = async (options) => api.verifyCredentials(this, options);
}
export default Fanfou;
