import { Token } from '../token';
import type * as ESTree from '../estree';
import { type Location, Flags, type AssignmentKind, type DestructuringKind } from '../common';
import { Errors } from '../errors';
import { type NormalizedOptions, type OnComment, type OnToken } from '../options';
import { Scope, type ScopeKind } from './scope';
import { PrivateScope } from './private-scope';
export declare class Parser {
    readonly source: string;
    readonly options: NormalizedOptions;
    private lastOnToken;
    token: Token;
    flags: Flags;
    index: number;
    line: number;
    column: number;
    startIndex: number;
    end: number;
    tokenIndex: number;
    startColumn: number;
    tokenColumn: number;
    tokenLine: number;
    startLine: number;
    tokenValue: any;
    tokenRaw: string;
    tokenRegExp: void | {
        pattern: string;
        flags: string;
    };
    currentChar: number;
    exportedNames: Set<string>;
    exportedBindings: Set<string>;
    assignable: AssignmentKind | DestructuringKind;
    destructible: AssignmentKind | DestructuringKind;
    leadingDecorators: {
        start?: Location;
        decorators: ESTree.Decorator[];
    };
    constructor(source: string, options?: NormalizedOptions);
    getToken(): Token;
    setToken(value: Token, replaceLast?: boolean): Token;
    get tokenStart(): Location;
    get currentLocation(): Location;
    finishNode<T extends ESTree.Node>(node: T, start: Location, end: Location | void): T;
    addBindingToExports(name: string): void;
    declareUnboundVariable(name: string): void;
    report(type: Errors, ...params: string[]): never;
    createScopeIfLexical(type?: ScopeKind, parent?: Scope): Scope | undefined;
    createScope(type?: ScopeKind, parent?: Scope): Scope;
    createPrivateScopeIfLexical(parent?: PrivateScope): PrivateScope | undefined;
}
export declare function pushComment(comments: ESTree.Comment[], options: NormalizedOptions): OnComment;
export declare function pushToken(tokens: Token[], options: NormalizedOptions): OnToken;
