import { isBrowser } from "./is.mjs";

//#region src/lib/http.ts
const BASE_URL = "https://mixi.social/api/connect/com.mixi.mercury.api.MercuryService";
var Http = class {
	cookie;
	authKey;
	baseUrl;
	httpAdapter;
	constructor(cookie, authKey, options) {
		this.cookie = cookie;
		this.authKey = authKey;
		this.baseUrl = options?.baseUrl || BASE_URL;
		this.httpAdapter = options?.httpAdapter;
	}
	async request(path, body) {
		const headers = {
			"x-auth-key": this.authKey,
			"x-mercury-user-agent": "Mercury-web/3.2.0",
			"content-type": "application/proto"
		};
		if (isBrowser()) {
			if (this.cookie) headers["x-proxy-cookie"] = this.cookie;
		} else headers.cookie = this.cookie;
		const requestOptions = {
			method: "POST",
			headers,
			body
		};
		const response = await (this.httpAdapter ? this.httpAdapter(`${this.baseUrl}${path}`, requestOptions) : fetch(`${this.baseUrl}${path}`, requestOptions));
		if (response.status >= 400) throw new Error(`${response.status}: ${response.statusText}`);
		return response;
	}
};

//#endregion
export { Http };