import "./chunk-4ZP5YNWI.js";
import {
  formatRankingHistory
} from "./chunk-VZVUANDN.js";
import {
  RankingBuilder
} from "./chunk-BQLSW236.js";
import {
  SearchBuilderR18
} from "./chunk-E2H3AJSQ.js";
import {
  UserSearchBuilder
} from "./chunk-DEQICAN3.js";
import {
  NovelSearchBuilderBase,
  SearchBuilder,
  SearchBuilderBase
} from "./chunk-HOBLKBZ6.js";
import {
  BigGenre,
  BigGenreNotation,
  BooleanNumber,
  BuntaiParam,
  DateParam,
  Fields,
  Genre,
  GenreNotation,
  NovelTypeParam,
  OptionalFields,
  Order,
  R18Fields,
  R18Site,
  R18SiteNotation,
  RankingType,
  StopParam,
  UserFields,
  UserOrder
} from "./chunk-5UDKQCPJ.js";
import "./chunk-RNHRR56W.js";
import {
  NarouNovelJsonp
} from "./chunk-LQLNWSWV.js";
import "./chunk-IPDEGCWU.js";
import {
  NarouNovel
} from "./chunk-6BZWV4ZC.js";
import {
  End,
  NarouSearchResults,
  NovelType
} from "./chunk-3A5MHPWL.js";

// src/index.browser.ts
var narouNovelJsonp = new NarouNovelJsonp();
function search(word = "", api = narouNovelJsonp) {
  const builder = new SearchBuilder({}, api);
  if (word != "") builder.word(word);
  return builder;
}
function searchR18(word = "", api = narouNovelJsonp) {
  const builder = new SearchBuilderR18({}, api);
  if (word != "") builder.word(word);
  return builder;
}
function searchUser(word = "", api = narouNovelJsonp) {
  const builder = new UserSearchBuilder({}, api);
  if (word != "") builder.word(word);
  return builder;
}
function ranking(api = narouNovelJsonp) {
  const builder = new RankingBuilder({}, api);
  return builder;
}
async function rankingHistory(ncode, api = narouNovelJsonp) {
  const result = await api.executeRankingHistory({ ncode });
  if (Array.isArray(result)) {
    return result.map(formatRankingHistory);
  } else {
    throw new Error(result);
  }
}
var index_browser_default = {
  search,
  searchR18,
  searchUser,
  ranking,
  rankingHistory
};
export {
  BigGenre,
  BigGenreNotation,
  BooleanNumber,
  BuntaiParam,
  DateParam,
  End,
  Fields,
  Genre,
  GenreNotation,
  NarouNovel,
  NarouNovelJsonp,
  NarouSearchResults,
  NovelSearchBuilderBase,
  NovelType,
  NovelTypeParam,
  OptionalFields,
  Order,
  R18Fields,
  R18Site,
  R18SiteNotation,
  RankingBuilder,
  RankingType,
  SearchBuilder,
  SearchBuilderBase,
  SearchBuilderR18,
  StopParam,
  UserFields,
  UserOrder,
  index_browser_default as default,
  formatRankingHistory,
  ranking,
  rankingHistory,
  search,
  searchR18,
  searchUser
};
//# sourceMappingURL=index.browser.js.map