/**
 * 圧縮されたJSONデータを解凍して解析します。
 *
 * @param data - ArrayBuffer形式の圧縮データ
 * @returns 解凍されたデータからパースされたJSONオブジェクト
 * @throws {string} データが解凍できない、または解凍されたデータが有効なJSONでない場合、
 *                  解凍されたデータの文字列表現をスローします。
 * @throws {string} 解凍中にエラーが発生した場合、元のデータの文字列表現をスローします。
 */
declare function unzipp(data: ArrayBuffer): Promise<any>;

export { unzipp };
