/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * This file is based on WME Lite.
 * http://dead-code.org/redir.php?target=wmelite
 * Copyright (c) 2011 Jan Nedoma
 */

#ifndef WINTERMUTE_BASE_TRANSITION_MANAGER_H
#define WINTERMUTE_BASE_TRANSITION_MANAGER_H

#include "engines/wintermute/base/base.h"

namespace Wintermute {

class BaseTransitionMgr : public BaseClass {
public:
	bool _started;
	uint32 _lastTime;
	bool _origInteractive;
	bool _preserveInteractive;
	bool update();
	bool start(TTransitionType type, bool nonInteractive = false);
	bool isReady();
	TTransMgrState _state;
	BaseTransitionMgr(BaseGame *inGame);
	~BaseTransitionMgr() override;
	TTransitionType _type;
};

} // End of namespace Wintermute

#endif
