/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include "scumm/charset.h"
#include "scumm/scumm.h"

namespace Scumm {

// English Zak font
static const byte englishCharsetDataV2[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x03, 0x06, 0x0C, 0x18, 0x3E, 0x03, 0x00,
	0x80, 0xC0, 0x60, 0x30, 0x18, 0x7C, 0xC0, 0x00,
	0x00, 0x03, 0x3E, 0x18, 0x0C, 0x06, 0x03, 0x01,
	0x00, 0xC0, 0x7C, 0x18, 0x30, 0x60, 0xC0, 0x80,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x07, 0x07, 0x0F, 0x1F, 0x7F,
	0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0,
	0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07,
	0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x0C, 0x18,
	0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x18,
	0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00,
	0x18, 0x0C, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1F, 0x1F, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0xF8, 0xF8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x1F, 0x1F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x07, 0x0C, 0x18, 0x18,
	0x00, 0x00, 0x00, 0xC0, 0xE0, 0x30, 0x18, 0x18,
	0x18, 0x18, 0x30, 0xE0, 0xC0, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x0C, 0x07, 0x03, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xF8, 0xF8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xFF, 0xFF, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
	0x18, 0x3C, 0x66, 0xC3, 0xC3, 0x66, 0x3C, 0x18,
	0x18, 0x3C, 0x7E, 0xFF, 0xFF, 0x7E, 0x3C, 0x18,
	0x18, 0x66, 0xC3, 0xDB, 0xDB, 0xC3, 0x66, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00,
	0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x66, 0x66, 0xFF, 0x66, 0xFF, 0x66, 0x66, 0x00,
	0x18, 0x3E, 0x58, 0x3C, 0x1A, 0x7C, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x00,
	0x3C, 0x66, 0x3C, 0x38, 0x67, 0x66, 0x3F, 0x00,
	0x06, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00,
	0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00,
	0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30,
	0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00,
	0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7E, 0x00,
	0x3C, 0x66, 0x06, 0x0C, 0x30, 0x60, 0x7E, 0x00,
	0x3C, 0x66, 0x06, 0x1C, 0x06, 0x66, 0x3C, 0x00,
	0x06, 0x0E, 0x1E, 0x66, 0x7F, 0x06, 0x06, 0x00,
	0x7E, 0x60, 0x7C, 0x06, 0x06, 0x66, 0x3C, 0x00,
	0x3C, 0x66, 0x60, 0x7C, 0x66, 0x66, 0x3C, 0x00,
	0x7E, 0x66, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00,
	0x3C, 0x66, 0x66, 0x3E, 0x06, 0x66, 0x3C, 0x00,
	0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30,
	0x0E, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0E, 0x00,
	0x7C, 0x82, 0xBA, 0xA2, 0xBA, 0x82, 0x7C, 0x00,
	0x70, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x70, 0x00,
	0x3C, 0x66, 0x06, 0x0C, 0x18, 0x00, 0x18, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
	0x18, 0x3C, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00,
	0x7C, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x7C, 0x00,
	0x3C, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3C, 0x00,
	0x78, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0x78, 0x00,
	0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7E, 0x00,
	0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00,
	0x3C, 0x66, 0x60, 0x6E, 0x66, 0x66, 0x3C, 0x00,
	0x66, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00,
	0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00,
	0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x6C, 0x38, 0x00,
	0x66, 0x6C, 0x78, 0x70, 0x78, 0x6C, 0x66, 0x00,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x00,
	0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x63, 0x00,
	0x66, 0x76, 0x7E, 0x7E, 0x6E, 0x66, 0x66, 0x00,
	0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0x00,
	0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x0E, 0x00,
	0x7C, 0x66, 0x66, 0x7C, 0x78, 0x6C, 0x66, 0x00,
	0x3C, 0x66, 0x60, 0x3C, 0x06, 0x66, 0x3C, 0x00,
	0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00,
	0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00,
	0x66, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x66, 0x00,
	0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x00,
	0x7E, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x7E, 0x00,
	0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00,
	0x0C, 0x12, 0x30, 0x7C, 0x30, 0x62, 0xFC, 0x00,
	0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xDB, 0xDB, 0x00,
	0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00,
	0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x06, 0x3E, 0x66, 0x3E, 0x00,
	0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x7C, 0x00,
	0x00, 0x00, 0x3C, 0x60, 0x60, 0x60, 0x3C, 0x00,
	0x00, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x00,
	0x00, 0x00, 0x3C, 0x66, 0x7E, 0x60, 0x3C, 0x00,
	0x00, 0x0E, 0x18, 0x3E, 0x18, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x7C,
	0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x00,
	0x00, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3C, 0x00,
	0x00, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x3C,
	0x00, 0x60, 0x60, 0x6C, 0x78, 0x6C, 0x66, 0x00,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00,
	0x00, 0x00, 0x66, 0x7F, 0x7F, 0x6B, 0x63, 0x00,
	0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60,
	0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x06,
	0x00, 0x00, 0x7C, 0x66, 0x60, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x00,
	0x00, 0x18, 0x7E, 0x18, 0x18, 0x18, 0x0E, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3E, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00,
	0x00, 0x00, 0x63, 0x6B, 0x7F, 0x3E, 0x36, 0x00,
	0x00, 0x00, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x0C, 0x78,
	0x00, 0x00, 0x7E, 0x0C, 0x18, 0x30, 0x7E, 0x00,
	0x01, 0x03, 0x06, 0x6C, 0x78, 0x70, 0x60, 0x00,
	0x18, 0x3C, 0x7E, 0xFF, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0xFF, 0x7E, 0x3C, 0x18,
	0x10, 0x30, 0x70, 0xFF, 0xFF, 0x70, 0x30, 0x10,
	0x08, 0x0C, 0x0E, 0xFF, 0xFF, 0x0E, 0x0C, 0x08,
};

static const byte russianCharsetDataV2[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xc0, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7c,
	0x7c, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x00,
	0x00, 0xfe, 0xfe, 0xfe, 0xfc, 0xfe, 0x7e, 0x3e,
	0x3e, 0x7e, 0xfe, 0x7e, 0x7e, 0x7e, 0x7e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x1c, 0x00,
	0x04, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x78, 0x40, 0x3c, 0x00,
	0x0c, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x3c, 0x04, 0x38,
	0x00, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3c, 0x00,
	0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78, 0x00,
	0x02, 0x02, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x60, 0x00,
	0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x66, 0x66, 0xff, 0x66, 0xff, 0x66, 0x66, 0x00,
	0x30, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x30, 0x00,
	0xc4, 0xcc, 0x18, 0x30, 0x60, 0xcc, 0x8c, 0x00,
	0x78, 0xcc, 0x78, 0x70, 0xce, 0xcc, 0x7e, 0x00,
	0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x60, 0xc0, 0xc0, 0xc0, 0x60, 0x30, 0x00,
	0xc0, 0x60, 0x30, 0x30, 0x30, 0x60, 0xc0, 0x00,
	0x00, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00,
	0x66, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0xc0,
	0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x66, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0x60, 0xe0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00,
	0x78, 0xcc, 0x0c, 0x18, 0x60, 0xc0, 0xfc, 0x00,
	0x78, 0xcc, 0x0c, 0x38, 0x0c, 0xcc, 0x78, 0x00,
	0x0c, 0x1c, 0x2c, 0x4c, 0xfe, 0x0c, 0x0c, 0x00,
	0xfc, 0xc0, 0xf8, 0x0c, 0x0c, 0xcc, 0x78, 0x00,
	0x78, 0xcc, 0xc0, 0xf8, 0xcc, 0xcc, 0x78, 0x00,
	0xfc, 0xcc, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00,
	0x78, 0xcc, 0xcc, 0x78, 0xcc, 0xcc, 0x78, 0x00,
	0x78, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x00, 0x60, 0x60, 0xc0,
	0x7c, 0xfe, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0x61, 0xcc, 0xd0, 0xd0, 0xcc, 0x61, 0x3f,
	0x78, 0xcc, 0x0c, 0x18, 0x30, 0x00, 0x30, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00, 0x00,
	0x30, 0x78, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00,
	0xf8, 0xcc, 0xcc, 0xf8, 0xcc, 0xcc, 0xf8, 0x00,
	0x78, 0xcc, 0xc0, 0xc0, 0xc0, 0xcc, 0x78, 0x00,
	0xf0, 0xd8, 0xcc, 0xcc, 0xcc, 0xd8, 0xf0, 0x00,
	0xfc, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xfc, 0x00,
	0xfc, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0x00,
	0x78, 0xcc, 0xc0, 0xdc, 0xcc, 0xcc, 0x78, 0x00,
	0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0x70, 0x00,
	0xcc, 0xd8, 0xf0, 0xe0, 0xf0, 0xd8, 0xcc, 0x00,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0x00,
	0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0x00,
	0xcc, 0xec, 0xfc, 0xfc, 0xdc, 0xcc, 0xcc, 0x00,
	0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0xf8, 0xcc, 0xcc, 0xf8, 0xc0, 0xc0, 0xc0, 0x00,
	0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x0c,
	0xf8, 0xcc, 0xcc, 0xf8, 0xf0, 0xd8, 0xcc, 0x00,
	0x78, 0xcc, 0xc0, 0x78, 0x0c, 0xcc, 0x78, 0x00,
	0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00,
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00,
	0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00,
	0xcc, 0xcc, 0x78, 0x30, 0x78, 0xcc, 0xcc, 0x00,
	0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x30, 0x30, 0x00,
	0xfc, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfc, 0x00,
	0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x00,
	0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7c, 0x00,
	0xe8, 0x4d, 0x4a, 0x48, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe,
	0xfe, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7c, 0x00,
	0xc0, 0xc0, 0xf8, 0xcc, 0xcc, 0xcc, 0xf8, 0x00,
	0x00, 0x00, 0x78, 0xc0, 0xc0, 0xc0, 0x78, 0x00,
	0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x7c, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,
	0x38, 0x60, 0xf8, 0x60, 0x60, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0x7c, 0x0c, 0x78,
	0xc0, 0xc0, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,
	0xc0, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00,
	0x30, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0xe0,
	0xc0, 0xc0, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0x00,
	0xe0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00,
	0x00, 0x00, 0xcc, 0xfe, 0xfe, 0xd6, 0xc6, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xf8, 0xc0, 0xc0,
	0x00, 0x00, 0x7c, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c,
	0x00, 0x00, 0xf8, 0xcc, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x00,
	0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x1c, 0x00,
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x00,
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00,
	0x00, 0x00, 0xc6, 0xd6, 0xfe, 0x7c, 0x6c, 0x00,
	0x00, 0x00, 0xcc, 0x78, 0x30, 0x78, 0xcc, 0x00,
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x7c, 0x18, 0x70,
	0x00, 0x00, 0xfc, 0x18, 0x30, 0x60, 0xfc, 0x00,
	0xcc, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0xcc, 0x30, 0x78, 0xcc, 0xfc, 0xcc, 0xcc, 0x00,
	0x84, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0x38, 0x6c, 0x6c, 0xf8, 0xcc, 0xcc, 0xf8, 0x80,
	0x08, 0x0c, 0x0e, 0xff, 0xff, 0x0e, 0x0c, 0x08,
	0x30, 0x78, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00,
	0xf8, 0xc0, 0xc0, 0xf8, 0xcc, 0xcc, 0xf8, 0x00,
	0xf8, 0xcc, 0xcc, 0xf8, 0xcc, 0xcc, 0xf8, 0x00,
	0xfc, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00,
	0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6,
	0xfc, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xfc, 0x00,
	0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x00,
	0x78, 0x8c, 0x0c, 0x38, 0x0c, 0x8c, 0x78, 0x00,
	0xcc, 0xcc, 0xdc, 0xfc, 0xfc, 0xec, 0xcc, 0x00,
	0x30, 0xcc, 0xdc, 0xfc, 0xfc, 0xec, 0xcc, 0x00,
	0xcc, 0xd8, 0xf0, 0xe0, 0xf0, 0xd8, 0xcc, 0x00,
	0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xcc, 0x00,
	0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0x00,
	0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00,
	0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,
	0xf8, 0xcc, 0xcc, 0xf8, 0xc0, 0xc0, 0xc0, 0x00,
	0x78, 0xcc, 0xc0, 0xc0, 0xc0, 0xcc, 0x78, 0x00,
	0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00,
	0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00,
	0x78, 0xb4, 0xb4, 0xb4, 0x78, 0x30, 0x30, 0x00,
	0xcc, 0xcc, 0x78, 0x30, 0x78, 0xcc, 0xcc, 0x00,
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xfe, 0x06,
	0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x0c, 0x00,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x06,
	0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x7c, 0x00,
	0xc6, 0xc6, 0xc6, 0xf6, 0xde, 0xde, 0xf6, 0x00,
	0xc0, 0xc0, 0xc0, 0xf8, 0xcc, 0xcc, 0xf8, 0x00,
	0x78, 0x8c, 0x0c, 0x3c, 0x0c, 0x8c, 0x78, 0x00,
	0xcc, 0xd6, 0xd6, 0xf6, 0xd6, 0xd6, 0xcc, 0x00,
	0x7c, 0xcc, 0xcc, 0x7c, 0x3c, 0x6c, 0xcc, 0x00,
	0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7c, 0x00,
	0x04, 0x78, 0xc0, 0xf8, 0xcc, 0xcc, 0x78, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xf8, 0xcc, 0xf8, 0x00,
	0x00, 0x00, 0xf0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6,
	0x00, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,
	0x00, 0x00, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0x00,
	0x00, 0x00, 0x78, 0x9c, 0x38, 0x9c, 0x78, 0x00,
	0x00, 0x00, 0xcc, 0xdc, 0xfc, 0xec, 0xcc, 0x00,
	0x10, 0x20, 0xcc, 0xdc, 0xfc, 0xec, 0xcc, 0x00,
	0x00, 0x00, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0x00,
	0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6c, 0xcc, 0x00,
	0x00, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0x00,
	0x00, 0x00, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00,
	0x00, 0x00, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xf8, 0xc0, 0xc0,
	0x00, 0x00, 0x78, 0xc0, 0xc0, 0xc0, 0x78, 0x00,
	0x00, 0x00, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x7c, 0x18, 0x70,
	0x00, 0x00, 0x78, 0xb4, 0xb4, 0x78, 0x30, 0x30,
	0x00, 0x00, 0xcc, 0x78, 0x30, 0x78, 0xcc, 0x00,
	0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xd8, 0xfc, 0x0c,
	0x00, 0x00, 0xd8, 0xd8, 0x78, 0x18, 0x18, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x06,
	0x00, 0x00, 0xe0, 0x60, 0x7c, 0x66, 0x7c, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xf6, 0xce, 0xf6, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xf8, 0xcc, 0xf8, 0x00,
	0x00, 0x00, 0x78, 0x8c, 0x3c, 0x8c, 0x78, 0x00,
	0x00, 0x00, 0xcc, 0xd6, 0xf6, 0xd6, 0xcc, 0x00,
	0x00, 0x00, 0x7c, 0xcc, 0x7c, 0x3c, 0xec, 0x00,
	0x48, 0xfc, 0xc0, 0xf8, 0xc0, 0xc0, 0xfc, 0x00,
	0x48, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00
};

// These replacement character tables have been created using the
// make-charset-fontdata tool.

// English v1 Zak font with inverted apostrophe.
// The original interpreter apparently manipulates the character on
// the fly and kind of mirrors it; we instead opt for a substitution.
static const byte englishCharsetDataV1[] = {
	39,
	2,
};

// German Zak font.
static const byte germanCharsetDataV2[] = {
	36, 0,
	37, 1,
	39, 2,
	61, 3,
	91, 4,
	92, 5,
	93, 6,
	123, 7,
	124, 8,
	125, 9,
	126, 10,
};

// German v0 MM.
static const byte germanCharsetDataV0[] = {
	36, 11,
	42, 12,
	43, 13,
	60, 4,
	62, 7,
	91, 5,
	93, 14,
	94, 15,
};

// French Zak font.
static const byte frenchCharsetDataV2[] = {
	36, 0,
	37, 1,
	39, 2,
	60, 16,
	61, 17,
	62, 18,
	91, 19,
	92, 20,
	93, 21,
	95, 22,
	123, 23,
	124, 24,
	125, 25,
	126, 26,
};

// Italian Zak font.
static const byte italianCharsetDataV2[] = {
	36, 0,
	37, 1,
	39, 2,
	60, 16,
	61, 27,
	62, 20,
	91, 19,
	92, 20,
	93, 21,
	95, 22,
	123, 28,
	124, 29,
	125, 25,
	126, 26,
};

// Spanish Zak font.
static const byte spanishCharsetDataV2[] = {
	36, 0,
	37, 1,
	39, 2,
	61, 3,
	91, 4,
	92, 5,
	93, 6,
	123, 7,
	124, 8,
	125, 9,
	126, 10,
};

// Russian MM font.
static const byte russCharsetDataV2[] = {
	60, 234,
	62, 158,
	65, 128,
	66, 129,
	67, 150,
	68, 132,
	69, 133,
	70, 148,
	71, 131,
	72, 149,
	73, 136,
	74, 137,
	75, 138,
	76, 139,
	77, 140,
	78, 141,
	79, 142,
	80, 143,
	81, 159,
	82, 144,
	83, 145,
	84, 146,
	85, 147,
	86, 134,
	87, 130,
	88, 156,
	89, 155,
	90, 135,
	91, 152,
	92, 157,
	93, 153,
	94, 151,
	96, 238,
	97, 160,
	98, 161,
	99, 230,
	100, 164,
	101, 165,
	102, 228,
	103, 163,
	104, 229,
	105, 168,
	106, 169,
	107, 170,
	108, 171,
	109, 172,
	110, 173,
	111, 174,
	112, 175,
	113, 239,
	114, 224,
	115, 225,
	116, 226,
	117, 227,
	118, 166,
	119, 162,
	120, 236,
	121, 235,
	122, 167,
	123, 232,
	124, 237,
	125, 233,
	126, 231,
};

// Hebrew Zak and MM font map.
static const byte hebrewCharsetMapV2[] = {
		65, 0,
		66, 1,
		67, 2,
		68, 3,
		69, 4,
		70, 5,
		71, 6,
		72, 7,
		73, 8,
		74, 9,
		75, 10,
		76, 11,
		77, 12,
		78, 13,
		79, 14,
		80, 15,
		81, 16,
		82, 17,
		83, 18,
		84, 19,
		85, 20,
		86, 21,
		87, 22,
		88, 23,
		89, 24,
		90, 25,
		91, 26,
};

// Hebrew Zak and MM font data
static const byte hebrewCharsetDataV2[] = {
		0x00, 0x84, 0x44, 0x64, 0x98, 0x88, 0x84, 0x00,
		0x00, 0xf0, 0x08, 0x08, 0x08, 0x08, 0xfc, 0x00,
		0x00, 0x60, 0x10, 0x10, 0x30, 0x50, 0x90, 0x00,
		0x00, 0xfc, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
		0x00, 0xf8, 0x04, 0x04, 0x84, 0x84, 0x84, 0x00,
		0x00, 0xc0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00,
		0x00, 0xe0, 0x40, 0x40, 0x20, 0x20, 0x40, 0x00,
		0x00, 0xf8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x00,
		0x00, 0x88, 0x94, 0x84, 0x84, 0x84, 0xf8, 0x00,
		0x00, 0xe0, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00,
		0x00, 0xfc, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08,
		0x00, 0xf8, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00,
		0x80, 0xf8, 0x04, 0x04, 0x04, 0x08, 0x30, 0x00,
		0x00, 0xf8, 0x44, 0x84, 0x84, 0x84, 0xfc, 0x00,
		0x00, 0x9c, 0x64, 0x44, 0x84, 0x84, 0xbc, 0x00,
		0x00, 0xc0, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40,
		0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x00,
		0x00, 0xfc, 0x44, 0x84, 0x84, 0x48, 0x30, 0x00,
		0x00, 0x24, 0x24, 0x24, 0x24, 0x28, 0xf0, 0x00,
		0x00, 0xf8, 0x44, 0x44, 0x64, 0x04, 0x04, 0x04,
		0x00, 0xf8, 0x44, 0x44, 0x64, 0x04, 0xfc, 0x00,
		0x00, 0x84, 0x44, 0x48, 0x30, 0x20, 0x20, 0x20,
		0x00, 0x84, 0x44, 0x28, 0x10, 0x08, 0xfc, 0x00,
		0x00, 0xf8, 0x04, 0x44, 0x48, 0x50, 0x40, 0x40,
		0x00, 0xf8, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00,
		0x00, 0x92, 0x92, 0x92, 0xa2, 0xc4, 0xf8, 0x00,
		0x00, 0xf8, 0x44, 0x44, 0x44, 0x44, 0xc4, 0x00,
};

// Catalan MM font.
static const byte catalanCharsetDataV2[] = {
	34, 32,
	36, 33,
	37, 37,
	38, 41,
	39, 2,
	47, 38,
	59, 39,
	60, 40,
	61, 16,
	62, 30,
	91, 20,
	92, 19,
	93, 31,
	95, 22,
	123, 29,
	124, 34,
	125, 35,
	126, 36,
	127, 18,
};

// Special characters
static const byte specialCharsetData[] = {
	0x18, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x18, 0x00,
	0x62, 0x66, 0x0c, 0x18, 0x30, 0x66, 0x46, 0x00,
	0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x82, 0xba, 0xa2, 0xa2, 0xba, 0x82, 0x7c,
	0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00,
	0x66, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00,
	0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,
	0x66, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x00,
	0x66, 0x18, 0x3c, 0x66, 0x7e, 0x66, 0x66, 0x00,
	0x42, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,
	0x1c, 0x36, 0x36, 0x7c, 0x66, 0x66, 0x7c, 0x40,
	0x66, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,
	0x3c, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x6c, 0x60,
	0x66, 0x3c, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00,
	0x66, 0x24, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,
	0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18,
	0x10, 0x08, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00,
	0x18, 0x24, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00,
	0x00, 0x00, 0x3c, 0x60, 0x60, 0x3c, 0x18, 0x38,
	0x08, 0x10, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00,
	0x10, 0x08, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00,
	0x18, 0x24, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00,
	0x00, 0x6c, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00,
	0x18, 0x24, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00,
	0x10, 0x08, 0x00, 0x66, 0x66, 0x66, 0x3e, 0x00,
	0x18, 0x24, 0x00, 0x66, 0x66, 0x66, 0x3e, 0x00,
	0x08, 0x10, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00,
	0x10, 0x08, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00,
	0x10, 0x08, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x38, 0x18, 0x18, 0x3C, 0x00,
	0x10, 0x08, 0x3C, 0x66, 0x7E, 0x66, 0x66, 0x00,
	0x10, 0x08, 0x7E, 0x60, 0x7C, 0x60, 0x7E, 0x00,
	0x08, 0x10, 0x00, 0x3C, 0x66, 0x66, 0x3C, 0x00,
	0x08, 0x10, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x00,
	0x00, 0x6C, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x00,
	0x08, 0x10, 0x7E, 0x60, 0x7C, 0x60, 0x7E, 0x00,
	0x10, 0x08, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x08, 0x10, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x08, 0x10, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
	0x08, 0x10, 0x3C, 0x18, 0x18, 0x18, 0x3C, 0x00,
	0x66, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x3C, 0x00,
	0x3C, 0x66, 0x60, 0x60, 0x66, 0x3C, 0x18, 0x38,
};

#ifdef USE_TTS

static const uint16 specialCharactersEncoding[] = {
	0x0024, 0x0025, 0x0060, 0x0040, 0xc3bc, 0xc3a4, 0xc39c, 0xc3b6,	// $, %, `, @, ü, ä, Ü, ö
	0xc384, 0xc396, 0xc39f, 0xc396, 0xc39f, 0xc384, 0xc39c, 0x0020,	// Ä, Ö, ß, Ö, ß, Ä, Ü, ↑ (replaced with space)
	0xc3a0, 0xc3a2, 0xc3a7, 0xc3a9, 0xc3a8, 0xc3aa, 0xc3af, 0xc3ae,	// à, â, ç, é, è, ê, ï, î
	0xc3b4, 0xc3b9, 0xc3bb, 0xc3a1, 0xc3ac, 0xc3b2					// ô, ù, û, á, ì, ò
};

#endif

CharsetRendererV2::CharsetRendererV2(ScummEngine *vm, Common::Language language)
	: CharsetRendererV3(vm) {

	_fontHeight = 8;
	_curId = 0;

	const byte *replacementMap = nullptr, *replacementData = nullptr;
	int replacementChars = 0;

	switch (language) {
	case Common::DE_DEU:
		if (_vm->_game.version == 0) {
			replacementMap = germanCharsetDataV0;
			replacementChars = sizeof(germanCharsetDataV0) / 2;
		} else {
			replacementMap = germanCharsetDataV2;
			replacementChars = sizeof(germanCharsetDataV2) / 2;
		}
		replacementData = specialCharsetData;
		break;
	case Common::FR_FRA:
		replacementMap = frenchCharsetDataV2;
		replacementChars = sizeof(frenchCharsetDataV2) / 2;
		replacementData = specialCharsetData;
		break;
	case Common::IT_ITA:
		replacementMap = italianCharsetDataV2;
		replacementChars = sizeof(italianCharsetDataV2) / 2;
		replacementData = specialCharsetData;
		break;
	case Common::ES_ESP:
		replacementMap = spanishCharsetDataV2;
		replacementChars = sizeof(spanishCharsetDataV2) / 2;
		replacementData = specialCharsetData;
		break;
	case Common::RU_RUS:
		if (((_vm->_game.id == GID_MANIAC) || (_vm->_game.id == GID_ZAK)) && (_vm->_game.version == 2)) {
			replacementMap = russCharsetDataV2;
			replacementChars = sizeof(russCharsetDataV2) / 2;
			replacementData = russianCharsetDataV2;
		} else {
			_fontPtr = russianCharsetDataV2;
		}
		break;
	case Common::HE_ISR:
		replacementMap = hebrewCharsetMapV2;
		replacementChars = sizeof(hebrewCharsetMapV2) / 2;
		replacementData = hebrewCharsetDataV2;
		break;
	case Common::CA_ESP:
		replacementMap = catalanCharsetDataV2;
		replacementChars = sizeof(catalanCharsetDataV2) / 2;
		replacementData = specialCharsetData;
		break;
	default:
		if (_vm->_game.version == 1 && !(_vm->_game.features & GF_DEMO)) {
			replacementMap = englishCharsetDataV1;
			replacementChars = sizeof(englishCharsetDataV1) / 2;
			replacementData = specialCharsetData;
		} else {
			_fontPtr = englishCharsetDataV2;
		}
		break;
	}

	if (replacementMap && replacementData) {
		_fontPtr = new byte[sizeof(englishCharsetDataV2)];
		_deleteFontPtr = true;
		memcpy(const_cast<byte *>(_fontPtr), englishCharsetDataV2, sizeof(englishCharsetDataV2));

		for (int i = 0; i < replacementChars; i++) {
			int ch1 = replacementMap[2 * i];
			int ch2 = replacementMap[2 * i + 1];

			memcpy(const_cast<byte *>(_fontPtr) + 8 * ch1, replacementData + 8 * ch2, 8);
		}
	} else
		_deleteFontPtr = false;

#if 0
	// Decompress weird encoding in which the Zak executable contains the font.
	// I leave the code around in case we need to use it again (e.g. we might
	// have to include different fonts for french/spanish/russian/... version
	// of MM / Zak
	//
	int count = 0, len;
	byte b;
	const byte *data = spanishCharsetDataV2;
	const int size = sizeof(spanishCharsetDataV2);
	for (int offset = 0; offset < size; offset++) {
		if (data[offset+1] == 0x00 && data[offset+2] == 0xB2 &&
			data[offset+5] == 0x00 && data[offset+6] == 0xB0) {
			b = data[offset+3];
			len = data[offset+4];
			while (len--) {
				debugN("0x%02x, ", b);
				count++;
				if (count % 8 == 0)
					debugN("\n");
			}
			offset += 6;
		} else {
			debugN("0x%02x, ", data[offset]);
			count++;
			if (count % 8 == 0)
				debugN("\n");
		}
	}
	debugN("\n");
	_vm->quitGame();
#endif
}

#ifdef USE_TTS

Common::U32String CharsetRendererV2::convertText(const Common::String &text, Common::Language language) const {
	const byte *map = nullptr;
	int mapLen = 0;
	Common::CodePage encoding;

	switch (language) {
	case Common::EN_ANY:
	case Common::EN_GRB:
	case Common::EN_USA:
		if (_vm->_game.version == 1 && !(_vm->_game.features & GF_DEMO)) {
			map = englishCharsetDataV1;
			mapLen = ARRAYSIZE(englishCharsetDataV1);
			encoding = Common::CodePage::kUtf8;
		} else {
			return Common::U32String(text, Common::CodePage::kDos850);
		}
		break;
	case Common::DE_DEU:
		if (_vm->_game.version == 0) {
			map = germanCharsetDataV0;
			mapLen = ARRAYSIZE(germanCharsetDataV0);
		} else {
			map = germanCharsetDataV2;
			mapLen = ARRAYSIZE(germanCharsetDataV2);
		}
		encoding = Common::CodePage::kUtf8;
		break;
	case Common::FR_FRA:
		map = frenchCharsetDataV2;
		mapLen = ARRAYSIZE(frenchCharsetDataV2);
		encoding = Common::CodePage::kUtf8;
		break;
	case Common::IT_ITA:
		map = italianCharsetDataV2;
		mapLen = ARRAYSIZE(italianCharsetDataV2);
		encoding = Common::CodePage::kUtf8;
		break;
	case Common::ES_ESP:
		map = spanishCharsetDataV2;
		mapLen = ARRAYSIZE(spanishCharsetDataV2);
		encoding = Common::CodePage::kUtf8;
		break;
	case Common::RU_RUS:
		map = russCharsetDataV2;
		mapLen = ARRAYSIZE(russCharsetDataV2);
		encoding = Common::CodePage::kDos866;

		if ((_vm->_game.id != GID_MANIAC && _vm->_game.id != GID_ZAK) || _vm->_game.version != 2) {
			return Common::U32String(text, Common::CodePage::kDos866);
		}
		break;
	case Common::HE_ISR:
		encoding = Common::CodePage::kDos862;
		break;
	default:
		return Common::U32String(text, _vm->getDialogCodePage());
	}

	const byte *bytes = (const byte *)text.c_str();
	byte *convertedBytes = new byte[text.size() * 2 + 1];

	int i = 0;
	for (const byte *b = bytes; *b; ++b) {
		if (map) {
			// Change DOS 850 code for © to UTF-8
			if (language != Common::RU_RUS && *b == 0xb8) {
				convertedBytes[i] = 0xc2;
				convertedBytes[i + 1] = 0xa9;
				i += 2;
				continue;
			}

			bool inMap = false;
			for (int j = 0; j < mapLen; j += 2) {
				if (*b == map[j]) {
					if (language != Common::RU_RUS) {
						byte firstByte = (specialCharactersEncoding[map[j + 1]] >> 8) & 0xff;

						if (firstByte != 0) {
							convertedBytes[i] = firstByte;
							convertedBytes[i + 1] = specialCharactersEncoding[map[j + 1]] & 0xff;
							i++;
						} else {
							convertedBytes[i] = specialCharactersEncoding[map[j + 1]] & 0xff;
						}
					} else {
						convertedBytes[i] = map[j + 1];
					}

					inMap = true;
					break;
				}
			}

			if (!inMap) {
				convertedBytes[i] = *b;
			}
		} else {
			convertedBytes[i] = *b;

			if (language == Common::HE_ISR) {
				convertedBytes[i] += 63;
			}
		}

		i++;
	}

	convertedBytes[i] = 0;

	Common::U32String result((char *)convertedBytes, encoding);
	delete[] convertedBytes;

	return result;
}

#endif

CharsetRendererV2::~CharsetRendererV2() {
	if (_deleteFontPtr)
		delete[] _fontPtr;
}

} // End of namespace Scumm
