import { checkIsPrivateColumn } from './column';

/*
 * @param {object} record eg: { [column_key]: value, [column_name]: value }
 * @param {object} column
 * @return {any} value
 */
export const getCellValueByColumn = (record, column) => {
  if (!record || !column) return null;
  const { key, name } = column;
  return checkIsPrivateColumn(column) ? record[key] : record[name];
};
