#include "libcore.pb.h"
#include <spb/json.hpp>
#include <system_error>
#include <type_traits>

namespace spb::json
{
namespace detail
{
void serialize_value( detail::ostream & , const ::libcore::EmptyReq & )
{
}

void deserialize_value( detail::istream &, ::libcore::EmptyReq & )
{

}

} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & , const ::libcore::EmptyResp & )
{
}

void deserialize_value( detail::istream &, ::libcore::EmptyResp & )
{

}

} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::ErrorResp & value )
{
	stream.serialize( "error"sv, value.error );
}
void deserialize_value( detail::istream & stream, ::libcore::ErrorResp & value )
{
	auto key = stream.deserialize_key( 5, 5 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "error"sv ):
			if( key == "error"sv )
			{
				return stream.deserialize( value.error );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::LoadConfigReq & value )
{
	stream.serialize( "core_config"sv, value.core_config );
	stream.serialize( "disable_stats"sv, value.disable_stats );
	stream.serialize( "need_extra_process"sv, value.need_extra_process );
	stream.serialize( "extra_process_path"sv, value.extra_process_path );
	stream.serialize( "extra_process_args"sv, value.extra_process_args );
	stream.serialize( "extra_process_conf"sv, value.extra_process_conf );
	stream.serialize( "extra_process_conf_dir"sv, value.extra_process_conf_dir );
	stream.serialize( "extra_no_out"sv, value.extra_no_out );
}
void deserialize_value( detail::istream & stream, ::libcore::LoadConfigReq & value )
{
	auto key = stream.deserialize_key( 10, 22 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "need_extra_process"sv ):
			if( key == "need_extra_process"sv )
			{
				return stream.deserialize( value.need_extra_process );
			}
				break;
		case detail::djb2_hash( "extraProcessConfDir"sv ):
			if( key == "extraProcessConfDir"sv )
			{
				return stream.deserialize( value.extra_process_conf_dir );
			}
				break;
		case detail::djb2_hash( "disable_stats"sv ):
			if( key == "disable_stats"sv )
			{
				return stream.deserialize( value.disable_stats );
			}
				break;
		case detail::djb2_hash( "coreConfig"sv ):
			if( key == "coreConfig"sv )
			{
				return stream.deserialize( value.core_config );
			}
				break;
		case detail::djb2_hash( "extraProcessArgs"sv ):
			if( key == "extraProcessArgs"sv )
			{
				return stream.deserialize( value.extra_process_args );
			}
				break;
		case detail::djb2_hash( "extraProcessConf"sv ):
			if( key == "extraProcessConf"sv )
			{
				return stream.deserialize( value.extra_process_conf );
			}
				break;
		case detail::djb2_hash( "extraProcessPath"sv ):
			if( key == "extraProcessPath"sv )
			{
				return stream.deserialize( value.extra_process_path );
			}
				break;
		case detail::djb2_hash( "extraNoOut"sv ):
			if( key == "extraNoOut"sv )
			{
				return stream.deserialize( value.extra_no_out );
			}
				break;
		case detail::djb2_hash( "extra_process_args"sv ):
			if( key == "extra_process_args"sv )
			{
				return stream.deserialize( value.extra_process_args );
			}
				break;
		case detail::djb2_hash( "extra_process_conf"sv ):
			if( key == "extra_process_conf"sv )
			{
				return stream.deserialize( value.extra_process_conf );
			}
				break;
		case detail::djb2_hash( "extra_process_path"sv ):
			if( key == "extra_process_path"sv )
			{
				return stream.deserialize( value.extra_process_path );
			}
				break;
		case detail::djb2_hash( "core_config"sv ):
			if( key == "core_config"sv )
			{
				return stream.deserialize( value.core_config );
			}
				break;
		case detail::djb2_hash( "needExtraProcess"sv ):
			if( key == "needExtraProcess"sv )
			{
				return stream.deserialize( value.need_extra_process );
			}
				break;
		case detail::djb2_hash( "disableStats"sv ):
			if( key == "disableStats"sv )
			{
				return stream.deserialize( value.disable_stats );
			}
				break;
		case detail::djb2_hash( "extra_process_conf_dir"sv ):
			if( key == "extra_process_conf_dir"sv )
			{
				return stream.deserialize( value.extra_process_conf_dir );
			}
				break;
		case detail::djb2_hash( "extra_no_out"sv ):
			if( key == "extra_no_out"sv )
			{
				return stream.deserialize( value.extra_no_out );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::URLTestResp & value )
{
	stream.serialize( "outbound_tag"sv, value.outbound_tag );
	stream.serialize( "latency_ms"sv, value.latency_ms );
	stream.serialize( "error"sv, value.error );
}
void deserialize_value( detail::istream & stream, ::libcore::URLTestResp & value )
{
	auto key = stream.deserialize_key( 5, 12 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "error"sv ):
			if( key == "error"sv )
			{
				return stream.deserialize( value.error );
			}
				break;
		case detail::djb2_hash( "outboundTag"sv ):
			if( key == "outboundTag"sv )
			{
				return stream.deserialize( value.outbound_tag );
			}
				break;
		case detail::djb2_hash( "latencyMs"sv ):
			if( key == "latencyMs"sv )
			{
				return stream.deserialize( value.latency_ms );
			}
				break;
		case detail::djb2_hash( "latency_ms"sv ):
			if( key == "latency_ms"sv )
			{
				return stream.deserialize( value.latency_ms );
			}
				break;
		case detail::djb2_hash( "outbound_tag"sv ):
			if( key == "outbound_tag"sv )
			{
				return stream.deserialize( value.outbound_tag );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::TestReq & value )
{
	stream.serialize( "config"sv, value.config );
	stream.serialize( "outbound_tags"sv, value.outbound_tags );
	stream.serialize( "use_default_outbound"sv, value.use_default_outbound );
	stream.serialize( "url"sv, value.url );
	stream.serialize( "test_current"sv, value.test_current );
	stream.serialize( "max_concurrency"sv, value.max_concurrency );
	stream.serialize( "test_timeout_ms"sv, value.test_timeout_ms );
}
void deserialize_value( detail::istream & stream, ::libcore::TestReq & value )
{
	auto key = stream.deserialize_key( 3, 20 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "url"sv ):
			if( key == "url"sv )
			{
				return stream.deserialize( value.url );
			}
				break;
		case detail::djb2_hash( "use_default_outbound"sv ):
			if( key == "use_default_outbound"sv )
			{
				return stream.deserialize( value.use_default_outbound );
			}
				break;
		case detail::djb2_hash( "test_current"sv ):
			if( key == "test_current"sv )
			{
				return stream.deserialize( value.test_current );
			}
				break;
		case detail::djb2_hash( "testTimeoutMs"sv ):
			if( key == "testTimeoutMs"sv )
			{
				return stream.deserialize( value.test_timeout_ms );
			}
				break;
		case detail::djb2_hash( "useDefaultOutbound"sv ):
			if( key == "useDefaultOutbound"sv )
			{
				return stream.deserialize( value.use_default_outbound );
			}
				break;
		case detail::djb2_hash( "testCurrent"sv ):
			if( key == "testCurrent"sv )
			{
				return stream.deserialize( value.test_current );
			}
				break;
		case detail::djb2_hash( "outboundTags"sv ):
			if( key == "outboundTags"sv )
			{
				return stream.deserialize( value.outbound_tags );
			}
				break;
		case detail::djb2_hash( "maxConcurrency"sv ):
			if( key == "maxConcurrency"sv )
			{
				return stream.deserialize( value.max_concurrency );
			}
				break;
		case detail::djb2_hash( "outbound_tags"sv ):
			if( key == "outbound_tags"sv )
			{
				return stream.deserialize( value.outbound_tags );
			}
				break;
		case detail::djb2_hash( "test_timeout_ms"sv ):
			if( key == "test_timeout_ms"sv )
			{
				return stream.deserialize( value.test_timeout_ms );
			}
				break;
		case detail::djb2_hash( "max_concurrency"sv ):
			if( key == "max_concurrency"sv )
			{
				return stream.deserialize( value.max_concurrency );
			}
				break;
		case detail::djb2_hash( "config"sv ):
			if( key == "config"sv )
			{
				return stream.deserialize( value.config );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::TestResp & value )
{
	stream.serialize( "results"sv, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::TestResp & value )
{
	auto key = stream.deserialize_key( 7, 7 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "results"sv ):
			if( key == "results"sv )
			{
				return stream.deserialize( value.results );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::QueryStatsResp & value )
{
	stream.serialize( "ups"sv, value.ups );
	stream.serialize( "downs"sv, value.downs );
}
void deserialize_value( detail::istream & stream, ::libcore::QueryStatsResp & value )
{
	auto key = stream.deserialize_key( 3, 5 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "ups"sv ):
			if( key == "ups"sv )
			{
				return stream.deserialize( value.ups );
			}
				break;
		case detail::djb2_hash( "downs"sv ):
			if( key == "downs"sv )
			{
				return stream.deserialize( value.downs );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::ListConnectionsResp & value )
{
	stream.serialize( "connections"sv, value.connections );
}
void deserialize_value( detail::istream & stream, ::libcore::ListConnectionsResp & value )
{
	auto key = stream.deserialize_key( 11, 11 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "connections"sv ):
			if( key == "connections"sv )
			{
				return stream.deserialize( value.connections );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::ConnectionMetaData & value )
{
	stream.serialize( "id"sv, value.id );
	stream.serialize( "created_at"sv, value.created_at );
	stream.serialize( "upload"sv, value.upload );
	stream.serialize( "download"sv, value.download );
	stream.serialize( "outbound"sv, value.outbound );
	stream.serialize( "network"sv, value.network );
	stream.serialize( "dest"sv, value.dest );
	stream.serialize( "protocol"sv, value.protocol );
	stream.serialize( "domain"sv, value.domain );
	stream.serialize( "process"sv, value.process );
}
void deserialize_value( detail::istream & stream, ::libcore::ConnectionMetaData & value )
{
	auto key = stream.deserialize_key( 2, 10 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "id"sv ):
			if( key == "id"sv )
			{
				return stream.deserialize( value.id );
			}
				break;
		case detail::djb2_hash( "network"sv ):
			if( key == "network"sv )
			{
				return stream.deserialize( value.network );
			}
				break;
		case detail::djb2_hash( "created_at"sv ):
			if( key == "created_at"sv )
			{
				return stream.deserialize( value.created_at );
			}
				break;
		case detail::djb2_hash( "upload"sv ):
			if( key == "upload"sv )
			{
				return stream.deserialize( value.upload );
			}
				break;
		case detail::djb2_hash( "protocol"sv ):
			if( key == "protocol"sv )
			{
				return stream.deserialize( value.protocol );
			}
				break;
		case detail::djb2_hash( "outbound"sv ):
			if( key == "outbound"sv )
			{
				return stream.deserialize( value.outbound );
			}
				break;
		case detail::djb2_hash( "download"sv ):
			if( key == "download"sv )
			{
				return stream.deserialize( value.download );
			}
				break;
		case detail::djb2_hash( "dest"sv ):
			if( key == "dest"sv )
			{
				return stream.deserialize( value.dest );
			}
				break;
		case detail::djb2_hash( "createdAt"sv ):
			if( key == "createdAt"sv )
			{
				return stream.deserialize( value.created_at );
			}
				break;
		case detail::djb2_hash( "process"sv ):
			if( key == "process"sv )
			{
				return stream.deserialize( value.process );
			}
				break;
		case detail::djb2_hash( "domain"sv ):
			if( key == "domain"sv )
			{
				return stream.deserialize( value.domain );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::SetSystemDNSRequest & value )
{
	stream.serialize( "clear"sv, value.clear );
}
void deserialize_value( detail::istream & stream, ::libcore::SetSystemDNSRequest & value )
{
	auto key = stream.deserialize_key( 5, 5 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "clear"sv ):
			if( key == "clear"sv )
			{
				return stream.deserialize( value.clear );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::IsPrivilegedResponse & value )
{
	stream.serialize( "has_privilege"sv, value.has_privilege );
}
void deserialize_value( detail::istream & stream, ::libcore::IsPrivilegedResponse & value )
{
	auto key = stream.deserialize_key( 12, 13 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "has_privilege"sv ):
			if( key == "has_privilege"sv )
			{
				return stream.deserialize( value.has_privilege );
			}
				break;
		case detail::djb2_hash( "hasPrivilege"sv ):
			if( key == "hasPrivilege"sv )
			{
				return stream.deserialize( value.has_privilege );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::SpeedTestRequest & value )
{
	stream.serialize( "config"sv, value.config );
	stream.serialize( "outbound_tags"sv, value.outbound_tags );
	stream.serialize( "test_current"sv, value.test_current );
	stream.serialize( "use_default_outbound"sv, value.use_default_outbound );
	stream.serialize( "test_download"sv, value.test_download );
	stream.serialize( "test_upload"sv, value.test_upload );
	stream.serialize( "simple_download"sv, value.simple_download );
	stream.serialize( "simple_download_addr"sv, value.simple_download_addr );
	stream.serialize( "timeout_ms"sv, value.timeout_ms );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestRequest & value )
{
	auto key = stream.deserialize_key( 6, 20 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "use_default_outbound"sv ):
			if( key == "use_default_outbound"sv )
			{
				return stream.deserialize( value.use_default_outbound );
			}
				break;
		case detail::djb2_hash( "simpleDownloadAddr"sv ):
			if( key == "simpleDownloadAddr"sv )
			{
				return stream.deserialize( value.simple_download_addr );
			}
				break;
		case detail::djb2_hash( "test_current"sv ):
			if( key == "test_current"sv )
			{
				return stream.deserialize( value.test_current );
			}
				break;
		case detail::djb2_hash( "simpleDownload"sv ):
			if( key == "simpleDownload"sv )
			{
				return stream.deserialize( value.simple_download );
			}
				break;
		case detail::djb2_hash( "simple_download"sv ):
			if( key == "simple_download"sv )
			{
				return stream.deserialize( value.simple_download );
			}
				break;
		case detail::djb2_hash( "timeoutMs"sv ):
			if( key == "timeoutMs"sv )
			{
				return stream.deserialize( value.timeout_ms );
			}
				break;
		case detail::djb2_hash( "test_download"sv ):
			if( key == "test_download"sv )
			{
				return stream.deserialize( value.test_download );
			}
				break;
		case detail::djb2_hash( "useDefaultOutbound"sv ):
			if( key == "useDefaultOutbound"sv )
			{
				return stream.deserialize( value.use_default_outbound );
			}
				break;
		case detail::djb2_hash( "testCurrent"sv ):
			if( key == "testCurrent"sv )
			{
				return stream.deserialize( value.test_current );
			}
				break;
		case detail::djb2_hash( "outboundTags"sv ):
			if( key == "outboundTags"sv )
			{
				return stream.deserialize( value.outbound_tags );
			}
				break;
		case detail::djb2_hash( "outbound_tags"sv ):
			if( key == "outbound_tags"sv )
			{
				return stream.deserialize( value.outbound_tags );
			}
				break;
		case detail::djb2_hash( "simple_download_addr"sv ):
			if( key == "simple_download_addr"sv )
			{
				return stream.deserialize( value.simple_download_addr );
			}
				break;
		case detail::djb2_hash( "testUpload"sv ):
			if( key == "testUpload"sv )
			{
				return stream.deserialize( value.test_upload );
			}
				break;
		case detail::djb2_hash( "timeout_ms"sv ):
			if( key == "timeout_ms"sv )
			{
				return stream.deserialize( value.timeout_ms );
			}
				break;
		case detail::djb2_hash( "config"sv ):
			if( key == "config"sv )
			{
				return stream.deserialize( value.config );
			}
				break;
		case detail::djb2_hash( "testDownload"sv ):
			if( key == "testDownload"sv )
			{
				return stream.deserialize( value.test_download );
			}
				break;
		case detail::djb2_hash( "test_upload"sv ):
			if( key == "test_upload"sv )
			{
				return stream.deserialize( value.test_upload );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::SpeedTestResult & value )
{
	stream.serialize( "dl_speed"sv, value.dl_speed );
	stream.serialize( "ul_speed"sv, value.ul_speed );
	stream.serialize( "latency"sv, value.latency );
	stream.serialize( "outbound_tag"sv, value.outbound_tag );
	stream.serialize( "error"sv, value.error );
	stream.serialize( "server_name"sv, value.server_name );
	stream.serialize( "server_country"sv, value.server_country );
	stream.serialize( "cancelled"sv, value.cancelled );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestResult & value )
{
	auto key = stream.deserialize_key( 5, 14 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "serverCountry"sv ):
			if( key == "serverCountry"sv )
			{
				return stream.deserialize( value.server_country );
			}
				break;
		case detail::djb2_hash( "error"sv ):
			if( key == "error"sv )
			{
				return stream.deserialize( value.error );
			}
				break;
		case detail::djb2_hash( "dlSpeed"sv ):
			if( key == "dlSpeed"sv )
			{
				return stream.deserialize( value.dl_speed );
			}
				break;
		case detail::djb2_hash( "dl_speed"sv ):
			if( key == "dl_speed"sv )
			{
				return stream.deserialize( value.dl_speed );
			}
				break;
		case detail::djb2_hash( "server_country"sv ):
			if( key == "server_country"sv )
			{
				return stream.deserialize( value.server_country );
			}
				break;
		case detail::djb2_hash( "ulSpeed"sv ):
			if( key == "ulSpeed"sv )
			{
				return stream.deserialize( value.ul_speed );
			}
				break;
		case detail::djb2_hash( "outboundTag"sv ):
			if( key == "outboundTag"sv )
			{
				return stream.deserialize( value.outbound_tag );
			}
				break;
		case detail::djb2_hash( "latency"sv ):
			if( key == "latency"sv )
			{
				return stream.deserialize( value.latency );
			}
				break;
		case detail::djb2_hash( "cancelled"sv ):
			if( key == "cancelled"sv )
			{
				return stream.deserialize( value.cancelled );
			}
				break;
		case detail::djb2_hash( "outbound_tag"sv ):
			if( key == "outbound_tag"sv )
			{
				return stream.deserialize( value.outbound_tag );
			}
				break;
		case detail::djb2_hash( "serverName"sv ):
			if( key == "serverName"sv )
			{
				return stream.deserialize( value.server_name );
			}
				break;
		case detail::djb2_hash( "server_name"sv ):
			if( key == "server_name"sv )
			{
				return stream.deserialize( value.server_name );
			}
				break;
		case detail::djb2_hash( "ul_speed"sv ):
			if( key == "ul_speed"sv )
			{
				return stream.deserialize( value.ul_speed );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::SpeedTestResponse & value )
{
	stream.serialize( "results"sv, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestResponse & value )
{
	auto key = stream.deserialize_key( 7, 7 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "results"sv ):
			if( key == "results"sv )
			{
				return stream.deserialize( value.results );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::QuerySpeedTestResponse & value )
{
	stream.serialize( "result"sv, value.result );
	stream.serialize( "is_running"sv, value.is_running );
}
void deserialize_value( detail::istream & stream, ::libcore::QuerySpeedTestResponse & value )
{
	auto key = stream.deserialize_key( 6, 10 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "result"sv ):
			if( key == "result"sv )
			{
				return stream.deserialize( value.result );
			}
				break;
		case detail::djb2_hash( "is_running"sv ):
			if( key == "is_running"sv )
			{
				return stream.deserialize( value.is_running );
			}
				break;
		case detail::djb2_hash( "isRunning"sv ):
			if( key == "isRunning"sv )
			{
				return stream.deserialize( value.is_running );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::QueryURLTestResponse & value )
{
	stream.serialize( "results"sv, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::QueryURLTestResponse & value )
{
	auto key = stream.deserialize_key( 7, 7 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "results"sv ):
			if( key == "results"sv )
			{
				return stream.deserialize( value.results );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
namespace detail
{
void serialize_value( detail::ostream & stream, const ::libcore::RuleSet & value )
{
	stream.serialize( "items"sv, value.items );
}
void deserialize_value( detail::istream & stream, ::libcore::RuleSet & value )
{
	auto key = stream.deserialize_key( 5, 5 );
	switch( djb2_hash( key ) )
	{
		case detail::djb2_hash( "items"sv ):
			if( key == "items"sv )
			{
				return stream.deserialize( value.items );
			}
			break;
	}
	return stream.skip_value( );
}
} // namespace detail
} // namespace spb::json
#include "libcore.pb.h"
#include <spb/pb.hpp>
#include <type_traits>

namespace spb::pb
{
namespace detail
{
void serialize( detail::ostream & , const ::libcore::EmptyReq & )
{
}

void deserialize_value( detail::istream & stream, ::libcore::EmptyReq &, uint32_t tag )
{
	stream.skip( tag );
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & , const ::libcore::EmptyResp & )
{
}

void deserialize_value( detail::istream & stream, ::libcore::EmptyResp &, uint32_t tag )
{
	stream.skip( tag );
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::ErrorResp & value )
{
	stream.serialize( 1, value.error );
}
void deserialize_value( detail::istream & stream, ::libcore::ErrorResp & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.error, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::LoadConfigReq & value )
{
	stream.serialize( 1, value.core_config );
	stream.serialize_as<scalar_encoder::varint>( 2, value.disable_stats );
	stream.serialize_as<scalar_encoder::varint>( 3, value.need_extra_process );
	stream.serialize( 4, value.extra_process_path );
	stream.serialize( 5, value.extra_process_args );
	stream.serialize( 6, value.extra_process_conf );
	stream.serialize( 7, value.extra_process_conf_dir );
	stream.serialize_as<scalar_encoder::varint>( 8, value.extra_no_out );
}
void deserialize_value( detail::istream & stream, ::libcore::LoadConfigReq & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.core_config, tag );
		case 2:
			return stream.deserialize_as<scalar_encoder::varint>( value.disable_stats, tag );
		case 3:
			return stream.deserialize_as<scalar_encoder::varint>( value.need_extra_process, tag );
		case 4:
			return stream.deserialize( value.extra_process_path, tag );
		case 5:
			return stream.deserialize( value.extra_process_args, tag );
		case 6:
			return stream.deserialize( value.extra_process_conf, tag );
		case 7:
			return stream.deserialize( value.extra_process_conf_dir, tag );
		case 8:
			return stream.deserialize_as<scalar_encoder::varint>( value.extra_no_out, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::URLTestResp & value )
{
	stream.serialize( 1, value.outbound_tag );
	stream.serialize_as<scalar_encoder::varint>( 2, value.latency_ms );
	stream.serialize( 3, value.error );
}
void deserialize_value( detail::istream & stream, ::libcore::URLTestResp & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.outbound_tag, tag );
		case 2:
			return stream.deserialize_as<scalar_encoder::varint>( value.latency_ms, tag );
		case 3:
			return stream.deserialize( value.error, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::TestReq & value )
{
	stream.serialize( 1, value.config );
	stream.serialize( 2, value.outbound_tags );
	stream.serialize_as<scalar_encoder::varint>( 3, value.use_default_outbound );
	stream.serialize( 4, value.url );
	stream.serialize_as<scalar_encoder::varint>( 5, value.test_current );
	stream.serialize_as<scalar_encoder::varint>( 6, value.max_concurrency );
	stream.serialize_as<scalar_encoder::varint>( 7, value.test_timeout_ms );
}
void deserialize_value( detail::istream & stream, ::libcore::TestReq & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.config, tag );
		case 2:
			return stream.deserialize( value.outbound_tags, tag );
		case 3:
			return stream.deserialize_as<scalar_encoder::varint>( value.use_default_outbound, tag );
		case 4:
			return stream.deserialize( value.url, tag );
		case 5:
			return stream.deserialize_as<scalar_encoder::varint>( value.test_current, tag );
		case 6:
			return stream.deserialize_as<scalar_encoder::varint>( value.max_concurrency, tag );
		case 7:
			return stream.deserialize_as<scalar_encoder::varint>( value.test_timeout_ms, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::TestResp & value )
{
	stream.serialize( 1, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::TestResp & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.results, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::QueryStatsResp & value )
{
	stream.serialize_as< scalar_encoder_combine( {}, scalar_encoder::varint ) >( 1, value.ups );
	stream.serialize_as< scalar_encoder_combine( {}, scalar_encoder::varint ) >( 2, value.downs );
}
void deserialize_value( detail::istream & stream, ::libcore::QueryStatsResp & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return 	stream.deserialize_as< scalar_encoder_combine( {}, scalar_encoder::varint ) >( value.ups, tag );
		case 2:
			return 	stream.deserialize_as< scalar_encoder_combine( {}, scalar_encoder::varint ) >( value.downs, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::ListConnectionsResp & value )
{
	stream.serialize( 1, value.connections );
}
void deserialize_value( detail::istream & stream, ::libcore::ListConnectionsResp & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.connections, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::ConnectionMetaData & value )
{
	stream.serialize( 1, value.id );
	stream.serialize_as<scalar_encoder::varint>( 2, value.created_at );
	stream.serialize_as<scalar_encoder::varint>( 3, value.upload );
	stream.serialize_as<scalar_encoder::varint>( 4, value.download );
	stream.serialize( 5, value.outbound );
	stream.serialize( 6, value.network );
	stream.serialize( 7, value.dest );
	stream.serialize( 8, value.protocol );
	stream.serialize( 9, value.domain );
	stream.serialize( 10, value.process );
}
void deserialize_value( detail::istream & stream, ::libcore::ConnectionMetaData & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.id, tag );
		case 2:
			return stream.deserialize_as<scalar_encoder::varint>( value.created_at, tag );
		case 3:
			return stream.deserialize_as<scalar_encoder::varint>( value.upload, tag );
		case 4:
			return stream.deserialize_as<scalar_encoder::varint>( value.download, tag );
		case 5:
			return stream.deserialize( value.outbound, tag );
		case 6:
			return stream.deserialize( value.network, tag );
		case 7:
			return stream.deserialize( value.dest, tag );
		case 8:
			return stream.deserialize( value.protocol, tag );
		case 9:
			return stream.deserialize( value.domain, tag );
		case 10:
			return stream.deserialize( value.process, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::SetSystemDNSRequest & value )
{
	stream.serialize_as<scalar_encoder::varint>( 1, value.clear );
}
void deserialize_value( detail::istream & stream, ::libcore::SetSystemDNSRequest & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize_as<scalar_encoder::varint>( value.clear, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::IsPrivilegedResponse & value )
{
	stream.serialize_as<scalar_encoder::varint>( 1, value.has_privilege );
}
void deserialize_value( detail::istream & stream, ::libcore::IsPrivilegedResponse & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize_as<scalar_encoder::varint>( value.has_privilege, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::SpeedTestRequest & value )
{
	stream.serialize( 1, value.config );
	stream.serialize( 2, value.outbound_tags );
	stream.serialize_as<scalar_encoder::varint>( 3, value.test_current );
	stream.serialize_as<scalar_encoder::varint>( 4, value.use_default_outbound );
	stream.serialize_as<scalar_encoder::varint>( 5, value.test_download );
	stream.serialize_as<scalar_encoder::varint>( 6, value.test_upload );
	stream.serialize_as<scalar_encoder::varint>( 7, value.simple_download );
	stream.serialize( 8, value.simple_download_addr );
	stream.serialize_as<scalar_encoder::varint>( 9, value.timeout_ms );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestRequest & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.config, tag );
		case 2:
			return stream.deserialize( value.outbound_tags, tag );
		case 3:
			return stream.deserialize_as<scalar_encoder::varint>( value.test_current, tag );
		case 4:
			return stream.deserialize_as<scalar_encoder::varint>( value.use_default_outbound, tag );
		case 5:
			return stream.deserialize_as<scalar_encoder::varint>( value.test_download, tag );
		case 6:
			return stream.deserialize_as<scalar_encoder::varint>( value.test_upload, tag );
		case 7:
			return stream.deserialize_as<scalar_encoder::varint>( value.simple_download, tag );
		case 8:
			return stream.deserialize( value.simple_download_addr, tag );
		case 9:
			return stream.deserialize_as<scalar_encoder::varint>( value.timeout_ms, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::SpeedTestResult & value )
{
	stream.serialize( 1, value.dl_speed );
	stream.serialize( 2, value.ul_speed );
	stream.serialize_as<scalar_encoder::varint>( 3, value.latency );
	stream.serialize( 4, value.outbound_tag );
	stream.serialize( 5, value.error );
	stream.serialize( 6, value.server_name );
	stream.serialize( 7, value.server_country );
	stream.serialize_as<scalar_encoder::varint>( 8, value.cancelled );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestResult & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.dl_speed, tag );
		case 2:
			return stream.deserialize( value.ul_speed, tag );
		case 3:
			return stream.deserialize_as<scalar_encoder::varint>( value.latency, tag );
		case 4:
			return stream.deserialize( value.outbound_tag, tag );
		case 5:
			return stream.deserialize( value.error, tag );
		case 6:
			return stream.deserialize( value.server_name, tag );
		case 7:
			return stream.deserialize( value.server_country, tag );
		case 8:
			return stream.deserialize_as<scalar_encoder::varint>( value.cancelled, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::SpeedTestResponse & value )
{
	stream.serialize( 1, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::SpeedTestResponse & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.results, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::QuerySpeedTestResponse & value )
{
	stream.serialize( 1, value.result );
	stream.serialize_as<scalar_encoder::varint>( 2, value.is_running );
}
void deserialize_value( detail::istream & stream, ::libcore::QuerySpeedTestResponse & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.result, tag );
		case 2:
			return stream.deserialize_as<scalar_encoder::varint>( value.is_running, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::QueryURLTestResponse & value )
{
	stream.serialize( 1, value.results );
}
void deserialize_value( detail::istream & stream, ::libcore::QueryURLTestResponse & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return stream.deserialize( value.results, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
namespace detail
{
void serialize( detail::ostream & stream, const ::libcore::RuleSet & value )
{
	stream.serialize_as< scalar_encoder_combine( {}, {} ) >( 1, value.items );
}
void deserialize_value( detail::istream & stream, ::libcore::RuleSet & value, uint32_t tag )
{
	switch( field_from_tag( tag ) )
	{
		case 1:
			return 	stream.deserialize_as< scalar_encoder_combine( {}, {} ) >( value.items, tag );
		default:
			return stream.skip( tag );	
}
}

} // namespace detail
} // namespace spb::pb
