/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.graphics.Color;
import java.util.Arrays;

public class Lwjgl3WindowConfiguration {
    int windowX = -1;
    int windowY = -1;
    int windowWidth = 640;
    int windowHeight = 480;
    int windowMinWidth = -1;
    int windowMinHeight = -1;
    int windowMaxWidth = -1;
    int windowMaxHeight = -1;
    boolean windowResizable = true;
    boolean windowDecorated = true;
    boolean windowMaximized = false;
    Lwjgl3Graphics.Lwjgl3Monitor maximizedMonitor;
    boolean autoIconify = true;
    Files.FileType windowIconFileType;
    String[] windowIconPaths;
    Lwjgl3WindowListener windowListener;
    Lwjgl3Graphics.Lwjgl3DisplayMode fullscreenMode;
    String title;
    Color initialBackgroundColor = Color.BLACK;
    boolean initialVisible = true;
    boolean vSyncEnabled = true;

    void setWindowConfiguration(Lwjgl3WindowConfiguration config2) {
        this.windowX = config2.windowX;
        this.windowY = config2.windowY;
        this.windowWidth = config2.windowWidth;
        this.windowHeight = config2.windowHeight;
        this.windowMinWidth = config2.windowMinWidth;
        this.windowMinHeight = config2.windowMinHeight;
        this.windowMaxWidth = config2.windowMaxWidth;
        this.windowMaxHeight = config2.windowMaxHeight;
        this.windowResizable = config2.windowResizable;
        this.windowDecorated = config2.windowDecorated;
        this.windowMaximized = config2.windowMaximized;
        this.maximizedMonitor = config2.maximizedMonitor;
        this.autoIconify = config2.autoIconify;
        this.windowIconFileType = config2.windowIconFileType;
        if (config2.windowIconPaths != null) {
            this.windowIconPaths = Arrays.copyOf(config2.windowIconPaths, config2.windowIconPaths.length);
        }
        this.windowListener = config2.windowListener;
        this.fullscreenMode = config2.fullscreenMode;
        this.title = config2.title;
        this.initialBackgroundColor = config2.initialBackgroundColor;
        this.initialVisible = config2.initialVisible;
        this.vSyncEnabled = config2.vSyncEnabled;
    }

    public void setInitialVisible(boolean visibility) {
        this.initialVisible = visibility;
    }

    public void setWindowedMode(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public void setResizable(boolean resizable) {
        this.windowResizable = resizable;
    }

    public void setDecorated(boolean decorated) {
        this.windowDecorated = decorated;
    }

    public void setMaximized(boolean maximized) {
        this.windowMaximized = maximized;
    }

    public void setMaximizedMonitor(Graphics.Monitor monitor) {
        this.maximizedMonitor = (Lwjgl3Graphics.Lwjgl3Monitor)monitor;
    }

    public void setAutoIconify(boolean autoIconify) {
        this.autoIconify = autoIconify;
    }

    public void setWindowPosition(int x, int y) {
        this.windowX = x;
        this.windowY = y;
    }

    public void setWindowSizeLimits(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.windowMinWidth = minWidth;
        this.windowMinHeight = minHeight;
        this.windowMaxWidth = maxWidth;
        this.windowMaxHeight = maxHeight;
    }

    public void setWindowIcon(String ... filePaths) {
        this.setWindowIcon(Files.FileType.Internal, filePaths);
    }

    public void setWindowIcon(Files.FileType fileType, String ... filePaths) {
        this.windowIconFileType = fileType;
        this.windowIconPaths = filePaths;
    }

    public void setWindowListener(Lwjgl3WindowListener windowListener) {
        this.windowListener = windowListener;
    }

    public void setFullscreenMode(Graphics.DisplayMode mode) {
        this.fullscreenMode = (Lwjgl3Graphics.Lwjgl3DisplayMode)mode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInitialBackgroundColor(Color color) {
        this.initialBackgroundColor = color;
    }

    public void useVsync(boolean vsync) {
        this.vSyncEnabled = vsync;
    }
}

