/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation;

import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.StatMap;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0005H\u0003J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fH\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0007J$\u0010$\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0007J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0007J'\u0010.\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b/J%\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u00a8\u00064"}, d2={"Lcom/unciv/logic/automation/Automation;", "", "<init>", "()V", "rankTileForCityWork", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "city", "Lcom/unciv/logic/city/City;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "rankSpecialist", "specialist", "", "getFoodModWeight", "surplusFood", "rankStatsForCityWork", "stats", "Lcom/unciv/models/stats/Stats;", "areWeRankingSpecialist", "", "tryTrainMilitaryUnit", "", "providesUnneededCarryingSlots", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "chooseMilitaryUnit", "availableUnits", "Lkotlin/sequences/Sequence;", "afraidOfBarbarians", "allowAutomatedConstruction", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "allowSpendingResource", "cityInfo", "threatAssessment", "Lcom/unciv/logic/automation/ThreatLevel;", "assessor", "assessed", "improvementIsRemovable", "getTileForConstructionImprovement", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "rankTile", "rankTile$core", "rankTileForExpansion", "", "rankTileForExpansion$core", "rankStatsValue", "core"})
@SourceDebugExtension(value={"SMAP\nAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Automation.kt\ncom/unciv/logic/automation/Automation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,544:1\n1276#2,3:545\n1276#2,3:553\n1255#2,2:562\n1463#2,14:564\n1255#2,2:578\n1431#2,14:580\n1463#2,14:607\n2275#2,2:621\n1#3:548\n1788#4,4:549\n2746#4,3:556\n1761#4,3:559\n774#4:601\n865#4,2:602\n774#4:604\n865#4,2:605\n504#5,7:594\n*S KotlinDebug\n*F\n+ 1 Automation.kt\ncom/unciv/logic/automation/Automation\n*L\n212#1:545,3\n238#1:553,3\n264#1:562,2\n268#1:564,14\n270#1:578,2\n273#1:580,14\n431#1:607,14\n509#1:621,2\n236#1:549,4\n242#1:556,3\n263#1:559,3\n387#1:601\n387#1:602,2\n388#1:604\n388#1:605,2\n284#1:594,7\n*E\n"})
public final class Automation {
    @NotNull
    public static final Automation INSTANCE = new Automation();

    private Automation() {
    }

    @Readonly
    public final float rankTileForCityWork(@NotNull Tile tile, @NotNull City city, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats = tile.getStats().getTileStats(city, city.getCiv(), localUniqueCache);
        return this.rankStatsForCityWork(stats, city, false, localUniqueCache);
    }

    @Readonly
    public final float rankSpecialist(@NotNull String specialist, @NotNull City city, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(specialist, "specialist");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats = city.getCityStats().getStatsOfSpecialist(specialist, localUniqueCache);
        float rank = this.rankStatsForCityWork(stats, city, true, localUniqueCache);
        float gpp = 0.0f;
        if (city.getRuleset().getSpecialists().containsKey(specialist)) {
            Specialist specialist2 = city.getRuleset().getSpecialists().get(specialist);
            Intrinsics.checkNotNull(specialist2);
            Specialist specialistInfo = specialist2;
            gpp = specialistInfo.getGreatPersonPoints().sumValues();
        }
        gpp = gpp * (float)(100 + city.getCurrentGPPBonus()) / (float)100;
        return rank += gpp;
    }

    @Readonly
    private final float getFoodModWeight(City city, float surplusFood) {
        float speed = city.getCiv().getGameInfo().getSpeed().getModifier();
        if (city.getCiv().getHappiness() < -8) {
            return 0.0f;
        }
        if (city.getCiv().isAI()) {
            return 1.5f;
        }
        if (city.getCityFocus() == CityFocus.NoFocus) {
            if (city.getPopulation().getPopulation() < 5) {
                return 2.0f;
            }
            if (surplusFood > (float)city.getPopulation().getFoodToNextPopulation() / ((float)10 * speed)) {
                return 0.75f;
            }
        }
        return 1.0f;
    }

    @Readonly
    public final float rankStatsForCityWork(@NotNull Stats stats, @NotNull City city, boolean areWeRankingSpecialist, @NotNull LocalUniqueCache localUniqueCache) {
        float surplusFood;
        boolean starving;
        Intrinsics.checkNotNullParameter(stats, "stats");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        CityFocus cityAIFocus = city.getCityFocus();
        Stats yieldStats = stats.clone();
        CityStats cityStatsObj = city.getCityStats();
        Civilization civInfo = city.getCiv();
        boolean allTechsAreResearched = civInfo.getTech().allTechsAreResearched();
        if (areWeRankingSpecialist) {
            Unique unique;
            Iterator iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, city, UniqueType.FoodConsumptionBySpecialists, null, 4, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                if (!City.matchesFilter$default(city, unique.getParams().get(1), null, false, 6, null)) continue;
                yieldStats.setFood(yieldStats.getFood() - Float.parseFloat(unique.getParams().get(0)) / 100.0f * 2.0f);
            }
            iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, city, UniqueType.UnhappinessFromPopulationTypePercentageChange, null, 4, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                if (!Intrinsics.areEqual(unique.getParams().get(1), "Specialists") || !City.matchesFilter$default(city, unique.getParams().get(2), null, false, 6, null)) continue;
                yieldStats.setHappiness(yieldStats.getHappiness() - Float.parseFloat(unique.getParams().get(0)) / 100.0f);
            }
            if (yieldStats.getScience() == 3.0f || yieldStats.getScience() >= 5.0f) {
                yieldStats.setScience(yieldStats.getScience() * 2.0f);
            }
        }
        boolean bl = starving = (surplusFood = city.getCityStats().getCurrentCityStats().get(Stat.Food)) < 0.0f;
        if (cityStatsObj.canConvertFoodToProduction(surplusFood, city.getCityConstructions().getCurrentConstruction())) {
            yieldStats.setProduction(yieldStats.getProduction() + (cityStatsObj.getProductionFromExcessiveFood(surplusFood + yieldStats.getFood()) - cityStatsObj.getProductionFromExcessiveFood(surplusFood)));
            yieldStats.setFood(0.0f);
        }
        float feedFood = 0.0f;
        if (starving) {
            feedFood = RangesKt.coerceAtLeast(Math.min(yieldStats.getFood(), -surplusFood), 0.0f);
        }
        float growthFood = yieldStats.getFood() - feedFood;
        if (city.getAvoidGrowth()) {
            growthFood = 0.0f;
        }
        yieldStats.setFood(1.0f);
        yieldStats.applyRankingWeights();
        float foodBaseWeight = yieldStats.getFood();
        yieldStats.setFood(feedFood * (foodBaseWeight * (float)8));
        Unique growthNullifyingUnique = (Unique)SequencesKt.firstOrNull(LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, city, UniqueType.NullifiesGrowth, null, 4, null));
        if (growthNullifyingUnique == null) {
            float newGrowthFood = growthFood;
            CityStats cityStats = new CityStats(city);
            StatMap growthBonuses = cityStats.getGrowthBonus(growthFood, localUniqueCache);
            for (Map.Entry growthBonus : ((Map)growthBonuses).entrySet()) {
                newGrowthFood += ((Stats)growthBonus.getValue()).getFood();
            }
            if (city.isWeLoveTheKingDayActive() && city.getCiv().getHappiness() >= 0) {
                newGrowthFood += growthFood / (float)4;
            }
            newGrowthFood = RangesKt.coerceAtLeast(newGrowthFood, 0.0f);
            yieldStats.setFood(yieldStats.getFood() + newGrowthFood * foodBaseWeight * this.getFoodModWeight(city, surplusFood));
        }
        if (city.getPopulation().getPopulation() < 10) {
            yieldStats.setScience(yieldStats.getScience() / (float)2);
        }
        if (city.getCiv().getStats().getStatsForNextTurn().getGold() < 0.0f) {
            yieldStats.setGold(yieldStats.getGold() * (float)2);
        }
        if (city.getCiv().getHappiness() < 0) {
            yieldStats.setHappiness(yieldStats.getHappiness() * (float)2);
        }
        if (allTechsAreResearched) {
            yieldStats.setScience(yieldStats.getScience() * 0.0f);
        }
        if (city.getCityConstructions().getCurrentConstruction() instanceof PerpetualConstruction) {
            yieldStats.setProduction(yieldStats.getProduction() / (float)6);
        }
        for (Stat stat : cityAIFocus.getStatValuesForFocus()) {
            float currentStat = yieldStats.get(stat);
            if (currentStat == 0.0f) continue;
            float statMultiplier = cityAIFocus.getStatMultiplier(stat);
            yieldStats.set(stat, currentStat * statMultiplier);
        }
        return SequencesKt.sumOfFloat(yieldStats.getValues());
    }

    public final void tryTrainMilitaryUnit(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        if (city.isPuppet()) {
            return;
        }
        IConstruction iConstruction = city.getCityConstructions().getCurrentConstruction();
        BaseUnit baseUnit = iConstruction instanceof BaseUnit ? (BaseUnit)iConstruction : null;
        boolean bl = baseUnit != null ? baseUnit.isMilitary() : false;
        if (bl) {
            return;
        }
        Collection<BaseUnit> collection = city.getCiv().getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        BaseUnit chosenUnit = this.chooseMilitaryUnit(city, CollectionsKt.asSequence((Iterable)collection));
        if (chosenUnit != null) {
            city.getCityConstructions().setCurrentConstructionFromQueue(chosenUnit.getName());
        }
    }

    @Readonly
    public final boolean providesUnneededCarryingSlots(@NotNull BaseUnit baseUnit, @NotNull Civilization civInfo) {
        MapUnit it;
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Unique carryUnique = (Unique)SequencesKt.first(IHasUniques.getMatchingUniques$default(baseUnit, UniqueType.CarryAirUnits, null, 2, null));
        String carryFilter = carryUnique.getParams().get(1);
        Sequence<MapUnit> $this$count$iv = civInfo.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            MapUnit element$iv;
            it = element$iv = iterator2.next();
            boolean bl = false;
            if (!MapUnit.matchesFilter$default(it, carryFilter, false, 2, null) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalCarriableUnits = count$iv;
        Sequence<MapUnit> sequence = civInfo.getUnits().getCivUnits();
        int n = 0;
        iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            MapUnit mapUnit;
            it = mapUnit = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = Automation.providesUnneededCarryingSlots$getCarryAmount(carryFilter, it);
            n = n2 + n3;
        }
        int totalCarryingSlots = n;
        return totalCarriableUnits < totalCarryingSlots;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Readonly
    @Nullable
    public final BaseUnit chooseMilitaryUnit(@NotNull City city, @NotNull Sequence<BaseUnit> availableUnits) {
        block40: {
            block36: {
                block39: {
                    block35: {
                        block34: {
                            block37: {
                                block33: {
                                    block38: {
                                        Intrinsics.checkNotNullParameter(city, "city");
                                        Intrinsics.checkNotNullParameter(availableUnits, "availableUnits");
                                        currentChoice = city.getCityConstructions().getCurrentConstruction();
                                        if (currentChoice instanceof BaseUnit && !((BaseUnit)currentChoice).isCivilian()) {
                                            return (BaseUnit)currentChoice;
                                        }
                                        removeShips = new Ref.BooleanRef();
                                        removeShips.element = true;
                                        isMissingNavalUnitsForCityDefence = false;
                                        if (!city.isCoastal()) break block37;
                                        findWaterConnectedCitiesAndEnemies = new BFS(city.getCenterTile(), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$0(com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)());
                                        findWaterConnectedCitiesAndEnemies.stepToEnd();
                                        var8_7 = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            v0 = 0;
                                        } else {
                                            count$iv = 0;
                                            for (T element$iv : $this$count$iv) {
                                                it = (Tile)element$iv;
                                                $i$a$-count-Automation$chooseMilitaryUnit$numberOfOurConnectedCities$1 = false;
                                                if (!(it.isCityCenter() != false && Intrinsics.areEqual(it.getOwner(), city.getCiv()) != false) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            v0 = count$iv;
                                        }
                                        numberOfOurConnectedCities = v0;
                                        $i$f$count = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        count$iv = 0;
                                        for (T element$iv : $i$f$count) {
                                            it = (Tile)element$iv;
                                            var22_57 = count$iv;
                                            $i$a$-sumOfInt-Automation$chooseMilitaryUnit$numberOfOurNavalMeleeUnits$1 = false;
                                            $this$count$iv = it.getUnits();
                                            $i$f$count = false;
                                            count$iv = 0;
                                            var18_53 = $this$count$iv.iterator();
                                            while (var18_53.hasNext()) {
                                                it = element$iv = var18_53.next();
                                                $i$a$-count-Automation$chooseMilitaryUnit$numberOfOurNavalMeleeUnits$1$1 = false;
                                                if (!Automation.chooseMilitaryUnit$isNavalMeleeUnit(it.getBaseUnit()) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            var23_59 = count$iv;
                                            count$iv = var22_57 + var23_59;
                                        }
                                        numberOfOurNavalMeleeUnits = count$iv;
                                        isMissingNavalUnitsForCityDefence = numberOfOurConnectedCities > numberOfOurNavalMeleeUnits;
                                        $i$f$count = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        var22_58 = removeShips;
                                        $i$f$none = false;
                                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block38;
                                        v1 = 1;
                                        break block33;
                                    }
                                    for (T element$iv : $this$none$iv) {
                                        it = (Tile)element$iv;
                                        $i$a$-none-Automation$chooseMilitaryUnit$1 = false;
                                        if (it.isCityCenter() && !Intrinsics.areEqual(it.getOwner(), city.getCiv())) ** GOTO lbl-1000
                                        if (it.getMilitaryUnit() != null) {
                                            v2 = it.getMilitaryUnit();
                                            Intrinsics.checkNotNull(v2);
                                            ** if (Intrinsics.areEqual((Object)v2.getCiv(), (Object)city.getCiv())) goto lbl-1000
                                        }
                                        ** GOTO lbl-1000
lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = true;
                                            ** GOTO lbl67
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = false;
                                        }
lbl67:
                                        // 2 sources

                                        if (!v3) continue;
                                        v1 = 0;
                                        break block33;
                                    }
                                    v1 = 1;
                                }
                                var23_59 = v1;
                                var22_58.element = var23_59;
                            }
                            militaryUnits = CollectionsKt.asSequence((Iterable)SequencesKt.toList(SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filter(availableUnits, (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$4(com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)()), (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$5(kotlin.jvm.internal.Ref$BooleanRef com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)((Ref.BooleanRef)removeShips)), (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$6(com.unciv.logic.city.City com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)((City)city)), (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$7(com.unciv.logic.city.City com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)((City)city)), (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$8(com.unciv.logic.city.City com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)((City)city))));
                            chosenUnit = null;
                            if (city.getCiv().isAtWar()) break block39;
                            $this$any$iv = city.getCiv().getCities();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v4 = false;
                            } else {
                                $i$f$none = $this$any$iv.iterator();
                                while ($i$f$none.hasNext()) {
                                    element$iv = $i$f$none.next();
                                    it = (City)element$iv;
                                    $i$a$-any-Automation$chooseMilitaryUnit$2 = false;
                                    if (!(it.getCenterTile().getMilitaryUnit() == null)) continue;
                                    v4 = true;
                                    break block34;
                                }
                                v4 = false;
                            }
                        }
                        if (!v4) break block39;
                        $this$any$iv = militaryUnits;
                        $i$f$any = false;
                        $i$f$none = $this$any$iv.iterator();
                        while ($i$f$none.hasNext()) {
                            element$iv = $i$f$none.next();
                            it = (BaseUnit)element$iv;
                            $i$a$-any-Automation$chooseMilitaryUnit$3 = false;
                            if (!it.isRanged()) continue;
                            v5 = true;
                            break block35;
                        }
                        v5 = false;
                    }
                    if (!v5) break block39;
                    $this$any$iv = SequencesKt.filter(militaryUnits, (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$11(com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)());
                    $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v6 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v6 = maxElem$iv;
                        } else {
                            it = (BaseUnit)maxElem$iv;
                            $i$a$-maxByOrNull-Automation$chooseMilitaryUnit$5 = false;
                            maxValue$iv = it.getCost();
                            do {
                                e$iv = iterator$iv.next();
                                it = (BaseUnit)e$iv;
                                $i$a$-maxByOrNull-Automation$chooseMilitaryUnit$5 = false;
                                v$iv = it.getCost();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v6 = maxElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v6);
                    chosenUnit = v6;
                    break block40;
                }
                if (!isMissingNavalUnitsForCityDefence) ** GOTO lbl-1000
                $this$any$iv /* !! */  = militaryUnits;
                $i$f$any = false;
                iterator$iv = $this$any$iv /* !! */ .iterator();
                while (iterator$iv.hasNext()) {
                    element$iv = iterator$iv.next();
                    it = (BaseUnit)element$iv;
                    $i$a$-any-Automation$chooseMilitaryUnit$6 = false;
                    if (!Automation.chooseMilitaryUnit$isNavalMeleeUnit((BaseUnit)it)) continue;
                    v7 = true;
                    break block36;
                }
                v7 = false;
            }
            if (v7) {
                $this$any$iv /* !! */  = SequencesKt.filter(militaryUnits, (Function1<BaseUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseMilitaryUnit$lambda$14(com.unciv.models.ruleset.unit.BaseUnit ), (Lcom/unciv/models/ruleset/unit/BaseUnit;)Ljava/lang/Boolean;)());
                $i$f$maxByOrThrow = false;
                iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v8 = maxElem$iv;
                } else {
                    it = (BaseUnit)maxElem$iv;
                    $i$a$-maxByOrThrow-Automation$chooseMilitaryUnit$8 = false;
                    maxValue$iv = it.getCost();
                    do {
                        e$iv = iterator$iv.next();
                        it = (BaseUnit)e$iv;
                        $i$a$-maxByOrThrow-Automation$chooseMilitaryUnit$8 = false;
                        v$iv = it.getCost();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v8 = maxElem$iv;
                }
                chosenUnit = (BaseUnit)v8;
            } else lbl-1000:
            // 2 sources

            {
                bestUnitsForType = new HashMap<K, V>();
                $i$f$maxByOrThrow = militaryUnits.iterator();
                while ($i$f$maxByOrThrow.hasNext()) {
                    v9 = $i$f$maxByOrThrow.next();
                    Intrinsics.checkNotNullExpressionValue(v9, "next(...)");
                    unit = (BaseUnit)v9;
                    if (bestUnitsForType.get(unit.getUnitType()) != null) {
                        v10 = bestUnitsForType.get(unit.getUnitType());
                        Intrinsics.checkNotNull(v10);
                        if (((BaseUnit)v10).getCost() >= unit.getCost()) continue;
                    }
                    ((Map)bestUnitsForType).put(unit.getUnitType(), unit);
                }
                maxValue$iv = ((Iterable)((Map)bestUnitsForType).entrySet()).iterator();
                if (!maxValue$iv.hasNext()) {
                    v11 = null;
                } else {
                    it = (Map.Entry)maxValue$iv.next();
                    $i$a$-maxOfOrNull-Automation$chooseMilitaryUnit$bestForce$1 = false;
                    var13_37 = ((BaseUnit)it.getValue()).getForceEvaluation();
                    while (maxValue$iv.hasNext()) {
                        it = (Map.Entry)maxValue$iv.next();
                        $i$a$-maxOfOrNull-Automation$chooseMilitaryUnit$bestForce$1 = false;
                        if (var13_37.compareTo(it = (Comparable)Integer.valueOf(((BaseUnit)it.getValue()).getForceEvaluation())) >= 0) continue;
                        var13_37 = it;
                    }
                    v11 = var13_37;
                }
                v12 = (Integer)v11;
                if (v12 == null) {
                    return null;
                }
                bestForce = v12;
                $this$filterValues$iv = bestUnitsForType;
                $i$f$filterValues = false;
                result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
                    it = (BaseUnit)entry$iv.getValue();
                    $i$a$-filterValues-Automation$chooseMilitaryUnit$9 = false;
                    if (!(it.getUniqueTo() != null || it.getForceEvaluation() > bestForce / 3)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                chosenUnit = (BaseUnit)CollectionsKt.random(((Map)result$iv).values(), Random.Default);
            }
        }
        return chosenUnit;
    }

    public final boolean afraidOfBarbarians(@NotNull Civilization civInfo) {
        float multiplier;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        if (civInfo.isCityState() || civInfo.isBarbarian()) {
            return false;
        }
        if (civInfo.getGameInfo().getGameParameters().getNoBarbarians()) {
            return false;
        }
        Speed speed = civInfo.getGameInfo().getSpeed();
        if ((float)civInfo.getGameInfo().getTurns() > (float)200 * speed.getBarbarianModifier()) {
            return false;
        }
        float f = multiplier = civInfo.getGameInfo().getGameParameters().getRagingBarbarians() ? 1.3f : 1.0f;
        if ((float)civInfo.getGameInfo().getTurns() > (float)120 * speed.getBarbarianModifier() * multiplier) {
            multiplier /= (float)2;
        }
        if (civInfo.getCities().isEmpty() || (float)SequencesKt.count(civInfo.getUnits().getCivUnits()) >= (float)4 * multiplier) {
            return false;
        }
        civInfo.getGameInfo().getTileMap().assignContinents(TileMap.AssignContinentsMode.Ensure);
        City city = Civilization.getCapital$default(civInfo, false, 1, null);
        Intrinsics.checkNotNull(city);
        int startingContinent = city.getCenterTile().getContinent();
        Integer startingContinentSize = civInfo.getGameInfo().getTileMap().getContinentSizes().get(startingContinent);
        return startingContinentSize == null || !((float)startingContinentSize.intValue() < (float)civInfo.getViewableTiles().size() * multiplier);
    }

    @Readonly
    public final boolean allowAutomatedConstruction(@NotNull Civilization civInfo, @NotNull City city, @NotNull INonPerpetualConstruction construction) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(construction, "construction");
        return this.allowSpendingResource(civInfo, construction, city);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Readonly
    public final boolean allowSpendingResource(@NotNull Civilization civInfo, @NotNull INonPerpetualConstruction construction, @Nullable City cityInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(construction, "construction");
        if (civInfo.isCityState()) {
            return true;
        }
        if (civInfo.getGameInfo().getSpaceResources().contains(construction.getName())) {
            return true;
        }
        if (construction instanceof BaseUnit) {
            v0 = ((BaseUnit)construction).getResourceRequirementsPerTurn(civInfo.getState());
        } else {
            v1 = cityInfo;
            if (v1 == null || (v1 = v1.getState()) == null) {
                v1 = civInfo.getState();
            }
            v0 = requiredResources = construction.getResourceRequirementsPerTurn((GameContext)v1);
        }
        if (requiredResources.isEmpty()) {
            return true;
        }
        civResources = civInfo.getCivResourcesByName();
        for (Map.Entry<K, V> var7_7 : ((Map)requiredResources).entrySet()) {
            resource = (String)var7_7.getKey();
            amount = ((Number)var7_7.getValue()).intValue();
            futureForUnits = 0;
            futureForBuildings = 0;
            for (City city : civInfo.getCities()) {
                otherConstruction = city.getCityConstructions().getCurrentConstruction();
                if (otherConstruction instanceof Building) {
                    futureForBuildings += ((Number)((Building)otherConstruction).getResourceRequirementsPerTurn(city.getState()).get(resource)).intValue();
                    continue;
                }
                futureForUnits += ((Number)otherConstruction.getResourceRequirementsPerTurn(civInfo.getState()).get(resource)).intValue();
            }
            if (civInfo.getGameInfo().getSpaceResources().contains(resource)) {
                v2 = civResources.get(resource);
                Intrinsics.checkNotNull(v2);
                if (((Number)v2).intValue() - amount - futureForBuildings - futureForUnits < 2) {
                    return false;
                }
            }
            v3 = neededForBuilding = civInfo.getCache().getLastEraResourceUsedForBuilding().get(resource) != null;
            if (civInfo.getCache().getLastEraResourceUsedForUnit().get(resource) == null) ** GOTO lbl-1000
            v4 = civInfo.getCache().getLastEraResourceUsedForUnit().get(resource);
            Intrinsics.checkNotNull(v4);
            if (((Number)v4).intValue() >= civInfo.getEraNumber()) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = neededForUnits = false;
            }
            if (!neededForBuilding || !neededForUnits) continue;
            $this$filter$iv = civInfo.getDetailedCivResources();
            $i$f$filter = 0;
            var17_23 = $this$filter$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>();
            $i$f$filterTo = false;
            var20_28 = $this$filterTo$iv$iv.iterator();
            while (var20_28.hasNext()) {
                element$iv$iv = var20_28.next();
                it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
                $i$a$-filter-Automation$allowSpendingResource$usedForUnits$1 = false;
                if (!(Intrinsics.areEqual(it.getResource().getName(), resource) != false && Intrinsics.areEqual(it.getOrigin(), "Units") != false)) continue;
                destination$iv$iv /* !! */ .add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv /* !! */ ;
            $i$f$filter = 0;
            $this$filterTo$iv$iv = $this$filter$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                destination$iv$iv /* !! */  = $this$filterTo$iv$iv.next();
                $i$f$filterTo = (ResourceSupplyList.ResourceSupply)destination$iv$iv /* !! */ ;
                var25_38 = $i$f$filter;
                $i$a$-sumOfInt-Automation$allowSpendingResource$usedForUnits$2 = false;
                var26_39 = -it.getAmount();
                $i$f$filter = var25_38 + var26_39;
            }
            usedForUnits = $i$f$filter;
            $this$filter$iv = civInfo.getDetailedCivResources();
            $i$f$filter = false;
            destination$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
                $i$a$-filter-Automation$allowSpendingResource$usedForBuildings$1 = false;
                if (!(Intrinsics.areEqual(it.getResource().getName(), resource) != false && Intrinsics.areEqual(it.getOrigin(), "Buildings") != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var16_20 = (List)destination$iv$iv;
            var17_22 = 0;
            for (T var19_25 : var16_20) {
                $i$f$filterTo = (ResourceSupplyList.ResourceSupply)var19_25;
                var25_38 = var17_22;
                $i$a$-sumOfInt-Automation$allowSpendingResource$usedForBuildings$2 = false;
                var26_39 = -it.getAmount();
                var17_22 = var25_38 + var26_39;
            }
            usedForBuildings = var17_22;
            if (construction instanceof Building) {
                v6 = civResources.get(resource);
                Intrinsics.checkNotNull(v6);
                if (((Number)v6).intValue() + usedForUnits >= usedForBuildings + amount + futureForBuildings) continue;
                return false;
            }
            v7 = civResources.get(resource);
            Intrinsics.checkNotNull(v7);
            if (((Number)v7).intValue() + usedForBuildings >= usedForUnits + amount + futureForUnits) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean allowSpendingResource$default(Automation automation, Civilization civilization, INonPerpetualConstruction iNonPerpetualConstruction, City city, int n, Object object) {
        if ((n & 4) != 0) {
            city = null;
        }
        return automation.allowSpendingResource(civilization, iNonPerpetualConstruction, city);
    }

    @Readonly
    @NotNull
    public final ThreatLevel threatAssessment(@NotNull Civilization assessor, @NotNull Civilization assessed) {
        Intrinsics.checkNotNullParameter(assessor, "assessor");
        Intrinsics.checkNotNullParameter(assessed, "assessed");
        float powerLevelComparison = (float)assessed.getStatForRanking(RankingType.Force) / (float)assessor.getStatForRanking(RankingType.Force);
        return powerLevelComparison > 2.0f ? ThreatLevel.VeryHigh : (powerLevelComparison > 1.5f ? ThreatLevel.High : (powerLevelComparison < 0.5f ? ThreatLevel.VeryLow : (powerLevelComparison < 0.6666667f ? ThreatLevel.Low : ThreatLevel.Medium)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean improvementIsRemovable(City city, Tile tile) {
        GameContext gameContext = new GameContext(city.getCiv(), city, null, tile, null, null, null, null, null, null, false, 2036, null);
        TileImprovement tileImprovement = tile.getTileImprovement();
        if (tileImprovement == null) return false;
        if (tileImprovement.hasUnique(UniqueType.AutomatedUnitsWillNotReplace, gameContext)) return false;
        boolean bl = true;
        if (!bl) return false;
        TileImprovement tileImprovement2 = tile.getTileImprovement();
        if (tileImprovement2 == null) return false;
        if (tileImprovement2.hasUnique(UniqueType.Irremovable, gameContext)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @Nullable
    public final Tile getTileForConstructionImprovement(@NotNull City city, @NotNull TileImprovement improvement) {
        Object v0;
        void $this$maxByOrNull$iv;
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Civilization civ = city.getCiv();
        Sequence<Tile> sequence = SequencesKt.filter(city.getTiles(), arg_0 -> Automation.getTileForConstructionImprovement$lambda$0(city, improvement, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Tile it = (Tile)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = INSTANCE.rankStatsValue(it.getStats().getStatDiffForImprovement(improvement, civ, city, localUniqueCache, it.getStats().getTileStats(city, civ, localUniqueCache)), civ) + ((Number)(IHasUniques.hasUnique$default(improvement, UniqueType.DefensiveBonus, null, 2, null) ? (Number)Float.valueOf((float)it.aerialDistanceTo(city.getCenterTile()) + Tile.getDefensiveBonus$default(it, false, null, 2, null)) : (Number)0)).floatValue();
                do {
                    Object e$iv = iterator$iv.next();
                    it = (Tile)e$iv;
                    bl = false;
                    float v$iv = INSTANCE.rankStatsValue(it.getStats().getStatDiffForImprovement(improvement, civ, city, localUniqueCache, it.getStats().getTileStats(city, civ, localUniqueCache)), civ) + ((Number)(IHasUniques.hasUnique$default(improvement, UniqueType.DefensiveBonus, null, 2, null) ? (Number)Float.valueOf((float)it.aerialDistanceTo(city.getCenterTile()) + Tile.getDefensiveBonus$default(it, false, null, 2, null)) : (Number)0)).floatValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    @Readonly
    public final float rankTile$core(@Nullable Tile tile, @NotNull Civilization civInfo, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (tile == null) {
            return 0.0f;
        }
        Civilization tileOwner = tile.getOwner();
        if (tileOwner != null && !Intrinsics.areEqual(tileOwner, civInfo)) {
            return 0.0f;
        }
        Stats stats = tile.getStats().getTileStats(null, civInfo, localUniqueCache);
        float rank = this.rankStatsValue(stats, civInfo);
        if (tile.getImprovement() == null) {
            rank += 0.5f;
        }
        if (tile.isPillaged()) {
            rank += 0.6f;
        }
        if (tile.hasViewableResource(civInfo)) {
            TileResource resource = tile.getTileResource();
            if (resource.getResourceType() != ResourceType.Bonus) {
                rank += 1.0f;
            }
            if (tile.getImprovement() == null) {
                rank += 1.0f;
            }
            if (tile.isPillaged()) {
                rank += 1.1f;
            }
        }
        return rank;
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    public final int rankTileForExpansion$core(@NotNull Tile tile, @NotNull City city, @NotNull LocalUniqueCache localUniqueCache) {
        block16: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(city, "city");
            Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
            distance = tile.aerialDistanceTo(city.getCenterTile());
            score = distance * 100;
            if (tile.hasViewableResource(city.getCiv())) {
                if (tile.getTileResource().getResourceType() != ResourceType.Bonus) {
                    score -= 105;
                } else if (distance <= city.getWorkRange()) {
                    score -= 104;
                }
            } else {
                if (tile.isWater()) {
                    score += 3;
                }
                if (distance > city.getWorkRange()) {
                    score += 100;
                }
            }
            if (tile.getNaturalWonder() != null) {
                score -= 105;
            }
            score -= (int)SequencesKt.sumOfFloat(tile.getStats().getTileStats(city, city.getCiv(), localUniqueCache).getValues());
            adjacentNaturalWonder = false;
            var7_7 = SequencesKt.filter(tile.getNeighbors(), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, rankTileForExpansion$lambda$0(com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)()).iterator();
            while (var7_7.hasNext()) {
                adjacentTile = var7_7.next();
                adjacentDistance = city.getCenterTile().aerialDistanceTo(adjacentTile);
                if (adjacentTile.hasViewableResource(city.getCiv()) && (adjacentDistance < city.getWorkRange() || adjacentTile.getTileResource().getResourceType() != ResourceType.Bonus)) {
                    --score;
                }
                if (adjacentTile.getNaturalWonder() == null) continue;
                if (adjacentDistance < city.getWorkRange()) {
                    adjacentNaturalWonder = true;
                }
                --score;
            }
            if (adjacentNaturalWonder) {
                --score;
            }
            $this$none$iv = tile.getNeighbors();
            $i$f$none = false;
            var9_11 = $this$none$iv.iterator();
            while (var9_11.hasNext()) {
                it = element$iv = var9_11.next();
                $i$a$-none-Automation$rankTileForExpansion$2 = false;
                if (it.getCity() == null) ** GOTO lbl-1000
                v0 = it.getCity();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual(v0.getId(), city.getId())) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = false;
                break block16;
            }
            v2 = true;
        }
        if (v2) {
            score += 1000;
        }
        return score;
    }

    @Readonly
    public final float rankStatsValue(@NotNull Stats stats, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(stats, "stats");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        float rank = 0.0f;
        rank += stats.getFood() * 1.2f;
        rank += civInfo.getGold() < 0 && civInfo.getStats().getStatsForNextTurn().getGold() <= 0.0f ? stats.getGold() : stats.getGold() / (float)3;
        rank += stats.getHappiness();
        rank += stats.getProduction();
        rank += stats.getScience();
        rank += stats.getCulture();
        return rank += stats.getFaith();
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private static final int providesUnneededCarryingSlots$getCarryAmount(String carryFilter, MapUnit mapUnit) {
        int n;
        Unique unique = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(mapUnit, UniqueType.CarryAirUnits, null, false, 6, null));
        if (unique == null) {
            return 0;
        }
        Unique mapUnitCarryUnique = unique;
        if (!Intrinsics.areEqual(mapUnitCarryUnique.getParams().get(1), carryFilter)) {
            return 0;
        }
        Sequence<Unique> sequence = SequencesKt.filter(MapUnit.getMatchingUniques$default(mapUnit, UniqueType.CarryExtraAirUnits, null, false, 6, null), arg_0 -> Automation.providesUnneededCarryingSlots$getCarryAmount$lambda$0(carryFilter, arg_0));
        int n2 = Integer.parseInt(mapUnitCarryUnique.getParams().get(0));
        int n3 = 0;
        Iterator<Unique> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Unique unique2;
            Unique unique3 = unique2 = iterator2.next();
            n = n3;
            boolean bl = false;
            int n4 = Integer.parseInt(it.getParams().get(0));
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    private static final boolean providesUnneededCarryingSlots$getCarryAmount$lambda$0(String $carryFilter, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getParams().get(1), $carryFilter);
    }

    @Readonly
    private static final boolean chooseMilitaryUnit$isNavalMeleeUnit(BaseUnit unit) {
        return unit.isMelee() && unit.getType().isWaterUnit();
    }

    private static final boolean chooseMilitaryUnit$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isWater() && !it.isImpassible() || it.isCityCenter();
    }

    private static final boolean chooseMilitaryUnit$lambda$4(BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMilitary();
    }

    private static final boolean chooseMilitaryUnit$lambda$5(Ref.BooleanRef $removeShips, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $removeShips.element && it.isWaterUnit();
    }

    private static final boolean chooseMilitaryUnit$lambda$6(City $city, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Automation.allowSpendingResource$default(INSTANCE, $city.getCiv(), it, null, 4, null);
    }

    private static final boolean chooseMilitaryUnit$lambda$7(City $city, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.CarryAirUnits, null, 2, null) && INSTANCE.providesUnneededCarryingSlots(it, $city.getCiv());
    }

    private static final boolean chooseMilitaryUnit$lambda$8(City $city, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isBuildable($city.getCityConstructions());
    }

    private static final boolean chooseMilitaryUnit$lambda$11(BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isRanged();
    }

    private static final boolean chooseMilitaryUnit$lambda$14(BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Automation.chooseMilitaryUnit$isNavalMeleeUnit(it);
    }

    private static final boolean getTileForConstructionImprovement$lambda$0(City $city, TileImprovement $improvement, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (it.getTileImprovement() == null || INSTANCE.improvementIsRemovable($city, it)) && it.getImprovementFunctions().canBuildImprovement($improvement, $city.getState());
    }

    private static final boolean rankTileForExpansion$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner() == null;
    }
}

