/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.automation.civilization.DeclareWarPlanEvaluator;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n0\tJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/automation/civilization/DeclareWarTargetAutomation;", "", "<init>", "()V", "chooseDeclareWarTarget", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "civAttackMotivations", "", "Lkotlin/Pair;", "", "tryDeclareWarWithPlan", "", "target", "motivation", "tryTeamWar", "tryJoinWar", "declareWar", "prepareWar", "core"})
@SourceDebugExtension(value={"SMAP\nDeclareWarTargetAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclareWarTargetAutomation.kt\ncom/unciv/logic/automation/civilization/DeclareWarTargetAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1068#2:130\n774#2:131\n865#2,2:132\n1068#2:134\n774#2:135\n865#2,2:136\n1068#2:138\n*S KotlinDebug\n*F\n+ 1 DeclareWarTargetAutomation.kt\ncom/unciv/logic/automation/civilization/DeclareWarTargetAutomation\n*L\n19#1:130\n51#1:131\n51#1:132,2\n56#1:134\n79#1:135\n79#1:136,2\n85#1:138\n*E\n"})
public final class DeclareWarTargetAutomation {
    @NotNull
    public static final DeclareWarTargetAutomation INSTANCE = new DeclareWarTargetAutomation();

    private DeclareWarTargetAutomation() {
    }

    public final void chooseDeclareWarTarget(@NotNull Civilization civInfo, @NotNull List<Pair<Civilization, Float>> civAttackMotivations) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(civAttackMotivations, "civAttackMotivations");
        Iterable $this$sortedByDescending$iv = civAttackMotivations;
        boolean $i$f$sortedByDescending = false;
        List<Pair> highestValueTargets = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Civilization)it.getFirst()).getStatForRanking(RankingType.Score));
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((Civilization)it.getFirst()).getStatForRanking(RankingType.Score));
            }
        });
        for (Pair target : highestValueTargets) {
            if (!this.tryDeclareWarWithPlan(civInfo, (Civilization)target.getFirst(), ((Number)target.getSecond()).floatValue())) continue;
            return;
        }
    }

    private final boolean tryDeclareWarWithPlan(Civilization civInfo, Civilization target, float motivation) {
        if (!target.isCityState()) {
            if (motivation > 5.0f && this.tryTeamWar(civInfo, target, motivation)) {
                return true;
            }
            if (motivation >= 15.0f && this.tryJoinWar(civInfo, target, motivation)) {
                return true;
            }
        }
        if (motivation >= 20.0f && this.declareWar(civInfo, target, motivation)) {
            return true;
        }
        return motivation >= 15.0f && this.prepareWar(civInfo, target, motivation);
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final boolean tryTeamWar(Civilization civInfo, Civilization target, float motivation) {
        v0 = civInfo.getDiplomacyManager(target);
        Intrinsics.checkNotNull(v0);
        var5_4 = v0.getCommonKnownCivs();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            $i$a$-filter-DeclareWarTargetAutomation$tryTeamWar$potentialAllies$1 = false;
            if (!it.isMajorCiv()) ** GOTO lbl-1000
            v1 = civInfo.getDiplomacyManager(it);
            Intrinsics.checkNotNull(v1);
            if (v1.hasFlag(DiplomacyFlags.DeclinedJoinWarOffer)) ** GOTO lbl-1000
            v2 = civInfo.getDiplomacyManager(it);
            Intrinsics.checkNotNull(v2);
            if (v2.isRelationshipLevelGE(RelationshipLevel.Neutral) && !it.isAtWarWith(target)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        potentialAllies = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStatForRanking(RankingType.Force));
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getStatForRanking(RankingType.Force));
            }
        });
        for (Civilization thirdCiv : potentialAllies) {
            if (DeclareWarPlanEvaluator.INSTANCE.evaluateTeamWarPlan(civInfo, target, thirdCiv, Float.valueOf(motivation)) <= 0.0f) continue;
            tradeLogic = new TradeLogic(civInfo, thirdCiv);
            tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer(target.getCivName(), TradeOfferType.WarDeclaration, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer(target.getCivName(), TradeOfferType.WarDeclaration, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            thirdCiv.getTradeRequests().add(new TradeRequest(civInfo.getCivName(), tradeLogic.getCurrentTrade().reverse()));
            return true;
        }
        return false;
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final boolean tryJoinWar(Civilization civInfo, Civilization target, float motivation) {
        v0 = civInfo.getDiplomacyManager(target);
        Intrinsics.checkNotNull(v0);
        var5_4 = v0.getCommonKnownCivs();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            $i$a$-filter-DeclareWarTargetAutomation$tryJoinWar$potentialAllies$1 = false;
            if (!it.isMajorCiv()) ** GOTO lbl-1000
            v1 = civInfo.getDiplomacyManager(it);
            Intrinsics.checkNotNull(v1);
            if (v1.hasFlag(DiplomacyFlags.DeclinedJoinWarOffer)) ** GOTO lbl-1000
            v2 = civInfo.getDiplomacyManager(it);
            Intrinsics.checkNotNull(v2);
            if (v2.isRelationshipLevelGE(RelationshipLevel.Favorable) && it.isAtWarWith(target)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        potentialAllies = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStatForRanking(RankingType.Force));
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getStatForRanking(RankingType.Force));
            }
        });
        for (Civilization thirdCiv : potentialAllies) {
            if (DeclareWarPlanEvaluator.INSTANCE.evaluateJoinWarPlan(civInfo, target, thirdCiv, Float.valueOf(motivation)) <= 0.0f) continue;
            tradeLogic = new TradeLogic(civInfo, thirdCiv);
            tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer(target.getCivName(), TradeOfferType.WarDeclaration, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            thirdCiv.getTradeRequests().add(new TradeRequest(civInfo.getCivName(), tradeLogic.getCurrentTrade().reverse()));
            return true;
        }
        return false;
    }

    private final boolean declareWar(Civilization civInfo, Civilization target, float motivation) {
        if (DeclareWarPlanEvaluator.INSTANCE.evaluateDeclareWarPlan(civInfo, target, Float.valueOf(motivation)) > 0.0f) {
            DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(target);
            Intrinsics.checkNotNull(diplomacyManager);
            DiplomacyManager.declareWar$default(diplomacyManager, null, 1, null);
            return true;
        }
        return false;
    }

    private final boolean prepareWar(Civilization civInfo, Civilization target, float motivation) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(target);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (DeclareWarPlanEvaluator.INSTANCE.evaluateStartPreparingWarPlan(civInfo, target, Float.valueOf(motivation)) > 0.0f) {
            diploManager.setFlag(DiplomacyFlags.WaryOf, -1);
            return true;
        }
        return false;
    }
}

