/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0003JR\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u0019j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0003Jd\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000e2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#2\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u0019j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006%"}, d2={"Lcom/unciv/logic/automation/unit/CityLocationTileRanker;", "", "<init>", "()V", "getBestTilesToFoundCity", "Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "distanceToSearch", "", "minimumValue", "", "(Lcom/unciv/logic/map/mapunit/MapUnit;Ljava/lang/Integer;F)Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "canSettleTile", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "nearbyCities", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/city/City;", "rankTileToSettle", "newCityTile", "baseTileMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "uniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "getDistanceToCityModifier", "rankTile", "onCoast", "newUniqueLuxuryResources", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "BestTilesToFoundCity", "core"})
@SourceDebugExtension(value={"SMAP\nCityLocationTileRanker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityLocationTileRanker.kt\ncom/unciv/logic/automation/unit/CityLocationTileRanker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,198:1\n1#2:199\n622#3:200\n183#3,2:201\n1255#3,2:203\n*S KotlinDebug\n*F\n+ 1 CityLocationTileRanker.kt\ncom/unciv/logic/automation/unit/CityLocationTileRanker\n*L\n56#1:200\n58#1:201,2\n40#1:203,2\n*E\n"})
public final class CityLocationTileRanker {
    @NotNull
    public static final CityLocationTileRanker INSTANCE = new CityLocationTileRanker();

    private CityLocationTileRanker() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BestTilesToFoundCity getBestTilesToFoundCity(@NotNull MapUnit unit, @Nullable Integer distanceToSearch, float minimumValue) {
        Object v3;
        BestTilesToFoundCity bestTilesToFoundCity;
        block8: {
            void $this$sortedByDescending$iv;
            Sequence possibleTileLocationsWithRank;
            int n;
            Intrinsics.checkNotNullParameter(unit, "unit");
            float distanceModifier = 3.0f;
            Integer n2 = distanceToSearch;
            if (n2 != null) {
                n = n2;
            } else {
                int n3;
                if (unit.getCiv().getCities().isEmpty()) {
                    n3 = 0;
                } else {
                    Iterator iterator2 = ((Iterable)unit.getCiv().getCities()).iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    City it22 = (City)iterator2.next();
                    boolean bl = false;
                    int it22 = it22.getCenterTile().aerialDistanceTo(unit.getTile());
                    while (iterator2.hasNext()) {
                        City it32 = (City)iterator2.next();
                        $i$a$-minOf-CityLocationTileRanker$getBestTilesToFoundCity$range$distanceFromHome$1 = false;
                        int it32 = it32.getCenterTile().aerialDistanceTo(unit.getTile());
                        if (it22 <= it32) continue;
                        it22 = it32;
                    }
                    n3 = it22;
                }
                int distanceFromHome = n3;
                n = RangesKt.coerceIn(8 - distanceFromHome, 1, 5);
            }
            int range = n;
            Sequence<City> nearbyCities = SequencesKt.filter(unit.getCiv().getGameInfo().getCities(), arg_0 -> CityLocationTileRanker.getBestTilesToFoundCity$lambda$1(unit, range, arg_0));
            Sequence uniques = SequencesKt.plus(MapUnit.getMatchingUniques$default(unit, UniqueType.FoundCity, null, false, 6, null), MapUnit.getMatchingUniques$default(unit, UniqueType.FoundPuppetCity, null, false, 6, null));
            Sequence<Tile> possibleCityLocations = SequencesKt.filter(SequencesKt.filter(unit.getTile().getTilesInDistance(range), arg_0 -> CityLocationTileRanker.getBestTilesToFoundCity$lambda$2(uniques, unit, arg_0)), arg_0 -> CityLocationTileRanker.getBestTilesToFoundCity$lambda$3(unit, nearbyCities, arg_0));
            LocalUniqueCache uniqueCache = new LocalUniqueCache(false, 1, null);
            bestTilesToFoundCity = new BestTilesToFoundCity();
            HashMap baseTileMap = new HashMap();
            Sequence<Pair> sequence = SequencesKt.filter(SequencesKt.map(possibleCityLocations, arg_0 -> CityLocationTileRanker.getBestTilesToFoundCity$lambda$4(unit, nearbyCities, baseTileMap, uniqueCache, distanceModifier, minimumValue, bestTilesToFoundCity, arg_0)), arg_0 -> CityLocationTileRanker.getBestTilesToFoundCity$lambda$5(minimumValue, arg_0));
            boolean $i$f$sortedByDescending = false;
            Sequence $this$firstOrNull$iv = possibleTileLocationsWithRank = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Float)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getSecond()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator3 = $this$firstOrNull$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach((Tile)it.getFirst())) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        Pair bestReachableTile = v3;
        if (bestReachableTile != null) {
            bestTilesToFoundCity.setBestTile((Tile)bestReachableTile.getFirst());
            bestTilesToFoundCity.setBestTileRank(((Number)bestReachableTile.getSecond()).floatValue());
        }
        return bestTilesToFoundCity;
    }

    public static /* synthetic */ BestTilesToFoundCity getBestTilesToFoundCity$default(CityLocationTileRanker cityLocationTileRanker, MapUnit mapUnit, Integer n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return cityLocationTileRanker.getBestTilesToFoundCity(mapUnit, n, f);
    }

    @Readonly
    private final boolean canSettleTile(Tile tile, Civilization civ, Sequence<City> nearbyCities) {
        ModConstants modConstants = civ.getGameInfo().getRuleset().getModOptions().getConstants();
        if (!tile.isLand() || tile.isImpassible()) {
            return false;
        }
        if (tile.getOwner() != null && !Intrinsics.areEqual(tile.getOwner(), civ)) {
            return false;
        }
        Iterator<City> iterator2 = nearbyCities.iterator();
        while (iterator2.hasNext()) {
            City city = iterator2.next();
            int distance = city.getCenterTile().aerialDistanceTo(tile);
            if (distance <= 6 && civ.knows(city.getCiv()) && !civ.isAtWarWith(city.getCiv())) {
                DiplomacyManager diplomacyManager = city.getCiv().getDiplomacyManager(civ);
                Intrinsics.checkNotNull(diplomacyManager);
                if (diplomacyManager.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) {
                    return false;
                }
            }
            if (!(tile.getContinent() == city.getCenterTile().getContinent() ? distance <= modConstants.getMinimalCityDistance() : distance <= modConstants.getMinimalCityDistanceOnDifferentContinents())) continue;
            return false;
        }
        return true;
    }

    private final float rankTileToSettle(Tile newCityTile, Civilization civ, Sequence<City> nearbyCities, HashMap<Tile, Float> baseTileMap, LocalUniqueCache uniqueCache) {
        float tileValue = 0.0f;
        tileValue += this.getDistanceToCityModifier(newCityTile, nearbyCities, civ);
        boolean onCoast = newCityTile.isCoastalTile();
        boolean onHill = newCityTile.isHill();
        boolean isNextToMountain = Tile.isAdjacentTo$default(newCityTile, "Mountain", null, 2, null);
        HashSet<String> newUniqueLuxuryResources = new HashSet<String>();
        if (onCoast) {
            tileValue += (float)3;
        }
        if (onHill) {
            tileValue += (float)14;
        }
        if (isNextToMountain) {
            tileValue += (float)5;
        }
        if (newCityTile.isAdjacentToRiver()) {
            tileValue += (float)20;
        }
        if (Tile.terrainHasUnique$default(newCityTile, UniqueType.Unbuildable, null, 2, null)) {
            tileValue += (float)3;
        }
        if (newCityTile.hasViewableResource(civ)) {
            tileValue -= (float)4;
        }
        if (newCityTile.hasViewableResource(civ) && newCityTile.getTileResource().getResourceType() == ResourceType.Bonus) {
            tileValue -= (float)8;
        }
        int tiles = 0;
        for (int i = 0; i < 3; ++i) {
            Iterator<Tile> iterator2 = newCityTile.getTilesAtDistance(i).iterator();
            while (iterator2.hasNext()) {
                Tile nearbyTile = iterator2.next();
                ++tiles;
                tileValue += this.rankTile(nearbyTile, civ, onCoast, newUniqueLuxuryResources, baseTileMap, uniqueCache) * (float)(3 / (i + 1));
            }
        }
        return tileValue -= (float)(HexMath.INSTANCE.getNumberOfTilesInHexagon(2) - tiles) * 2.4f;
    }

    @Readonly
    private final float getDistanceToCityModifier(Tile newCityTile, Sequence<City> nearbyCities, Civilization civ) {
        float modifier = 0.0f;
        Iterator<City> iterator2 = nearbyCities.iterator();
        while (iterator2.hasNext()) {
            float distanceToCityModifier;
            City city = iterator2.next();
            int distanceToCity = newCityTile.aerialDistanceTo(city.getCenterTile());
            float f = distanceToCity == 7 ? 2.0f : (distanceToCity == 6 ? 4.0f : (distanceToCity == 5 ? 8.0f : (distanceToCity == 4 ? 6.0f : (distanceToCity == 3 ? -25.0f : (distanceToCityModifier = distanceToCity < 3 ? -30.0f : 0.0f)))));
            if (!Intrinsics.areEqual(city.getCiv(), civ)) continue;
            modifier += (distanceToCityModifier *= (float)(city.isCapital() ? 2 : 1));
        }
        return modifier;
    }

    private final float rankTile(Tile rankTile, Civilization civ, boolean onCoast, HashSet<String> newUniqueLuxuryResources, HashMap<Tile, Float> baseTileMap, LocalUniqueCache uniqueCache) {
        if (rankTile.getCity() != null) {
            return -1.0f;
        }
        float locationSpecificTileValue = 0.0f;
        if (rankTile.isWater() && !onCoast) {
            locationSpecificTileValue -= 1.0f;
        }
        if (rankTile.hasViewableResource(civ) && rankTile.getTileResource().getResourceType() == ResourceType.Luxury) {
            String string = rankTile.getResource();
            Intrinsics.checkNotNull(string);
            if (!civ.hasResource(string) && !CollectionsKt.contains((Iterable)newUniqueLuxuryResources, rankTile.getResource())) {
                locationSpecificTileValue += (float)10;
                String string2 = rankTile.getResource();
                Intrinsics.checkNotNull(string2);
                newUniqueLuxuryResources.add(string2);
            }
        }
        if (baseTileMap.containsKey(rankTile)) {
            Float f = baseTileMap.get(rankTile);
            Intrinsics.checkNotNull(f);
            return locationSpecificTileValue + ((Number)f).floatValue();
        }
        if (rankTile.getOwner() != null && !Intrinsics.areEqual(rankTile.getOwner(), civ)) {
            return 0.0f;
        }
        float rankTileValue = Automation.INSTANCE.rankStatsValue(rankTile.getStats().getTileStats(null, civ, uniqueCache), civ);
        if (rankTile.hasViewableResource(civ)) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[rankTile.getTileResource().getResourceType().ordinal()]) {
                case 1: {
                    f = 1.0f;
                    break;
                }
                case 2: {
                    f = 2.0f;
                    break;
                }
                case 3: {
                    f = 10.0f;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            rankTileValue += f;
        }
        if (Tile.terrainHasUnique$default(rankTile, UniqueType.FreshWater, null, 2, null)) {
            rankTileValue += 0.5f;
        }
        if (!((Collection)rankTile.getTerrainFeatures()).isEmpty() && IHasUniques.hasUnique$default(rankTile.getLastTerrain(), UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
            rankTileValue += 0.7f;
        }
        if (rankTile.isNaturalWonder()) {
            rankTileValue += (float)4;
        }
        ((Map)baseTileMap).put(rankTile, Float.valueOf(rankTileValue));
        return rankTileValue + locationSpecificTileValue;
    }

    private static final boolean getBestTilesToFoundCity$lambda$1(MapUnit $unit, int $range, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().aerialDistanceTo($unit.getTile()) <= 7 + $range;
    }

    private static final boolean getBestTilesToFoundCity$lambda$2(Sequence $uniques, MapUnit $unit, Tile tile) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Sequence $this$any$iv = $uniques;
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!it.conditionalsApply(new GameContext(null, null, $unit, tile, null, null, null, null, null, null, false, 2035, null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean getBestTilesToFoundCity$lambda$3(MapUnit $unit, Sequence $nearbyCities, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.canSettleTile(it, $unit.getCiv(), $nearbyCities) && (Intrinsics.areEqual($unit.getTile(), it) || UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null));
    }

    private static final Pair getBestTilesToFoundCity$lambda$4(MapUnit $unit, Sequence $nearbyCities, HashMap $baseTileMap, LocalUniqueCache $uniqueCache, float $distanceModifier, float $minimumValue, BestTilesToFoundCity $bestTilesToFoundCity, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        float tileValue = INSTANCE.rankTileToSettle(it, $unit.getCiv(), $nearbyCities, $baseTileMap, $uniqueCache);
        float distanceScore = RangesKt.coerceIn((float)$unit.getCurrentTile().aerialDistanceTo(it) * $distanceModifier, 0.0f, 99.0f);
        tileValue *= ((float)100 - distanceScore) / (float)100;
        if (tileValue >= $minimumValue) {
            ((Map)$bestTilesToFoundCity.getTileRankMap()).put(it, Float.valueOf(tileValue));
        }
        return new Pair<Tile, Float>(it, Float.valueOf(tileValue));
    }

    private static final boolean getBestTilesToFoundCity$lambda$5(float $minimumValue, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)it.getSecond()).floatValue() >= $minimumValue;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R6\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "", "<init>", "()V", "tileRankMap", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "", "Lkotlin/collections/HashMap;", "getTileRankMap", "()Ljava/util/HashMap;", "setTileRankMap", "(Ljava/util/HashMap;)V", "bestTile", "getBestTile", "()Lcom/unciv/logic/map/tile/Tile;", "setBestTile", "(Lcom/unciv/logic/map/tile/Tile;)V", "bestTileRank", "getBestTileRank", "()F", "setBestTileRank", "(F)V", "core"})
    public static final class BestTilesToFoundCity {
        @NotNull
        private HashMap<Tile, Float> tileRankMap = new HashMap();
        @Nullable
        private Tile bestTile;
        private float bestTileRank;

        @NotNull
        public final HashMap<Tile, Float> getTileRankMap() {
            return this.tileRankMap;
        }

        public final void setTileRankMap(@NotNull HashMap<Tile, Float> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
            this.tileRankMap = hashMap;
        }

        @Nullable
        public final Tile getBestTile() {
            return this.bestTile;
        }

        public final void setBestTile(@Nullable Tile tile) {
            this.bestTile = tile;
        }

        public final float getBestTileRank() {
            return this.bestTileRank;
        }

        public final void setBestTileRank(float f) {
            this.bestTileRank = f;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.Bonus.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Strategic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Luxury.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

