/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityPopulationManager;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0003J.\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0003J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/city/managers/CityFounder;", "", "<init>", "()V", "foundCity", "Lcom/unciv/logic/city/City;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "cityLocation", "Lcom/badlogic/gdx/math/Vector2;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "generateNewCityName", "", "foundingCiv", "aliveCivs", "", "borrowCityName", "usedCityNames", "addStartingBuildings", "", "city", "startingEra", "triggerCitiesSettledNearOtherCiv", "NamingConstants", "core"})
@SourceDebugExtension(value={"SMAP\nCityFounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityFounder.kt\ncom/unciv/logic/city/managers/CityFounder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,251:1\n1#2:252\n774#3:253\n865#3,2:254\n543#3,6:258\n183#4,2:256\n*S KotlinDebug\n*F\n+ 1 CityFounder.kt\ncom/unciv/logic/city/managers/CityFounder\n*L\n48#1:253\n48#1:254,2\n185#1:258,6\n150#1:256,2\n*E\n"})
public final class CityFounder {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final City foundCity(@NotNull Civilization civInfo, @NotNull Vector2 cityLocation, @Nullable MapUnit unit) {
        void $this$filterTo$iv$iv;
        void $this$foundCity_u24lambda_u241;
        List<City> list2;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(cityLocation, "cityLocation");
        City city = new City();
        city.setFoundingCiv(civInfo.getCivName());
        city.setTurnAcquired(civInfo.getGameInfo().getTurns());
        city.setLocation(cityLocation);
        city.setTransients(civInfo);
        String string = this.generateNewCityName(civInfo, SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence((Iterable)civInfo.getGameInfo().getCivilizations()), CityFounder::foundCity$lambda$0)));
        if (string == null) {
            string = "City Without A Name";
        }
        city.setName(string);
        city.setOriginalCapital(civInfo.getCitiesCreated() == 0);
        if (city.isOriginalCapital()) {
            civInfo.setHasEverOwnedOriginalCapital(true);
            civInfo.getPolicies().setShouldOpenPolicyPicker(true);
        }
        int n = civInfo.getCitiesCreated();
        civInfo.setCitiesCreated(n + 1);
        List<City> list3 = list2 = CollectionsKt.toMutableList((Collection)civInfo.getCities());
        Civilization civilization = civInfo;
        boolean bl = false;
        $this$foundCity_u24lambda_u241.add(city);
        civilization.setCities(list2);
        String startingEra = civInfo.getGameInfo().getGameParameters().getStartingEra();
        city.getExpansion().reset();
        city.tryUpdateRoadStatus$core();
        Tile tile = city.getCenterTile();
        Iterable $this$filter$iv = tile.getTerrainFeatures();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (!city.getRuleset().getTileImprovements().containsKey("Remove " + it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String terrainFeature : (List)destination$iv$iv) {
            tile.removeTerrainFeature(terrainFeature);
        }
        if (civInfo.getGameInfo().getRuleset().getTileImprovements().containsKey("City center")) {
            Tile.setImprovement$default(tile, "City center", civInfo, null, 4, null);
        }
        tile.stopWorkingOnImprovement();
        Ruleset ruleset = civInfo.getGameInfo().getRuleset();
        city.setWorkedTiles(new HashSet<Vector2>());
        CityPopulationManager cityPopulationManager = city.getPopulation();
        Era era = ruleset.getEras().get(startingEra);
        Intrinsics.checkNotNull(era);
        cityPopulationManager.setPopulation(era.getSettlerPopulation());
        if (civInfo.getReligionManager().getReligionState() == ReligionState.Pantheon) {
            CityReligionManager cityReligionManager = city.getReligion();
            Religion religion = civInfo.getReligionManager().getReligion();
            Intrinsics.checkNotNull(religion);
            CityReligionManager.addPressure$default(cityReligionManager, religion.getName(), 200 * city.getPopulation().getPopulation(), false, 4, null);
        }
        city.getPopulation().autoAssignPopulation$core();
        for (Civilization otherCiv : civInfo.getGameInfo().getAliveMajorCivs()) {
            if (civInfo.getProximity(otherCiv) == Proximity.Neighbors) continue;
            civInfo.getCache().updateProximity(otherCiv, CivInfoTransientCache.updateProximity$default(otherCiv.getCache(), civInfo, null, 2, null));
        }
        for (Civilization otherCiv : civInfo.getGameInfo().getAliveCityStates()) {
            if (civInfo.getProximity(otherCiv) == Proximity.Neighbors) continue;
            civInfo.getCache().updateProximity(otherCiv, CivInfoTransientCache.updateProximity$default(otherCiv.getCache(), civInfo, null, 2, null));
        }
        this.triggerCitiesSettledNearOtherCiv(city);
        this.addStartingBuildings(city, civInfo, startingEra);
        for (Unique unique : Civilization.getTriggeredUniques$default(civInfo, UniqueType.TriggerUponFoundingCity, new GameContext(civInfo, city, unit, null, null, null, null, null, null, null, false, 2040, null), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civInfo, city, unit, null, null, "due to founding a city", 48, null);
        }
        if (unit != null) {
            Iterator<Civilization> iterator2 = MapUnit.getTriggeredUniques$default(unit, UniqueType.TriggerUponFoundingCity, new GameContext(civInfo, city, unit, null, null, null, null, null, null, null, false, 2040, null), null, 4, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)((Object)iterator2.next());
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civInfo, city, unit, null, null, "due to founding a city", 48, null);
            }
        }
        return city;
    }

    public static /* synthetic */ City foundCity$default(CityFounder cityFounder, Civilization civilization, Vector2 vector2, MapUnit mapUnit, int n, Object object) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        return cityFounder.foundCity(civilization, vector2, mapUnit);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final String generateNewCityName(Civilization foundingCiv, Set<Civilization> aliveCivs) {
        Set<String> usedCityNames = SequencesKt.toSet(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)aliveCivs), CityFounder::generateNewCityName$lambda$0));
        Iterator<String> iterator2 = foundingCiv.getNation().getCities().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String cityName;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (usedCityNames.contains(cityName)) continue;
            return cityName;
        }
        if (Civilization.hasUnique$default(foundingCiv, UniqueType.BorrowsCityNames, null, 2, null)) {
            return this.borrowCityName(foundingCiv, aliveCivs, usedCityNames);
        }
        for (int number = 1; number < 11; ++number) {
            Iterator<String> iterator4;
            Intrinsics.checkNotNullExpressionValue(NamingConstants.INSTANCE.getPrefixes().iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                String candidate;
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    String prefix;
                    Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                    String repeatedPredix = StringsKt.repeat(prefix + " [", number);
                    String suffix = StringsKt.repeat("]", number);
                    Sequence<String> sequence = SequencesKt.map(CollectionsKt.asSequence((Iterable)foundingCiv.getNation().getCities()), arg_0 -> CityFounder.generateNewCityName$lambda$1(repeatedPredix, suffix, arg_0));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!(!usedCityNames.contains(it))) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                String string = candidate = (String)v1;
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    @Readonly
    private final String borrowCityName(Civilization foundingCiv, Set<Civilization> aliveCivs, Set<String> usedCityNames) {
        Sequence<Nation> aliveMajorNations = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)aliveCivs), CityFounder::borrowCityName$lambda$0), CityFounder::borrowCityName$lambda$1);
        Sequence<Nation> otherMajorNations = SequencesKt.filter(aliveMajorNations, arg_0 -> CityFounder.borrowCityName$lambda$2(foundingCiv, arg_0));
        Set<String> newCityNames = SequencesKt.toSet(SequencesKt.mapNotNull(otherMajorNations, arg_0 -> CityFounder.borrowCityName$lambda$3(usedCityNames, arg_0)));
        if (!((Collection)newCityNames).isEmpty()) {
            return (String)CollectionsKt.random((Collection)newCityNames, Random.Default);
        }
        Collection<Nation> collection = foundingCiv.getGameInfo().getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence<Nation> absentMajorNations = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> CityFounder.borrowCityName$lambda$4(aliveMajorNations, arg_0));
        newCityNames = SequencesKt.toSet(SequencesKt.flatMap(absentMajorNations, arg_0 -> CityFounder.borrowCityName$lambda$5(usedCityNames, arg_0)));
        if (!((Collection)newCityNames).isEmpty()) {
            return (String)CollectionsKt.random((Collection)newCityNames, Random.Default);
        }
        return null;
    }

    private final void addStartingBuildings(City city, Civilization civInfo, String startingEra) {
        Building capitalCityIndicator;
        Ruleset ruleset = civInfo.getGameInfo().getRuleset();
        if (civInfo.getCities().size() == 1 && (capitalCityIndicator = civInfo.capitalCityIndicator(city)) != null) {
            city.getCityConstructions().addBuilding(capitalCityIndicator, false);
        }
        Era era = ruleset.getEras().get(startingEra);
        Intrinsics.checkNotNull(era);
        Iterator<String> iterator2 = era.getSettlerBuildings().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Building building;
            Building uniqueBuilding;
            String buildingName;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (ruleset.getBuildings().get(buildingName) == null || !(uniqueBuilding = civInfo.getEquivalentBuilding(building)).isBuildable(city.getCityConstructions())) continue;
            city.getCityConstructions().addBuilding(uniqueBuilding, false);
        }
        civInfo.getCivConstructions().tryAddFreeBuildings();
    }

    private final void triggerCitiesSettledNearOtherCiv(City city) {
        Sequence<City> citiesWithin6Tiles = SequencesKt.filter(SequencesKt.flatMapIterable(SequencesKt.filter(CollectionsKt.asSequence((Iterable)city.getCiv().getGameInfo().getCivilizations()), arg_0 -> CityFounder.triggerCitiesSettledNearOtherCiv$lambda$0(city, arg_0)), CityFounder::triggerCitiesSettledNearOtherCiv$lambda$1), arg_0 -> CityFounder.triggerCitiesSettledNearOtherCiv$lambda$2(city, arg_0));
        Sequence<Civilization> civsWithCloseCities = SequencesKt.filter(SequencesKt.distinct(SequencesKt.map(citiesWithin6Tiles, CityFounder::triggerCitiesSettledNearOtherCiv$lambda$3)), arg_0 -> CityFounder.triggerCitiesSettledNearOtherCiv$lambda$4(city, arg_0));
        Iterator<Civilization> iterator2 = civsWithCloseCities.iterator();
        while (iterator2.hasNext()) {
            Civilization otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(city.getCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setFlag(DiplomacyFlags.SettledCitiesNearUs, 30);
        }
    }

    private static final boolean foundCity$lambda$0(Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        return civ.isAlive();
    }

    private static final Sequence generateNewCityName$lambda$0(Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)civilization.getCities()), CityFounder::generateNewCityName$lambda$0$0);
    }

    private static final String generateNewCityName$lambda$0$0(City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return city.getName();
    }

    private static final String generateNewCityName$lambda$1(String $repeatedPredix, String $suffix, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $repeatedPredix + it + $suffix;
    }

    private static final boolean borrowCityName$lambda$0(Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        return civ.isMajorCiv();
    }

    private static final Nation borrowCityName$lambda$1(Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        return civ.getNation();
    }

    private static final boolean borrowCityName$lambda$2(Civilization $foundingCiv, Nation nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return !Intrinsics.areEqual(nation, $foundingCiv.getNation());
    }

    private static final String borrowCityName$lambda$3(Set $usedCityNames, Nation nation) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(nation, "nation");
            List $this$lastOrNull$iv = nation.getCities();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                String city = (String)element$iv;
                boolean bl = false;
                if (!(!$usedCityNames.contains(city))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean borrowCityName$lambda$4(Sequence $aliveMajorNations, Nation nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return nation.isMajorCiv() && !SequencesKt.contains($aliveMajorNations, nation);
    }

    private static final Sequence borrowCityName$lambda$5(Set $usedCityNames, Nation nation) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)nation.getCities()), arg_0 -> CityFounder.borrowCityName$lambda$5$0($usedCityNames, arg_0));
    }

    private static final boolean borrowCityName$lambda$5$0(Set $usedCityNames, String city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return !$usedCityNames.contains(city);
    }

    private static final boolean triggerCitiesSettledNearOtherCiv$lambda$0(City $city, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv() && !Intrinsics.areEqual(it, $city.getCiv());
    }

    private static final Iterable triggerCitiesSettledNearOtherCiv$lambda$1(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCities();
    }

    private static final boolean triggerCitiesSettledNearOtherCiv$lambda$2(City $city, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().aerialDistanceTo($city.getCenterTile()) <= 6;
    }

    private static final Civilization triggerCitiesSettledNearOtherCiv$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCiv();
    }

    private static final boolean triggerCitiesSettledNearOtherCiv$lambda$4(City $city, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.knows($city.getCiv()) && it.hasExplored($city.getCenterTile());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/city/managers/CityFounder$NamingConstants;", "", "<init>", "()V", "prefixes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getPrefixes", "()Ljava/util/ArrayList;", "fallback", "core"})
    private static final class NamingConstants {
        @NotNull
        public static final NamingConstants INSTANCE = new NamingConstants();
        @NotNull
        private static final ArrayList<String> prefixes;
        @NotNull
        public static final String fallback = "City Without A Name";

        private NamingConstants() {
        }

        @NotNull
        public final ArrayList<String> getPrefixes() {
            return prefixes;
        }

        static {
            String[] stringArray = new String[]{"New", "Neo", "Nova", "Altera"};
            prefixes = CollectionsKt.arrayListOf(stringArray);
        }
    }
}

