/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020#J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007J\b\u0010+\u001a\u00020#H\u0002J \u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u00122\b\b\u0002\u0010/\u001a\u00020\u001dJ\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\fJ\u000e\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0012J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\fH\u0002J\u0012\u00106\u001a\u00020#2\b\b\u0002\u00107\u001a\u00020\u001dH\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007J\u0010\u00109\u001a\u00020\u00122\u0006\u00101\u001a\u00020\fH\u0007J\b\u0010:\u001a\u00020\u0012H\u0007J\u0010\u0010;\u001a\u00020\u00122\u0006\u00101\u001a\u00020\fH\u0007J\u0006\u0010<\u001a\u00020#J\n\u0010=\u001a\u0004\u0018\u00010\fH\u0007J\n\u0010>\u001a\u0004\u0018\u00010?H\u0007J\b\u0010@\u001a\u00020#H\u0002J\b\u0010A\u001a\u00020\u0012H\u0003J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007J\u0014\u0010C\u001a\u00020\u001d2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010E\u001a\u00020\u00122\u0006\u0010F\u001a\u00020\u0005H\u0003J\u0012\u0010G\u001a\u00020\u00122\b\u0010H\u001a\u0004\u0018\u00010\fH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006I"}, d2={"Lcom/unciv/logic/city/managers/CityReligionManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "setCity", "(Lcom/unciv/logic/city/City;)V", "religionsAtSomePointAdopted", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "pressures", "Lcom/unciv/models/Counter;", "followers", "pressureFromAdjacentCities", "", "getPressureFromAdjacentCities", "()I", "pressureFromAdjacentCities$delegate", "Lkotlin/Lazy;", "religionThisIsTheHolyCityOf", "getReligionThisIsTheHolyCityOf", "()Ljava/lang/String;", "setReligionThisIsTheHolyCityOf", "(Ljava/lang/String;)V", "isBlockedHolyCity", "", "()Z", "setBlockedHolyCity", "(Z)V", "clone", "setTransients", "", "endTurn", "getUniques", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "getPressures", "clearAllPressures", "addPressure", "religionName", "amount", "shouldUpdateFollowers", "removeAllPressuresExceptFor", "religion", "updatePressureOnPopulationChange", "populationChangeAmount", "triggerReligionAdoption", "newMajorityReligion", "updateNumberOfFollowers", "checkForReligionAdoption", "getNumberOfFollowers", "getFollowersOf", "getFollowersOfMajorityReligion", "getFollowersOfOtherReligionsThan", "removeUnknownPantheons", "getMajorityReligionName", "getMajorityReligion", "Lcom/unciv/models/Religion;", "getAffectedBySurroundingCities", "getSpreadRange", "getPressuresFromSurroundingCities", "isProtectedByInquisitor", "fromReligion", "pressureAmountToAdjacentCities", "pressuredCity", "getPressureDeficit", "otherReligion", "core"})
@SourceDebugExtension(value={"SMAP\nCityReligionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityReligionManager.kt\ncom/unciv/logic/city/managers/CityReligionManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,341:1\n2322#2,7:342\n1#3:349\n561#4:350\n546#4,6:351\n*S KotlinDebug\n*F\n+ 1 CityReligionManager.kt\ncom/unciv/logic/city/managers/CityReligionManager\n*L\n120#1:342,7\n201#1:350\n201#1:351,6\n*E\n"})
public final class CityReligionManager
implements IsPartOfGameInfoSerialization {
    public transient City city;
    @NotNull
    private final HashSet<String> religionsAtSomePointAdopted = new HashSet();
    @NotNull
    private final Counter<String> pressures = new Counter(null, 1, null);
    @NotNull
    private final transient Counter<String> followers = new Counter(null, 1, null);
    @NotNull
    private final transient Lazy pressureFromAdjacentCities$delegate = LazyKt.lazy(() -> CityReligionManager.pressureFromAdjacentCities_delegate$lambda$0(this));
    @Nullable
    private String religionThisIsTheHolyCityOf;
    private boolean isBlockedHolyCity;

    public CityReligionManager() {
        this.clearAllPressures();
    }

    @NotNull
    public final City getCity() {
        City city = this.city;
        if (city != null) {
            return city;
        }
        Intrinsics.throwUninitializedPropertyAccessException("city");
        return null;
    }

    public final void setCity(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "<set-?>");
        this.city = city;
    }

    private final int getPressureFromAdjacentCities() {
        Lazy lazy = this.pressureFromAdjacentCities$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Nullable
    public final String getReligionThisIsTheHolyCityOf() {
        return this.religionThisIsTheHolyCityOf;
    }

    public final void setReligionThisIsTheHolyCityOf(@Nullable String string) {
        this.religionThisIsTheHolyCityOf = string;
    }

    public final boolean isBlockedHolyCity() {
        return this.isBlockedHolyCity;
    }

    public final void setBlockedHolyCity(boolean bl) {
        this.isBlockedHolyCity = bl;
    }

    @NotNull
    public final CityReligionManager clone() {
        CityReligionManager toReturn = new CityReligionManager();
        toReturn.setCity(this.getCity());
        toReturn.religionsAtSomePointAdopted.addAll((Collection<String>)this.religionsAtSomePointAdopted);
        toReturn.pressures.putAll((Map)this.pressures);
        toReturn.followers.putAll((Map)this.followers);
        toReturn.religionThisIsTheHolyCityOf = this.religionThisIsTheHolyCityOf;
        toReturn.isBlockedHolyCity = this.isBlockedHolyCity;
        return toReturn;
    }

    public final void setTransients(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this.setCity(city);
        this.updateNumberOfFollowers(false);
    }

    public final void endTurn() {
        this.getAffectedBySurroundingCities();
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> getUniques(@NotNull UniqueType uniqueType) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Religion religion = this.getMajorityReligion();
        if (religion == null) {
            return SequencesKt.emptySequence();
        }
        Religion majorityReligion = religion;
        return majorityReligion.getFollowerBeliefUniqueMap().getUniques(uniqueType);
    }

    @Readonly
    @NotNull
    public final Counter<String> getPressures() {
        return this.pressures.clone();
    }

    private final void clearAllPressures() {
        this.pressures.clear();
        this.pressures.add("The religion of TheLegend27", 100);
    }

    public final void addPressure(@NotNull String religionName, int amount, boolean shouldUpdateFollowers) {
        Intrinsics.checkNotNullParameter(religionName, "religionName");
        if (!this.getCity().getCiv().getGameInfo().isReligionEnabled()) {
            return;
        }
        this.pressures.add(religionName, amount);
        if (shouldUpdateFollowers) {
            CityReligionManager.updateNumberOfFollowers$default(this, false, 1, null);
        }
    }

    public static /* synthetic */ void addPressure$default(CityReligionManager cityReligionManager, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        cityReligionManager.addPressure(string, n, bl);
    }

    public final void removeAllPressuresExceptFor(@NotNull String religion) {
        Intrinsics.checkNotNullParameter(religion, "religion");
        int pressureFromThisReligion = ((Number)this.pressures.get(religion)).intValue();
        int pressureFromAtheism = ((Number)this.pressures.get("The religion of TheLegend27")).intValue();
        this.clearAllPressures();
        this.pressures.add(religion, pressureFromThisReligion);
        if (pressureFromAtheism != 0) {
            ((Map)this.pressures).put("The religion of TheLegend27", pressureFromAtheism);
        }
        CityReligionManager.updateNumberOfFollowers$default(this, false, 1, null);
    }

    public final void updatePressureOnPopulationChange(int populationChangeAmount) {
        String majorityReligion;
        String string;
        if (this.getMajorityReligionName() != null) {
            String string2 = this.getMajorityReligionName();
            string = string2;
            Intrinsics.checkNotNull(string2);
        } else {
            string = majorityReligion = "The religion of TheLegend27";
        }
        if (populationChangeAmount > 0) {
            CityReligionManager.addPressure$default(this, majorityReligion, 100 * populationChangeAmount, false, 4, null);
        } else {
            CityReligionManager.updateNumberOfFollowers$default(this, false, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerReligionAdoption(String newMajorityReligion) {
        Religion religion = this.getCity().getCiv().getGameInfo().getReligions().get(newMajorityReligion);
        Intrinsics.checkNotNull(religion);
        Religion newMajorityReligionObject = religion;
        String[] stringArray = new String[]{"StatIcons/Faith"};
        this.getCity().getCiv().addNotification("Your city [" + this.getCity().getName() + "] was converted to [" + newMajorityReligionObject.getReligionDisplayName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Religion, stringArray);
        if (this.religionsAtSomePointAdopted.contains(newMajorityReligion)) {
            return;
        }
        Civilization religionOwningCiv = newMajorityReligionObject.getFounder();
        if (Civilization.hasUnique$default(religionOwningCiv, UniqueType.StatsWhenAdoptingReligion, null, 2, null)) {
            void $this$reduce$iv;
            String[] stringArray2 = SequencesKt.map(Civilization.getMatchingUniques$default(religionOwningCiv, UniqueType.StatsWhenAdoptingReligion, null, 2, null), arg_0 -> CityReligionManager.triggerReligionAdoption$lambda$0(this, arg_0));
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void stats;
                Stats stats2 = (Stats)iterator$iv.next();
                Stats acc = (Stats)accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.plus((Stats)stats);
            }
            Stats statsGranted = (Stats)accumulator$iv;
            for (Stats.StatValuePair statValuePair : statsGranted) {
                Stat key = statValuePair.component1();
                float value = statValuePair.component2();
                religionOwningCiv.addStat(key, (int)value);
            }
            if (religionOwningCiv.hasExplored(this.getCity().getCenterTile())) {
                stringArray2 = new String[]{"StatIcons/Faith"};
                religionOwningCiv.addNotification("You gained [" + statsGranted + "] as your religion was spread to [" + this.getCity().getName() + ']', this.getCity().getLocation(), Notification.NotificationCategory.Religion, stringArray2);
            } else {
                stringArray2 = new String[]{"StatIcons/Faith"};
                religionOwningCiv.addNotification("You gained [" + statsGranted + "] as your religion was spread to an unknown city", Notification.NotificationCategory.Religion, stringArray2);
            }
        }
        this.religionsAtSomePointAdopted.add(newMajorityReligion);
    }

    private final void updateNumberOfFollowers(boolean checkForReligionAdoption) {
        String oldMajorityReligion = checkForReligionAdoption ? this.getMajorityReligionName() : null;
        Object previousFollowers = this.followers.clone();
        this.followers.clear();
        if (this.getCity().getPopulation().getPopulation() <= 0) {
            return;
        }
        HashMap remainders = new HashMap();
        Collection<Integer> collection = this.pressures.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        int pressurePerFollower = CollectionsKt.sumOfInt((Iterable<Integer>)collection) / this.getCity().getPopulation().getPopulation();
        for (Map.Entry entry : ((Map)this.pressures).entrySet()) {
            String religion = (String)entry.getKey();
            int pressure = ((Number)entry.getValue()).intValue();
            int followersOfThisReligion = (int)((float)pressure / (float)pressurePerFollower);
            this.followers.add(religion, followersOfThisReligion);
            ((Map)remainders).put(religion, Float.valueOf((float)pressure - (float)(followersOfThisReligion * pressurePerFollower)));
        }
        int n = this.getCity().getPopulation().getPopulation();
        Intrinsics.checkNotNullExpressionValue(this.followers.values(), "<get-values>(...)");
        for (int unallocatedPopulation = (v191212) - CollectionsKt.sumOfInt((Iterable<Integer>)(v191215)); unallocatedPopulation > 0; --unallocatedPopulation) {
            Object v2;
            Iterable iterable = ((Map)remainders).entrySet();
            Iterator iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                v2 = null;
            } else {
                Object t = iterator2.next();
                if (!iterator2.hasNext()) {
                    v2 = t;
                } else {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    float f = ((Number)it.getValue()).floatValue();
                    do {
                        Object t2 = iterator2.next();
                        Map.Entry it2 = (Map.Entry)t2;
                        $i$a$-maxByOrNull-CityReligionManager$updateNumberOfFollowers$largestRemainder$1 = false;
                        float f2 = ((Number)it2.getValue()).floatValue();
                        if (Float.compare(f, f2) >= 0) continue;
                        t = t2;
                        f = f2;
                    } while (iterator2.hasNext());
                    v2 = t;
                }
            }
            Map.Entry largestRemainder = v2;
            if (largestRemainder == null) {
                this.followers.add("The religion of TheLegend27", unallocatedPopulation);
                break;
            }
            this.followers.add((String)largestRemainder.getKey(), 1);
            ((Map)remainders).put(largestRemainder.getKey(), Float.valueOf(0.0f));
        }
        this.followers.remove("The religion of TheLegend27");
        if (checkForReligionAdoption) {
            String newMajorityReligion = this.getMajorityReligionName();
            if (!Intrinsics.areEqual(oldMajorityReligion, newMajorityReligion) && newMajorityReligion != null) {
                this.triggerReligionAdoption(newMajorityReligion);
            }
            if (!Intrinsics.areEqual(oldMajorityReligion, newMajorityReligion)) {
                this.getCity().getCiv().getCache().updateCivResources();
            }
            if (!Intrinsics.areEqual(this.followers, previousFollowers)) {
                CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
            }
        }
    }

    static /* synthetic */ void updateNumberOfFollowers$default(CityReligionManager cityReligionManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        cityReligionManager.updateNumberOfFollowers(bl);
    }

    @Readonly
    @NotNull
    public final Counter<String> getNumberOfFollowers() {
        return this.followers.clone();
    }

    @Readonly
    public final int getFollowersOf(@NotNull String religion) {
        Intrinsics.checkNotNullParameter(religion, "religion");
        return ((Number)this.followers.get(religion)).intValue();
    }

    @Readonly
    public final int getFollowersOfMajorityReligion() {
        String string = this.getMajorityReligionName();
        if (string == null) {
            return 0;
        }
        String majorityReligion = string;
        return ((Number)this.followers.get(majorityReligion)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int getFollowersOfOtherReligionsThan(@NotNull String religion) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(religion, "religion");
        Map $this$filterNot$iv = this.followers;
        boolean $i$f$filterNot = false;
        Map map2 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (Intrinsics.areEqual(it.getKey(), religion)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.sumOfInt(destination$iv$iv.values());
    }

    public final void removeUnknownPantheons() {
        Set<String> set = this.pressures.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        for (String pressure : CollectionsKt.toList((Iterable)set)) {
            Religion correspondingReligion;
            if (Intrinsics.areEqual(pressure, "The religion of TheLegend27")) continue;
            Intrinsics.checkNotNull(this.getCity().getCiv().getGameInfo().getReligions().get(pressure));
            if (!correspondingReligion.isPantheon() || Intrinsics.areEqual(correspondingReligion.getFoundingCivName(), this.getCity().getCiv().getCivName())) continue;
            this.pressures.remove(pressure);
        }
        CityReligionManager.updateNumberOfFollowers$default(this, false, 1, null);
    }

    @Readonly
    @Nullable
    public final String getMajorityReligionName() {
        Object v0;
        if (this.followers.isEmpty()) {
            return null;
        }
        Iterable iterable = ((Map)this.followers).entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-CityReligionManager$getMajorityReligionName$religionWithMaxPressure$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        Intrinsics.checkNotNull(entry);
        String religionWithMaxPressure = (String)entry.getKey();
        return Intrinsics.areEqual(religionWithMaxPressure, "The religion of TheLegend27") ? null : (((Number)this.followers.get(religionWithMaxPressure)).intValue() >= this.getCity().getPopulation().getPopulation() / 2 ? religionWithMaxPressure : null);
    }

    @Readonly
    @Nullable
    public final Religion getMajorityReligion() {
        String string = this.getMajorityReligionName();
        if (string == null) {
            return null;
        }
        String majorityReligionName = string;
        return this.getCity().getCiv().getGameInfo().getReligions().get(majorityReligionName);
    }

    private final void getAffectedBySurroundingCities() {
        if (!this.getCity().getCiv().getGameInfo().isReligionEnabled()) {
            return;
        }
        if (this.getCity().isHolyCity()) {
            String string = this.religionThisIsTheHolyCityOf;
            Intrinsics.checkNotNull(string);
            this.addPressure(string, 5 * this.getPressureFromAdjacentCities(), false);
        }
        Iterator<City> iterator2 = this.getCity().getCiv().getGameInfo().getCities().iterator();
        while (iterator2.hasNext()) {
            String majorityReligionOfCity;
            City otherCity = iterator2.next();
            if (Intrinsics.areEqual(otherCity, this.getCity()) || otherCity.getReligion().getMajorityReligionName() == null) continue;
            Religion religion = this.getCity().getCiv().getGameInfo().getReligions().get(majorityReligionOfCity);
            Intrinsics.checkNotNull(religion);
            if (!religion.isMajorReligion() || otherCity.getCenterTile().aerialDistanceTo(this.getCity().getCenterTile()) > otherCity.getReligion().getSpreadRange()) continue;
            this.addPressure(majorityReligionOfCity, otherCity.getReligion().pressureAmountToAdjacentCities(this.getCity()), false);
        }
        CityReligionManager.updateNumberOfFollowers$default(this, false, 1, null);
    }

    @Readonly
    private final int getSpreadRange() {
        int spreadRange = 10;
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.ReligionSpreadDistance, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            spreadRange += Integer.parseInt(unique.getParams().get(0));
        }
        Religion majorityReligion = this.getMajorityReligion();
        if (majorityReligion != null) {
            Iterator iterator3 = Civilization.getMatchingUniques$default(majorityReligion.getFounder(), UniqueType.ReligionSpreadDistance, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                spreadRange += Integer.parseInt(unique.getParams().get(0));
            }
        }
        return spreadRange;
    }

    @Readonly
    @NotNull
    public final Counter<String> getPressuresFromSurroundingCities() {
        Counter<String> addedPressure = new Counter<String>(null, 1, null);
        if (this.getCity().isHolyCity()) {
            Map map2 = addedPressure;
            String string = this.religionThisIsTheHolyCityOf;
            Intrinsics.checkNotNull(string);
            map2.put(string, 5 * this.getPressureFromAdjacentCities());
        }
        Sequence<City> allCitiesWithin10Tiles = SequencesKt.filter(this.getCity().getCiv().getGameInfo().getCities(), arg_0 -> CityReligionManager.getPressuresFromSurroundingCities$lambda$0(this, arg_0));
        Iterator<City> iterator2 = allCitiesWithin10Tiles.iterator();
        while (iterator2.hasNext()) {
            Religion majorityReligionOfCity;
            City city = iterator2.next();
            if (city.getReligion().getMajorityReligion() == null || !majorityReligionOfCity.isMajorReligion()) continue;
            addedPressure.add(majorityReligionOfCity.getName(), city.getReligion().pressureAmountToAdjacentCities(this.getCity()));
        }
        return addedPressure;
    }

    @Readonly
    public final boolean isProtectedByInquisitor(@Nullable String fromReligion) {
        Iterator<Tile> iterator2 = this.getCity().getCenterTile().getTilesInDistance(1).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            MapUnit[] mapUnitArray = new MapUnit[]{tile.getCivilianUnit(), tile.getMilitaryUnit()};
            Iterator<MapUnit> iterator3 = CollectionsKt.listOf(mapUnitArray).iterator();
            while (iterator3.hasNext()) {
                MapUnit unit;
                MapUnit mapUnit = unit = iterator3.next();
                if ((mapUnit != null ? mapUnit.getReligion() : null) == null || fromReligion != null && Intrinsics.areEqual(unit.getReligion(), fromReligion) || !MapUnit.hasUnique$default(unit, UniqueType.PreventSpreadingReligion, null, false, 6, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean isProtectedByInquisitor$default(CityReligionManager cityReligionManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return cityReligionManager.isProtectedByInquisitor(string);
    }

    @Readonly
    private final int pressureAmountToAdjacentCities(City pressuredCity) {
        float pressure = this.getPressureFromAdjacentCities();
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.NaturalReligionSpreadStrength, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(pressuredCity, unique.getParams().get(1), null, false, 6, null)) continue;
            pressure *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        Religion majorityReligion = this.getMajorityReligion();
        if (majorityReligion != null) {
            Iterator iterator3 = Civilization.getMatchingUniques$default(majorityReligion.getFounder(), UniqueType.NaturalReligionSpreadStrength, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                if (!City.matchesFilter$default(pressuredCity, unique.getParams().get(1), null, false, 6, null)) continue;
                pressure *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
            }
        }
        return (int)pressure;
    }

    @Readonly
    public final int getPressureDeficit(@Nullable String otherReligion) {
        Counter<String> pressures = this.getPressures();
        Integer n = (Integer)((Map)pressures).get(this.getMajorityReligionName());
        Integer n2 = (Integer)((Map)pressures).get(otherReligion);
        return (n != null ? n : 0) - (n2 != null ? n2 : 0);
    }

    private static final int pressureFromAdjacentCities_delegate$lambda$0(CityReligionManager this$0) {
        return this$0.getCity().getCiv().getGameInfo().getSpeed().getReligiousPressureAdjacentCity();
    }

    private static final Stats triggerReligionAdoption$lambda$0(CityReligionManager this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getStats().times(!it.isModifiedByGameSpeed() ? 1.0f : this$0.getCity().getCiv().getGameInfo().getSpeed().getModifier());
    }

    private static final boolean getPressuresFromSurroundingCities$lambda$0(CityReligionManager this$0, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, this$0.getCity()) && it.getCenterTile().aerialDistanceTo(this$0.getCity().getCenterTile()) <= it.getReligion().getSpreadRange();
    }
}

