/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.transients;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.transients.CapitalConnectionsFinder;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020(J\u0012\u0010+\u001a\u00020(2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-J\b\u0010.\u001a\u00020(H\u0002J\u0006\u00106\u001a\u00020(J\b\u00107\u001a\u00020(H\u0002J\b\u00108\u001a\u00020(H\u0002J\u0006\u00109\u001a\u00020(J\u0006\u0010:\u001a\u00020(J\u0010\u0010;\u001a\u00020(2\b\b\u0002\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020(J\u001a\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00032\n\b\u0002\u0010B\u001a\u0004\u0018\u00010@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0013j\b\u0012\u0004\u0012\u00020\u0019`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0013j\b\u0012\u0004\u0012\u00020\u001c`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R,\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R \u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006C"}, d2={"Lcom/unciv/logic/civilization/transients/CivInfoTransientCache;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "lastEraResourceUsedForBuilding", "Ljava/util/HashMap;", "", "", "getLastEraResourceUsedForBuilding", "()Ljava/util/HashMap;", "setLastEraResourceUsedForBuilding", "(Ljava/util/HashMap;)V", "lastEraResourceUsedForUnit", "getLastEraResourceUsedForUnit", "uniqueUnits", "Ljava/util/HashSet;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "Lkotlin/collections/HashSet;", "getUniqueUnits", "()Ljava/util/HashSet;", "uniqueImprovements", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getUniqueImprovements", "uniqueBuildings", "Lcom/unciv/models/ruleset/Building;", "getUniqueBuildings", "citiesConnectedToCapitalToMediums", "", "Lcom/unciv/logic/city/City;", "Ljava/util/EnumSet;", "Lcom/unciv/logic/civilization/transients/CapitalConnectionsFinder$CapitalConnectionMedium;", "getCitiesConnectedToCapitalToMediums", "()Ljava/util/Map;", "setCitiesConnectedToCapitalToMediums", "(Ljava/util/Map;)V", "updateState", "", "setTransients", "updateSightAndResources", "updateViewableTiles", "explorerPosition", "Lcom/badlogic/gdx/math/Vector2;", "updateViewableInvisibleTiles", "ourTilesAndNeighboringTiles", "", "Lcom/unciv/logic/map/tile/Tile;", "getOurTilesAndNeighboringTiles", "()Ljava/util/Set;", "setOurTilesAndNeighboringTiles", "(Ljava/util/Set;)V", "updateOurTiles", "setNewViewableTiles", "updateLastSeenImprovements", "discoverNaturalWonders", "updateHasActiveEnemyMovementPenalty", "updateCitiesConnectedToCapital", "initialSetup", "", "updateCivResources", "updateProximity", "Lcom/unciv/logic/civilization/Proximity;", "otherCiv", "preCalculated", "core"})
@SourceDebugExtension(value={"SMAP\nCivInfoTransientCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivInfoTransientCache.kt\ncom/unciv/logic/civilization/transients/CivInfoTransientCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,449:1\n774#2:450\n865#2,2:451\n1285#2,2:453\n1299#2,4:455\n774#2:459\n865#2,2:460\n1285#2,2:462\n1299#2,4:464\n1761#2,3:493\n774#2:496\n865#2,2:497\n1374#2:499\n1460#2,5:500\n865#2,2:505\n536#3:468\n521#3,6:469\n536#3:479\n521#3,6:480\n126#4:475\n153#4,3:476\n126#4:486\n153#4,3:487\n1#5:490\n1321#6,2:491\n*S KotlinDebug\n*F\n+ 1 CivInfoTransientCache.kt\ncom/unciv/logic/civilization/transients/CivInfoTransientCache\n*L\n57#1:450\n57#1:451,2\n58#1:453,2\n58#1:455,4\n61#1:459\n61#1:460,2\n62#1:462,2\n62#1:464,4\n158#1:493,3\n241#1:496\n241#1:497,2\n242#1:499\n242#1:500,5\n292#1:505,2\n65#1:468\n65#1:469,6\n66#1:479\n66#1:480,6\n65#1:475\n65#1:476,3\n66#1:486\n66#1:487,3\n113#1:491,2\n*E\n"})
public final class CivInfoTransientCache {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private transient HashMap<String, Integer> lastEraResourceUsedForBuilding;
    @NotNull
    private final transient HashMap<String, Integer> lastEraResourceUsedForUnit;
    @NotNull
    private final transient HashSet<BaseUnit> uniqueUnits;
    @NotNull
    private final transient HashSet<TileImprovement> uniqueImprovements;
    @NotNull
    private final transient HashSet<Building> uniqueBuildings;
    @NotNull
    private transient Map<City, ? extends EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> citiesConnectedToCapitalToMediums;
    @NotNull
    private Set<Tile> ourTilesAndNeighboringTiles;

    public CivInfoTransientCache(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.lastEraResourceUsedForBuilding = new HashMap();
        this.lastEraResourceUsedForUnit = new HashMap();
        this.uniqueUnits = new HashSet();
        this.uniqueImprovements = new HashSet();
        this.uniqueBuildings = new HashSet();
        this.citiesConnectedToCapitalToMediums = MapsKt.emptyMap();
        this.ourTilesAndNeighboringTiles = new HashSet();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @NotNull
    public final HashMap<String, Integer> getLastEraResourceUsedForBuilding() {
        return this.lastEraResourceUsedForBuilding;
    }

    public final void setLastEraResourceUsedForBuilding(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.lastEraResourceUsedForBuilding = hashMap;
    }

    @NotNull
    public final HashMap<String, Integer> getLastEraResourceUsedForUnit() {
        return this.lastEraResourceUsedForUnit;
    }

    @NotNull
    public final HashSet<BaseUnit> getUniqueUnits() {
        return this.uniqueUnits;
    }

    @NotNull
    public final HashSet<TileImprovement> getUniqueImprovements() {
        return this.uniqueImprovements;
    }

    @NotNull
    public final HashSet<Building> getUniqueBuildings() {
        return this.uniqueBuildings;
    }

    @NotNull
    public final Map<City, EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> getCitiesConnectedToCapitalToMediums() {
        return this.citiesConnectedToCapitalToMediums;
    }

    public final void setCitiesConnectedToCapitalToMediums(@NotNull Map<City, ? extends EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.citiesConnectedToCapitalToMediums = map2;
    }

    public final void updateState() {
        this.civInfo.setState(new GameContext(this.civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<String> set;
        Object object;
        Object e;
        void $this$associateWithTo$iv$iv2;
        void $this$associateWith$iv2;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Ruleset ruleset = this.civInfo.getGameInfo().getRuleset();
        GameContext state = this.civInfo.getState();
        Collection<Building> collection = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Building it = (Building)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!Intrinsics.areEqual(this.civInfo.getEquivalentBuilding(it), it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$associateWith232 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv2, 10)), 16));
        destination$iv$iv = $this$associateWith$iv2;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void it;
            Building bl = (Building)element$iv$iv;
            e = element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            set = it.requiredResources(state);
            object.put(e, set);
        }
        Map buildingsToRequiredResources = destination$iv$iv2;
        Collection<BaseUnit> collection2 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $i$f$associateWith232 = collection2;
        boolean $i$f$filter2 = false;
        $this$associateWithTo$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaseUnit it = (BaseUnit)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!Intrinsics.areEqual(this.civInfo.getEquivalentUnit(it), it)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        destination$iv$iv3 = $this$associateWith$iv;
        Map destination$iv$iv32 = result$iv2;
        boolean $i$f$associateWithTo222 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it2;
            BaseUnit bl = (BaseUnit)element$iv$iv;
            e = element$iv$iv;
            object = destination$iv$iv32;
            boolean bl3 = false;
            set = it2.requiredResources(state);
            object.put(e, set);
        }
        Map unitsToRequiredResources = destination$iv$iv32;
        Collection<TileResource> collection3 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Iterator<Object> iterator2 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection3), CivInfoTransientCache::setTransients$lambda$4), CivInfoTransientCache::setTransients$lambda$5).iterator();
        while (iterator2.hasNext()) {
            Comparable comparable;
            Object object2;
            Object object3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            void $this$filterTo$iv$iv3;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            boolean bl2;
            Map.Entry it;
            void $this$filterTo$iv$iv4;
            String resource = iterator2.next();
            Map $this$filter$iv3 = buildingsToRequiredResources;
            boolean $i$f$filter3 = false;
            Map $i$f$associateWithTo222 = $this$filter$iv3;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$filterTo3 = false;
            Iterator it2 = $this$filterTo$iv$iv4.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = it2.next();
                bl2 = false;
                if (!((Set)it.getValue()).contains(resource)) continue;
                destination$iv$iv4.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv3 = destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv4 = $this$map$iv2;
            Object destination$iv$iv5 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
                it = item$iv$iv;
                object = destination$iv$iv5;
                bl2 = false;
                object.add((Building)it.getKey());
            }
            List applicableBuildings = (List)destination$iv$iv5;
            Map $this$filter$iv4 = unitsToRequiredResources;
            boolean $i$f$filter4 = false;
            destination$iv$iv5 = $this$filter$iv4;
            Map destination$iv$iv52 = new LinkedHashMap();
            boolean $i$f$filterTo4 = false;
            Iterator item$iv$iv = $this$filterTo$iv$iv3.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it32 = element$iv$iv = item$iv$iv.next();
                bl = false;
                if (!((Set)it32.getValue()).contains(resource)) continue;
                destination$iv$iv52.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv4 = destination$iv$iv52;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv6 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo2 = false;
            item$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                void it3;
                Map.Entry item$iv$iv2;
                Map.Entry it32 = item$iv$iv2 = item$iv$iv.next();
                object = destination$iv$iv6;
                bl = false;
                object.add((BaseUnit)it3.getKey());
            }
            List applicableUnits = (List)destination$iv$iv6;
            Iterator iterator3 = ((Iterable)applicableBuildings).iterator();
            if (!iterator3.hasNext()) {
                object3 = null;
            } else {
                Building it4 = (Building)iterator3.next();
                boolean bl3 = false;
                Era era = it4.era(ruleset);
                object2 = era != null ? era.getEraNumber() : 0;
                while (iterator3.hasNext()) {
                    Object it5 = (Building)iterator3.next();
                    boolean bl4 = false;
                    Era era2 = ((RulesetStatsObject)it5).era(ruleset);
                    it5 = era2 != null ? era2.getEraNumber() : 0;
                    if (object2.compareTo(it5) >= 0) continue;
                    object2 = it5;
                }
                object3 = object2;
            }
            Integer lastEraForBuilding = (Integer)object3;
            object2 = ((Iterable)applicableUnits).iterator();
            if (!object2.hasNext()) {
                comparable = null;
            } else {
                BaseUnit it6 = (BaseUnit)object2.next();
                boolean bl5 = false;
                Era era = it6.era(ruleset);
                Comparable comparable2 = Integer.valueOf(era != null ? era.getEraNumber() : 0);
                while (object2.hasNext()) {
                    BaseUnit it7 = (BaseUnit)object2.next();
                    boolean bl6 = false;
                    Era era3 = it7.era(ruleset);
                    Comparable comparable3 = Integer.valueOf(era3 != null ? era3.getEraNumber() : 0);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer lastEraForUnit = (Integer)comparable;
            if (lastEraForBuilding != null) {
                ((Map)this.lastEraResourceUsedForBuilding).put(resource, lastEraForBuilding);
            }
            if (lastEraForUnit == null) continue;
            ((Map)this.lastEraResourceUsedForUnit).put(resource, lastEraForUnit);
        }
        for (Object object4 : ruleset.getBuildings().values()) {
            Intrinsics.checkNotNullExpressionValue(object4, "next(...)");
            Building building = (Building)object4;
            if (building.getUniqueTo() == null) continue;
            String string = building.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueBuildings.add(building);
        }
        for (Object object5 : ruleset.getTileImprovements().values()) {
            Intrinsics.checkNotNullExpressionValue(object5, "next(...)");
            TileImprovement improvement = (TileImprovement)object5;
            if (improvement.getUniqueTo() == null) continue;
            String string = improvement.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueImprovements.add(improvement);
        }
        for (Object object6 : ruleset.getUnits().values()) {
            Intrinsics.checkNotNullExpressionValue(object6, "next(...)");
            BaseUnit unit = (BaseUnit)object6;
            if (unit.getUniqueTo() == null) continue;
            String string = unit.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueUnits.add(unit);
        }
    }

    public final void updateSightAndResources() {
        CivInfoTransientCache.updateViewableTiles$default(this, null, 1, null);
        this.updateHasActiveEnemyMovementPenalty();
        this.updateCivResources();
    }

    public final void updateViewableTiles(@Nullable Vector2 explorerPosition) {
        this.setNewViewableTiles();
        this.updateViewableInvisibleTiles();
        this.updateLastSeenImprovements();
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)this.civInfo.getViewableTiles());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Tile tile = (Tile)element$iv;
            boolean bl = false;
            tile.setExplored(this.civInfo, true, explorerPosition);
        }
        HashMap viewedCivs = new HashMap();
        for (Tile tile : this.civInfo.getViewableTiles()) {
            Civilization tileOwner = tile.getOwner();
            if (tileOwner != null) {
                ((Map)viewedCivs).put(tileOwner, tile);
            }
            MapUnit mapUnit = tile.getFirstUnit();
            Civilization unitOwner = mapUnit != null ? mapUnit.getCiv() : null;
            if (unitOwner == null) continue;
            ((Map)viewedCivs).put(unitOwner, tile);
        }
        if (!this.civInfo.isBarbarian()) {
            for (Map.Entry entry : ((Map)viewedCivs).entrySet()) {
                String[] stringArray;
                Civilization metCiv = (Civilization)entry.getKey();
                if (Intrinsics.areEqual(metCiv, this.civInfo) || metCiv.isBarbarian() || this.civInfo.getDiplomacy().containsKey(metCiv.getCivName())) continue;
                DiplomacyFunctions.makeCivilizationsMeet$default(this.civInfo.getDiplomacyFunctions(), metCiv, false, 2, null);
                if (!this.civInfo.isSpectator()) {
                    stringArray = new String[]{metCiv.getCivName(), "OtherIcons/Diplomacy"};
                    this.civInfo.addNotification("We have encountered [" + metCiv.getCivName() + "]!", ((Tile)entry.getValue()).getPosition(), Notification.NotificationCategory.Diplomacy, stringArray);
                }
                stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
                metCiv.addNotification("We have encountered [" + this.civInfo.getCivName() + "]!", ((Tile)entry.getValue()).getPosition(), Notification.NotificationCategory.Diplomacy, stringArray);
            }
            this.discoverNaturalWonders();
        }
    }

    public static /* synthetic */ void updateViewableTiles$default(CivInfoTransientCache civInfoTransientCache, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = null;
        }
        civInfoTransientCache.updateViewableTiles(vector2);
    }

    private final void updateViewableInvisibleTiles() {
        HashSet<Tile> newViewableInvisibleTiles = new HashSet<Tile>();
        Iterator<MapUnit> iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            Iterator<Tile> iterator3;
            MapUnit unit = iterator2.next();
            Sequence invisibleUnitUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.CanSeeInvisibleUnits, null, false, 6, null);
            if (SequencesKt.none(invisibleUnitUniques)) continue;
            List<String> visibleUnitTypes = SequencesKt.toList(SequencesKt.map(invisibleUnitUniques, CivInfoTransientCache::updateViewableInvisibleTiles$lambda$0));
            Intrinsics.checkNotNullExpressionValue(unit.getViewableTiles().iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                boolean bl;
                Tile tile;
                block5: {
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    if (tile.getMilitaryUnit() == null || newViewableInvisibleTiles.contains(tile)) continue;
                    Iterable $this$any$iv = visibleUnitTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            MapUnit mapUnit = tile.getMilitaryUnit();
                            Intrinsics.checkNotNull(mapUnit);
                            if (!MapUnit.matchesFilter$default(mapUnit, it, false, 2, null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                newViewableInvisibleTiles.add(tile);
            }
        }
        this.civInfo.setViewableInvisibleUnitsTiles((Set<Tile>)newViewableInvisibleTiles);
    }

    @NotNull
    public final Set<Tile> getOurTilesAndNeighboringTiles() {
        return this.ourTilesAndNeighboringTiles;
    }

    public final void setOurTilesAndNeighboringTiles(@NotNull Set<Tile> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.ourTilesAndNeighboringTiles = set;
    }

    public final void updateOurTiles() {
        this.ourTilesAndNeighboringTiles = SequencesKt.toSet(SequencesKt.flatMap(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.civInfo.getCities()), CivInfoTransientCache::updateOurTiles$lambda$0), CivInfoTransientCache::updateOurTiles$lambda$1));
        CivInfoTransientCache.updateViewableTiles$default(this, null, 1, null);
        this.updateCivResources();
    }

    private final void setNewViewableTiles() {
        if (this.civInfo.isDefeated()) {
            this.civInfo.setViewableTiles(SetsKt.emptySet());
            return;
        }
        if (this.civInfo.isSpectator() || DebugUtils.INSTANCE.getVISIBLE_MAP()) {
            Set<Tile> allTiles = CollectionsKt.toSet((Iterable)this.civInfo.getGameInfo().getTileMap().getValues());
            this.civInfo.setViewableTiles(allTiles);
            this.civInfo.setViewableInvisibleUnitsTiles(allTiles);
            return;
        }
        HashSet newViewableTiles = new HashSet(this.ourTilesAndNeighboringTiles);
        CollectionsKt.addAll((Collection)newViewableTiles, SequencesKt.flatMap(this.civInfo.getUnits().getCivUnits(), arg_0 -> CivInfoTransientCache.setNewViewableTiles$lambda$0(this, arg_0)));
        Iterator<Civilization> iterator2 = this.civInfo.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            Civilization otherCiv = iterator2.next();
            if (!Intrinsics.areEqual(otherCiv.getAllyCivName(), this.civInfo.getCivName()) && !Intrinsics.areEqual(otherCiv.getCivName(), this.civInfo.getAllyCivName())) continue;
            CollectionsKt.addAll((Collection)newViewableTiles, SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)otherCiv.getCities()), CivInfoTransientCache::setNewViewableTiles$lambda$1));
        }
        CollectionsKt.addAll((Collection)newViewableTiles, this.civInfo.getEspionageManager().getTilesVisibleViaSpies());
        this.civInfo.setViewableTiles(newViewableTiles);
    }

    private final void updateLastSeenImprovements() {
        if (this.civInfo.getPlayerType() == PlayerType.AI) {
            return;
        }
        for (Tile tile : this.civInfo.getViewableTiles()) {
            this.civInfo.setLastSeenImprovement(tile.getPosition(), tile.getImprovement());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void discoverNaturalWonders() {
        HashSet newlyViewedNaturalWonders = new HashSet();
        for (Tile tile : this.civInfo.getViewableTiles()) {
            if (tile.getNaturalWonder() == null) continue;
            ArrayList<String> arrayList = this.civInfo.getNaturalWonders();
            String string = tile.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            if (arrayList.contains(string)) continue;
            ((Collection)newlyViewedNaturalWonders).add(tile);
        }
        Iterator iterator2 = newlyViewedNaturalWonders.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Tile> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            void $this$flatMapTo$iv$iv;
            Iterator $this$flatMap$iv;
            Civilization it;
            void $this$filterTo$iv$iv;
            Tile tile;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (CollectionsKt.contains((Iterable)this.civInfo.getNaturalWonders(), tile.getNaturalWonder())) continue;
            ArrayList<String> arrayList = this.civInfo.getNaturalWonders();
            String string = tile.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            arrayList.add(string);
            if (this.civInfo.isSpectator()) continue;
            String[] stringArray = new String[]{"StatIcons/Happiness"};
            this.civInfo.addNotification("We have discovered [" + tile.getNaturalWonder() + "]!", tile.getPosition(), Notification.NotificationCategory.General, stringArray);
            Stats statsGained = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            Iterable $this$filter$iv = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, this.civInfo) && it.isMajorCiv())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getNaturalWonders();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List discoveredNaturalWonders = (List)destination$iv$iv;
            if (Tile.terrainHasUnique$default(tile, UniqueType.GrantsStatsToFirstToDiscover, null, 2, null)) {
                String string2 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string2);
                if (!discoveredNaturalWonders.contains(string2)) {
                    $this$flatMap$iv = Tile.getTerrainMatchingUniques$default(tile, UniqueType.GrantsStatsToFirstToDiscover, null, 2, null).iterator();
                    while ($this$flatMap$iv.hasNext()) {
                        Unique unique = (Unique)$this$flatMap$iv.next();
                        statsGained.add(unique.getStats());
                    }
                }
            }
            $this$flatMap$iv = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.StatBonusWhenDiscoveringNaturalWonder, null, 2, null).iterator();
            while ($this$flatMap$iv.hasNext()) {
                Unique unique = (Unique)$this$flatMap$iv.next();
                Stats normalBonus = Stats.Companion.parse(unique.getParams().get(0));
                Stats firstDiscoveredBonus = Stats.Companion.parse(unique.getParams().get(1));
                String string3 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string3);
                Stats stats = discoveredNaturalWonders.contains(string3) ? statsGained.add(normalBonus) : statsGained.add(firstDiscoveredBonus);
            }
            String naturalWonder = null;
            if (!statsGained.isEmpty()) {
                String string4 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string4);
                naturalWonder = string4;
            }
            if (!statsGained.isEmpty() && naturalWonder != null) {
                this.civInfo.addStats(statsGained);
                String[] stringArray2 = new String[]{statsGained.toString()};
                this.civInfo.addNotification("We have received [" + statsGained + "] for discovering [" + naturalWonder + ']', Notification.NotificationCategory.General, stringArray2);
            }
            for (Unique unique : Civilization.getTriggeredUniques$default(this.civInfo, UniqueType.TriggerUponDiscoveringNaturalWonder, new GameContext(this.civInfo, null, null, tile, null, null, null, null, null, null, false, 2038, null), null, 4, null)) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.civInfo, null, null, tile, null, "due to discovering a Natural Wonder", 44, null);
            }
        }
    }

    public final void updateHasActiveEnemyMovementPenalty() {
        this.civInfo.setHasActiveEnemyMovementPenalty(Civilization.hasUnique$default(this.civInfo, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null));
        this.civInfo.setEnemyMovementPenaltyUniques(Civilization.getMatchingUniques$default(this.civInfo, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCitiesConnectedToCapital(boolean initialSetup) {
        String[] stringArray;
        Set set;
        if (this.civInfo.getCities().isEmpty()) {
            return;
        }
        if (initialSetup) {
            void destination$iv;
            void $this$filterTo$iv;
            Iterable iterable = this.civInfo.getCities();
            Iterator<Object> iterator2 = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!it.getConnectedToCapitalStatus()) continue;
                destination$iv.add(element$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = this.citiesConnectedToCapitalToMediums.keySet();
        }
        Set oldConnectedCities = set;
        this.citiesConnectedToCapitalToMediums = new CapitalConnectionsFinder(this.civInfo).find();
        Set<City> newConnectedCities = this.citiesConnectedToCapitalToMediums.keySet();
        for (City city : newConnectedCities) {
            if (oldConnectedCities.contains(city) || !Intrinsics.areEqual(city.getCiv(), this.civInfo) || Intrinsics.areEqual(city, Civilization.getCapital$default(this.civInfo, false, 1, null))) continue;
            stringArray = new String[]{"StatIcons/Gold"};
            this.civInfo.addNotification('[' + city.getName() + "] has been connected to your capital!", city.getLocation(), Notification.NotificationCategory.Cities, stringArray);
        }
        for (City city : oldConnectedCities) {
            if (newConnectedCities.contains(city) || !Intrinsics.areEqual(city.getCiv(), this.civInfo) || city.getPopulation().getPopulation() <= 0) continue;
            stringArray = new String[]{"StatIcons/Gold"};
            this.civInfo.addNotification('[' + city.getName() + "] has been disconnected from your capital!", city.getLocation(), Notification.NotificationCategory.Cities, stringArray);
        }
        for (City city : this.civInfo.getCities()) {
            city.setConnectedToCapitalStatus(newConnectedCities.contains(city));
        }
    }

    public static /* synthetic */ void updateCitiesConnectedToCapital$default(CivInfoTransientCache civInfoTransientCache, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        civInfoTransientCache.updateCitiesConnectedToCapital(bl);
    }

    public final void updateCivResources() {
        Iterator<Object> iterator2;
        Iterator<IsPartOfGameInfoSerialization> cityStateProvidedResources;
        ResourceSupplyList newDetailedCivResources = new ResourceSupplyList(false, 1, null);
        Map<String, Float> resourceModifers = this.civInfo.getResourceModifiers();
        for (City city : this.civInfo.getCities()) {
            newDetailedCivResources.add(city.getResourcesGeneratedByCity(resourceModifers));
        }
        if (!this.civInfo.isCityState()) {
            cityStateProvidedResources = new ResourceSupplyList(false, 1, null);
            float resourceBonusPercentage = 1.0f;
            iterator2 = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.CityStateResources, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                resourceBonusPercentage += Float.parseFloat(unique.getParams().get(0)) / (float)100;
            }
            iterator2 = SequencesKt.filter(this.civInfo.getKnownCivs(), arg_0 -> CivInfoTransientCache.updateCivResources$lambda$0(this, arg_0)).iterator();
            while (iterator2.hasNext()) {
                Iterator iterator3;
                Civilization cityStateAlly = (Civilization)iterator2.next();
                Intrinsics.checkNotNullExpressionValue(cityStateAlly.getCityStateFunctions().getCityStateResourcesForAlly().iterator(), "iterator(...)");
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)e;
                    if (resourceSupply.getResource().hasUnique(UniqueType.CannotBeTraded, cityStateAlly.getState())) continue;
                    int newAmount = (int)((float)resourceSupply.getAmount() * resourceBonusPercentage);
                    ((ResourceSupplyList)((Object)cityStateProvidedResources)).add(ResourceSupplyList.ResourceSupply.copy$default(resourceSupply, null, null, newAmount, 3, null));
                }
            }
            newDetailedCivResources.addByResource((ResourceSupplyList)((Object)cityStateProvidedResources), "City-States");
        }
        cityStateProvidedResources = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.ProvidesResources, null, 2, null).iterator();
        while (cityStateProvidedResources.hasNext()) {
            TileResource resource;
            Unique unique = (Unique)cityStateProvidedResources.next();
            if (unique.getSourceObjectType() == UniqueTarget.Building || unique.getSourceObjectType() == UniqueTarget.Wonder) continue;
            Intrinsics.checkNotNull(this.civInfo.getGameInfo().getRuleset().getTileResources().get(unique.getParams().get(1)));
            newDetailedCivResources.add(resource, unique.getSourceNameForUser(), (int)(Float.parseFloat(unique.getParams().get(0)) * this.civInfo.getResourceModifier(resource)));
        }
        cityStateProvidedResources = this.civInfo.getDiplomacy().values().iterator();
        while (cityStateProvidedResources.hasNext()) {
            DiplomacyManager diplomacyManager;
            Intrinsics.checkNotNullExpressionValue(cityStateProvidedResources.next(), "next(...)");
            newDetailedCivResources.add(diplomacyManager.resourcesFromTrade());
        }
        cityStateProvidedResources = this.civInfo.getUnits().getCivUnits().iterator();
        while (cityStateProvidedResources.hasNext()) {
            MapUnit unit = (MapUnit)cityStateProvidedResources.next();
            newDetailedCivResources.subtractResourceRequirements((HashMap<String, Integer>)unit.getResourceRequirementsPerTurn(), this.civInfo.getGameInfo().getRuleset(), "Units");
        }
        CollectionsKt.removeAll(newDetailedCivResources, CivInfoTransientCache::updateCivResources$lambda$1);
        if (Intrinsics.areEqual(this.civInfo.getDetailedCivResources(), newDetailedCivResources)) {
            return;
        }
        ResourceSupplyList summarizedResourceSupply = newDetailedCivResources.sumByResource("All");
        UniqueMap newResourceUniqueMap = new UniqueMap();
        Iterator iterator4 = summarizedResourceSupply.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            ResourceSupplyList.ResourceSupply resource = (ResourceSupplyList.ResourceSupply)object;
            if (resource.getAmount() <= 0) continue;
            newResourceUniqueMap.addUniques((Iterable<Unique>)resource.getResource().getUniqueObjects());
        }
        this.civInfo.setDetailedCivResources(newDetailedCivResources);
        this.civInfo.setSummarizedCivResourceSupply(summarizedResourceSupply);
        this.civInfo.setCivResourcesUniqueMap(newResourceUniqueMap);
        this.civInfo.updateStatsForNextTurn();
    }

    @NotNull
    public final Proximity updateProximity(@NotNull Civilization otherCiv, @Nullable Proximity preCalculated) {
        int numMajors;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            return Proximity.None;
        }
        if (preCalculated != null) {
            ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), preCalculated);
            return preCalculated;
        }
        if (this.civInfo.getCities().isEmpty() || otherCiv.getCities().isEmpty()) {
            ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), Proximity.None);
            return Proximity.None;
        }
        MapParameters mapParams = this.civInfo.getGameInfo().getTileMap().getMapParameters();
        int minDistance = 100000;
        int totalDistance = 0;
        int connections = 0;
        Proximity proximity = Proximity.None;
        for (City ourCity : this.civInfo.getCities()) {
            for (City theirCity : otherCiv.getCities()) {
                int distance = ourCity.getCenterTile().aerialDistanceTo(theirCity.getCenterTile());
                totalDistance += distance;
                ++connections;
                if (minDistance <= distance) continue;
                minDistance = distance;
            }
        }
        if (minDistance <= 7) {
            proximity = Proximity.Neighbors;
        } else if (connections > 0) {
            int averageDistance = totalDistance / connections;
            int mapFactor = Intrinsics.areEqual(mapParams.getShape(), "Rectangular") ? (mapParams.getMapSize().getHeight() + mapParams.getMapSize().getWidth()) / 2 : mapParams.getMapSize().getRadius() * 3 / 2;
            int closeDistance = RangesKt.coerceIn(mapFactor * 25 / 100, 10, 20);
            int farDistance = RangesKt.coerceIn(mapFactor * 45 / 100, 20, 50);
            Proximity proximity2 = minDistance <= 11 && averageDistance <= closeDistance ? Proximity.Close : (proximity = averageDistance <= farDistance ? Proximity.Far : Proximity.Distant);
        }
        if (connections > 0 && proximity != Proximity.Distant && !this.civInfo.getGameInfo().getTileMap().isWaterMap()) {
            City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city);
            int n = city.getCenterTile().getContinent();
            City city2 = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city2);
            if (n != city2.getCenterTile().getContinent()) {
                switch (WhenMappings.$EnumSwitchMapping$0[proximity.ordinal()]) {
                    case 1: {
                        Proximity proximity3 = Proximity.Distant;
                        break;
                    }
                    case 2: {
                        Proximity proximity3 = Proximity.Far;
                        break;
                    }
                    case 3: {
                        Proximity proximity3 = Proximity.Close;
                        break;
                    }
                    default: {
                        Proximity proximity3 = proximity = proximity;
                    }
                }
            }
        }
        if ((numMajors = this.civInfo.getGameInfo().getAliveMajorCivs().size()) <= 2 && proximity.compareTo((Enum)Proximity.Close) > 0) {
            proximity = Proximity.Close;
        }
        if (numMajors <= 4 && proximity.compareTo((Enum)Proximity.Far) > 0) {
            proximity = Proximity.Far;
        }
        ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), proximity);
        return proximity;
    }

    public static /* synthetic */ Proximity updateProximity$default(CivInfoTransientCache civInfoTransientCache, Civilization civilization, Proximity proximity, int n, Object object) {
        if ((n & 2) != 0) {
            proximity = null;
        }
        return civInfoTransientCache.updateProximity(civilization, proximity);
    }

    private static final boolean setTransients$lambda$4(TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResourceType() == ResourceType.Strategic;
    }

    private static final String setTransients$lambda$5(TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final String updateViewableInvisibleTiles$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final Sequence updateOurTiles$lambda$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTiles();
    }

    private static final Sequence updateOurTiles$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.plus(SequencesKt.sequenceOf(it), it.getNeighbors());
    }

    private static final Sequence setNewViewableTiles$lambda$0(CivInfoTransientCache this$0, MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getViewableTiles()), arg_0 -> CivInfoTransientCache.setNewViewableTiles$lambda$0$0(this$0, arg_0));
    }

    private static final boolean setNewViewableTiles$lambda$0$0(CivInfoTransientCache this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it.getOwner(), this$0.civInfo);
    }

    private static final Sequence setNewViewableTiles$lambda$1(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTiles();
    }

    private static final boolean updateCivResources$lambda$0(CivInfoTransientCache this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAllyCivName(), this$0.civInfo.getCivName());
    }

    private static final boolean updateCivResources$lambda$1(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResource().isCityWide();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proximity.values().length];
            try {
                nArray[Proximity.Far.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Close.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Neighbors.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

