/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.badlogic.gdx.math.Vector2;
import com.unciv.Constants;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapElevationGenerator;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapLandmassGenerator;
import com.unciv.logic.map.mapgenerator.NaturalWonderGenerator;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.Counter;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.screens.mapeditorscreen.MapGeneratorSteps;
import com.unciv.utils.LogKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0003QRSB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0010H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0002J\u0014\u0010+\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\u0010\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0018\u00104\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00152\u0006\u00105\u001a\u000206H\u0002J \u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020.2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020;H\u0002J0\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020>2\u0006\u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020;H\u0002J\u0010\u0010F\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0010\u0010G\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0010\u0010H\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0015H\u0002J\u001e\u0010I\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00152\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bH\u0002J,\u0010K\u001a\u00020\"2\u0006\u0010<\u001a\u00020.2\u0006\u0010L\u001a\u00020\u000b2\b\u0010M\u001a\u0004\u0018\u00010\u000b2\b\u0010N\u001a\u0004\u0018\u00010\u000bH\u0002J2\u0010O\u001a\u00020\"2\u0006\u0010<\u001a\u00020.2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\b\u0010M\u001a\u0004\u0018\u00010\u000b2\b\u0010N\u001a\u0004\u0018\u00010\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lkotlinx/coroutines/CoroutineScope;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "landTerrainName", "", "waterTerrainName", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "firstLandTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "getGenerationConditions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "generateMap", "Lcom/unciv/logic/map/TileMap;", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "civilizations", "", "Lcom/unciv/logic/civilization/Civilization;", "flipTopBottom", "Lcom/badlogic/gdx/math/Vector2;", "vector", "flipLeftRight", "mirror", "", "map", "generateSingleStep", "step", "Lcom/unciv/ui/screens/mapeditorscreen/MapGeneratorSteps;", "runAndMeasure", "text", "action", "Lkotlin/Function0;", "convertTerrains", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "spreadCoast", "spawnLakesAndCoasts", "spreadAncientRuins", "spreadResources", "tileMap", "spreadStrategicResources", "mapRadius", "", "resourceType", "Lcom/unciv/models/ruleset/tile/ResourceType;", "applyHumidityAndTemperature", "getTileRadius", "", "tile", "getTemperatureAtRadius", "", "radius", "scaleToRange", "x1", "x2", "y1", "y2", "value", "spawnVegetation", "spawnRareFeatures", "spawnIce", "spawnFlatEarthIceWalls", "iceEquivalents", "spawnFlatEarthCenterIceWall", "bestArcticTileName", "iceTerrainName", "mountainTerrainName", "spawnFlatEarthEdgeIceWall", "arcticTileNameList", "Companion", "TerrainOccursRange", "Helpers", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,838:1\n230#2,2:839\n774#2:841\n865#2,2:842\n774#2:844\n865#2,2:845\n774#2:854\n865#2:855\n1761#2,3:856\n866#2:859\n774#2:860\n865#2,2:861\n774#2:863\n865#2,2:864\n774#2:866\n865#2:867\n866#2:870\n1788#2,4:871\n827#2:875\n855#2,2:876\n774#2:878\n865#2,2:879\n774#2:881\n865#2,2:882\n827#2:884\n855#2,2:885\n774#2:887\n865#2:888\n1761#2,3:891\n866#2:894\n1788#2,4:895\n774#2:899\n865#2,2:900\n2423#2,14:902\n774#2:916\n865#2,2:917\n1387#2:919\n1475#2,5:920\n295#2,2:928\n774#2:943\n865#2,2:944\n1374#2:946\n1460#2,5:947\n774#2:952\n865#2:953\n866#2:956\n774#2:957\n865#2,2:958\n774#2:960\n865#2,2:961\n774#2:963\n865#2,2:964\n1563#2:966\n1634#2,3:967\n774#2:970\n865#2,2:971\n1563#2:973\n1634#2,3:974\n774#2:977\n865#2,2:978\n1563#2:980\n1634#2,3:981\n295#2,2:984\n1788#2,4:986\n774#2:990\n865#2,2:991\n774#2:993\n865#2,2:994\n1740#2,3:996\n536#3:847\n521#3,6:848\n2275#4,2:868\n2275#4,2:889\n1163#4,3:925\n2275#4,2:954\n11879#5,9:930\n13805#5:939\n13806#5:941\n11888#5:942\n1#6:940\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n*L\n55#1:839,2\n287#1:841\n287#1:842,2\n313#1:844\n313#1:845,2\n362#1:854\n362#1:855\n363#1:856,3\n362#1:859\n369#1:860\n369#1:861,2\n384#1:863\n384#1:864,2\n387#1:866\n387#1:867\n387#1:870\n389#1:871,4\n394#1:875\n394#1:876,2\n395#1:878\n395#1:879,2\n409#1:881\n409#1:882,2\n412#1:884\n412#1:885,2\n413#1:887\n413#1:888\n415#1:891,3\n413#1:894\n417#1:895,4\n424#1:899\n424#1:900,2\n426#1:902,14\n451#1:916\n451#1:917,2\n452#1:919\n452#1:920,5\n500#1:928,2\n578#1:943\n578#1:944,2\n579#1:946\n579#1:947,5\n587#1:952\n587#1:953\n587#1:956\n606#1:957\n606#1:958,2\n611#1:960\n611#1:961,2\n663#1:963\n663#1:964,2\n667#1:966\n667#1:967,3\n676#1:970\n676#1:971,2\n678#1:973\n678#1:974,3\n700#1:977\n700#1:978,2\n702#1:980\n702#1:981,3\n713#1:984,2\n151#1:986,4\n154#1:990\n154#1:991,2\n161#1:993\n161#1:994,2\n635#1:996,3\n354#1:847\n354#1:848,6\n388#1:868,2\n414#1:889,2\n457#1:925,3\n589#1:954,2\n577#1:930,9\n577#1:939\n577#1:941\n577#1:942\n577#1:940\n*E\n"})
public final class MapGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @Nullable
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String landTerrainName;
    @NotNull
    private final String waterTerrainName;
    @NotNull
    private MapGenerationRandomness randomness;
    @NotNull
    private final Terrain firstLandTerrain;
    private static final boolean consoleTimings = false;

    /*
     * WARNING - void declaration
     */
    public MapGenerator(@NotNull Ruleset ruleset, @Nullable CoroutineScope coroutineScope) {
        Object element$iv2;
        block3: {
            void $this$first$iv;
            String string;
            MapGenerator mapGenerator;
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            this.ruleset = ruleset;
            this.coroutineScope = coroutineScope;
            this.landTerrainName = MapLandmassGenerator.Companion.getInitializationTerrain$core(this.ruleset, TerrainType.Land);
            MapGenerator mapGenerator2 = this;
            try {
                mapGenerator = mapGenerator2;
                string = MapLandmassGenerator.Companion.getInitializationTerrain$core(this.ruleset, TerrainType.Water);
            }
            catch (Exception exception2) {
                mapGenerator = mapGenerator2;
                string = this.landTerrainName;
            }
            mapGenerator.waterTerrainName = string;
            this.randomness = new MapGenerationRandomness();
            Collection<Terrain> collection = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable iterable = collection;
            mapGenerator2 = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Terrain it = (Terrain)element$iv2;
                boolean bl = false;
                if (!(it.getType() == TerrainType.Land)) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNullExpressionValue(t, "first(...)");
        mapGenerator2.firstLandTerrain = (Terrain)t;
    }

    public /* synthetic */ MapGenerator(Ruleset ruleset, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = null;
        }
        this(ruleset, coroutineScope);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final Sequence<TerrainOccursRange> getGenerationConditions(Terrain $this$getGenerationConditions) {
        return SequencesKt.map(IHasUniques.getMatchingUniques$default($this$getGenerationConditions, UniqueType.TileGenerationConditions, null, 2, null), arg_0 -> MapGenerator.getGenerationConditions$lambda$0($this$getGenerationConditions, arg_0));
    }

    @NotNull
    public final TileMap generateMap(@NotNull MapParameters mapParameters, @NotNull GameParameters gameParameters, @NotNull List<Civilization> civilizations) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        Intrinsics.checkNotNullParameter(civilizations, "civilizations");
        MapSize mapSize = mapParameters.getMapSize();
        String mapType = mapParameters.getType();
        if (mapParameters.getSeed() == 0L) {
            mapParameters.setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(mapParameters.getSeed());
        TileMap map2 = Intrinsics.areEqual(mapParameters.getShape(), "Rectangular") ? new TileMap(mapSize.getWidth(), mapSize.getHeight(), this.ruleset, mapParameters.getWorldWrap()) : new TileMap(mapSize.getRadius(), this.ruleset, mapParameters.getWorldWrap());
        mapParameters.setCreatedWithVersion(UncivGame.Companion.getVERSION().toNiceString());
        map2.setMapParameters(mapParameters);
        if (Intrinsics.areEqual(mapType, "Empty")) {
            for (Tile tile : map2.getValues()) {
                tile.setBaseTerrain("Ocean");
                tile.setTerrainTransients();
            }
            return map2;
        }
        this.runAndMeasure("MapLandmassGenerator", () -> MapGenerator.generateMap$lambda$0(map2, this));
        this.runAndMeasure("raiseMountainsAndHills", () -> MapGenerator.generateMap$lambda$1(map2, this));
        this.runAndMeasure("applyHumidityAndTemperature", () -> MapGenerator.generateMap$lambda$2(this, map2));
        this.runAndMeasure("spawnLakesAndCoasts", () -> MapGenerator.generateMap$lambda$3(this, map2));
        this.runAndMeasure("spawnVegetation", () -> MapGenerator.generateMap$lambda$4(this, map2));
        this.runAndMeasure("spawnRareFeatures", () -> MapGenerator.generateMap$lambda$5(this, map2));
        this.runAndMeasure("spawnIce", () -> MapGenerator.generateMap$lambda$6(this, map2));
        this.runAndMeasure("assignContinents", () -> MapGenerator.generateMap$lambda$7(map2));
        this.runAndMeasure("RiverGenerator", () -> MapGenerator.generateMap$lambda$8(map2, this));
        this.convertTerrains((Iterable<Tile>)map2.getValues());
        if (!((Collection)civilizations).isEmpty()) {
            MapRegions regions = new MapRegions(this.ruleset);
            this.runAndMeasure("generateRegions", () -> MapGenerator.generateMap$lambda$9(regions, map2, civilizations, this));
            this.runAndMeasure("assignRegions", () -> MapGenerator.generateMap$lambda$10(regions, map2, civilizations, gameParameters, this));
            this.runAndMeasure("NaturalWonderGenerator", () -> MapGenerator.generateMap$lambda$11(this, map2));
            this.runAndMeasure("placeResourcesAndMinorCivs", () -> MapGenerator.generateMap$lambda$12(regions, map2, civilizations, this));
        } else {
            this.runAndMeasure("NaturalWonderGenerator", () -> MapGenerator.generateMap$lambda$13(this, map2));
            this.runAndMeasure("spreadResources", () -> MapGenerator.generateMap$lambda$14(this, map2));
        }
        this.runAndMeasure("spreadAncientRuins", () -> MapGenerator.generateMap$lambda$15(this, map2));
        this.mirror(map2);
        for (Tile tile : map2.getValues()) {
            TileNormalizer.INSTANCE.normalizeToRuleset(tile, this.ruleset);
        }
        return map2;
    }

    public static /* synthetic */ TileMap generateMap$default(MapGenerator mapGenerator, MapParameters mapParameters, GameParameters gameParameters, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            gameParameters = new GameParameters();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mapGenerator.generateMap(mapParameters, gameParameters, list2);
    }

    private final Vector2 flipTopBottom(Vector2 vector) {
        return new Vector2(-vector.y, -vector.x);
    }

    private final Vector2 flipLeftRight(Vector2 vector) {
        return new Vector2(vector.y, vector.x);
    }

    private final void mirror(TileMap map2) {
        if (Intrinsics.areEqual(map2.getMapParameters().getMirroring(), "None")) {
            return;
        }
        for (Tile tile : map2.getValues()) {
            MapGenerator.mirror$copyTile(this, map2, tile, map2.getMapParameters().getMirroring());
        }
    }

    public final void generateSingleStep(@NotNull TileMap map2, @NotNull MapGeneratorSteps step) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter((Object)step, "step");
        if (map2.getMapParameters().getSeed() == 0L) {
            map2.getMapParameters().setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(map2.getMapParameters().getSeed());
        this.runAndMeasure("SingleStep " + (Object)((Object)step), () -> MapGenerator.generateSingleStep$lambda$0(step, map2, this));
    }

    private final void runAndMeasure(String text2, Function0<Unit> action2) {
        CoroutineScope coroutineScope = this.coroutineScope;
        boolean bl = coroutineScope != null ? !CoroutineScopeKt.isActive(coroutineScope) : false;
        if (bl) {
            return;
        }
        action2.invoke();
    }

    public final void convertTerrains(@NotNull Iterable<Tile> tiles) {
        Intrinsics.checkNotNullParameter(tiles, "tiles");
        Helpers.INSTANCE.convertTerrains(this.ruleset, tiles);
    }

    /*
     * WARNING - void declaration
     */
    private final void spreadCoast(TileMap map2) {
        int i = 1;
        int n = map2.getMapParameters().getMaxCoastExtension();
        if (i <= n) {
            while (true) {
                void $this$filterTo$iv$iv;
                List toCoast = new ArrayList();
                Iterable $this$filter$iv = map2.getValues();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Tile it = (Tile)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getBaseTerrain(), "Ocean")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                block2: for (Tile tile : (List)destination$iv$iv) {
                    Sequence<Tile> tilesInDistance = tile.getTilesInDistance(1);
                    object = tilesInDistance.iterator();
                    while (object.hasNext()) {
                        Tile neighborTile = (Tile)object.next();
                        if (neighborTile.isLand()) {
                            toCoast.add(tile);
                            continue block2;
                        }
                        if (!Intrinsics.areEqual(neighborTile.getBaseTerrain(), "Coast")) continue;
                        boolean randbool = this.randomness.getRNG().nextBoolean();
                        if (!randbool) continue block2;
                        toCoast.add(tile);
                        continue block2;
                    }
                }
                for (Object e : toCoast) {
                    Tile tile;
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    tile = (Tile)e;
                    tile.setBaseTerrain("Coast");
                    tile.setTransients();
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnLakesAndCoasts(TileMap map2) {
        if (this.ruleset.getTerrains().containsKey("Lakes")) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = map2.getValues();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!it.isWater()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List waterTiles = CollectionsKt.toMutableList((List)destination$iv$iv);
            ArrayList tilesInArea = new ArrayList();
            ArrayList tilesToCheck = new ArrayList();
            int maxLakeSize = this.ruleset.getModOptions().getConstants().getMaxLakeSize();
            while (!((Collection)waterTiles).isEmpty()) {
                Tile initialWaterTile = (Tile)waterTiles.remove(0);
                ((Collection)tilesInArea).add(initialWaterTile);
                ((Collection)tilesToCheck).add(initialWaterTile);
                while (!((Collection)tilesToCheck).isEmpty()) {
                    Object e = tilesToCheck.remove(0);
                    Intrinsics.checkNotNullExpressionValue(e, "removeAt(...)");
                    Tile tileWeAreChecking = (Tile)e;
                    Iterator<Object> iterator2 = tileWeAreChecking.getNeighbors().iterator();
                    while (iterator2.hasNext()) {
                        Tile vector = (Tile)iterator2.next();
                        if (tilesInArea.contains(vector) || !waterTiles.contains(vector)) continue;
                        ((Collection)tilesInArea).add(vector);
                        ((Collection)tilesToCheck).add(vector);
                        ((Collection)waterTiles).remove(vector);
                    }
                }
                if (tilesInArea.size() <= maxLakeSize) {
                    Iterator iterator3;
                    Intrinsics.checkNotNullExpressionValue(tilesInArea.iterator(), "iterator(...)");
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        Tile tile = (Tile)e;
                        tile.setBaseTerrain("Lakes");
                        tile.setTransients();
                    }
                }
                tilesInArea.clear();
            }
        }
        if (this.ruleset.getTerrains().containsKey("Coast")) {
            this.spreadCoast(map2);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void spreadAncientRuins(TileMap map) {
        $this$filter$iv = this.ruleset.getTileImprovements();
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            it = element$iv$iv;
            $i$a$-filter-MapGenerator$spreadAncientRuins$ruinsEquivalents$1 = false;
            if (!TileImprovement.isAncientRuinsEquivalent$default((TileImprovement)it.getValue(), null, 1, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        ruinsEquivalents = destination$iv$iv;
        if (map.getMapParameters().getNoRuins() || ruinsEquivalents.isEmpty()) {
            return;
        }
        $this$filter$iv = map.getValues();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block10: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadAncientRuins$suitableTiles$1 = false;
                if (!it.isLand() || it.isImpassible()) ** GOTO lbl-1000
                $this$any$iv = ruinsEquivalents.values();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        improvement = (TileImprovement)element$iv;
                        $i$a$-any-MapGenerator$spreadAncientRuins$suitableTiles$1$1 = false;
                        if (!MapGenerator.spreadAncientRuins$isPlaceable(improvement, it)) continue;
                        v0 = true;
                        break block10;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        suitableTiles = (List)destination$iv$iv /* !! */ ;
        locations = this.randomness.chooseSpreadOutLocations(MathKt.roundToInt((float)suitableTiles.size() * this.ruleset.getModOptions().getConstants().getAncientRuinCountMultiplier()), suitableTiles, map.getMapParameters().getMapSize().getRadius());
        v2 = locations.iterator();
        Intrinsics.checkNotNullExpressionValue(v2, "iterator(...)");
        var5_7 = v2;
        while (var5_7.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var5_7.next(), "next(...)");
            destination$iv$iv /* !! */  = ruinsEquivalents.values();
            var19_29 = tile;
            $i$f$filter = false;
            element$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileImprovement)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadAncientRuins$1 = false;
                if (!MapGenerator.spreadAncientRuins$isPlaceable(it, tile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var19_29.setImprovement(((TileImprovement)CollectionsKt.random((List)destination$iv$iv, Random.Default)).getName());
        }
    }

    private final void spreadResources(TileMap tileMap) {
        int mapRadius = tileMap.getMapParameters().getMapSize().getRadius();
        for (Tile tile : tileMap.getValues()) {
            tile.setResource(null);
        }
        this.spreadStrategicResources(tileMap, mapRadius);
        this.spreadResources(tileMap, mapRadius, ResourceType.Luxury);
        this.spreadResources(tileMap, mapRadius, ResourceType.Bonus);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spreadStrategicResources(TileMap tileMap, int mapRadius) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadStrategicResources$strategicResources$1 = false;
            if (!(it.getResourceType() == ResourceType.Strategic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        strategicResources = (List)destination$iv$iv;
        $this$filter$iv = tileMap.getValues();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block12: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$candidateTiles$1 = false;
                if (it.getResource() != null || it.isImpassible()) ** GOTO lbl-1000
                $this$none$iv = it.getNeighbors();
                $i$f$none = false;
                var16_36 = $this$none$iv.iterator();
                while (var16_36.hasNext()) {
                    neighbor = element$iv = var16_36.next();
                    $i$a$-none-MapGenerator$spreadStrategicResources$candidateTiles$1$1 = false;
                    if (!neighbor.isNaturalWonder()) continue;
                    v1 = false;
                    break block12;
                }
                v1 = true;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidateTiles = (List)destination$iv$iv;
        $this$count$iv = candidateTiles;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v3 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv /* !! */ ;
                $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = false;
                if (!it.isLand() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v3 = count$iv;
        }
        totalNumberOfResources = (float)v3 * tileMap.getMapParameters().getResourceRichness();
        resourcesPerType = (int)(totalNumberOfResources / (float)strategicResources.size());
        for (E v4 : strategicResources) {
            Intrinsics.checkNotNullExpressionValue(v4, "next(...)");
            resource = (TileResource)v4;
            element$iv /* !! */  = candidateTiles;
            $i$f$filterNot = false;
            $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filterNot-MapGenerator$spreadStrategicResources$suitableTiles$1 = false;
                if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$suitableTiles$2 = false;
                if (!(it.getResource() == null && resource.generatesNaturallyOn(it) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            suitableTiles = (List)destination$iv$iv;
            locations = this.randomness.chooseSpreadOutLocations(resourcesPerType, suitableTiles, mapRadius);
            Intrinsics.checkNotNullExpressionValue(locations.iterator(), "iterator(...)");
            while (var11_23.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(var11_23.next(), "next(...)");
                Tile.setTileResource$default(location, resource, null, this.randomness.getRNG(), 2, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spreadResources(TileMap tileMap, int mapRadius, ResourceType resourceType) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var7_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadResources$resourcesOfType$1 = false;
            if (!(it.getResourceType() == resourceType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        resourcesOfType = (List)destination$iv$iv;
        $i$f$filter = tileMap.getValues();
        $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filterNot-MapGenerator$spreadResources$suitableTiles$1 = false;
            if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block20: {
                block19: {
                    it = (Tile)element$iv$iv;
                    $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = false;
                    if (it.getResource() != null) ** GOTO lbl-1000
                    $this$none$iv = it.getNeighbors();
                    $i$f$none = false;
                    var17_39 = $this$none$iv.iterator();
                    while (var17_39.hasNext()) {
                        neighbor = element$iv = var17_39.next();
                        $i$a$-none-MapGenerator$spreadResources$suitableTiles$2$1 = false;
                        if (!neighbor.isNaturalWonder()) continue;
                        v1 = false;
                        break block19;
                    }
                    v1 = true;
                }
                if (!v1) ** GOTO lbl-1000
                $this$any$iv = resourcesOfType;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Tile element$iv : $this$any$iv) {
                        r = (TileResource)element$iv;
                        $i$a$-any-MapGenerator$spreadResources$suitableTiles$2$2 = false;
                        if (!r.generatesNaturallyOn(it)) continue;
                        v2 = true;
                        break block20;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableTiles = (List)destination$iv$iv;
        $this$count$iv = tileMap.getValues();
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v4 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv;
                $i$a$-count-MapGenerator$spreadResources$numberOfResources$1 = false;
                if (!(it.isLand() != false && it.isImpassible() == false) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        numberOfResources = (float)v4 * tileMap.getMapParameters().getResourceRichness();
        locations = this.randomness.chooseSpreadOutLocations((int)numberOfResources, suitableTiles, mapRadius);
        resourceToNumber = new Counter<String>(null, 1, null);
        v5 = locations.iterator();
        Intrinsics.checkNotNullExpressionValue(v5, "iterator(...)");
        var9_17 = v5;
        while (var9_17.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var9_17.next(), "next(...)");
            $this$filter$iv = resourcesOfType;
            $i$f$filter = false;
            $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadResources$possibleResources$1 = false;
                if (!it.generatesNaturallyOn(tile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleResources = (List)destination$iv$iv;
            if (possibleResources.isEmpty()) continue;
            $this$minByOrNull$iv = possibleResources;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v6 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v6 = minElem$iv;
                } else {
                    it = (TileResource)minElem$iv;
                    $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                    minValue$iv = ((Number)resourceToNumber.get(it.getName())).intValue();
                    do {
                        e$iv = iterator$iv.next();
                        it = (TileResource)e$iv;
                        $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                        v$iv = ((Number)resourceToNumber.get(it.getName())).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v6 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v6);
            resourceWithLeastAssignments = v6;
            resourceToNumber.add(resourceWithLeastAssignments.getName(), 1);
            Tile.setTileResource$default(tile, resourceWithLeastAssignments, null, this.randomness.getRNG(), 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHumidityAndTemperature(TileMap tileMap) {
        void destination$iv;
        void $this$mapTo$iv;
        Object list$iv$iv;
        Sequence<Terrain> $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Terrain it;
        void $this$filterTo$iv$iv;
        double humiditySeed = this.randomness.getRNG().nextInt();
        double temperatureSeed = this.randomness.getRNG().nextInt();
        TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
        double scale = tileMap.getMapParameters().getTilesPerBiomeArea();
        float temperatureintensity = tileMap.getMapParameters().getTemperatureintensity();
        float temperatureShift = tileMap.getMapParameters().getTemperatureShift();
        float humidityShift = temperatureShift > 0.0f ? -temperatureShift / (float)2 : 0.0f;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == TerrainType.Land)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            list$iv$iv = this.getGenerationConditions(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List limitsMap = (List)destination$iv$iv;
        boolean noTerrainUniques = limitsMap.isEmpty();
        Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        $this$flatMapTo$iv$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), MapGenerator::applyHumidityAndTemperature$lambda$2);
        destination$iv$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            list$iv$iv = (Terrain)item$iv;
            void var32_23 = destination$iv;
            boolean bl = false;
            var32_23.add(it.getName());
        }
        Set elevationTerrains = (Set)destination$iv;
        if (elevationTerrains.isEmpty()) {
            elevationTerrains.add("Mountain");
        }
        object = CollectionsKt.asSequence((Iterable)tileMap.getValues()).iterator();
        while (object.hasNext()) {
            TerrainOccursRange matchingTerrain;
            Object v4;
            Object[] objectArray;
            double temperature;
            double humidity;
            Tile tile;
            block18: {
                double d;
                tile = (Tile)object.next();
                if (tile.isWater() || elevationTerrains.contains(tile.getBaseTerrain())) continue;
                double humidityRandom = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, humiditySeed, 1, 0.0, 0.0, scale, 24, null);
                humidity = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf((humidityRandom + 1.0) / 2.0 + (double)humidityShift), RangesKt.rangeTo(0.0, 1.0))).doubleValue();
                if (Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
                    double radiusTemperature;
                    float radius = this.getTileRadius(tile, tileMap);
                    d = radiusTemperature = this.getTemperatureAtRadius(radius);
                } else {
                    double latitudeTemperature;
                    d = latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
                }
                double expectedTemperature = d;
                double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, temperatureSeed, 1, 0.0, 0.0, scale, 24, null);
                temperature = 0.0;
                temperature = (5.0 * expectedTemperature + randomTemperature) / 6.0;
                temperature = Math.pow(Math.abs(temperature), 1.0 - (double)temperatureintensity) * Math.signum(temperature);
                temperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(temperature + (double)temperatureShift), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
                if (noTerrainUniques) {
                    String autoTerrain;
                    String string;
                    if (temperature < -0.4) {
                        string = humidity < 0.5 ? "Snow" : "Tundra";
                    } else if (temperature < 0.8) {
                        string = humidity < 0.5 ? "Plains" : "Grassland";
                    } else if (temperature <= 1.0) {
                        string = humidity < 0.7 ? "Desert" : "Plains";
                    } else {
                        objectArray = new Object[]{temperature};
                        LogKt.debug("applyHumidityAndTemperature: Invalid temperature %s", objectArray);
                        string = autoTerrain = this.firstLandTerrain.getName();
                    }
                    if (this.ruleset.getTerrains().containsKey(autoTerrain)) {
                        tile.setBaseTerrain(autoTerrain);
                    }
                    tile.setTerrainTransients();
                    continue;
                }
                Iterable $this$firstOrNull$iv = limitsMap;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TerrainOccursRange it2 = (TerrainOccursRange)element$iv;
                    boolean bl = false;
                    if (!it2.matches(temperature, humidity)) continue;
                    v4 = element$iv;
                    break block18;
                }
                v4 = null;
            }
            TerrainOccursRange terrainOccursRange = matchingTerrain = (TerrainOccursRange)v4;
            if (terrainOccursRange != null) {
                tile.setBaseTerrain(terrainOccursRange.getTerrain().getName());
            } else {
                tile.setBaseTerrain(this.firstLandTerrain.getName());
                objectArray = new Object[]{temperature, humidity};
                LogKt.debug("applyHumidityAndTemperature: No terrain found for temperature: %s, humidity: %s", objectArray);
            }
            tile.setHumidity(humidity);
            tile.setTemperature(temperature);
            tile.setTerrainTransients();
        }
    }

    private final float getTileRadius(Tile tile, TileMap tileMap) {
        float latitudeRatio = Math.abs(tile.getLatitude()) / tileMap.getMaxLatitude();
        float longitudeRatio = Math.abs(tile.getLongitude()) / tileMap.getMaxLongitude();
        return (float)Math.sqrt((float)Math.pow(latitudeRatio, 2) + (float)Math.pow(longitudeRatio, 2));
    }

    private final double getTemperatureAtRadius(float radius) {
        return (double)radius < 0.5 ? this.scaleToRange(0.05, 0.5, -1.0, 1.0, radius) : ((double)radius > 0.5 ? this.scaleToRange(0.5, 0.95, 1.0, -1.0, radius) : 1.0);
    }

    private final double scaleToRange(double x1, double x2, double y1, double y2, float value) {
        double gain = (y2 - y1) / (x2 - x1);
        double offset = y2 - gain * x2;
        return gain * (double)value + offset;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spawnVegetation(TileMap tileMap) {
        vegetationSeed = this.randomness.getRNG().nextInt();
        $this$mapNotNull$iv /* !! */  = Constants.INSTANCE.getVegetation();
        $i$f$mapNotNull = false;
        var7_6 = $this$mapNotNull$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var13_22 = ((void)$this$forEach$iv$iv$iv).length;
        for (var12_19 = 0; var12_19 < var13_22; ++var12_19) {
            element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var12_19];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            it = element$iv$iv;
            $i$a$-mapNotNull-MapGenerator$spawnVegetation$vegetationTerrains$1 = false;
            if (this.ruleset.getTerrains().get(it) == null) continue;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        v0 = (List)destination$iv$iv;
        v1 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(v1, "<get-values>(...)");
        $this$mapNotNull$iv /* !! */  = v1;
        var26_39 = v0;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-filter-MapGenerator$spawnVegetation$vegetationTerrains$2 = false;
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.Vegetation, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vegetationTerrains = CollectionsKt.toHashSet((Iterable)CollectionsKt.plus(var26_39, (Iterable)((List)destination$iv$iv)));
        $this$flatMap$iv = vegetationTerrains;
        $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-flatMap-MapGenerator$spawnVegetation$candidateTerrains$1 = false;
            list$iv$iv = it.getOccursOn();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        candidateTerrains = (List)destination$iv$iv;
        var6_5 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, spawnVegetation$lambda$3(java.util.List com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)((List)candidateTerrains)).iterator();
        while (var6_5.hasNext()) {
            tile = var6_5.next();
            vegetation = (MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, vegetationSeed, 1, 0.0, 0.0, 3.0, 24, null) + 1.0) / 2.0;
            if (!(vegetation <= (double)tileMap.getMapParameters().getVegetationRichness())) continue;
            $this$filter$iv = vegetationTerrains;
            $i$f$filter = false;
            list$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block10: {
                    vegetationTerrain = (Terrain)element$iv$iv;
                    $i$a$-filter-MapGenerator$spawnVegetation$possibleVegetation$1 = false;
                    if (!vegetationTerrain.getOccursOn().contains(tile.getLastTerrain().getName())) ** GOTO lbl-1000
                    $this$none$iv = IHasUniques.getMatchingUniques$default(vegetationTerrain, UniqueType.TileGenerationConditions, null, 2, null);
                    $i$f$none = false;
                    var22_42 = $this$none$iv.iterator();
                    while (var22_42.hasNext()) {
                        element$iv = var22_42.next();
                        it = (Unique)element$iv;
                        $i$a$-none-MapGenerator$spawnVegetation$possibleVegetation$1$1 = false;
                        v2 = tile.getTemperature();
                        Intrinsics.checkNotNull(v2);
                        if (v2 < Double.parseDouble(it.getParams().get(0))) ** GOTO lbl-1000
                        v3 = tile.getTemperature();
                        Intrinsics.checkNotNull(v3);
                        if (v3 > Double.parseDouble(it.getParams().get(1))) ** GOTO lbl-1000
                        v4 = tile.getHumidity();
                        Intrinsics.checkNotNull(v4);
                        if (v4 < Double.parseDouble(it.getParams().get(2))) ** GOTO lbl-1000
                        v5 = tile.getHumidity();
                        Intrinsics.checkNotNull(v5);
                        if (v5 > Double.parseDouble(it.getParams().get(3))) lbl-1000:
                        // 4 sources

                        {
                            v6 = true;
                        } else {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v7 = false;
                        break block10;
                    }
                    v7 = true;
                }
                if (v7 && NaturalWonderGenerator.Companion.fitsTerrainUniques(vegetationTerrain, tile)) {
                    v8 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v8 = false;
                }
                if (!v8) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleVegetation = (List)destination$iv$iv;
            if (possibleVegetation.isEmpty()) continue;
            randomVegetation = (Terrain)CollectionsKt.random(possibleVegetation, this.randomness.getRNG());
            tile.addTerrainFeature(randomVegetation.getName());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spawnRareFeatures(TileMap tileMap) {
        v0 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-filter-MapGenerator$spawnRareFeatures$rareFeatures$1 = false;
            if (it.getType() != TerrainType.TerrainFeature) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (IHasUniques.hasUnique$default(it, UniqueType.RareFeature, null, 2, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        rareFeatures = (List)destination$iv$iv;
        var3_2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, spawnRareFeatures$lambda$1(com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)()).iterator();
        while (var3_2.hasNext()) {
            tile = var3_2.next();
            if (!(this.randomness.getRNG().nextDouble() <= (double)tileMap.getMapParameters().getRareFeaturesRichness())) continue;
            $this$filter$iv = rareFeatures;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Terrain)element$iv$iv;
                $i$a$-filter-MapGenerator$spawnRareFeatures$possibleFeatures$1 = false;
                if (!it.getOccursOn().contains(tile.getBaseTerrain()) || tile.isHill() && !it.getOccursOn().contains("Hill")) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it);
                if (NaturalWonderGenerator.Companion.fitsTerrainUniques(it, tile)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleFeatures = (List)destination$iv$iv;
            if (!CollectionsKt.any(possibleFeatures)) continue;
            tile.addTerrainFeature(((Terrain)CollectionsKt.random(possibleFeatures, this.randomness.getRNG())).getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnIce(TileMap tileMap) {
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Set<String> waterTerrain = SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), MapGenerator::spawnIce$lambda$0), MapGenerator::spawnIce$lambda$1));
        Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        List<TerrainOccursRange> iceEquivalents = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), arg_0 -> MapGenerator.spawnIce$lambda$2(waterTerrain, arg_0)), arg_0 -> MapGenerator.spawnIce$lambda$3(this, arg_0)));
        if (Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
            this.spawnFlatEarthIceWalls(tileMap, iceEquivalents);
        }
        if (iceEquivalents.isEmpty()) {
            return;
        }
        TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
        double temperatureSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : tileMap.getValues()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TerrainOccursRange it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (!waterTerrain.contains(tile.getBaseTerrain()) || !((Collection)tile.getTerrainFeatures()).isEmpty()) continue;
            MapGenerationRandomness mapGenerationRandomness = this.randomness;
            double d = tileMap.getMapParameters().getTilesPerBiomeArea();
            double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(mapGenerationRandomness, tile, temperatureSeed, 1, 0.0, 0.0, d, 24, null);
            double latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
            double temperature = 0.0;
            temperature = (latitudeTemperature + randomTemperature) / 2.0;
            temperature = Math.pow(Math.abs(temperature), 1.0 - (double)tileMap.getMapParameters().getTemperatureintensity()) * Math.signum(temperature);
            temperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(temperature + (double)tileMap.getMapParameters().getTemperatureShift()), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
            Iterable iterable = iceEquivalents;
            boolean $i$f$filter = false;
            void var16_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!(it.matches(temperature, 1.0) && it.getTerrain().getOccursOn().contains(tile.getLastTerrain().getName()) && NaturalWonderGenerator.Companion.fitsTerrainUniques(it.getTerrain(), tile))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TerrainOccursRange)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getTerrain().getName());
            }
            List candidates = (List)destination$iv$iv;
            int n = candidates.size();
            if (n == 1) {
                tile.addTerrainFeature((String)CollectionsKt.first(candidates));
                continue;
            }
            if (0 <= n ? n < 2 : false) continue;
            tile.addTerrainFeature((String)CollectionsKt.random(candidates, this.randomness.getRNG()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnFlatEarthIceWalls(TileMap tileMap, List<TerrainOccursRange> iceEquivalents) {
        Object v2;
        String snowTerrainName;
        String iceTerrainName;
        block9: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterator it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = iceEquivalents;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!((TerrainOccursRange)((Object)it2)).matches(-1.0, 1.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            int $i$f$map = 0;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (TerrainOccursRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((TerrainOccursRange)((Object)it2)).getTerrain().getName());
            }
            List iceCandidates = (List)destination$iv$iv;
            $i$f$map = iceCandidates.size();
            iceTerrainName = $i$f$map == 1 ? (String)CollectionsKt.first(iceCandidates) : (!(0 <= $i$f$map ? $i$f$map < 2 : false) ? (String)CollectionsKt.random(iceCandidates, this.randomness.getRNG()) : null);
            Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
            Iterable $this$filter$iv2 = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), MapGenerator::spawnFlatEarthIceWalls$lambda$2), arg_0 -> MapGenerator.spawnFlatEarthIceWalls$lambda$3(this, arg_0)));
            boolean $i$f$filter2 = false;
            Iterable $i$f$mapTo22 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!((TerrainOccursRange)it).matches(-1.0, 1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            int $i$f$map2 = 0;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TerrainOccursRange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((TerrainOccursRange)it).getTerrain().getName());
            }
            List snowCandidates = (List)destination$iv$iv2;
            $i$f$map2 = snowCandidates.size();
            snowTerrainName = $i$f$map2 == 1 ? (String)CollectionsKt.first(snowCandidates) : (!(0 <= $i$f$map2 ? $i$f$map2 < 2 : false) ? (String)CollectionsKt.random(snowCandidates, this.randomness.getRNG()) : null);
            Collection<Terrain> collection3 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Terrain)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.hasUnique$default((IHasUniques)it, UniqueType.OccursInChains, null, 2, null)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        Terrain terrain = v2;
        String mountainTerrainName = terrain != null ? terrain.getName() : null;
        String string = iceTerrainName;
        if (string == null && (string = snowTerrainName) == null && (string = mountainTerrainName) == null) {
            string = null;
        }
        String bestArcticTileName = string;
        String[] stringArray = new String[]{iceTerrainName, snowTerrainName, mountainTerrainName};
        List<String> arcticTileNameList = ArraysKt.filterNotNull(stringArray);
        if (bestArcticTileName == null && arcticTileNameList.isEmpty()) {
            return;
        }
        for (Tile tile : tileMap.getValues()) {
            boolean isEdgeTile;
            boolean isCenterTile = tile.getLatitude() == 0.0f && tile.getLongitude() == 0.0f;
            boolean bl = isEdgeTile = SequencesKt.count(tile.getNeighbors()) < 6;
            if (isCenterTile && bestArcticTileName != null) {
                this.spawnFlatEarthCenterIceWall(tile, bestArcticTileName, iceTerrainName, mountainTerrainName);
            }
            if (!isEdgeTile || !(!((Collection)arcticTileNameList).isEmpty())) continue;
            this.spawnFlatEarthEdgeIceWall(tile, arcticTileNameList, iceTerrainName, mountainTerrainName);
        }
    }

    private final void spawnFlatEarthCenterIceWall(Tile tile, String bestArcticTileName, String iceTerrainName, String mountainTerrainName) {
        if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
            tile.setBaseTerrain(this.waterTerrainName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
            tile.setBaseTerrain(bestArcticTileName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else {
            tile.setBaseTerrain(bestArcticTileName);
            tile.removeTerrainFeatures();
        }
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
                neighbor.setBaseTerrain(this.waterTerrainName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
            } else if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
                neighbor.setBaseTerrain(bestArcticTileName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
            } else {
                neighbor.setBaseTerrain(bestArcticTileName);
                neighbor.removeTerrainFeatures();
            }
            Iterator<Tile> iterator3 = neighbor.getNeighbors().iterator();
            while (iterator3.hasNext()) {
                Tile neighbor2 = iterator3.next();
                if (this.randomness.getRNG().nextDouble() < 0.75) continue;
                if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
                    neighbor2.setBaseTerrain(this.waterTerrainName);
                    neighbor2.removeTerrainFeatures();
                    neighbor2.addTerrainFeature(iceTerrainName);
                    continue;
                }
                if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
                    neighbor2.setBaseTerrain(bestArcticTileName);
                    neighbor2.removeTerrainFeatures();
                    neighbor2.addTerrainFeature(iceTerrainName);
                    continue;
                }
                neighbor2.setBaseTerrain(bestArcticTileName);
                neighbor2.removeTerrainFeatures();
            }
        }
    }

    private final void spawnFlatEarthEdgeIceWall(Tile tile, List<String> arcticTileNameList, String iceTerrainName, String mountainTerrainName) {
        String arcticTileName;
        String string = arcticTileName = arcticTileNameList.size() == 1 ? CollectionsKt.first(arcticTileNameList) : (String)CollectionsKt.random((Collection)arcticTileNameList, this.randomness.getRNG());
        if (Intrinsics.areEqual(arcticTileName, iceTerrainName)) {
            tile.setBaseTerrain(this.waterTerrainName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else if (iceTerrainName != null && !Intrinsics.areEqual(arcticTileName, mountainTerrainName)) {
            tile.setBaseTerrain(arcticTileName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else {
            tile.setBaseTerrain(arcticTileName);
            tile.removeTerrainFeatures();
        }
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            boolean neighborIsEdgeTile = SequencesKt.count(neighbor.getNeighbors()) < 6;
            if (neighborIsEdgeTile || this.randomness.getRNG().nextDouble() < 0.75) continue;
            if (Intrinsics.areEqual(arcticTileName, iceTerrainName)) {
                neighbor.setBaseTerrain(this.waterTerrainName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
                continue;
            }
            if (iceTerrainName != null && !Intrinsics.areEqual(arcticTileName, mountainTerrainName)) {
                neighbor.setBaseTerrain(arcticTileName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
                continue;
            }
            neighbor.setBaseTerrain(arcticTileName);
            neighbor.removeTerrainFeatures();
        }
    }

    private static final TerrainOccursRange getGenerationConditions$lambda$0(Terrain $this_getGenerationConditions, Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        return new TerrainOccursRange($this_getGenerationConditions, unique);
    }

    private static final Unit generateMap$lambda$0(TileMap $map, MapGenerator this$0) {
        new MapLandmassGenerator($map, this$0.ruleset, this$0.randomness).generateLand();
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$1(TileMap $map, MapGenerator this$0) {
        new MapElevationGenerator($map, this$0.ruleset, this$0.randomness).raiseMountainsAndHills();
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$2(MapGenerator this$0, TileMap $map) {
        this$0.applyHumidityAndTemperature($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$3(MapGenerator this$0, TileMap $map) {
        this$0.spawnLakesAndCoasts($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$4(MapGenerator this$0, TileMap $map) {
        this$0.spawnVegetation($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$5(MapGenerator this$0, TileMap $map) {
        this$0.spawnRareFeatures($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$6(MapGenerator this$0, TileMap $map) {
        this$0.spawnIce($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$7(TileMap $map) {
        $map.assignContinents(TileMap.AssignContinentsMode.Assign);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$8(TileMap $map, MapGenerator this$0) {
        RiverGenerator.spawnRivers$default(new RiverGenerator($map, this$0.randomness, this$0.ruleset), null, 1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$9(MapRegions $regions, TileMap $map, List $civilizations, MapGenerator this$0) {
        int n;
        void $this$count$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                Nation nation = this$0.ruleset.getNations().get(it.getCivName());
                Intrinsics.checkNotNull(nation);
                if (!nation.isMajorCiv() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        mapRegions.generateRegions(tileMap, n2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$10(MapRegions $regions, TileMap $map, List $civilizations, GameParameters $gameParameters, MapGenerator this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            Nation nation = this$0.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(nation);
            if (!nation.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        mapRegions.assignRegions(tileMap, list2, $gameParameters);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$11(MapGenerator this$0, TileMap $map) {
        new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$12(MapRegions $regions, TileMap $map, List $civilizations, MapGenerator this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            Nation nation = this$0.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(nation);
            if (!nation.isCityState()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        mapRegions.placeResourcesAndMinorCivs(tileMap, list2);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$13(MapGenerator this$0, TileMap $map) {
        new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$14(MapGenerator this$0, TileMap $map) {
        this$0.spreadResources($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$15(MapGenerator this$0, TileMap $map) {
        this$0.spreadAncientRuins($map);
        return Unit.INSTANCE;
    }

    private static final Tile mirror$getMirrorTile(MapGenerator this$0, TileMap $map, Tile tile, String mirroringType) {
        Vector2 vector2;
        switch (mirroringType) {
            case "Top-Bottom": {
                if (tile.getRow() <= 0) {
                    return null;
                }
                vector2 = this$0.flipTopBottom(tile.getPosition());
                break;
            }
            case "Bottom-Top": {
                if (tile.getColumn() <= 0) {
                    return null;
                }
                vector2 = this$0.flipLeftRight(tile.getPosition());
                break;
            }
            case "Around Center Tile": {
                if (tile.getRow() <= 0) {
                    return null;
                }
                vector2 = this$0.flipLeftRight(this$0.flipTopBottom(tile.getPosition()));
                break;
            }
            case "4-way": {
                if (tile.getRow() < 0 && tile.getColumn() < 0) {
                    return null;
                }
                if (tile.getRow() < 0 && tile.getColumn() >= 0) {
                    vector2 = this$0.flipLeftRight(tile.getPosition());
                    break;
                }
                if (tile.getRow() >= 0 && tile.getColumn() < 0) {
                    vector2 = this$0.flipTopBottom(tile.getPosition());
                    break;
                }
                vector2 = this$0.flipLeftRight(this$0.flipTopBottom(tile.getPosition()));
                break;
            }
            default: {
                return null;
            }
        }
        Vector2 mirrorTileVector = vector2;
        return $map.getIfTileExistsOrNull((int)mirrorTileVector.x, (int)mirrorTileVector.y);
    }

    private static final void mirror$copyTile(MapGenerator this$0, TileMap $map, Tile tile, String mirroringType) {
        Tile tile2 = MapGenerator.mirror$getMirrorTile(this$0, $map, tile, mirroringType);
        if (tile2 == null) {
            return;
        }
        Tile mirrorTile = tile2;
        tile.setBaseTerrain(mirrorTile.getBaseTerrain());
        tile.setNaturalWonder(mirrorTile.getNaturalWonder());
        tile.setTerrainFeatures(mirrorTile.getTerrainFeatures());
        tile.setResource(mirrorTile.getResource());
        tile.setImprovement(mirrorTile.getImprovement());
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighborMirror;
            Tile neighbor = iterator2.next();
            if (MapGenerator.mirror$getMirrorTile(this$0, $map, neighbor, mirroringType) == null || !SequencesKt.contains(mirrorTile.getNeighbors(), neighborMirror)) continue;
            Tile.setConnectedByRiver$default(tile, neighbor, mirrorTile.isConnectedByRiver(neighborMirror), false, 4, null);
        }
    }

    private static final Unit generateSingleStep$lambda$0(MapGeneratorSteps $step, TileMap $map, MapGenerator this$0) {
        switch (WhenMappings.$EnumSwitchMapping$0[$step.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalArgumentException("MapGeneratorSteps.All cannot be used in generateSingleStep");
            }
            case 3: {
                new MapLandmassGenerator($map, this$0.ruleset, this$0.randomness).generateLand();
                break;
            }
            case 4: {
                new MapElevationGenerator($map, this$0.ruleset, this$0.randomness).raiseMountainsAndHills();
                break;
            }
            case 5: {
                this$0.applyHumidityAndTemperature($map);
                break;
            }
            case 6: {
                this$0.spawnLakesAndCoasts($map);
                break;
            }
            case 7: {
                this$0.spawnVegetation($map);
                break;
            }
            case 8: {
                this$0.spawnRareFeatures($map);
                break;
            }
            case 9: {
                this$0.spawnIce($map);
                break;
            }
            case 10: {
                $map.assignContinents(TileMap.AssignContinentsMode.Reassign);
                break;
            }
            case 11: {
                new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
                break;
            }
            case 12: {
                Set resultingTiles = new LinkedHashSet();
                new RiverGenerator($map, this$0.randomness, this$0.ruleset).spawnRivers(resultingTiles);
                this$0.convertTerrains(resultingTiles);
                break;
            }
            case 13: {
                this$0.spreadResources($map);
                break;
            }
            case 14: {
                this$0.spreadAncientRuins($map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean spreadAncientRuins$isPlaceable(TileImprovement improvement, Tile tile) {
        return TileImprovementFunctions.canImprovementBeBuiltHere$core$default(tile.getImprovementFunctions(), improvement, false, null, GameContext.Companion.getIgnoreConditionals(), false, 22, null);
    }

    private static final boolean applyHumidityAndTemperature$lambda$2(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.OccursInChains, null, 2, null);
    }

    private static final boolean spawnVegetation$lambda$3(List $candidateTerrains, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $candidateTerrains.contains(it.getBaseTerrain()) && $candidateTerrains.contains(it.getLastTerrain().getName());
    }

    private static final boolean spawnRareFeatures$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTerrainFeatures().isEmpty();
    }

    private static final boolean spawnIce$lambda$0(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TerrainType.Water;
    }

    private static final String spawnIce$lambda$1(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean spawnIce$lambda$2(Set $waterTerrain, Terrain terrain) {
        String it;
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        if (terrain.getType() != TerrainType.TerrainFeature) return false;
        if (!terrain.getImpassable()) return false;
        Iterable $this$all$iv = terrain.getOccursOn();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while ($waterTerrain.contains(it));
        return false;
    }

    private static final Sequence spawnIce$lambda$3(MapGenerator this$0, Terrain terrain) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Sequence<TerrainOccursRange> conditions = this$0.getGenerationConditions(terrain);
        return SequencesKt.any(conditions) ? conditions : SequencesKt.sequenceOf(new TerrainOccursRange(terrain, -1.0f, this$0.ruleset.getModOptions().getConstants().getSpawnIceBelowTemperature(), 0.0f, 1.0f));
    }

    private static final boolean spawnFlatEarthIceWalls$lambda$2(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TerrainType.Land;
    }

    private static final Sequence spawnFlatEarthIceWalls$lambda$3(MapGenerator this$0, Terrain terrain) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Sequence<TerrainOccursRange> conditions = this$0.getGenerationConditions(terrain);
        return SequencesKt.any(conditions) ? conditions : SequencesKt.sequenceOf(new TerrainOccursRange(terrain, -1.0f, this$0.ruleset.getModOptions().getConstants().getSpawnIceBelowTemperature(), 0.0f, 1.0f));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Companion;", "", "<init>", "()V", "consoleTimings", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Helpers;", "", "<init>", "()V", "convertTerrains", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "core"})
    @SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,838:1\n183#2,2:839\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n*L\n270#1:839,2\n*E\n"})
    public static final class Helpers {
        @NotNull
        public static final Helpers INSTANCE = new Helpers();

        private Helpers() {
        }

        /*
         * WARNING - void declaration
         */
        public final void convertTerrains(@NotNull Ruleset ruleset, @NotNull Iterable<Tile> tiles) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Intrinsics.checkNotNullParameter(tiles, "tiles");
            for (Tile tile : tiles) {
                Terrain terrain;
                Unique conversionUnique;
                Object v0;
                block4: {
                    void $this$firstOrNull$iv;
                    Sequence<Unique> sequence = tile.getBaseTerrain().getMatchingUniques(UniqueType.ChangesTerrain, new GameContext(null, null, null, tile, null, null, null, null, null, null, false, 2039, null));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl = false;
                        if (!Tile.isAdjacentTo$default(tile, it.getParams().get(1), null, 2, null)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((Unique)v0 == null || ruleset.getTerrains().get(conversionUnique.getParams().get(0)) == null) continue;
                if (terrain.getType() != TerrainType.TerrainFeature) {
                    tile.setBaseTerrain(terrain.getName());
                } else {
                    if (!terrain.getOccursOn().contains(tile.getLastTerrain().getName())) continue;
                    tile.addTerrainFeature(terrain.getName());
                }
                tile.setTerrainTransients();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "", "terrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "tempFrom", "", "tempTo", "humidFrom", "humidTo", "<init>", "(Lcom/unciv/models/ruleset/tile/Terrain;FFFF)V", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/models/ruleset/tile/Terrain;Lcom/unciv/models/ruleset/unique/Unique;)V", "getTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "getTempFrom", "()F", "getTempTo", "getHumidFrom", "getHumidTo", "matches", "", "temperature", "", "humidity", "Companion", "core"})
    private static final class TerrainOccursRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Terrain terrain;
        private final float tempFrom;
        private final float tempTo;
        private final float humidFrom;
        private final float humidTo;

        public TerrainOccursRange(@NotNull Terrain terrain, float tempFrom, float tempTo, float humidFrom, float humidTo) {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            this.terrain = terrain;
            this.tempFrom = tempFrom;
            this.tempTo = tempTo;
            this.humidFrom = humidFrom;
            this.humidTo = humidTo;
        }

        @NotNull
        public final Terrain getTerrain() {
            return this.terrain;
        }

        public final float getTempFrom() {
            return this.tempFrom;
        }

        public final float getTempTo() {
            return this.tempTo;
        }

        public final float getHumidFrom() {
            return this.humidFrom;
        }

        public final float getHumidTo() {
            return this.humidTo;
        }

        public TerrainOccursRange(@NotNull Terrain terrain, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            Intrinsics.checkNotNullParameter(unique, "unique");
            this(terrain, TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(0), -1.0f), Float.parseFloat(unique.getParams().get(1)), TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(2), 0.0f), Float.parseFloat(unique.getParams().get(3)));
        }

        public final boolean matches(double temperature, double humidity) {
            return (double)this.tempFrom < temperature && temperature <= (double)this.tempTo && (double)this.humidFrom < humidity && humidity <= (double)this.humidTo;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange$Companion;", "", "<init>", "()V", "toFloatMakeInclusive", "", "", "limit", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final float toFloatMakeInclusive(String $this$toFloatMakeInclusive, float limit) {
                float result2 = Float.parseFloat($this$toFloatMakeInclusive);
                if (!(result2 == limit)) {
                    return result2;
                }
                return result2 - Math.ulp(result2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MapGeneratorSteps.values().length];
            try {
                nArray[MapGeneratorSteps.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.All.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Landmass.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Elevation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.HumidityAndTemperature.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.LakesAndCoast.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Vegetation.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.RareFeatures.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Ice.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Continents.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.NaturalWonders.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Rivers.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Resources.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.AncientRuins.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

