/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.resourceplacement;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapResourceSetting;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.mapgenerator.resourceplacement.MapRegionResources;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.utils.CollectionExtensionsKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJP\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J`\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003JZ\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\u000b2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JR\u0010\u001e\u001a\u00020\u001f2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006Jb\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010 \u001a\u00020!2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\"\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0086\u0001\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u0016H\u0002JF\u0010(\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010)\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JT\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0002JF\u0010+\u001a\u00020\u001f2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006,"}, d2={"Lcom/unciv/logic/map/mapgenerator/resourceplacement/LuxuryResourcePlacementLogic;", "", "<init>", "()V", "assignLuxuries", "Lkotlin/Pair;", "", "", "regions", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "Lkotlin/collections/ArrayList;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getLuxuriesForRandomPlacement", "assignableLuxuries", "Lcom/unciv/models/ruleset/tile/TileResource;", "amountRegionsWithLuxury", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getCandidateLuxuries", "maxRegionsWithLuxury", "fallbackWeightings", "", "region", "assignCityStateLuxuries", "targetCityStateLuxuries", "placeLuxuries", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "cityStateLuxuries", "randomLuxuries", "fillSpecialLuxuries", "specialLuxuries", "placedSpecials", "addExtraLuxuryToStarts", "addRandomLuxuries", "addRegionalLuxuries", "placeLuxuriesAtMinorCivStartLocations", "placeLuxuriesAtMajorCivStartLocations", "core"})
@SourceDebugExtension(value={"SMAP\nLuxuryResourcePlacementLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxuryResourcePlacementLogic.kt\ncom/unciv/logic/map/mapgenerator/resourceplacement/LuxuryResourcePlacementLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,415:1\n2746#2,3:416\n774#2:419\n865#2,2:420\n1869#2,2:422\n1056#2:424\n774#2:425\n865#2,2:426\n1563#2:428\n1634#2,3:429\n1788#2,4:432\n774#2:436\n865#2:437\n1761#2,3:438\n866#2:441\n774#2:442\n865#2:443\n1761#2,3:444\n866#2:447\n774#2:448\n865#2,2:449\n774#2:451\n865#2,2:452\n774#2:454\n865#2,2:455\n1869#2,2:457\n1563#2:459\n1634#2,3:460\n1617#2,9:463\n1869#2:472\n1870#2:474\n1626#2:475\n295#2,2:487\n1#3:473\n1#3:489\n488#4,7:476\n126#5:483\n153#5,3:484\n608#6:490\n608#6:491\n1255#6,2:492\n*S KotlinDebug\n*F\n+ 1 LuxuryResourcePlacementLogic.kt\ncom/unciv/logic/map/mapgenerator/resourceplacement/LuxuryResourcePlacementLogic\n*L\n30#1:416,3\n40#1:419\n40#1:420,2\n47#1:422,2\n49#1:424\n91#1:425\n91#1:426,2\n93#1:428\n93#1:429,3\n98#1:432,4\n113#1:436\n113#1:437\n120#1:438,3\n113#1:441\n125#1:442\n125#1:443\n130#1:444,3\n125#1:447\n135#1:448\n135#1:449,2\n151#1:451\n151#1:452,2\n188#1:454\n188#1:455,2\n193#1:457,2\n243#1:459\n243#1:460,3\n245#1:463,9\n245#1:472\n245#1:474\n245#1:475\n341#1:487,2\n245#1:473\n340#1:476,7\n340#1:483\n340#1:484,3\n384#1:490\n395#1:491\n312#1:492,2\n*E\n"})
public final class LuxuryResourcePlacementLogic {
    @NotNull
    public static final LuxuryResourcePlacementLogic INSTANCE = new LuxuryResourcePlacementLogic();

    private LuxuryResourcePlacementLogic() {
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final Pair<List<String>, List<String>> assignLuxuries(@NotNull ArrayList<Region> regions, @NotNull TileDataMap tileData, @NotNull Ruleset ruleset) {
        block8: {
            block9: {
                Intrinsics.checkNotNullParameter(regions, "regions");
                Intrinsics.checkNotNullParameter(tileData, "tileData");
                Intrinsics.checkNotNullParameter(ruleset, "ruleset");
                v0 = ruleset.getTileResources().values();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                $this$none$iv = v0;
                $i$f$none = false;
                if (!((Collection)$this$none$iv).isEmpty()) break block9;
                v1 = true;
                break block8;
            }
            for (T element$iv : $this$none$iv) {
                it /* !! */  = (TileResource)element$iv;
                $i$a$-none-LuxuryResourcePlacementLogic$assignLuxuries$fallbackWeightings$1 = false;
                if (it /* !! */ .getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it /* !! */ );
                if (IHasUniques.hasUnique$default(it /* !! */ , UniqueType.ResourceWeighting, null, 2, null) || IHasUniques.hasUnique$default(it /* !! */ , UniqueType.LuxuryWeightingForCityStates, null, 2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v1 = false;
                break block8;
            }
            v1 = true;
        }
        fallbackWeightings = v1;
        maxRegionsWithLuxury = regions.size() > 14 ? 3 : (regions.size() > 10 ? 2 : 1);
        v3 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
        $this$filter$iv = v3;
        $i$f$filter = false;
        it /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-LuxuryResourcePlacementLogic$assignLuxuries$assignableLuxuries$1 = false;
            if (it.getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.LuxurySpecialPlacement, null, 2, null) && !IHasUniques.hasUnique$default(it, UniqueType.CityStateOnlyResource, null, 2, null)) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        assignableLuxuries = (List)destination$iv$iv;
        amountRegionsWithLuxury = new HashMap<String, Integer>();
        v5 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
        $i$f$filter = v5;
        $i$f$forEach = false;
        destination$iv$iv = $this$forEach$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            element$iv = destination$iv$iv.next();
            it = (TileResource)element$iv;
            $i$a$-forEach-LuxuryResourcePlacementLogic$assignLuxuries$1 = false;
            ((Map)amountRegionsWithLuxury).put(it.getName(), 0);
        }
        $this$sortedBy$iv = regions;
        $i$f$sortedBy = false;
        for (Region region : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(ruleset){
            final /* synthetic */ Ruleset $ruleset$inlined;
            {
                this.$ruleset$inlined = ruleset;
            }

            public final int compare(T a, T b) {
                Region it = (Region)a;
                boolean bl = false;
                Comparable comparable = MapRegionsKt.getRegionPriority(this.$ruleset$inlined.getTerrains().get(it.getType()));
                it = (Region)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)MapRegionsKt.getRegionPriority(this.$ruleset$inlined.getTerrains().get(it.getType())));
            }
        })) {
            candidateLuxuries = this.getCandidateLuxuries(assignableLuxuries, amountRegionsWithLuxury, maxRegionsWithLuxury, fallbackWeightings, region, ruleset);
            if (candidateLuxuries.isEmpty()) continue;
            regionConditional = new GameContext(null, null, null, null, null, null, null, null, region, null, false, 1791, null);
            region.setLuxury(((TileResource)CollectionExtensionsKt.randomWeighted$default(candidateLuxuries, null, (Function1<TileResource, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, assignLuxuries$lambda$4(com.unciv.models.ruleset.unique.GameContext java.util.HashMap com.unciv.models.ruleset.tile.TileResource ), (Lcom/unciv/models/ruleset/tile/TileResource;)Ljava/lang/Float;)((GameContext)regionConditional, amountRegionsWithLuxury), 1, null)).getName());
            v6 = amountRegionsWithLuxury;
            v7 = region.getLuxury();
            Intrinsics.checkNotNull(v7);
            v8 = ((Map)amountRegionsWithLuxury).get(region.getLuxury());
            Intrinsics.checkNotNull(v8);
            v6.put(v7, ((Number)v8).intValue() + 1);
        }
        cityStateLuxuries = this.assignCityStateLuxuries(4, assignableLuxuries, amountRegionsWithLuxury, fallbackWeightings);
        randomLuxuries = this.getLuxuriesForRandomPlacement(assignableLuxuries, amountRegionsWithLuxury, tileData, ruleset);
        return new Pair<List<String>, List<String>>(cityStateLuxuries, randomLuxuries);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final List<String> getLuxuriesForRandomPlacement(List<TileResource> assignableLuxuries, HashMap<String, Integer> amountRegionsWithLuxury, TileDataMap tileData, Ruleset ruleset) {
        int n;
        void $this$count$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        TileResource it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = assignableLuxuries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            boolean bl = false;
            Integer n2 = amountRegionsWithLuxury.get(it.getName());
            if (!(n2 != null && n2 == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TileResource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List remainingLuxuries = CollectionsKt.shuffled((List)destination$iv$iv);
        int disabledPercent = 100 - (int)Math.min((float)Math.pow(tileData.size(), 0.2f) * (float)16, 100.0f);
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$mapTo$iv$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TileResource)element$iv;
                boolean bl = false;
                if (!(it.getResourceType() == ResourceType.Luxury) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int targetDisabledLuxuries = n * disabledPercent / 100;
        return CollectionsKt.drop(remainingLuxuries, targetDisabledLuxuries);
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final List<TileResource> getCandidateLuxuries(List<TileResource> assignableLuxuries, HashMap<String, Integer> amountRegionsWithLuxury, int maxRegionsWithLuxury, boolean fallbackWeightings, Region region, Ruleset ruleset) {
        block16: {
            regionConditional = new GameContext(null, null, null, null, null, null, null, null, region, null, false, 1791, null);
            $this$filter$iv = assignableLuxuries;
            $i$f$filter = false;
            var11_10 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block14: {
                    it = (TileResource)element$iv$iv;
                    $i$a$-filter-LuxuryResourcePlacementLogic$getCandidateLuxuries$candidateLuxuries$1 = false;
                    v0 = amountRegionsWithLuxury.get(it.getName());
                    Intrinsics.checkNotNull(v0);
                    if (((Number)v0).intValue() >= maxRegionsWithLuxury || !fallbackWeightings && !it.hasUnique(UniqueType.ResourceWeighting, regionConditional)) ** GOTO lbl-1000
                    v1 = region.getTerrainCounts().get("Coastal");
                    if ((v1 != null ? v1 : 0) >= 12) ** GOTO lbl-1000
                    $this$any$iv = it.getTerrainsCanBeFoundOn();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v2 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            terrain = (String)element$iv;
                            $i$a$-any-LuxuryResourcePlacementLogic$getCandidateLuxuries$candidateLuxuries$1$1 = false;
                            v3 = ruleset.getTerrains().get(terrain);
                            Intrinsics.checkNotNull(v3);
                            if (!(v3.getType() != TerrainType.Water)) continue;
                            v2 = true;
                            break block14;
                        }
                        v2 = false;
                    }
                }
                if (v2) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidateLuxuries = (List)destination$iv$iv;
            if (!candidateLuxuries.isEmpty()) break block16;
            $this$filter$iv = assignableLuxuries;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block15: {
                    it = (TileResource)element$iv$iv;
                    $i$a$-filter-LuxuryResourcePlacementLogic$getCandidateLuxuries$1 = false;
                    v5 = amountRegionsWithLuxury.get(it.getName());
                    Intrinsics.checkNotNull(v5);
                    if (((Number)v5).intValue() >= maxRegionsWithLuxury) ** GOTO lbl-1000
                    v6 = region.getTerrainCounts().get("Coastal");
                    if ((v6 != null ? v6 : 0) >= 12) ** GOTO lbl-1000
                    $this$any$iv = it.getTerrainsCanBeFoundOn();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v7 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            terrain = (String)element$iv;
                            $i$a$-any-LuxuryResourcePlacementLogic$getCandidateLuxuries$1$1 = false;
                            v8 = ruleset.getTerrains().get(terrain);
                            Intrinsics.checkNotNull(v8);
                            if (!(v8.getType() != TerrainType.Water)) continue;
                            v7 = true;
                            break block15;
                        }
                        v7 = false;
                    }
                }
                if (v7) lbl-1000:
                // 2 sources

                {
                    v9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = false;
                }
                if (!v9) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidateLuxuries = (List)destination$iv$iv;
        }
        if (candidateLuxuries.isEmpty()) {
            $this$filter$iv = assignableLuxuries;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-LuxuryResourcePlacementLogic$getCandidateLuxuries$2 = false;
                v10 = amountRegionsWithLuxury.get(it.getName());
                Intrinsics.checkNotNull(v10);
                if (!(((Number)v10).intValue() < maxRegionsWithLuxury)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidateLuxuries = (List)destination$iv$iv;
        }
        return candidateLuxuries;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<String> assignCityStateLuxuries(int targetCityStateLuxuries, List<TileResource> assignableLuxuries, HashMap<String, Integer> amountRegionsWithLuxury, boolean fallbackWeightings) {
        ArrayList<String> cityStateLuxuries = new ArrayList<String>();
        for (int i = 0; i < targetCityStateLuxuries; ++i) {
            void $this$filterTo$iv$iv;
            int it = i;
            boolean bl = false;
            Iterable $this$filter$iv = assignableLuxuries;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TileResource it2 = (TileResource)element$iv$iv;
                boolean bl2 = false;
                Integer n = amountRegionsWithLuxury.get(it2.getName());
                if (!(n != null && n == 0 && (fallbackWeightings || IHasUniques.hasUnique$default(it2, UniqueType.LuxuryWeightingForCityStates, null, 2, null)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidateLuxuries = (List)destination$iv$iv;
            if (candidateLuxuries.isEmpty()) continue;
            String luxury = ((TileResource)CollectionExtensionsKt.randomWeighted$default(candidateLuxuries, null, LuxuryResourcePlacementLogic::assignCityStateLuxuries$lambda$0$1, 1, null)).getName();
            cityStateLuxuries.add(luxury);
            ((Map)amountRegionsWithLuxury).put(luxury, 1);
        }
        return cityStateLuxuries;
    }

    /*
     * Unable to fully structure code
     */
    public final void placeLuxuries(@NotNull ArrayList<Region> regions, @NotNull TileMap tileMap, @NotNull TileDataMap tileData, @NotNull Ruleset ruleset, @NotNull List<String> cityStateLuxuries, @NotNull List<String> randomLuxuries) {
        Intrinsics.checkNotNullParameter(regions, "regions");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(tileData, "tileData");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(cityStateLuxuries, "cityStateLuxuries");
        Intrinsics.checkNotNullParameter(randomLuxuries, "randomLuxuries");
        this.placeLuxuriesAtMajorCivStartLocations(regions, tileMap, ruleset, tileData, randomLuxuries);
        this.placeLuxuriesAtMinorCivStartLocations(tileMap, ruleset, regions, randomLuxuries, cityStateLuxuries, tileData);
        this.addRegionalLuxuries(tileData, regions, tileMap, ruleset);
        this.addRandomLuxuries(randomLuxuries, tileData, tileMap, regions, ruleset);
        v0 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var10_10 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-LuxuryResourcePlacementLogic$placeLuxuries$specialLuxuries$1 = false;
            if (it.getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (IHasUniques.hasUnique$default(it, UniqueType.LuxurySpecialPlacement, null, 2, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        specialLuxuries = (List)destination$iv$iv;
        placedSpecials = new HashMap<String, Integer>();
        $this$forEach$iv = specialLuxuries;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (TileResource)element$iv;
            $i$a$-forEach-LuxuryResourcePlacementLogic$placeLuxuries$1 = false;
            ((Map)placedSpecials).put(it.getName(), 0);
        }
        this.addExtraLuxuryToStarts(tileMap, regions, randomLuxuries, specialLuxuries, cityStateLuxuries, tileData, ruleset, placedSpecials);
        this.fillSpecialLuxuries(specialLuxuries, tileMap, regions, placedSpecials, tileData);
    }

    private final void fillSpecialLuxuries(List<TileResource> specialLuxuries, TileMap tileMap, ArrayList<Region> regions, HashMap<String, Integer> placedSpecials, TileDataMap tileData) {
        Iterator<TileResource> iterator2 = specialLuxuries.iterator();
        while (iterator2.hasNext()) {
            TileResource special;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            int targetNumber = (int)((float)regions.size() * tileMap.getMapParameters().getMapResources().getSpecialLuxuriesTargetFactor());
            Integer n = placedSpecials.get(special.getName());
            Intrinsics.checkNotNull(n);
            int numberToPlace = Math.max(2, targetNumber - ((Number)n).intValue());
            MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, special, numberToPlace, SequencesKt.shuffled(CollectionsKt.asSequence((Iterable)tileMap.getValues())), 1.0f, true, 6, 0, false, 256, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addExtraLuxuryToStarts(TileMap tileMap, ArrayList<Region> regions, List<String> randomLuxuries, List<TileResource> specialLuxuries, List<String> cityStateLuxuries, TileDataMap tileData, Ruleset ruleset, HashMap<String, Integer> placedSpecials) {
        if (Intrinsics.areEqual(tileMap.getMapParameters().getMapResources(), MapResourceSetting.sparse.getLabel())) {
            return;
        }
        Iterator<Region> iterator2 = regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Region> iterator3 = iterator2;
        block0: while (iterator3.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            Object object2;
            Region region;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Vector2 vector2 = region.getStartPosition();
            Intrinsics.checkNotNull(vector2);
            Sequence<Tile> tilesToCheck = tileMap.get(vector2).getTilesInDistanceRange(new IntRange(1, 2));
            List candidateLuxuries = CollectionsKt.toMutableList(CollectionsKt.shuffled((Iterable)randomLuxuries));
            if (!tileMap.getMapParameters().strategicBalanceGetter()) {
                Iterable $this$map$iv;
                object2 = candidateLuxuries;
                Iterable iterable = CollectionsKt.shuffled((Iterable)specialLuxuries);
                boolean $i$f$map = false;
                void var16_16 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (TileResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                $this$map$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(object2, $this$map$iv);
            }
            CollectionsKt.addAll((Collection)candidateLuxuries, CollectionsKt.shuffled((Iterable)cityStateLuxuries));
            object2 = candidateLuxuries;
            Iterable $this$mapNotNull$iv = regions;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Region it = (Region)element$iv$iv;
                boolean bl2 = false;
                if (it.getLuxury() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            CollectionsKt.addAll(object2, CollectionsKt.shuffled((List)destination$iv$iv));
            for (Object e : candidateLuxuries) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                String luxury = (String)e;
                TileResource tileResource = ruleset.getTileResources().get(luxury);
                Intrinsics.checkNotNull(tileResource);
                if (MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, tileResource, 1, tilesToCheck, 0.0f, false, 0, 0, false, 496, null) <= 0) continue;
                if (!placedSpecials.containsKey(luxury)) continue block0;
                Map map2 = placedSpecials;
                Integer n = placedSpecials.get(luxury);
                Intrinsics.checkNotNull(n);
                map2.put(luxury, ((Number)n).intValue() + 1);
                continue block0;
            }
        }
    }

    private final void addRandomLuxuries(List<String> randomLuxuries, TileDataMap tileData, TileMap tileMap, ArrayList<Region> regions, Ruleset ruleset) {
        if (randomLuxuries.isEmpty()) {
            return;
        }
        int targetRandomLuxuries = (int)Math.pow(tileData.size(), 0.45f);
        targetRandomLuxuries *= tileMap.getMapParameters().getMapResources().getRandomLuxuriesPercent();
        targetRandomLuxuries /= 100;
        targetRandomLuxuries += Random.Default.nextInt(regions.size());
        int minimumRandomLuxuries = (int)Math.pow(tileData.size(), 0.2f);
        Sequence worldTiles = SequencesKt.shuffled(CollectionsKt.asSequence((Iterable)tileMap.getValues()));
        Iterator iterator2 = ((Iterable)CollectionsKt.shuffled((Iterable)randomLuxuries)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2;
            int index = n++;
            String luxury = (String)iterator2.next();
            if (randomLuxuries.size() > 8) {
                n2 = targetRandomLuxuries / 10;
            } else {
                int minimum = Math.max(3, minimumRandomLuxuries - index);
                float f = targetRandomLuxuries;
                List<Float> list2 = MapRegions.Companion.getRandomLuxuryRatios().get(randomLuxuries.size());
                Intrinsics.checkNotNull(list2);
                n2 = Math.max(minimum, (int)(f * ((Number)list2.get(index)).floatValue() + 0.5f));
            }
            int targetForThisLuxury = n2;
            TileResource tileResource = ruleset.getTileResources().get(luxury);
            Intrinsics.checkNotNull(tileResource);
            MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, tileResource, targetForThisLuxury, worldTiles, 0.25f, true, 4, 2, false, 256, null);
        }
    }

    private final void addRegionalLuxuries(TileDataMap tileData, ArrayList<Region> regions, TileMap tileMap, Ruleset ruleset) {
        int idealCivsForMapSize = Math.max(2, tileData.size() / 500);
        int regionTargetNumber = tileData.size() / 600 - (int)(0.3f * (float)Math.abs(regions.size() - idealCivsForMapSize));
        regionTargetNumber += tileMap.getMapParameters().getMapResources().getRegionalLuxuriesDelta();
        regionTargetNumber = Math.max(1, regionTargetNumber);
        Iterator<Region> iterator2 = regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Region> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TileResource resource;
            Region region;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if ((TileResource)((Map)ruleset.getTileResources()).get(region.getLuxury()) == null) continue;
            Sequence candidates = MapRegionsKt.isWaterOnlyResource(resource, ruleset) ? SequencesKt.filter(tileMap.getTilesInRectangle(region.getRect()), arg_0 -> LuxuryResourcePlacementLogic.addRegionalLuxuries$lambda$1(region, arg_0)) : CollectionsKt.asSequence((Iterable)region.getTiles());
            MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, resource, regionTargetNumber, SequencesKt.shuffled(candidates), 0.4f, true, 4, 2, false, 256, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void placeLuxuriesAtMinorCivStartLocations(TileMap tileMap, Ruleset ruleset, ArrayList<Region> regions, List<String> randomLuxuries, List<String> cityStateLuxuries, TileDataMap tileData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Map $this$filterKeys$iv;
        Map map2 = tileMap.getStartingLocationsByNation();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            it = (String)entry$iv.getKey();
            boolean bl = false;
            Nation nation = ruleset.getNations().get(it);
            Intrinsics.checkNotNull(nation);
            if (!nation.isCityState()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        it = $this$mapTo$iv$iv.entrySet().iterator();
        while (it.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)it.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Tile)CollectionsKt.first((Iterable)it2.getValue()));
        }
        block2: for (Tile startLocation : (List)destination$iv$iv) {
            Object v1;
            block5: {
                Iterable $this$firstOrNull$iv = regions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Region it3 = (Region)element$iv;
                    boolean bl = false;
                    if (!it3.getTiles().contains(startLocation)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            Region region = v1;
            Sequence<Tile> tilesToCheck = startLocation.getTilesInDistanceRange(new IntRange(1, 2));
            Region region2 = region;
            List<String> globalLuxuries = (region2 != null ? region2.getLuxury() : null) != null ? CollectionsKt.plus((Collection)randomLuxuries, (Iterable)CollectionsKt.listOf(region.getLuxury())) : randomLuxuries;
            List<String> candidateLuxuries = Random.Default.nextInt(100) >= 25 ? CollectionsKt.plus((Collection)CollectionsKt.shuffled((Iterable)cityStateLuxuries), (Iterable)CollectionsKt.shuffled((Iterable)globalLuxuries)) : CollectionsKt.plus((Collection)CollectionsKt.shuffled((Iterable)globalLuxuries), (Iterable)CollectionsKt.shuffled((Iterable)cityStateLuxuries));
            for (String luxury : candidateLuxuries) {
                Object v = ((Map)ruleset.getTileResources()).get(luxury);
                Intrinsics.checkNotNull(v);
                if (MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, (TileResource)v, 1, tilesToCheck, 0.0f, false, 0, 0, false, 496, null) <= 0) continue;
                continue block2;
            }
        }
    }

    private final void placeLuxuriesAtMajorCivStartLocations(ArrayList<Region> regions, TileMap tileMap, Ruleset ruleset, TileDataMap tileData, List<String> randomLuxuries) {
        int n;
        Region it;
        Object t;
        Object object = regions;
        int n2 = 0;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            t = iterator2.next();
            Region region = (Region)t;
            int n3 = n2;
            boolean bl = false;
            n = it.getTotalFertility();
            n2 = n3 + n;
        }
        object = regions;
        float f = n2;
        n2 = 0;
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            t = iterator2.next();
            it = (Region)t;
            n = n2;
            boolean bl = false;
            int n4 = it.getTiles().size();
            n2 = n + n4;
        }
        n = n2;
        float averageFertilityDensity = f / (float)n;
        Iterator<Region> iterator3 = regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        object = iterator3;
        block2: while (object.hasNext()) {
            TileResource luxuryToPlace;
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Region region = (Region)e;
            int targetLuxuries = 2;
            if (tileMap.getMapParameters().legendaryStartGetter()) {
                ++targetLuxuries;
            }
            if ((float)region.getTotalFertility() / (float)region.getTiles().size() < averageFertilityDensity) {
                ++targetLuxuries;
            }
            if ((TileResource)((Map)ruleset.getTileResources()).get(region.getLuxury()) == null) continue;
            Vector2 vector2 = region.getStartPosition();
            Intrinsics.checkNotNull(vector2);
            Sequence<Tile> $this$sortedBy$iv = SequencesKt.shuffled(tileMap.get(vector2).getTilesInDistanceRange(new IntRange(1, 2)));
            boolean $i$f$sortedBy = false;
            Sequence<Tile> firstPass = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(MapRegionsKt.getTileFertility(it, false));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, MapRegionsKt.getTileFertility(it, false));
                }
            });
            targetLuxuries -= MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, luxuryToPlace, targetLuxuries, firstPass, 0.5f, false, 0, 0, false, 480, null);
            if (targetLuxuries > 0) {
                Vector2 vector22 = region.getStartPosition();
                Intrinsics.checkNotNull(vector22);
                Sequence<Tile> $this$sortedBy$iv2 = SequencesKt.shuffled(tileMap.get(vector22).getTilesAtDistance(3));
                boolean $i$f$sortedBy2 = false;
                Sequence<Tile> secondPass = SequencesKt.plus(firstPass, SequencesKt.sortedWith($this$sortedBy$iv2, new Comparator(){

                    public final int compare(T a, T b) {
                        Tile it = (Tile)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(MapRegionsKt.getTileFertility(it, false));
                        it = (Tile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, MapRegionsKt.getTileFertility(it, false));
                    }
                }));
                targetLuxuries -= MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, luxuryToPlace, targetLuxuries, secondPass, 0.0f, false, 0, 0, false, 496, null);
            }
            if (targetLuxuries <= 0) continue;
            for (String luxury : randomLuxuries) {
                TileResource tileResource = ruleset.getTileResources().get(luxury);
                Intrinsics.checkNotNull(tileResource);
                if (MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, tileResource, 1, firstPass, 0.0f, false, 0, 0, false, 496, null) <= 0) continue;
                continue block2;
            }
        }
    }

    private static final float assignLuxuries$lambda$4(GameContext $regionConditional, HashMap $amountRegionsWithLuxury, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Unique weightingUnique = SequencesKt.firstOrNull(it.getMatchingUniques(UniqueType.ResourceWeighting, $regionConditional));
        float relativeWeight = weightingUnique == null ? 1.0f : Float.parseFloat(weightingUnique.getParams().get(0));
        Object v = $amountRegionsWithLuxury.get(it.getName());
        Intrinsics.checkNotNull(v);
        return relativeWeight / (1.0f + ((Number)v).floatValue());
    }

    private static final float assignCityStateLuxuries$lambda$0$1(TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Unique weightingUnique = (Unique)SequencesKt.firstOrNull(IHasUniques.getMatchingUniques$default(it, UniqueType.LuxuryWeightingForCityStates, null, 2, null));
        return weightingUnique == null ? 1.0f : Float.parseFloat(weightingUnique.getParams().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean addRegionalLuxuries$isShoreOfContinent(Tile $this$addRegionalLuxuries_u24isShoreOfContinent, int continent) {
        boolean bl;
        if (!$this$addRegionalLuxuries_u24isShoreOfContinent.isWater()) return false;
        Sequence<Tile> $this$any$iv = $this$addRegionalLuxuries_u24isShoreOfContinent.getNeighbors();
        boolean $i$f$any = false;
        Iterator<Tile> iterator2 = $this$any$iv.iterator();
        do {
            Tile element$iv;
            if (!iterator2.hasNext()) return false;
            Tile it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (it.getContinent() == continent) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean addRegionalLuxuries$lambda$1(Region $region, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return LuxuryResourcePlacementLogic.addRegionalLuxuries$isShoreOfContinent(it, $region.getContinentID());
    }
}

