/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007J'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/map/mapunit/UnitUpgradeManager;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "canUpgrade", "", "unitToUpgradeTo", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "ignoreRequirements", "ignoreResources", "getCostOfUpgrade", "", "performUpgrade", "", "upgradedUnit", "isFree", "goldCostOfUpgrade", "(Lcom/unciv/models/ruleset/unit/BaseUnit;ZLjava/lang/Integer;)V", "core"})
public final class UnitUpgradeManager {
    @NotNull
    private final MapUnit unit;

    public UnitUpgradeManager(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @Readonly
    public final boolean canUpgrade(@NotNull BaseUnit unitToUpgradeTo, boolean ignoreRequirements, boolean ignoreResources) {
        Intrinsics.checkNotNullParameter(unitToUpgradeTo, "unitToUpgradeTo");
        if (Intrinsics.areEqual(this.unit.getName(), unitToUpgradeTo.getName())) {
            return false;
        }
        Sequence rejectionReasons = BaseUnit.getRejectionReasons$default(unitToUpgradeTo, this.unit.getCiv(), null, this.unit.getResourceRequirementsPerTurn(), 2, null);
        Sequence<RejectionReason> relevantRejectionReasons = SequencesKt.filterNot(rejectionReasons, UnitUpgradeManager::canUpgrade$lambda$0);
        if (ignoreRequirements) {
            relevantRejectionReasons = SequencesKt.filterNot(relevantRejectionReasons, UnitUpgradeManager::canUpgrade$lambda$1);
        }
        if (ignoreResources) {
            relevantRejectionReasons = SequencesKt.filterNot(relevantRejectionReasons, UnitUpgradeManager::canUpgrade$lambda$2);
        }
        return SequencesKt.none(relevantRejectionReasons);
    }

    public static /* synthetic */ boolean canUpgrade$default(UnitUpgradeManager unitUpgradeManager, BaseUnit baseUnit, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return unitUpgradeManager.canUpgrade(baseUnit, bl, bl2);
    }

    @Readonly
    public final int getCostOfUpgrade(@NotNull BaseUnit unitToUpgradeTo) {
        Intrinsics.checkNotNullParameter(unitToUpgradeTo, "unitToUpgradeTo");
        int goldCostOfUpgrade = 0;
        Ruleset ruleset = this.unit.getCiv().getGameInfo().getRuleset();
        ModConstants.UnitUpgradeCost constants = ruleset.getModOptions().getConstants().getUnitUpgradeCost();
        float civModifier = 1.0f;
        GameContext stateForConditionals = this.unit.getCache().getState();
        Iterator<Unique> iterator2 = this.unit.getCiv().getMatchingUniques(UniqueType.UnitUpgradeCost, stateForConditionals).iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            civModifier *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        float cost = constants.getBase();
        cost += RangesKt.coerceAtLeast(constants.getPerProduction() * (float)(unitToUpgradeTo.getCost() - this.unit.getBaseUnit().getCost()), 0.0f);
        Era era = unitToUpgradeTo.era(ruleset);
        if (era != null) {
            cost *= 1.0f + (float)era.getEraNumber() * constants.getEraMultiplier();
        }
        cost = (float)Math.pow(cost * civModifier, constants.getExponent());
        return goldCostOfUpgrade += (int)((cost *= this.unit.getCiv().getGameInfo().getSpeed().getModifier()) / (float)constants.getRoundTo()) * constants.getRoundTo();
    }

    public final void performUpgrade(@NotNull BaseUnit upgradedUnit, boolean isFree, @Nullable Integer goldCostOfUpgrade) {
        Intrinsics.checkNotNullParameter(upgradedUnit, "upgradedUnit");
        if (this.unit.isDestroyed()) {
            return;
        }
        this.unit.destroy(false);
        Civilization civ = this.unit.getCiv();
        Vector2 position = this.unit.getCurrentTile().getPosition();
        MapUnit newUnit = civ.getUnits().placeUnitNearTile(position, upgradedUnit, this.unit.getId());
        if (newUnit == null) {
            MapUnit mapUnit = UnitManager.placeUnitNearTile$default(civ.getUnits(), position, this.unit.getBaseUnit(), null, 4, null);
            Intrinsics.checkNotNull(mapUnit);
            MapUnit resurrectedUnit = mapUnit;
            this.unit.copyStatisticsTo(resurrectedUnit);
            return;
        }
        if (!isFree) {
            Integer n = goldCostOfUpgrade;
            civ.addGold(-(n != null ? n.intValue() : this.getCostOfUpgrade(upgradedUnit)));
        }
        this.unit.copyStatisticsTo(newUnit);
        newUnit.setCurrentMovement(0.0f);
        if (newUnit.isFortified() && !newUnit.canFortify(true)) {
            newUnit.setAction(null);
        }
        if (newUnit.isGuarding() && !MapUnit.hasUnique$default(newUnit, UniqueType.WithdrawsBeforeMeleeCombat, null, false, 6, null)) {
            newUnit.setAction(null);
        }
    }

    public static /* synthetic */ void performUpgrade$default(UnitUpgradeManager unitUpgradeManager, BaseUnit baseUnit, boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        unitUpgradeManager.performUpgrade(baseUnit, bl, n);
    }

    private static final boolean canUpgrade$lambda$0(RejectionReason it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isConstructionRejection() || it.getType() == RejectionReasonType.Obsoleted;
    }

    private static final boolean canUpgrade$lambda$1(RejectionReason it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.techPolicyEraWonderRequirements();
    }

    private static final boolean canUpgrade$lambda$2(RejectionReason it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == RejectionReasonType.ConsumesResources;
    }
}

