/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.EspionageAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.managers.EspionageManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.TileMap;
import com.unciv.models.SpyAction;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001FB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00102\b\b\u0002\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020!J\b\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020(H\u0003J\b\u0010)\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020!H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0017H\u0002J\b\u0010-\u001a\u00020.H\u0007J\b\u0010/\u001a\u00020!H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020.H\u0007J\u0010\u00103\u001a\u00020!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0010\u00104\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\u0010\u00105\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u00106\u001a\u00020.H\u0007J\b\u00107\u001a\u00020.H\u0007J\b\u00108\u001a\u00020.H\u0007J\n\u00109\u001a\u0004\u0018\u00010\u001eH\u0007J\b\u0010:\u001a\u00020\u001eH\u0007J\b\u0010;\u001a\u00020\u0005H\u0007J\u0010\u0010<\u001a\u00020!2\b\b\u0002\u0010=\u001a\u00020\u0007J\b\u0010>\u001a\u00020\u0007H\u0007J\b\u0010?\u001a\u00020@H\u0007J\b\u0010A\u001a\u00020!H\u0002J\b\u0010B\u001a\u00020.H\u0007J\u000e\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020\u0005J\b\u0010E\u001a\u00020\u0007H\u0003R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/unciv/models/Spy;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "name", "", "rank", "", "(Ljava/lang/String;I)V", "value", "getName", "()Ljava/lang/String;", "getRank", "()I", "location", "Lcom/badlogic/gdx/math/Vector2;", "Lcom/unciv/models/SpyAction;", "action", "getAction", "()Lcom/unciv/models/SpyAction;", "turnsRemainingForAction", "getTurnsRemainingForAction", "progressTowardsStealingTech", "Lcom/unciv/logic/civilization/Civilization;", "civInfo", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "espionageManager", "Lcom/unciv/logic/civilization/managers/EspionageManager;", "city", "Lcom/unciv/logic/city/City;", "clone", "setTransients", "", "setAction", "newAction", "turns", "endTurn", "startStealingTech", "canStealTech", "Lcom/unciv/models/Spy$CanStealTech;", "incrementTechStealingProgress", "stealTech", "demandToNotBeSpiedOn", "otherCiv", "canDoCoup", "", "initiateCoup", "getCoupChanceOfSuccess", "", "includeunknownFactors", "moveTo", "canDismissAgreementToNotSendSpies", "canMoveTo", "isSetUp", "isIdle", "isDoingWork", "getCityOrNull", "getCity", "getLocationName", "levelUpSpy", "amount", "getSkillModifierPercent", "getEfficiencyModifier", "", "killSpy", "isAlive", "addNotification", "text", "randomSeed", "CanStealTech", "core"})
@SourceDebugExtension(value={"SMAP\nSpy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spy.kt\ncom/unciv/models/Spy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n1#2:478\n*E\n"})
public final class Spy
implements IsPartOfGameInfoSerialization {
    private String name;
    private int rank;
    @Nullable
    private Vector2 location;
    @NotNull
    private SpyAction action;
    private int turnsRemainingForAction;
    private int progressTowardsStealingTech;
    private transient Civilization civInfo;
    private transient EspionageManager espionageManager;
    @Nullable
    private transient City city;

    private Spy() {
        this.rank = 1;
        this.action = SpyAction.None;
    }

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("name");
        return null;
    }

    public final int getRank() {
        return this.rank;
    }

    @NotNull
    public final SpyAction getAction() {
        return this.action;
    }

    public final int getTurnsRemainingForAction() {
        return this.turnsRemainingForAction;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public Spy(@NotNull String name, int rank) {
        Intrinsics.checkNotNullParameter(name, "name");
        this();
        this.name = name;
        this.rank = rank;
    }

    @NotNull
    public final Spy clone() {
        Spy toReturn = new Spy(this.getName(), this.rank);
        toReturn.location = this.location;
        toReturn.action = this.action;
        toReturn.turnsRemainingForAction = this.turnsRemainingForAction;
        toReturn.progressTowardsStealingTech = this.progressTowardsStealingTech;
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.espionageManager = civInfo.getEspionageManager();
    }

    public final void setAction(@NotNull SpyAction newAction, int turns) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newAction, "newAction");
        boolean bl2 = bl = !newAction.getHasCountdownTurns() || turns > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.action = newAction;
        this.turnsRemainingForAction = turns;
    }

    public static /* synthetic */ void setAction$default(Spy spy, SpyAction spyAction, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        spy.setAction(spyAction, n);
    }

    public final void endTurn() {
        if (this.action.getHasCountdownTurns()) {
            this.turnsRemainingForAction += -1;
            if (this.turnsRemainingForAction > 0) {
                return;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.action.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (Intrinsics.areEqual(this.getCity().getCiv(), this.getCivInfo())) {
                    this.setAction(SpyAction.CounterIntelligence, 10);
                    break;
                }
                this.setAction(SpyAction.EstablishNetwork, 3);
                break;
            }
            case 3: {
                City city = this.getCity();
                if (city.getCiv().isCityState()) {
                    Integer n = this.getCity().getCiv().getFlagsCountdown().get("TurnsTillCityStateElection");
                    this.setAction(SpyAction.RiggingElections, (n != null ? n : 1) - 1);
                    break;
                }
                if (Intrinsics.areEqual(city.getCiv(), this.getCivInfo())) {
                    this.setAction(SpyAction.CounterIntelligence, 10);
                    break;
                }
                this.startStealingTech();
                break;
            }
            case 4: {
                if (!this.getCity().getCiv().isMajorCiv()) {
                    return;
                }
                if (this.canStealTech() != CanStealTech.Yes) {
                    return;
                }
                Spy.setAction$default(this, SpyAction.StealingTech, 0, 2, null);
                break;
            }
            case 5: {
                CanStealTech canStealTechResult = this.canStealTech();
                if (canStealTechResult != CanStealTech.Yes) {
                    Spy.setAction$default(this, SpyAction.Surveillance, 0, 2, null);
                    if (canStealTechResult == CanStealTech.NoTechsToSteal) {
                        this.addNotification("Your spy [" + this.getName() + "] cannot steal any more techs from [" + this.getCity().getCiv() + "] as we've already researched all the technology they know!");
                    }
                    return;
                }
                this.turnsRemainingForAction = this.incrementTechStealingProgress();
                if (this.turnsRemainingForAction != 0) break;
                this.stealTech();
                break;
            }
            case 6: {
                Integer n = this.getCity().getCiv().getFlagsCountdown().get("TurnsTillCityStateElection");
                this.turnsRemainingForAction = (n != null ? n : 0) - 1;
                break;
            }
            case 7: {
                this.initiateCoup();
                break;
            }
            case 8: {
                String oldSpyName = this.getName();
                EspionageManager espionageManager = this.espionageManager;
                if (espionageManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                    espionageManager = null;
                }
                this.name = espionageManager.getSpyName();
                Spy.setAction$default(this, SpyAction.None, 0, 2, null);
                EspionageManager espionageManager2 = this.espionageManager;
                if (espionageManager2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                    espionageManager2 = null;
                }
                this.rank = espionageManager2.getStartingSpyRank();
                this.addNotification("We have recruited a new spy name [" + this.getName() + "] after [" + oldSpyName + "] was killed.");
                break;
            }
            case 9: {
                this.turnsRemainingForAction += -1;
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void startStealingTech() {
        this.progressTowardsStealingTech = 0;
        Spy.setAction$default(this, SpyAction.StealingTech, 0, 2, null);
    }

    @Readonly
    private final CanStealTech canStealTech() {
        Set<String> stealableTechs;
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        if ((stealableTechs = espionageManager.getTechsToSteal(this.getCity().getCiv())).isEmpty()) {
            return CanStealTech.NoTechsToSteal;
        }
        float cityScience = this.getCity().getCityStats().getCurrentCityStats().getScience();
        if (cityScience <= 0.0f) {
            return CanStealTech.NoScienceInCity;
        }
        return CanStealTech.Yes;
    }

    private final int incrementTechStealingProgress() {
        Object object;
        Set<String> stealableTechs;
        Iterator iterator2;
        boolean bl;
        boolean bl2 = bl = this.canStealTech() == CanStealTech.Yes;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        float progressThisTurn = this.getCity().getCityStats().getCurrentCityStats().getScience();
        int rankTechStealModifier = this.rank * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getSpyRankStealPercentBonus();
        progressThisTurn *= ((float)rankTechStealModifier + 75.0f) / 100.0f;
        this.progressTowardsStealingTech += (int)(progressThisTurn *= (float)this.getEfficiencyModifier());
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        if (!(iterator2 = ((Iterable)(stealableTechs = espionageManager.getTechsToSteal(this.getCity().getCiv()))).iterator()).hasNext()) {
            object = null;
        } else {
            Object it = (String)iterator2.next();
            boolean bl3 = false;
            Technology technology = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().get(it);
            Intrinsics.checkNotNull(technology);
            it = technology.getCost();
            while (iterator2.hasNext()) {
                String it2 = (String)iterator2.next();
                $i$a$-maxOfOrNull-Spy$incrementTechStealingProgress$techStealCost$1 = false;
                Technology technology2 = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().get(it2);
                Intrinsics.checkNotNull(technology2);
                Comparable comparable = Integer.valueOf(technology2.getCost());
                if (it.compareTo(comparable) >= 0) continue;
                it = comparable;
            }
            object = it;
        }
        Intrinsics.checkNotNull(object);
        float techStealCost = ((Number)object).intValue();
        float techStealCostModifier = this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getSpyTechStealCostModifier();
        float techSpeedModifier = this.getCivInfo().getGameInfo().getSpeed().getScienceCostModifier();
        float remainingCost = (techStealCost *= techStealCostModifier * techSpeedModifier) - (float)this.progressTowardsStealingTech;
        if (remainingCost <= 0.0f) {
            return 0;
        }
        return (int)Math.ceil(remainingCost / progressThisTurn);
    }

    private final void stealTech() {
        String detectionString;
        Spy defendingSpy;
        City city = this.getCity();
        Civilization otherCiv = city.getCiv();
        int randomSeed = this.randomSeed();
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        String stolenTech = (String)CollectionsKt.randomOrNull((Collection)espionageManager.getTechsToSteal(this.getCity().getCiv()), RandomKt.Random(randomSeed));
        int spyResult = RandomKt.Random(randomSeed).nextInt(300);
        spyResult -= this.getSkillModifierPercent();
        Spy spy = defendingSpy = city.getCiv().getEspionageManager().getSpyAssignedToCity(city);
        int n = spy != null ? spy.getSkillModifierPercent() : 0;
        String string = (spyResult += n) >= 200 ? (defendingSpy == null ? "A spy from [" + this.getCivInfo().getCivName() + "] was found and killed trying to steal Technology in [" + city + "]!" : "A spy from [" + this.getCivInfo().getCivName() + "] was found and killed by [" + defendingSpy.getName() + "] trying to steal Technology in [" + city + "]!") : (stolenTech == null ? null : (spyResult < 0 ? null : (detectionString = spyResult < 100 ? "An unidentified spy stole the Technology [" + stolenTech + "] from [" + city + "]!" : "A spy from [" + this.getCivInfo().getCivName() + "] stole the Technology [" + stolenTech + "] from [" + city + "]!")));
        if (detectionString != null) {
            String[] stringArray = new String[]{"OtherIcons/Spy"};
            otherCiv.addNotification(detectionString, city.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
        }
        if (spyResult < 200 && stolenTech != null) {
            TechManager.addTechnology$default(this.getCivInfo().getTech(), stolenTech, false, 2, null);
            this.addNotification("Your spy [" + this.getName() + "] stole the Technology [" + stolenTech + "] from [" + city + "]!");
            Spy.levelUpSpy$default(this, 0, 1, null);
        }
        if (spyResult >= 200) {
            this.addNotification("Your spy [" + this.getName() + "] was killed trying to steal Technology in [" + city + "]!");
            Spy spy2 = defendingSpy;
            if (spy2 != null) {
                Spy.levelUpSpy$default(spy2, 0, 1, null);
            }
            this.killSpy();
            this.demandToNotBeSpiedOn(otherCiv);
        } else {
            this.startStealingTech();
        }
        if (spyResult >= 100) {
            this.demandToNotBeSpiedOn(otherCiv);
        }
    }

    private final void demandToNotBeSpiedOn(Civilization otherCiv) {
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        otherCivDiplomacyManager.addModifier(DiplomaticModifiers.SpiedOnUs, -15.0f);
        otherCivDiplomacyManager.setFlag(DiplomacyFlags.DiscoveredSpiesInOurCities, 30);
    }

    @Readonly
    public final boolean canDoCoup() {
        return this.getCityOrNull() != null && this.getCity().getCiv().isCityState() && this.isSetUp() && !Intrinsics.areEqual(this.getCity().getCiv().getAllyCivName(), this.getCivInfo().getCivName());
    }

    private final void initiateCoup() {
        block10: {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
            Civilization allyCiv;
            Civilization cityState;
            block9: {
                float f;
                Civilization civilization;
                if (!this.canDoCoup()) {
                    this.setAction(SpyAction.RiggingElections, 10);
                    return;
                }
                cityState = this.getCity().getCiv();
                String string = cityState.getAllyCivName();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    civilization = this.getCivInfo().getGameInfo().getCivilization(it);
                } else {
                    civilization = null;
                }
                allyCiv = civilization;
                float successChance = this.getCoupChanceOfSuccess(true);
                float randomValue = RandomKt.Random(this.randomSeed()).nextFloat();
                if (!(randomValue <= successChance)) break block9;
                Civilization civilization2 = allyCiv;
                if (civilization2 != null) {
                    DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civilization2);
                    Intrinsics.checkNotNull(diplomacyManager);
                    f = diplomacyManager.getInfluence();
                } else {
                    f = 80.0f;
                }
                float previousInfluence = f;
                DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(this.getCivInfo());
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.setInfluence(previousInfluence);
                Object object = new String[]{"OtherIcons/Spy", cityState.getCivName()};
                this.getCivInfo().addNotification("Your spy [" + this.getName() + "] successfully staged a coup in [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, (String[])object);
                if (allyCiv != null) {
                    cityState.getDiplomacyManagerOrMeet(allyCiv).reduceInfluence(20.0f);
                    object = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                    allyCiv.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] successfully staged a coup in our former ally [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, (String[])object);
                    allyCiv.getDiplomacyManagerOrMeet(this.getCivInfo()).addModifier(DiplomaticModifiers.SpiedOnUs, -15.0f);
                }
                object = cityState.getKnownCivsWithSpectators().iterator();
                while (object.hasNext()) {
                    Civilization civ = (Civilization)object.next();
                    if (Intrinsics.areEqual(civ, allyCiv) || Intrinsics.areEqual(civ, this.getCivInfo())) continue;
                    String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                    civ.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] successfully staged a coup in [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
                    if (civ.isSpectator()) continue;
                    DiplomacyManager diplomacyManager2 = cityState.getDiplomacyManager(civ);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    diplomacyManager2.reduceInfluence(10.0f);
                }
                this.setAction(SpyAction.RiggingElections, 10);
                cityState.getCityStateFunctions().updateAllyCivForCityState();
                break block10;
            }
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization2 = allyCiv;
            Spy spy = isPartOfGameInfoSerialization2 != null && (isPartOfGameInfoSerialization2 = ((Civilization)isPartOfGameInfoSerialization2).getEspionageManager()) != null ? ((EspionageManager)isPartOfGameInfoSerialization2).getSpyAssignedToCity(this.getCity()) : null;
            DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(-20.0f);
            Civilization civilization = allyCiv;
            if (civilization != null) {
                String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                civilization.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] failed to stage a coup in our ally [" + cityState.getCivName() + "] and was killed!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
            if ((isPartOfGameInfoSerialization = allyCiv) != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getDiplomacyManagerOrMeet(this.getCivInfo())) != null) {
                ((DiplomacyManager)isPartOfGameInfoSerialization).addModifier(DiplomaticModifiers.SpiedOnUs, -10.0f);
            }
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
            this.getCivInfo().addNotification("Our spy [" + this.getName() + "] failed to stage a coup in [" + cityState.getCivName() + "] and was killed!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            this.killSpy();
            Spy spy2 = spy;
            if (spy2 == null) break block10;
            Spy.levelUpSpy$default(spy2, 0, 1, null);
        }
    }

    @Readonly
    public final float getCoupChanceOfSuccess(boolean includeunknownFactors) {
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
        float f;
        Civilization cityState = this.getCity().getCiv();
        float successPercentage = 50.0f;
        if (cityState.getAllyCivName() != null) {
            String string = cityState.getAllyCivName();
            Intrinsics.checkNotNull(string);
            DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(string);
            Intrinsics.checkNotNull(diplomacyManager);
            f = diplomacyManager.getInfluence();
        } else {
            f = 60.0f;
        }
        float influenceDifference = f;
        DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(this.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        successPercentage -= (influenceDifference -= diplomacyManager.getInfluence()) / 2.0f;
        Spy defendingSpy = includeunknownFactors ? ((isPartOfGameInfoSerialization = cityState.getAllyCiv()) != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getEspionageManager()) != null ? ((EspionageManager)isPartOfGameInfoSerialization).getSpyAssignedToCity(this.getCity()) : null) : null;
        Spy spy = defendingSpy;
        int spyRanks = this.getSkillModifierPercent() - (spy != null ? spy.getSkillModifierPercent() : 0);
        successPercentage += (float)spyRanks / 2.0f;
        successPercentage = RangesKt.coerceIn(successPercentage, 0.0f, 85.0f);
        return successPercentage / 100.0f;
    }

    public final void moveTo(@Nullable City city) {
        if (city == null) {
            this.location = null;
            this.city = null;
            Spy.setAction$default(this, SpyAction.None, 0, 2, null);
            return;
        }
        this.location = city.getLocation();
        this.city = city;
        this.setAction(SpyAction.Moving, 1);
    }

    @Readonly
    private final boolean canDismissAgreementToNotSendSpies(City city) {
        DiplomacyManager diplomacyManager = city.getCiv().getDiplomacyManager(this.getCivInfo());
        if (diplomacyManager == null) {
            return false;
        }
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        Civilization otherCiv = otherCivDiplomacyManager.getCivInfo();
        float techSize = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().values().size();
        float ourResearchTechSize = this.getCivInfo().getTech().getTechsResearched().size();
        float otherCivResearchTechSize = otherCiv.getTech().getTechsResearched().size();
        float ourTechResearchLevel = ourResearchTechSize / techSize * 100.0f;
        float otherCivTechResearchLevel = otherCivResearchTechSize / techSize * 100.0f;
        return otherCivDiplomacyManager.hasFlag(DiplomacyFlags.AgreedToNotSendSpies) && otherCivTechResearchLevel <= ourTechResearchLevel + 10.0f;
    }

    @Readonly
    public final boolean canMoveTo(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        if (this.canDismissAgreementToNotSendSpies(city)) {
            return false;
        }
        if (Intrinsics.areEqual(this.getCityOrNull(), city)) {
            return true;
        }
        if (!city.getCenterTile().isExplored(this.getCivInfo())) {
            return false;
        }
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        return espionageManager.getSpyAssignedToCity(city) == null;
    }

    @Readonly
    public final boolean isSetUp() {
        return this.action.isSetUp$core();
    }

    @Readonly
    public final boolean isIdle() {
        return this.action == SpyAction.None;
    }

    @Readonly
    public final boolean isDoingWork() {
        return this.action.isDoingWork$core(this);
    }

    @Readonly
    @Nullable
    public final City getCityOrNull() {
        if (this.location == null) {
            return null;
        }
        if (this.city == null) {
            TileMap tileMap = this.getCivInfo().getGameInfo().getTileMap();
            Vector2 vector2 = this.location;
            Intrinsics.checkNotNull(vector2);
            this.city = tileMap.get(vector2).getCity();
        }
        return this.city;
    }

    @Readonly
    @NotNull
    public final City getCity() {
        City city = this.getCityOrNull();
        Intrinsics.checkNotNull(city);
        return city;
    }

    @Readonly
    @NotNull
    public final String getLocationName() {
        Object object = this.getCityOrNull();
        if (object == null || (object = ((City)object).getName()) == null) {
            object = "Spy Hideout";
        }
        return object;
    }

    public final void levelUpSpy(int amount) {
        if (this.rank >= this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMaxSpyRank()) {
            return;
        }
        int ranksToLevelUp = RangesKt.coerceAtMost(amount, this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMaxSpyRank() - this.rank);
        if (ranksToLevelUp == 1) {
            this.addNotification("Your spy [" + this.getName() + "] has leveled up!");
        } else {
            this.addNotification("Your spy [" + this.getName() + "] has leveled up [" + ranksToLevelUp + "] times!");
        }
        this.rank += ranksToLevelUp;
    }

    public static /* synthetic */ void levelUpSpy$default(Spy spy, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        spy.levelUpSpy(n);
    }

    @Readonly
    public final int getSkillModifierPercent() {
        return this.rank * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getSpyRankSkillPercentBonus();
    }

    @Readonly
    public final double getEfficiencyModifier() {
        int n;
        Unique it;
        int n2;
        Object object;
        Sequence<Object> friendlyUniques = null;
        Sequence<Object> enemyUniques = null;
        City city = this.getCityOrNull();
        if (city == null) {
            friendlyUniques = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyEffectiveness, null, 2, null);
            enemyUniques = SequencesKt.emptySequence();
        } else if (Intrinsics.areEqual(city.getCiv(), this.getCivInfo())) {
            friendlyUniques = city.getMatchingUniques(UniqueType.SpyEffectiveness, city.getState(), true);
            enemyUniques = SequencesKt.emptySequence();
        } else {
            friendlyUniques = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyEffectiveness, null, 2, null);
            enemyUniques = city.getMatchingUniques(UniqueType.EnemySpyEffectiveness, city.getState(), true);
        }
        double totalEfficiency = 1.0;
        Sequence<Object> sequence = friendlyUniques;
        double d = 100.0;
        double d2 = totalEfficiency;
        int n3 = 0;
        Iterator<Object> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            Unique unique = (Unique)object;
            n2 = n3;
            boolean bl = false;
            n = Integer.parseInt(it.getParams().get(0));
            n3 = n2 + n;
        }
        n2 = n3;
        totalEfficiency = d2 * ((d + (double)n2) / (double)100);
        sequence = enemyUniques;
        d = 100.0;
        d2 = totalEfficiency;
        n3 = 0;
        iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            it = (Unique)object;
            n2 = n3;
            boolean bl = false;
            n = Integer.parseInt(it.getParams().get(0));
            n3 = n2 + n;
        }
        n2 = n3;
        totalEfficiency = d2 * ((d + (double)n2) / (double)100);
        return RangesKt.coerceAtLeast(totalEfficiency, 0.0);
    }

    private final void killSpy() {
        this.moveTo(null);
        this.setAction(SpyAction.Dead, 5);
        this.rank = 1;
    }

    @Readonly
    public final boolean isAlive() {
        return this.action != SpyAction.Dead;
    }

    public final void addNotification(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        String[] stringArray = new String[]{"OtherIcons/Spy"};
        this.getCivInfo().addNotification(text2, EspionageAction.Companion.withLocation(this.location), Notification.NotificationCategory.Espionage, stringArray);
    }

    @Readonly
    private final int randomSeed() {
        City $this$randomSeed_u24lambda_u240 = this.getCity();
        boolean bl = false;
        return (int)($this$randomSeed_u24lambda_u240.getLocation().x * $this$randomSeed_u24lambda_u240.getLocation().y + 123.0f * (float)this.getCivInfo().getGameInfo().getTurns()) + this.getName().hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/models/Spy$CanStealTech;", "", "<init>", "(Ljava/lang/String;I)V", "Yes", "NoTechsToSteal", "NoScienceInCity", "core"})
    public static final class CanStealTech
    extends Enum<CanStealTech> {
        public static final /* enum */ CanStealTech Yes = new CanStealTech();
        public static final /* enum */ CanStealTech NoTechsToSteal = new CanStealTech();
        public static final /* enum */ CanStealTech NoScienceInCity = new CanStealTech();
        private static final /* synthetic */ CanStealTech[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CanStealTech[] values() {
            return (CanStealTech[])$VALUES.clone();
        }

        public static CanStealTech valueOf(String value) {
            return Enum.valueOf(CanStealTech.class, value);
        }

        @NotNull
        public static EnumEntries<CanStealTech> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = canStealTechArray = new CanStealTech[]{CanStealTech.Yes, CanStealTech.NoTechsToSteal, CanStealTech.NoScienceInCity};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpyAction.values().length];
            try {
                nArray[SpyAction.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Moving.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.EstablishNetwork.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Surveillance.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.StealingTech.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.RiggingElections.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Coup.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Dead.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.CounterIntelligence.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

