/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.stats.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\"\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u000f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180<H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000f0>2\u0006\u0010?\u001a\u00020\u000fH\u0002R\u001b\u0010\b\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nRJ\u0010\r\u001a>\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\u0010j\b\u0012\u0004\u0012\u00020\u000f`\u00110\u000ej\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\u0010j\b\u0012\u0004\u0012\u00020\u000f`\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/unciv/models/ruleset/validation/BaseRulesetValidator;", "Lcom/unciv/models/ruleset/validation/RulesetValidator;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tryFixUnknownUniques", "", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Z)V", "vanillaRuleset", "getVanillaRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "vanillaRuleset$delegate", "Lkotlin/Lazy;", "prereqsHashMap", "Ljava/util/HashMap;", "", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "anyAncientRuins", "getAnyAncientRuins", "()Z", "anyAncientRuins$delegate", "checkBuilding", "", "building", "Lcom/unciv/models/ruleset/Building;", "lines", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "addDifficultyErrors", "addEraErrors", "addImprovementErrors", "addModOptionsErrors", "checkNation", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "addPersonalityErrors", "addPolicyErrors", "addPromotionErrors", "checkPromotion", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "checkPromotionCircularReferences", "addResourceErrors", "addRuinsErrors", "addSpecialistErrors", "addTechErrors", "addTerrainErrors", "addUnitErrors", "checkUnit", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "addVictoryTypeErrors", "checkUniqueToMisspelling", "obj", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "uniqueTo", "checkUnitType", "type", "reportError", "Lkotlin/Function0;", "getPrereqTree", "", "technologyName", "core"})
@SourceDebugExtension(value={"SMAP\nBaseRulesetValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseRulesetValidator.kt\ncom/unciv/models/ruleset/validation/BaseRulesetValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,479:1\n2746#2,3:480\n2746#2,3:483\n1374#2:486\n1460#2,5:487\n1761#2,3:492\n2746#2,3:495\n2746#2,3:498\n1374#2:501\n1460#2,5:502\n1255#3,2:507\n*S KotlinDebug\n*F\n+ 1 BaseRulesetValidator.kt\ncom/unciv/models/ruleset/validation/BaseRulesetValidator\n*L\n112#1:480,3\n115#1:483,3\n201#1:486\n201#1:487,5\n309#1:492,3\n330#1:495,3\n356#1:498,3\n443#1:501\n443#1:502,5\n37#1:507,2\n*E\n"})
public final class BaseRulesetValidator
extends RulesetValidator {
    @NotNull
    private final Lazy vanillaRuleset$delegate;
    @NotNull
    private final HashMap<String, HashSet<String>> prereqsHashMap;
    @NotNull
    private final Lazy anyAncientRuins$delegate;

    public BaseRulesetValidator(@NotNull Ruleset ruleset, boolean tryFixUnknownUniques) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        super(ruleset, tryFixUnknownUniques);
        this.vanillaRuleset$delegate = LazyKt.lazy(BaseRulesetValidator::vanillaRuleset_delegate$lambda$0);
        this.prereqsHashMap = new HashMap();
        this.anyAncientRuins$delegate = LazyKt.lazy(() -> BaseRulesetValidator.anyAncientRuins_delegate$lambda$0(ruleset));
        this.getUniqueValidator().populateFilteringUniqueHashsets();
    }

    private final Ruleset getVanillaRuleset() {
        Lazy lazy = this.vanillaRuleset$delegate;
        return (Ruleset)lazy.getValue();
    }

    private final boolean getAnyAncientRuins() {
        Lazy lazy = this.anyAncientRuins$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    protected void checkBuilding(@NotNull Building building, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.checkBuilding(building, lines2);
        Iterator<Object> iterator2 = ((Map)building.getGreatPersonPoints()).entrySet().iterator();
        while (iterator2.hasNext()) {
            String gppName = (String)iterator2.next().getKey();
            if (this.getRuleset().getUnits().containsKey(gppName)) continue;
            RulesetErrorList.add$default(lines2, "Building " + building.getName() + " has greatPersonPoints for " + gppName + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
        iterator2 = building.requiredTechs().iterator();
        while (iterator2.hasNext()) {
            String requiredTech = (String)iterator2.next();
            if (this.getRuleset().getTechnologies().containsKey(requiredTech)) continue;
            RulesetErrorList.add$default(lines2, building.getName() + " requires tech " + requiredTech + " which does not exist!", null, building, null, 10, null);
        }
        for (Object object : building.getSpecialistSlots().keySet()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            String specialistName = (String)object;
            if (this.getRuleset().getSpecialists().containsKey(specialistName)) continue;
            RulesetErrorList.add$default(lines2, building.getName() + " provides specialist " + specialistName + " which does not exist!", null, building, null, 10, null);
        }
        for (Object object : building.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).keySet()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            String resource = (String)object;
            if (this.getRuleset().getTileResources().containsKey(resource)) continue;
            RulesetErrorList.add$default(lines2, building.getName() + " requires resource " + resource + " which does not exist!", null, building, null, 10, null);
        }
        if (building.getReplaces() != null) {
            LinkedHashMap<String, Building> linkedHashMap = this.getRuleset().getBuildings();
            String string = building.getReplaces();
            Intrinsics.checkNotNull(string);
            if (!linkedHashMap.containsKey(string)) {
                RulesetErrorList.add$default(lines2, building.getName() + " replaces " + building.getReplaces() + " which does not exist!", null, building, null, 10, null);
            }
        }
        if (building.getRequiredBuilding() != null) {
            LinkedHashMap<String, Building> linkedHashMap = this.getRuleset().getBuildings();
            String string = building.getRequiredBuilding();
            Intrinsics.checkNotNull(string);
            if (!linkedHashMap.containsKey(string)) {
                RulesetErrorList.add$default(lines2, building.getName() + " requires " + building.getRequiredBuilding() + " which does not exist!", null, building, null, 10, null);
            }
        }
        this.checkUniqueToMisspelling(building, building.getUniqueTo(), lines2);
    }

    @Override
    protected void addDifficultyErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addDifficultyErrors(lines2);
        Iterator<Difficulty> iterator2 = this.getRuleset().getDifficulties().values().iterator();
        while (iterator2.hasNext()) {
            Difficulty difficulty;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            for (String unitName : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)difficulty.getAiCityStateBonusStartingUnits(), (Iterable)difficulty.getAiMajorCivBonusStartingUnits()), (Iterable)difficulty.getPlayerBonusStartingUnits())) {
                if (Intrinsics.areEqual(unitName, "Era Starting Unit") || this.getRuleset().getUnits().containsKey(unitName)) continue;
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains starting unit " + unitName + " which does not exist!", null, null, null, 10, null);
            }
            if (difficulty.getAiDifficultyLevel() != null && !((Map)this.getRuleset().getDifficulties()).containsKey(difficulty.getAiDifficultyLevel())) {
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains aiDifficultyLevel " + difficulty.getAiDifficultyLevel() + " which does not exist!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            Iterator<String> iterator3 = difficulty.getAiFreeTechs().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator<String> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                String tech;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (this.getRuleset().getTechnologies().containsKey(tech)) continue;
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains AI free tech " + tech + " which does not exist!", null, null, null, 10, null);
            }
        }
    }

    @Override
    protected void addEraErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addEraErrors(lines2);
        if (this.getRuleset().getEras().isEmpty()) {
            RulesetErrorList.add$default(lines2, "Eras file is empty! This will likely lead to crashes. Ask the mod maker to update this mod!", null, null, null, 10, null);
        }
        HashSet allDifficultiesStartingUnits = new HashSet();
        Iterator<RulesetObject> iterator2 = this.getRuleset().getDifficulties().values().iterator();
        while (iterator2.hasNext()) {
            Difficulty difficulty;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            allDifficultiesStartingUnits.addAll(difficulty.getAiCityStateBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getAiMajorCivBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getPlayerBonusStartingUnits());
        }
        for (RulesetObject rulesetObject : this.getRuleset().getEras().values()) {
            boolean grantsStartingMilitaryUnit;
            BaseUnit it;
            Iterable $this$none$iv;
            Intrinsics.checkNotNullExpressionValue(rulesetObject, "next(...)");
            Era era = (Era)rulesetObject;
            Iterator<String> iterator3 = era.getStartingObsoleteWonders().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator<String> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                String wonder;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (((Map)this.getRuleset().getBuildings()).containsKey(wonder)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent wonder " + wonder + " obsoleted when starting in " + era.getName() + '!', null, era, null, 10, null);
            }
            Iterator<String> iterator5 = era.getSettlerBuildings().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
            iterator4 = iterator5;
            while (iterator4.hasNext()) {
                String building;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (((Map)this.getRuleset().getBuildings()).containsKey(building)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent building " + building + " built by settlers when starting in " + era.getName(), null, era, null, 10, null);
            }
            if (!((Map)this.getRuleset().getUnits()).containsKey(era.getStartingSettlerUnit())) {
                boolean bl;
                block15: {
                    Collection<BaseUnit> collection = this.getRuleset().getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl2 = false;
                            if (!it.isCityFounder()) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era.getStartingSettlerUnit() + " marked as starting unit when starting in " + era.getName(), null, era, null, 10, null);
                }
            }
            if (era.getStartingWorkerCount() != 0 && !((Map)this.getRuleset().getUnits()).containsKey(era.getStartingWorkerUnit())) {
                boolean bl;
                block16: {
                    Collection<BaseUnit> collection = this.getRuleset().getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it);
                            if (!IHasUniques.hasUnique$default(it, UniqueType.BuildImprovements, null, 2, null)) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era.getStartingWorkerUnit() + " marked as starting unit when starting in " + era.getName(), null, era, null, 10, null);
                }
            }
            if (!(grantsStartingMilitaryUnit = era.getStartingMilitaryUnitCount() != 0 || allDifficultiesStartingUnits.contains("Era Starting Unit")) || ((Map)this.getRuleset().getUnits()).containsKey(era.getStartingMilitaryUnit())) continue;
            RulesetErrorList.add$default(lines2, "Nonexistent unit " + era.getStartingMilitaryUnit() + " marked as starting unit when starting in " + era.getName(), null, era, null, 10, null);
        }
    }

    @Override
    protected void addImprovementErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addImprovementErrors(lines2);
        Iterator<TileImprovement> iterator2 = this.getRuleset().getTileImprovements().values().iterator();
        while (iterator2.hasNext()) {
            TileImprovement improvement;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (improvement.getTechRequired() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.getRuleset().getTechnologies();
                String string = improvement.getTechRequired();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, improvement.getName() + " requires tech " + improvement.getTechRequired() + " which does not exist!", null, improvement, null, 10, null);
                }
            }
            if (improvement.getReplaces() != null && !((Map)this.getRuleset().getTileImprovements()).containsKey(improvement.getReplaces())) {
                RulesetErrorList.add$default(lines2, improvement.getName() + " replaces " + improvement.getReplaces() + " which does not exist!", null, improvement, null, 10, null);
            }
            this.checkUniqueToMisspelling(improvement, improvement.getUniqueTo(), lines2);
            for (String terrain : improvement.getTerrainsCanBeBuiltOn()) {
                if (this.getRuleset().getTerrains().containsKey(terrain) || Intrinsics.areEqual(terrain, "Land") || Intrinsics.areEqual(terrain, "Water")) continue;
                RulesetErrorList.add$default(lines2, improvement.getName() + " can be built on terrain " + terrain + " which does not exist!", null, improvement, null, 10, null);
            }
        }
    }

    @Override
    protected void addModOptionsErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addModOptionsErrors(lines2);
        if (((CharSequence)this.getRuleset().getName()).length() == 0 && this.getRuleset().getMods().size() > 1) {
            return;
        }
        Iterator iterator2 = IHasUniques.getMatchingUniques$default(this.getRuleset().getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            RulesetErrorList.add$default(lines2, "Mod option '" + unique.getText() + "' is invalid for a base ruleset.", null, null, null, 10, null);
        }
    }

    @Override
    protected void checkNation(@NotNull Nation nation, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.checkNation(nation, lines2);
        if (!Intrinsics.areEqual(nation.getPreferredVictoryType(), "Neutral") && !((Map)this.getRuleset().getVictories()).containsKey(nation.getPreferredVictoryType())) {
            RulesetErrorList.add$default(lines2, nation.getName() + "'s preferredVictoryType is " + nation.getPreferredVictoryType() + " which does not exist!", null, nation, null, 10, null);
        }
        if (nation.getCityStateType() != null && !((Map)this.getRuleset().getCityStateTypes()).containsKey(nation.getCityStateType())) {
            RulesetErrorList.add$default(lines2, nation.getName() + " is of city-state type " + nation.getCityStateType() + " which does not exist!", null, nation, null, 10, null);
        }
        if (nation.getFavoredReligion() != null && !CollectionsKt.contains((Iterable)this.getRuleset().getReligions(), nation.getFavoredReligion())) {
            RulesetErrorList.add$default(lines2, nation.getName() + " has " + nation.getFavoredReligion() + " as their favored religion, which does not exist!", null, nation, null, 10, null);
        }
    }

    @Override
    protected void addPersonalityErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addPersonalityErrors(lines2);
        Iterator<Personality> iterator2 = this.getRuleset().getPersonalities().values().iterator();
        while (iterator2.hasNext()) {
            Personality personality;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (Intrinsics.areEqual(personality.getPreferredVictoryType(), "Neutral") || ((Map)this.getRuleset().getVictories()).containsKey(personality.getPreferredVictoryType())) continue;
            RulesetErrorList.add$default(lines2, "Preferred victory type " + personality.getPreferredVictoryType() + " does not exist in ruleset", RulesetErrorSeverity.Warning, personality, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addPolicyErrors(@NotNull RulesetErrorList lines2) {
        void $this$flatMapTo$iv$iv;
        Iterator<Policy> prereq22;
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addPolicyErrors(lines2);
        Iterator<Policy> iterator2 = this.getRuleset().getPolicies().values().iterator();
        while (iterator2.hasNext()) {
            Policy policy;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            ArrayList<String> arrayList = policy.getRequires();
            for (Iterator<Policy> prereq22 : arrayList != null ? (List<Iterator<Policy>>)arrayList : CollectionsKt.emptyList()) {
                if (this.getRuleset().getPolicies().containsKey(prereq22)) continue;
                RulesetErrorList.add$default(lines2, policy.getName() + " requires policy " + prereq22 + " which does not exist!", null, policy, null, 10, null);
            }
        }
        for (Policy policy : this.getRuleset().getPolicyBranches().values()) {
            Intrinsics.checkNotNullExpressionValue(policy, "next(...)");
            PolicyBranch branch = (PolicyBranch)policy;
            if (!((Map)this.getRuleset().getEras()).containsKey(branch.getEra())) {
                RulesetErrorList.add$default(lines2, branch.getName() + " requires era " + branch.getEra() + " which does not exist!", null, branch, null, 10, null);
            }
            HashMap policyLocations = new HashMap();
            Intrinsics.checkNotNullExpressionValue(branch.getPolicies().iterator(), "iterator(...)");
            while (prereq22.hasNext()) {
                Policy policy2;
                Intrinsics.checkNotNullExpressionValue(prereq22.next(), "next(...)");
                String policyLocation = "" + policy2.getRow() + '/' + policy2.getColumn();
                Policy existingPolicyInLocation = (Policy)policyLocations.get(policyLocation);
                if (existingPolicyInLocation == null) {
                    ((Map)policyLocations).put(policyLocation, policy2);
                    continue;
                }
                RulesetErrorList.add$default(lines2, "Policies " + policy2.getName() + " and " + existingPolicyInLocation.getName() + " in branch " + branch.getName() + " are both located at column " + policy2.getColumn() + " row " + policy2.getRow() + '!', null, policy2, null, 10, null);
            }
        }
        Collection<PolicyBranch> collection = this.getRuleset().getPolicyBranches().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        prereq22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PolicyBranch it = (PolicyBranch)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)it.getPolicies(), it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (Policy policy : (List)destination$iv$iv) {
            if (Intrinsics.areEqual(policy, this.getRuleset().getPolicies().get(policy.getName()))) continue;
            RulesetErrorList.add$default(lines2, "More than one policy with the name " + policy.getName() + " exists!", null, policy, null, 10, null);
        }
    }

    @Override
    protected void addPromotionErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addPromotionErrors(lines2);
        this.checkPromotionCircularReferences(lines2);
    }

    @Override
    protected void checkPromotion(@NotNull Promotion promotion, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(promotion, "promotion");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.checkPromotion(promotion, lines2);
        for (String prereq : promotion.getPrerequisites()) {
            if (this.getRuleset().getUnitPromotions().containsKey(prereq)) continue;
            RulesetErrorList.add$default(lines2, promotion.getName() + " requires promotion " + prereq + " which does not exist!", RulesetErrorSeverity.ErrorOptionsOnly, promotion, null, 8, null);
        }
        for (String unitType : promotion.getUnitTypes()) {
            this.checkUnitType(unitType, () -> BaseRulesetValidator.checkPromotion$lambda$0(lines2, promotion, unitType));
        }
    }

    private final void checkPromotionCircularReferences(RulesetErrorList lines2) {
        Iterator<Promotion> iterator2 = this.getRuleset().getUnitPromotions().values().iterator();
        while (iterator2.hasNext()) {
            Promotion promotion;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (promotion.getPrerequisites().isEmpty()) continue;
            BaseRulesetValidator.checkPromotionCircularReferences$recursiveCheck(lines2, this, new HashSet<Promotion>(), promotion, 0);
        }
    }

    @Override
    protected void addResourceErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<TileResource> iterator2 = this.getRuleset().getTileResources().values().iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (resource.getRevealedBy() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.getRuleset().getTechnologies();
                String string = resource.getRevealedBy();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource.getName() + " revealed by tech " + resource.getRevealedBy() + " which does not exist!", null, resource, null, 10, null);
                }
            }
            if (resource.getImprovement() != null) {
                LinkedHashMap<String, TileImprovement> linkedHashMap = this.getRuleset().getTileImprovements();
                String string = resource.getImprovement();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource.getName() + " improved by improvement " + resource.getImprovement() + " which does not exist!", null, resource, null, 10, null);
                }
            }
            for (String improvement : resource.getImprovedBy()) {
                if (this.getRuleset().getTileImprovements().containsKey(improvement)) continue;
                RulesetErrorList.add$default(lines2, resource.getName() + " improved by improvement " + improvement + " which does not exist!", null, resource, null, 10, null);
            }
            for (String terrain : resource.getTerrainsCanBeFoundOn()) {
                if (this.getRuleset().getTerrains().containsKey(terrain)) continue;
                RulesetErrorList.add$default(lines2, resource.getName() + " can be found on terrain " + terrain + " which does not exist!", null, resource, null, 10, null);
            }
        }
        super.addResourceErrors(lines2);
    }

    @Override
    protected void addRuinsErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addRuinsErrors(lines2);
        Iterator<RuinReward> iterator2 = this.getRuleset().getRuinRewards().values().iterator();
        while (iterator2.hasNext()) {
            RuinReward reward;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            for (String difficulty : reward.getExcludedDifficulties()) {
                if (this.getRuleset().getDifficulties().containsKey(difficulty)) continue;
                RulesetErrorList.add$default(lines2, reward.getName() + " references difficulty " + difficulty + ", which does not exist!", null, reward, null, 10, null);
            }
        }
        if (this.getAnyAncientRuins() && this.getRuleset().getRuinRewards().isEmpty()) {
            RulesetErrorList.add$default(lines2, "There are Ancient Ruins or equivalents, but not RuinRewards", null, null, null, 10, null);
        }
        if (!this.getAnyAncientRuins() && !((Map)this.getRuleset().getRuinRewards()).isEmpty()) {
            RulesetErrorList.add$default(lines2, "There are RuinRewards, but no Ancient Ruins or equivalents", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
    }

    @Override
    protected void addSpecialistErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addSpecialistErrors(lines2);
        Iterator<Specialist> iterator2 = this.getRuleset().getSpecialists().values().iterator();
        while (iterator2.hasNext()) {
            Specialist specialist;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Iterator iterator3 = ((Map)specialist.getGreatPersonPoints()).entrySet().iterator();
            while (iterator3.hasNext()) {
                String gppName = (String)iterator3.next().getKey();
                if (((Map)this.getRuleset().getUnits()).containsKey(gppName)) continue;
                RulesetErrorList.add$default(lines2, "Specialist " + specialist.getName() + " has greatPersonPoints for " + gppName + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    @Override
    protected void addTechErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addTechErrors(lines2);
        Iterator<Technology> iterator2 = this.getRuleset().getTechnologies().values().iterator();
        while (iterator2.hasNext()) {
            Technology tech;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Iterator<String> iterator3 = tech.getPrerequisites().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator<Object> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                boolean bl;
                String prereq;
                block9: {
                    Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                    if (!this.getRuleset().getTechnologies().containsKey(prereq)) {
                        RulesetErrorList.add$default(lines2, tech.getName() + " requires tech " + prereq + " which does not exist!", null, tech, null, 10, null);
                    }
                    Iterable $this$any$iv = tech.getPrerequisites();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual(it, prereq) && this.getPrereqTree(it).contains(prereq))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "No need to add " + prereq + " as a prerequisite of " + tech.getName() + " - it is already implicit from the other prerequisites!", RulesetErrorSeverity.WarningOptionsOnly, tech, null, 8, null);
                }
                if (!this.getPrereqTree(prereq).contains(tech.getName())) continue;
                RulesetErrorList.add$default(lines2, "Techs " + tech.getName() + " and " + prereq + " require each other!", null, tech, null, 10, null);
            }
            if (!((Map)this.getRuleset().getEras()).containsKey(tech.era())) {
                RulesetErrorList.add$default(lines2, "Unknown era " + tech.era() + " referenced in column of tech " + tech.getName(), null, tech, null, 10, null);
            }
            for (Object object : this.getRuleset().getTechnologies().values()) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                Technology otherTech = (Technology)object;
                if (tech.getName().compareTo(otherTech.getName()) <= 0) continue;
                TechColumn techColumn2 = otherTech.getColumn();
                techColumn2 = tech.getColumn();
                if (!Intrinsics.areEqual(techColumn != null ? Integer.valueOf(techColumn.getColumnNumber()) : null, techColumn2 != null ? Integer.valueOf(techColumn2.getColumnNumber()) : null) || otherTech.getRow() != tech.getRow()) continue;
                RulesetErrorList.add$default(lines2, tech.getName() + " is in the same row and column as " + otherTech.getName() + '!', null, tech, null, 10, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void addTerrainErrors(@NotNull RulesetErrorList lines) {
        block8: {
            block9: {
                Intrinsics.checkNotNullParameter(lines, "lines");
                v0 = this.getRuleset().getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                $this$none$iv = v0;
                $i$f$none = false;
                if (!((Collection)$this$none$iv).isEmpty()) break block9;
                v1 = true;
                break block8;
            }
            var4_5 = $this$none$iv.iterator();
            while (var4_5.hasNext()) {
                element$iv = var4_5.next();
                it = (Terrain)element$iv;
                $i$a$-none-BaseRulesetValidator$addTerrainErrors$1 = false;
                if (it.getType() != TerrainType.Land || it.getImpassable()) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.hasUnique$default(it, UniqueType.NoNaturalGeneration, null, 2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v1 = false;
                break block8;
            }
            v1 = true;
        }
        if (v1) {
            RulesetErrorList.add$default(lines, "No passable land terrains exist!", null, null, null, 10, null);
        }
        var2_2 = this.getRuleset().getTerrains().values().iterator();
        while (var2_2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var2_2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(terrain.getOccursOn().iterator(), "iterator(...)");
            while (var4_5.hasNext()) {
                v3 = var4_5.next();
                Intrinsics.checkNotNullExpressionValue(v3, "next(...)");
                baseTerrainName = (String)v3;
                baseTerrain = this.getRuleset().getTerrains().get(baseTerrainName);
                if (baseTerrain == null) {
                    RulesetErrorList.add$default(lines, terrain.getName() + " occurs on terrain " + baseTerrainName + " which does not exist!", null, terrain, null, 10, null);
                    continue;
                }
                if (baseTerrain.getType() != TerrainType.NaturalWonder) continue;
                RulesetErrorList.add$default(lines, terrain.getName() + " occurs on natural wonder " + baseTerrainName + ": Unsupported.", RulesetErrorSeverity.WarningOptionsOnly, terrain, null, 8, null);
            }
            if (terrain.getType() != TerrainType.NaturalWonder || terrain.getTurnsInto() == null) continue;
            baseTerrain = (Terrain)((Map)this.getRuleset().getTerrains()).get(terrain.getTurnsInto());
            if (baseTerrain == null) {
                RulesetErrorList.add$default(lines, terrain.getName() + " turns into terrain " + terrain.getTurnsInto() + " which does not exist!", null, terrain, null, 10, null);
                continue;
            }
            if (baseTerrain.getType().isBaseTerrain()) continue;
            RulesetErrorList.add$default(lines, terrain.getName() + " turns into terrain " + terrain.getTurnsInto() + " which is not a base terrain!", RulesetErrorSeverity.Warning, terrain, null, 8, null);
        }
        super.addTerrainErrors(lines);
    }

    @Override
    protected void addUnitErrors(@NotNull RulesetErrorList lines2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(lines2, "lines");
            Collection<BaseUnit> collection = this.getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    BaseUnit it = (BaseUnit)element$iv;
                    boolean bl2 = false;
                    if (!it.isCityFounder()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            RulesetErrorList.add$default(lines2, "No city-founding units in ruleset!", null, null, null, 10, null);
        }
        super.addUnitErrors(lines2);
    }

    @Override
    protected void checkUnit(@NotNull BaseUnit unit, @NotNull RulesetErrorList lines2) {
        String obsoleteTech;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.checkUnit(unit, lines2);
        Iterator<Object> iterator2 = unit.requiredTechs().iterator();
        while (iterator2.hasNext()) {
            String requiredTech = iterator2.next();
            if (this.getRuleset().getTechnologies().containsKey(requiredTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires tech " + requiredTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichNoLongerAvailable().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            if (this.getRuleset().getTechnologies().containsKey(obsoleteTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " obsoletes at tech " + obsoleteTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.getUpgradeUnits(GameContext.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (this.getRuleset().getUnits().containsKey(upgradesTo)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to unit " + upgradesTo + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichAutoUpgradeInProduction().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            Iterator<String> iterator3 = unit.getUpgradeUnits(GameContext.Companion.getIgnoreConditionals()).iterator();
            while (iterator3.hasNext()) {
                BaseUnit upgradedUnit;
                String upgradesTo = iterator3.next();
                if (!this.getRuleset().getUnits().containsKey(upgradesTo) || !this.getRuleset().getTechnologies().containsKey(obsoleteTech)) continue;
                Intrinsics.checkNotNull(this.getRuleset().getUnits().get(upgradesTo));
                Iterator<String> iterator4 = upgradedUnit.requiredTechs().iterator();
                while (iterator4.hasNext()) {
                    String requiredTech = iterator4.next();
                    if (Intrinsics.areEqual(requiredTech, obsoleteTech) || this.getPrereqTree(obsoleteTech).contains(requiredTech)) continue;
                    RulesetErrorList.add$default(lines2, unit.getName() + " is supposed to automatically upgrade at tech " + obsoleteTech + ", and therefore " + requiredTech + " for its upgrade " + upgradedUnit.getName() + " may not yet be researched!", RulesetErrorSeverity.Warning, unit, null, 8, null);
                }
            }
        }
        iterator2 = unit.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).keySet().iterator();
        while (iterator2.hasNext()) {
            String resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (this.getRuleset().getTileResources().containsKey(resource)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires resource " + resource + " which does not exist!", null, unit, null, 10, null);
        }
        if (unit.getReplaces() != null) {
            LinkedHashMap<String, BaseUnit> linkedHashMap = this.getRuleset().getUnits();
            String string = unit.getReplaces();
            Intrinsics.checkNotNull(string);
            if (!linkedHashMap.containsKey(string)) {
                RulesetErrorList.add$default(lines2, unit.getName() + " replaces " + unit.getReplaces() + " which does not exist!", null, unit, null, 10, null);
            }
        }
        Iterator<String> iterator5 = unit.getPromotions().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            String promotion;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (this.getRuleset().getUnitPromotions().containsKey(promotion)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " contains promotion " + promotion + " which does not exist!", null, unit, null, 10, null);
        }
        this.checkUnitType(unit.getUnitType(), () -> BaseRulesetValidator.checkUnit$lambda$0(lines2, unit));
        iterator2 = unit.getMatchingUniques(UniqueType.ConstructImprovementInstantly, GameContext.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            String improvementName = unique.getParams().get(0);
            if (this.getRuleset().getTileImprovements().get(improvementName) == null) continue;
            TileImprovement tileImprovement = this.getRuleset().getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
            if (!((Stats)tileImprovement).isEmpty() || !unit.isCivilian() || unit.isGreatPersonOfType("War")) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " can place improvement " + improvementName + " which has no stats, preventing unit automation!", RulesetErrorSeverity.WarningOptionsOnly, unit, null, 8, null);
        }
        this.checkUniqueToMisspelling(unit, unit.getUniqueTo(), lines2);
    }

    @Override
    protected void addVictoryTypeErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        super.addVictoryTypeErrors(lines2);
        Iterator<Victory> iterator2 = this.getRuleset().getVictories().values().iterator();
        while (iterator2.hasNext()) {
            Victory victoryType;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Iterator<String> iterator3 = victoryType.getRequiredSpaceshipParts().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator<Object> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                String requiredUnit;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (((Map)this.getRuleset().getUnits()).containsKey(requiredUnit)) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " requires adding the non-existant unit " + requiredUnit + " to the capital to win!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            for (Milestone milestone : victoryType.getMilestoneObjects()) {
                MilestoneType[] milestoneTypeArray = new MilestoneType[]{MilestoneType.BuiltBuilding, MilestoneType.BuildingBuiltGlobally};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf(milestoneTypeArray), milestone.getType()) || ((Map)this.getRuleset().getBuildings()).containsKey(milestone.getParams().get(0))) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " has milestone \"" + milestone.getUniqueDescription() + "\" that references an unknown building " + milestone.getParams().get(0) + '!', RulesetErrorSeverity.Error, null, null, 12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUniqueToMisspelling(IHasUniques obj, String uniqueTo, RulesetErrorList lines2) {
        void $this$flatMapTo$iv$iv;
        if (uniqueTo == null || ((Map)this.getRuleset().getNations()).containsKey(uniqueTo)) {
            return;
        }
        Collection<Nation> collection = this.getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Object object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Nation it = (Nation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getUniques();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set civUniques = CollectionsKt.toSet((List)destination$iv$iv);
        if (civUniques.contains(uniqueTo)) {
            return;
        }
        Collection collection2 = CollectionsKt.toList(civUniques);
        Set<String> set = this.getRuleset().getNations().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        List<String> possibleMisspellings = this.getPossibleMisspellings(uniqueTo, CollectionsKt.plus(collection2, (Iterable)set));
        if (possibleMisspellings.isEmpty()) {
            return;
        }
        String string = obj.getName() + " has uniqueTo \"" + uniqueTo + "\" does not match any nation/unique - may be a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, " OR ", null, null, 0, null, BaseRulesetValidator::checkUniqueToMisspelling$lambda$1, 30, null);
        object = RulesetErrorSeverity.OK;
        RulesetErrorList.add$default(lines2, string, (RulesetErrorSeverity)((Object)object), obj, null, 8, null);
    }

    private final void checkUnitType(String type, Function0<Unit> reportError) {
        if (this.getRuleset().getUnitTypes().containsKey(type)) {
            return;
        }
        if (this.getRuleset().getUnitTypes().isEmpty() && this.getVanillaRuleset().getUnitTypes().containsKey(type)) {
            return;
        }
        reportError.invoke();
    }

    private final Set<String> getPrereqTree(String technologyName) {
        if (this.prereqsHashMap.containsKey(technologyName)) {
            HashSet<String> hashSet = this.prereqsHashMap.get(technologyName);
            Intrinsics.checkNotNull(hashSet);
            return hashSet;
        }
        Technology technology = this.getRuleset().getTechnologies().get(technologyName);
        if (technology == null) {
            return SetsKt.emptySet();
        }
        Technology technology2 = technology;
        HashSet techHashSet = new HashSet();
        CollectionsKt.addAll((Collection)techHashSet, (Iterable)technology2.getPrerequisites());
        ((Map)this.prereqsHashMap).put(technologyName, techHashSet);
        Iterator<String> iterator2 = technology2.getPrerequisites().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String prerequisite;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            CollectionsKt.addAll((Collection)techHashSet, (Iterable)this.getPrereqTree(prerequisite));
        }
        return techHashSet;
    }

    private static final Ruleset vanillaRuleset_delegate$lambda$0() {
        return RulesetCache.INSTANCE.getVanillaRuleset();
    }

    private static final boolean anyAncientRuins_delegate$lambda$0(Ruleset $ruleset) {
        boolean bl;
        block1: {
            Collection<TileImprovement> collection = $ruleset.getTileImprovements().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Sequence $this$any$iv = SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)collection), BaseRulesetValidator::anyAncientRuins_delegate$lambda$0$0);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!(it.getType() == UniqueType.IsAncientRuinsEquivalent)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final Iterable anyAncientRuins_delegate$lambda$0$0(TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUniqueObjects();
    }

    private static final Unit checkPromotion$lambda$0(RulesetErrorList $lines, Promotion $promotion, String $unitType) {
        RulesetErrorList.add$default($lines, $promotion.getName() + " references unit type " + $unitType + ", which does not exist!", RulesetErrorSeverity.ErrorOptionsOnly, $promotion, null, 8, null);
        return Unit.INSTANCE;
    }

    private static final void checkPromotionCircularReferences$recursiveCheck(RulesetErrorList $lines, BaseRulesetValidator this$0, HashSet<Promotion> history, Promotion promotion, int level) {
        if (history.contains(promotion)) {
            RulesetErrorList.add$default($lines, "Circular Reference in Promotions: " + CollectionsKt.joinToString$default(history, "\u2192", null, null, 0, null, BaseRulesetValidator::checkPromotionCircularReferences$recursiveCheck$lambda$0, 30, null) + '\u2192' + promotion.getName(), RulesetErrorSeverity.Warning, promotion, null, 8, null);
            return;
        }
        if (level > 99) {
            return;
        }
        history.add((Promotion)promotion);
        for (String prerequisiteName : promotion.getPrerequisites()) {
            Promotion prerequisite;
            if (this$0.getRuleset().getUnitPromotions().get(prerequisiteName) == null) continue;
            HashSet linkedSetToPass = promotion.getPrerequisites().size() == 1 ? history : (HashSet)CollectionsKt.toCollection(history, (Collection)new HashSet());
            BaseRulesetValidator.checkPromotionCircularReferences$recursiveCheck($lines, this$0, linkedSetToPass, prerequisite, level + 1);
        }
    }

    private static final CharSequence checkPromotionCircularReferences$recursiveCheck$lambda$0(Promotion it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final Unit checkUnit$lambda$0(RulesetErrorList $lines, BaseUnit $unit) {
        RulesetErrorList.add$default($lines, $unit.getName() + " is of type " + $unit.getUnitType() + ", which does not exist!", null, $unit, null, 10, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence checkUniqueToMisspelling$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '\"' + it + '\"';
    }
}

