/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.RoadImage;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0006\u0010 \u001a\u00020\u000eR*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerFeatures;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "roadImages", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/ui/components/tilegroups/layers/RoadImage;", "Lkotlin/collections/HashMap;", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "updateRoadImages", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "doUpdate", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "dim", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerFeatures.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class TileLayerFeatures
extends TileLayer {
    @NotNull
    private final HashMap<Tile, RoadImage> roadImages;

    public TileLayerFeatures(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.roadImages = new HashMap();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private final void updateRoadImages(Civilization viewingCiv) {
        if (this.getTileGroup().isForMapEditorIcon()) {
            return;
        }
        Tile tile = this.getTileGroup().getTile();
        boolean isTileVisible = viewingCiv == null || tile.isVisible(viewingCiv);
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            RoadStatus roadStatus;
            Tile neighbor = iterator2.next();
            RoadImage roadImage = this.roadImages.get(neighbor);
            if (roadImage == null) {
                RoadImage roadImage2;
                RoadImage it = roadImage2 = new RoadImage();
                boolean bl = false;
                ((Map)this.roadImages).put(neighbor, it);
                roadImage = roadImage2;
            }
            RoadImage roadImage3 = roadImage;
            RoadStatus roadStatus2 = !isTileVisible && viewingCiv != null && !neighbor.isVisible(viewingCiv) ? RoadStatus.None : (tile.getRoadStatus() == RoadStatus.None || neighbor.getRoadStatus() == RoadStatus.None ? RoadStatus.None : (roadStatus = tile.getRoadStatus() == RoadStatus.Road || neighbor.getRoadStatus() == RoadStatus.Road ? RoadStatus.Road : RoadStatus.Railroad));
            if (roadImage3.getRoadStatus() == roadStatus) continue;
            roadImage3.setRoadStatus(roadStatus);
            if (roadImage3.getImage() != null) {
                Image image = roadImage3.getImage();
                Intrinsics.checkNotNull(image);
                image.remove();
                roadImage3.setImage(null);
            }
            if (roadStatus == RoadStatus.None) continue;
            Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().orFallback(arg_0 -> TileLayerFeatures.updateRoadImages$lambda$1(roadStatus, arg_0)), null, 2, null);
            roadImage3.setImage(image);
            Vector2 relativeWorldPosition = tile.getTileMap().getNeighborTilePositionAsWorldCoords(tile, neighbor);
            image.moveBy(25.0f, 25.0f);
            image.moveBy(-relativeWorldPosition.x * 0.8f * 25.0f, -relativeWorldPosition.y * 0.8f * 25.0f);
            image.setSize(10.0f, 6.0f);
            image.setOrigin(0.0f, 3.0f);
            image.setRotation((float)(57.29577951308232 * Math.atan2(relativeWorldPosition.y, relativeWorldPosition.x)));
            this.addActor(image);
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.updateRoadImages(viewingCiv);
    }

    public final void dim() {
        this.getColor().a = 0.5f;
    }

    private static final String updateRoadImages$lambda$1(RoadStatus $roadStatus, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        String string = $this$orFallback.getRoadsMap().get($roadStatus);
        Intrinsics.checkNotNull(string);
        return string;
    }
}

