/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleCityCommands$subcommands$lambda$10$;
import com.unciv.ui.screens.devconsole.ConsoleCityCommands$subcommands$lambda$9$;
import com.unciv.ui.screens.devconsole.ConsoleCommand;
import com.unciv.ui.screens.devconsole.ConsoleCommandNode;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R0\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleCityCommands;", "Lcom/unciv/ui/screens/devconsole/ConsoleCommandNode;", "<init>", "()V", "subcommands", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/devconsole/ConsoleCommand;", "Lkotlin/collections/HashMap;", "getSubcommands", "()Ljava/util/HashMap;", "core"})
@SourceDebugExtension(value={"SMAP\nConsoleCityCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleCityCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleCityCommands\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput$Companion\n*L\n1#1,101:1\n2275#2,2:102\n477#2:105\n477#2:107\n254#3:104\n254#3:106\n*S KotlinDebug\n*F\n+ 1 ConsoleCityCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleCityCommands\n*L\n48#1:102,2\n87#1:105\n94#1:107\n87#1:104\n94#1:106\n*E\n"})
public final class ConsoleCityCommands
implements ConsoleCommandNode {
    @NotNull
    private final HashMap<String, ConsoleCommand> subcommands;

    public ConsoleCityCommands() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("checkfilter", new ConsoleAction("city checkfilter <cityFilter>", ConsoleCityCommands::subcommands$lambda$0)), TuplesKt.to("add", new ConsoleAction("city add <civName>", ConsoleCityCommands::subcommands$lambda$1)), TuplesKt.to("remove", new ConsoleAction("city remove", ConsoleCityCommands::subcommands$lambda$2)), TuplesKt.to("setpop", new ConsoleAction("city setpop <amount>", ConsoleCityCommands::subcommands$lambda$3)), TuplesKt.to("setname", new ConsoleAction("city setname <\"name\">", ConsoleCityCommands::subcommands$lambda$4)), TuplesKt.to("addtile", new ConsoleAction("city addtile <cityName> [radius]", ConsoleCityCommands::subcommands$lambda$5)), TuplesKt.to("removetile", new ConsoleAction("city removetile", ConsoleCityCommands::subcommands$lambda$6)), TuplesKt.to("religion", new ConsoleAction("city religion <religionName> <\u00b1pressure>", ConsoleCityCommands::subcommands$lambda$7)), TuplesKt.to("sethealth", new ConsoleAction("city sethealth [amount]", ConsoleCityCommands::subcommands$lambda$8)), TuplesKt.to("addbuilding", new ConsoleAction("city addbuilding <buildingName>", ConsoleCityCommands::subcommands$lambda$9)), TuplesKt.to("removebuilding", new ConsoleAction("city removebuilding <buildingName>", ConsoleCityCommands::subcommands$lambda$10))};
        this.subcommands = MapsKt.hashMapOf(pairArray);
    }

    @Override
    @NotNull
    public HashMap<String, ConsoleCommand> getSubcommands() {
        return this.subcommands;
    }

    private static final DevConsoleResponse subcommands$lambda$0(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        return DevConsoleResponse.Companion.hint(String.valueOf(City.matchesFilter$default(city, ((CliInput)params.get(0)).originalUnquoted(), null, false, 6, null)));
    }

    private static final DevConsoleResponse subcommands$lambda$1(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        Civilization civ = console.getCivByName$core((CliInput)params.get(0));
        if (!civ.isMajorCiv() && !civ.isCityState()) {
            throw new ConsoleErrorException("Can only add cities to major civs or city states");
        }
        Tile selectedTile = console.getSelectedTile$core();
        if (selectedTile.isCityCenter()) {
            throw new ConsoleErrorException("Tile already contains a city center");
        }
        Civilization.addCity$default(civ, selectedTile.getPosition(), null, 2, null);
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$2(DevConsolePopup console, List list2) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(list2, "<unused var>");
        City city = console.getSelectedCity$core();
        city.destroyCity(true);
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$3(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        int newPop = ((CliInput)params.get(0)).toInt();
        if (newPop < 1) {
            throw new ConsoleErrorException("Population must be at least 1");
        }
        city.getPopulation().setPopulation(newPop);
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$4(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        city.setName(((CliInput)params.get(0)).originalUnquoted());
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$5(DevConsolePopup console, List params) {
        boolean bl;
        City city;
        Tile selectedTile;
        block4: {
            Intrinsics.checkNotNullParameter(console, "console");
            Intrinsics.checkNotNullParameter(params, "params");
            selectedTile = console.getSelectedTile$core();
            city = console.getCity$core((CliInput)params.get(0));
            Sequence<Tile> $this$none$iv = selectedTile.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getCity(), city)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            throw new ConsoleErrorException("Tile is not adjacent to any tile already owned by the city");
        }
        if (selectedTile.isCityCenter()) {
            throw new ConsoleErrorException("Cannot transfer city center");
        }
        CliInput cliInput = (CliInput)CollectionsKt.getOrNull(params, 1);
        int radius = cliInput != null ? cliInput.toInt() : 0;
        Iterator<Tile> iterator3 = selectedTile.getTilesInDistance(radius).iterator();
        while (iterator3.hasNext()) {
            Tile tile = iterator3.next();
            if (Intrinsics.areEqual(tile.getCity(), city) || tile.isCityCenter()) continue;
            city.getExpansion().takeOwnership(tile);
        }
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$6(DevConsolePopup console, List list2) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(list2, "<unused var>");
        Tile selectedTile = console.getSelectedTile$core();
        City city = console.getSelectedCity$core();
        city.getExpansion().relinquishOwnership(selectedTile);
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$7(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        CliInput cliInput = (CliInput)params.get(0);
        Set<String> set = console.getGameInfo$core().getReligions().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Object t = cliInput.findOrNull((Iterable)set);
        if (t == null) {
            throw new ConsoleErrorException("" + '\'' + params.get(0) + "' is not a known religion");
        }
        Object religion = t;
        int pressure = ((CliInput)params.get(1)).toInt();
        CityReligionManager.addPressure$default(city.getReligion(), religion, RangesKt.coerceAtLeast(pressure, -((Number)city.getReligion().getPressures().get(religion)).intValue()), false, 4, null);
        city.getReligion().updatePressureOnPopulationChange(0);
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$8(DevConsolePopup console, List params) {
        int health;
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        int maxHealth = city.getMaxHealth$core();
        CliInput cliInput = (CliInput)CollectionsKt.firstOrNull(params);
        int n = health = cliInput != null ? cliInput.toInt() : maxHealth;
        if (!(1 <= health ? health <= maxHealth : false)) {
            throw new ConsoleErrorException("Number out of range");
        }
        city.setHealth(health);
        return DevConsoleResponse.Companion.getOK();
    }

    /*
     * WARNING - void declaration
     */
    private static final DevConsoleResponse subcommands$lambda$9(DevConsolePopup console, List params) {
        void $this$findCliInput$iv;
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        CliInput.Companion companion = CliInput.Companion;
        DevConsolePopup devConsolePopup = console;
        CliInput param$iv = (CliInput)params.get(0);
        boolean $i$f$findCliInput = false;
        Sequence<IRulesetObject> $this$filterIsInstance$iv$iv = $this$findCliInput$iv.getGameInfo$core().getRuleset().allRulesetObjects();
        boolean $i$f$filterIsInstance = false;
        Sequence<IRulesetObject> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, subcommands$lambda$9$$inlined$findCliInput$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<T of com.unciv.ui.screens.devconsole.CliInput.Companion.findCliInput>");
        Building building = (Building)param$iv.findOrNull(sequence);
        if (building == null) {
            throw new ConsoleErrorException("Unknown building");
        }
        Building building2 = building;
        CityConstructions.addBuilding$default(city.getCityConstructions(), building2, false, 2, null);
        return DevConsoleResponse.Companion.getOK();
    }

    /*
     * WARNING - void declaration
     */
    private static final DevConsoleResponse subcommands$lambda$10(DevConsolePopup console, List params) {
        void $this$findCliInput$iv;
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        City city = console.getSelectedCity$core();
        CliInput.Companion companion = CliInput.Companion;
        DevConsolePopup devConsolePopup = console;
        CliInput param$iv = (CliInput)params.get(0);
        boolean $i$f$findCliInput = false;
        Sequence<IRulesetObject> $this$filterIsInstance$iv$iv = $this$findCliInput$iv.getGameInfo$core().getRuleset().allRulesetObjects();
        boolean $i$f$filterIsInstance = false;
        Sequence<IRulesetObject> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, subcommands$lambda$10$$inlined$findCliInput$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<T of com.unciv.ui.screens.devconsole.CliInput.Companion.findCliInput>");
        Building building = (Building)param$iv.findOrNull(sequence);
        if (building == null) {
            throw new ConsoleErrorException("Unknown building");
        }
        Building building2 = building;
        city.getCityConstructions().removeBuilding(building2);
        return DevConsoleResponse.Companion.getOK();
    }
}

