/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Scaling;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleCommandRoot;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 U2\u00020\u0001:\u0001UB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u0010\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u001cH\u0002J\r\u00103\u001a\u00020-H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020-H\u0002J\b\u00106\u001a\u00020-H\u0002J\u001f\u00107\u001a\u00020-2\b\u00108\u001a\u0004\u0018\u00010\n2\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020=H\u0002J\u0016\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n\u0018\u00010?H\u0002J\u0015\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0000\u00a2\u0006\u0002\bDJ\u0017\u0010E\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CH\u0000\u00a2\u0006\u0002\bFJ\u0017\u0010G\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CH\u0000\u00a2\u0006\u0002\bHJ\r\u0010I\u001a\u00020JH\u0000\u00a2\u0006\u0002\bKJ\r\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u0015\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020CH\u0000\u00a2\u0006\u0002\bQJ\r\u0010R\u001a\u00020SH\u0000\u00a2\u0006\u0002\bTR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R1\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f*\u0004\b\f\u0010\rR1\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138B@BX\u0082\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019*\u0004\b\u0015\u0010\rR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006V"}, d2={"Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "Lcom/unciv/ui/popups/Popup;", "screen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "history", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getHistory$delegate", "(Lcom/unciv/ui/screens/devconsole/DevConsolePopup;)Ljava/lang/Object;", "getHistory", "()Ljava/util/ArrayList;", "history$receiver", "Lcom/unciv/models/metadata/GameSettings;", "<set-?>", "", "keepOpen", "getKeepOpen$delegate", "getKeepOpen", "()Z", "setKeepOpen", "(Z)V", "keepOpen$receiver", "currentHistoryEntry", "", "textField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "responseLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "inputWrapper", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "commandRoot", "Lcom/unciv/ui/screens/devconsole/ConsoleCommandRoot;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo$core", "()Lcom/unciv/logic/GameInfo;", "getAutocompleteButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getHistoryButtons", "onAutocomplete", "", "onAltDelete", "onAltRight", "onAltLeft", "navigateHistory", "delta", "showHistory", "showHistory$core", "onEnter", "addHistory", "showResponse", "message", "color", "Lcom/badlogic/gdx/graphics/Color;", "showResponse$core", "handleCommand", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "getAutocomplete", "Lkotlin/Pair;", "getCivByName", "Lcom/unciv/logic/civilization/Civilization;", "name", "Lcom/unciv/ui/screens/devconsole/CliInput;", "getCivByName$core", "getCivByNameOrSelected", "getCivByNameOrSelected$core", "getCivByNameOrNull", "getCivByNameOrNull$core", "getSelectedTile", "Lcom/unciv/logic/map/tile/Tile;", "getSelectedTile$core", "getSelectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity$core", "getCity", "cityName", "getCity$core", "getSelectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit$core", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDevConsolePopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevConsolePopup.kt\ncom/unciv/ui/screens/devconsole/DevConsolePopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,257:1\n1#2:258\n295#3,2:259\n183#4,2:261\n*S KotlinDebug\n*F\n+ 1 DevConsolePopup.kt\ncom/unciv/ui/screens/devconsole/DevConsolePopup\n*L\n236#1:259,2\n245#1:261,2\n*E\n"})
public final class DevConsolePopup
extends Popup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldScreen screen;
    @NotNull
    private final GameSettings history$receiver;
    @NotNull
    private final GameSettings keepOpen$receiver;
    private int currentHistoryEntry;
    @NotNull
    private final UncivTextField textField;
    @NotNull
    private final Label responseLabel;
    @NotNull
    private final Table inputWrapper;
    @NotNull
    private final ConsoleCommandRoot commandRoot;
    @NotNull
    private final GameInfo gameInfo;
    private static final int maxHistorySize = 42;

    /*
     * WARNING - void declaration
     */
    public DevConsolePopup(@NotNull WorldScreen screen) {
        void $this$responseLabel_u24lambda_u240;
        Label label;
        Intrinsics.checkNotNullParameter(screen, "screen");
        super(screen, null, 0.0f, 6, null);
        this.screen = screen;
        this.history$receiver = this.screen.getGame().getSettings();
        this.keepOpen$receiver = this.screen.getGame().getSettings();
        this.currentHistoryEntry = this.getHistory().size();
        this.textField = new UncivTextField("", null, null, 6, null);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label label2 = label = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        DevConsolePopup devConsolePopup = this;
        boolean bl = false;
        $this$responseLabel_u24lambda_u240.setWrap(true);
        devConsolePopup.responseLabel = label;
        this.inputWrapper = new Table();
        this.commandRoot = new ConsoleCommandRoot();
        this.gameInfo = this.screen.getGameInfo();
        this.add((Actor)Scene2dExtensionsKt.toLabel$default("Developer Console {}", null, 24, 0, false, 13, null)).growX();
        this.add((Actor)Scene2dExtensionsKt.toCheckBox("Keep open {}", this.getKeepOpen(), arg_0 -> DevConsolePopup._init_$lambda$0(this, arg_0))).right().row();
        this.inputWrapper.defaults().space(5.0f);
        if (!GUI.INSTANCE.getKeyboardAvailable()) {
            this.inputWrapper.add(this.getAutocompleteButton());
        }
        this.inputWrapper.add((Actor)this.textField).growX();
        if (!GUI.INSTANCE.getKeyboardAvailable()) {
            this.inputWrapper.add(this.getHistoryButtons());
        }
        this.add((Actor)this.inputWrapper).minWidth(this.getStageToShowOn().getWidth() / (float)2).growX().colspan(2).row();
        this.textField.addAction(Actions.delay(0.05f, Actions.run(() -> DevConsolePopup._init_$lambda$1(this))));
        this.add((Actor)this.responseLabel).colspan(2).maxWidth(this.screen.getStage().getWidth() * 0.8f);
        ActivationExtensionsKt.getKeyShortcuts(this).add(KeyCharAndCode.Companion.getBACK(), () -> DevConsolePopup._init_$lambda$2(this));
        ActivationExtensionsKt.getKeyShortcuts(this.textField).add(66, new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DevConsolePopup)this.receiver).onEnter();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.textField).add(KeyCharAndCode.Companion.getTAB(), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DevConsolePopup)this.receiver).onAutocomplete();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.textField).add(KeyCharAndCode.Companion.ctrlFromCode(67), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DevConsolePopup)this.receiver).onAltDelete();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.textField).add(KeyCharAndCode.Companion.ctrlFromCode(22), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DevConsolePopup)this.receiver).onAltRight();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.textField).add(KeyCharAndCode.Companion.ctrlFromCode(21), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DevConsolePopup)this.receiver).onAltLeft();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(19, () -> DevConsolePopup._init_$lambda$3(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(20, () -> DevConsolePopup._init_$lambda$4(this));
        if (Gdx.app.getType() != Application.ApplicationType.Android) {
            this.setFillParent(false);
        }
        this.open(true);
        this.screen.getStage().setKeyboardFocus(this.textField);
    }

    @NotNull
    public final WorldScreen getScreen() {
        return this.screen;
    }

    private final ArrayList<String> getHistory() {
        return this.history$receiver.getConsoleCommandHistory();
    }

    private static Object getHistory$delegate(DevConsolePopup devConsolePopup) {
        return Reflection.property0(new PropertyReference0Impl((Object)devConsolePopup.history$receiver, GameSettings.class, "consoleCommandHistory", "getConsoleCommandHistory()Ljava/util/ArrayList;", 0));
    }

    private final boolean getKeepOpen() {
        return this.keepOpen$receiver.getKeepConsoleOpen();
    }

    private final void setKeepOpen(boolean bl) {
        this.keepOpen$receiver.setKeepConsoleOpen(bl);
    }

    private static Object getKeepOpen$delegate(DevConsolePopup devConsolePopup) {
        return Reflection.mutableProperty0(new MutablePropertyReference0Impl((Object)devConsolePopup.keepOpen$receiver, GameSettings.class, "keepConsoleOpen", "getKeepConsoleOpen()Z", 0));
    }

    @NotNull
    public final GameInfo getGameInfo$core() {
        return this.gameInfo;
    }

    private final Actor getAutocompleteButton() {
        Actor actor = ImageGetter.getArrowImage$default(ImageGetter.INSTANCE, 0, 1, null);
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        return ActivationExtensionsKt.onClick(Scene2dExtensionsKt.surroundWithCircle$default(actor, 50.0f, false, color, null, 10, null), new Function0<Unit>((Object)this){

            public final void invoke() {
                DevConsolePopup.access$onAutocomplete((DevConsolePopup)this.receiver);
            }
        });
    }

    private final Actor getHistoryButtons() {
        Table group = new Table();
        group.add((Actor)DevConsolePopup.getHistoryButtons$getArrow(this, 90.0f, -1)).size(36.0f, 16.0f).padBottom(4.0f).row();
        group.add((Actor)DevConsolePopup.getHistoryButtons$getArrow(this, -90.0f, 1)).size(36.0f, 16.0f);
        group.setSize(40.0f, 40.0f);
        Actor actor = group;
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        return ActivationExtensionsKt.onRightClick$default(Scene2dExtensionsKt.surroundWithCircle$default(actor, 50.0f, false, color, null, 8, null), null, new Function0<Unit>((Object)this){

            public final void invoke() {
                ((DevConsolePopup)this.receiver).showHistory$core();
            }
        }, 1, null);
    }

    private final void onAutocomplete() {
        Pair<Integer, String> pair = this.getAutocomplete();
        if (pair == null) {
            return;
        }
        Pair<Integer, String> pair2 = pair;
        int toRemove = ((Number)pair2.component1()).intValue();
        String toAdd = pair2.component2();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this.textField.setText(stringBuilder.append(DevConsolePopup.onAutocomplete$removeFromEnd(string, toRemove)).append(toAdd).toString());
        this.textField.setCursorPosition(Integer.MAX_VALUE);
        this.pack();
    }

    private final void onAltDelete() {
        Input input2 = Gdx.input;
        Intrinsics.checkNotNullExpressionValue(input2, "input");
        if (!Scene2dExtensionsKt.isAltKeyPressed(input2)) {
            return;
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DevConsolePopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        String text2 = DevConsolePopup.access$getTextField$p(this.this$0).getText();
                        Intrinsics.checkNotNull(text2);
                        int lastSpace = StringsKt.lastIndexOf$default((CharSequence)text2, ' ', DevConsolePopup.access$getTextField$p(this.this$0).getCursorPosition() - 1, false, 4, null);
                        if (lastSpace == -1) {
                            String string = text2;
                            int n = 0;
                            int n2 = DevConsolePopup.access$getTextField$p(this.this$0).getCursorPosition();
                            DevConsolePopup.access$getTextField$p(this.this$0).setText(((Object)StringsKt.removeRange((CharSequence)string, n, n2)).toString());
                            return Unit.INSTANCE;
                        }
                        String string = text2;
                        int n = lastSpace + 1;
                        int n3 = DevConsolePopup.access$getTextField$p(this.this$0).getCursorPosition();
                        DevConsolePopup.access$getTextField$p(this.this$0).setText(((Object)StringsKt.removeRange((CharSequence)string, n, n3)).toString());
                        DevConsolePopup.access$getTextField$p(this.this$0).setCursorPosition(lastSpace + 1);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void onAltRight() {
        Input input2 = Gdx.input;
        Intrinsics.checkNotNullExpressionValue(input2, "input");
        if (!Scene2dExtensionsKt.isAltKeyPressed(input2)) {
            return;
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DevConsolePopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        String text2 = DevConsolePopup.access$getTextField$p(this.this$0).getText();
                        Intrinsics.checkNotNull(text2);
                        int nextSpace = StringsKt.indexOf$default((CharSequence)text2, ' ', DevConsolePopup.access$getTextField$p(this.this$0).getCursorPosition(), false, 4, null);
                        if (nextSpace == -1) {
                            DevConsolePopup.access$getTextField$p(this.this$0).setCursorPosition(text2.length());
                            return Unit.INSTANCE;
                        }
                        DevConsolePopup.access$getTextField$p(this.this$0).setCursorPosition(nextSpace);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void onAltLeft() {
        Input input2 = Gdx.input;
        Intrinsics.checkNotNullExpressionValue(input2, "input");
        if (!Scene2dExtensionsKt.isAltKeyPressed(input2)) {
            return;
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DevConsolePopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        String text2 = DevConsolePopup.access$getTextField$p(this.this$0).getText();
                        Intrinsics.checkNotNull(text2);
                        int previousSpace = StringsKt.lastIndexOf$default((CharSequence)text2, ' ', DevConsolePopup.access$getTextField$p(this.this$0).getCursorPosition() - 1, false, 4, null);
                        if (previousSpace == -1) {
                            DevConsolePopup.access$getTextField$p(this.this$0).setCursorPosition(0);
                            return Unit.INSTANCE;
                        }
                        DevConsolePopup.access$getTextField$p(this.this$0).setCursorPosition(previousSpace);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void navigateHistory(int delta) {
        if (this.getHistory().isEmpty()) {
            return;
        }
        this.currentHistoryEntry = RangesKt.coerceIn(this.currentHistoryEntry + delta, CollectionsKt.getIndices((Collection)this.getHistory()));
        this.textField.setText(this.getHistory().get(this.currentHistoryEntry));
        this.textField.setCursorPosition(this.textField.getText().length());
    }

    public final void showHistory$core() {
        if (this.getHistory().isEmpty()) {
            return;
        }
        Stage stage = this.getStageToShowOn();
        Popup popup2 = new Popup(this, stage){
            {
                Iterator<T> iterator2 = ((Iterable)DevConsolePopup.access$getHistory($receiver)).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index = n++;
                    String entry = (String)iterator2.next();
                    Label label = new Label((CharSequence)entry, this.getSkin());
                    ActivationExtensionsKt.onClick(label, () -> showHistory.popup.1._init_$lambda$0($receiver, index, this));
                    this.add((Actor)label).row();
                }
                this.setClickBehindToClose(true);
                if ($receiver.getScreen().getGame().getSettings().getForbidPopupClickBehindToClose()) {
                    Popup.addCloseButton$default(this, null, null, null, null, 15, null);
                }
                this.getShowListeners().add(() -> showHistory.popup.1._init_$lambda$1(this));
            }

            private static final Unit _init_$lambda$0(DevConsolePopup this$0, int $index, showHistory.popup.1 this$1) {
                DevConsolePopup.access$setCurrentHistoryEntry$p(this$0, $index);
                DevConsolePopup.access$navigateHistory(this$0, 0);
                this$1.close();
                return Unit.INSTANCE;
            }

            private static final Unit _init_$lambda$1(showHistory.popup.1 this$0) {
                block0: {
                    ScrollPane scrollPane = this$0.getScrollPane();
                    if (scrollPane == null) break block0;
                    ScrollPane $this$lambda_u241_u240 = scrollPane;
                    boolean bl = false;
                    $this$lambda_u241_u240.setScrollY($this$lambda_u241_u240.getMaxY());
                }
                return Unit.INSTANCE;
            }
        };
        popup2.open(true);
    }

    private final void onEnter() {
        DevConsoleResponse handleCommandResponse = this.handleCommand();
        if (handleCommandResponse.isOK()) {
            this.screen.setShouldUpdate(true);
            this.addHistory();
            if (!this.getKeepOpen()) {
                this.close();
            } else {
                this.textField.setText("");
            }
            return;
        }
        this.showResponse$core(handleCommandResponse.getMessage(), handleCommandResponse.getColor());
    }

    private final void addHistory() {
        String text2 = this.textField.getText();
        Intrinsics.checkNotNull(text2);
        if (StringsKt.isBlank(text2)) {
            return;
        }
        if (!((Collection)this.getHistory()).isEmpty() && StringsKt.equals((String)CollectionsKt.last((List)this.getHistory()), text2, true)) {
            return;
        }
        if (this.getHistory().size() >= 42) {
            CollectionsKt.removeAll((List)this.getHistory(), arg_0 -> DevConsolePopup.addHistory$lambda$0(text2, arg_0));
            if (this.getHistory().size() >= 42) {
                this.getHistory().remove(0);
            }
        }
        this.getHistory().add(this.textField.getText());
        this.currentHistoryEntry = this.getHistory().size();
    }

    public final void showResponse$core(@Nullable String message, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.responseLabel.setText(message);
        this.responseLabel.getStyle().fontColor = color;
    }

    private final DevConsoleResponse handleCommand() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        List<CliInput> params = CliInput.Companion.splitToCliInput(((Object)StringsKt.trim((CharSequence)string)).toString());
        return this.commandRoot.handle(this, params);
    }

    private final Pair<Integer, String> getAutocomplete() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        List<CliInput> params = CliInput.Companion.splitToCliInput(string);
        String string2 = this.commandRoot.autocomplete(this, params);
        if (string2 == null) {
            return null;
        }
        String autoCompleteString = string2;
        CliInput cliInput = CollectionsKt.lastOrNull(params);
        int replaceLength = cliInput != null ? cliInput.originalLength() : 0;
        return TuplesKt.to(replaceLength, autoCompleteString);
    }

    @NotNull
    public final Civilization getCivByName$core(@NotNull CliInput name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Civilization civilization = this.getCivByNameOrNull$core(name);
        if (civilization == null) {
            throw new ConsoleErrorException("Unknown civ: " + name);
        }
        return civilization;
    }

    @NotNull
    public final Civilization getCivByNameOrSelected$core(@Nullable CliInput name) {
        Object object;
        block3: {
            block2: {
                object = name;
                if (object == null) break block2;
                CliInput it = object;
                boolean bl = false;
                Civilization civilization = this.getCivByName$core(it);
                object = civilization;
                if (civilization != null) break block3;
            }
            object = this.screen.getSelectedCiv();
        }
        return object;
    }

    @Nullable
    public final Civilization getCivByNameOrNull$core(@NotNull CliInput name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$firstOrNull$iv = this.gameInfo.getCivilizations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!name.equals(it.getCivName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Tile getSelectedTile$core() {
        Tile tile = this.screen.getMapHolder().getSelectedTile$core();
        if (tile == null) {
            throw new ConsoleErrorException("Select tile");
        }
        return tile;
    }

    @NotNull
    public final City getSelectedCity$core() {
        City city = this.getSelectedTile$core().getCity();
        if (city == null) {
            throw new ConsoleErrorException("Select tile belonging to city");
        }
        return city;
    }

    @NotNull
    public final City getCity$core(@NotNull CliInput cityName) {
        City city;
        block2: {
            Intrinsics.checkNotNullParameter(cityName, "cityName");
            Sequence<City> $this$firstOrNull$iv = this.gameInfo.getCities();
            boolean $i$f$firstOrNull = false;
            Iterator<City> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl = false;
                if (!cityName.equals(it.getName())) continue;
                city = element$iv;
                break block2;
            }
            city = null;
        }
        City city2 = city;
        if (city2 == null) {
            throw new ConsoleErrorException("Unknown city: " + cityName);
        }
        return city2;
    }

    @NotNull
    public final MapUnit getSelectedUnit$core() {
        Tile selectedTile = this.getSelectedTile$core();
        if (selectedTile.getFirstUnit() == null) {
            throw new ConsoleErrorException("Select tile with units");
        }
        List<MapUnit> units = SequencesKt.toList(selectedTile.getUnits());
        MapUnit selectedUnit = this.screen.getBottomUnitTable$core().getSelectedUnit();
        return selectedUnit != null && Intrinsics.areEqual(selectedUnit.getTile(), selectedTile) ? selectedUnit : CollectionsKt.first(units);
    }

    private static final Unit _init_$lambda$0(DevConsolePopup this$0, boolean it) {
        this$0.setKeepOpen(it);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(DevConsolePopup this$0) {
        this$0.textField.setText("");
    }

    private static final Unit _init_$lambda$2(DevConsolePopup this$0) {
        this$0.close();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(DevConsolePopup this$0) {
        this$0.navigateHistory(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(DevConsolePopup this$0) {
        this$0.navigateHistory(1);
        return Unit.INSTANCE;
    }

    private static final Image getHistoryButtons$getArrow(DevConsolePopup this$0, float rotation, int delta) {
        Image image;
        Image $this$getHistoryButtons_u24getArrow_u24lambda_u240 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/ForwardArrow", null, 2, null);
        boolean bl = false;
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setName(delta > 0 ? "down" : "up");
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setScaling(Scaling.fillX);
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setSize(36.0f, 16.0f);
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setScaleX(0.75f);
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setOrigin(18.0f, 8.0f);
        $this$getHistoryButtons_u24getArrow_u24lambda_u240.setRotation(rotation);
        ActivationExtensionsKt.onClick($this$getHistoryButtons_u24getArrow_u24lambda_u240, () -> DevConsolePopup.getHistoryButtons$getArrow$lambda$0$0(this$0, delta));
        return image;
    }

    private static final Unit getHistoryButtons$getArrow$lambda$0$0(DevConsolePopup this$0, int $delta) {
        this$0.navigateHistory($delta);
        return Unit.INSTANCE;
    }

    private static final String onAutocomplete$removeFromEnd(String $this$onAutocomplete_u24removeFromEnd, int n) {
        String string = $this$onAutocomplete_u24removeFromEnd.substring(0, RangesKt.coerceAtLeast($this$onAutocomplete_u24removeFromEnd.length() - n, 0));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    private static final boolean addHistory$lambda$0(String $text, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.equals(it, $text, true);
    }

    public static final /* synthetic */ UncivTextField access$getTextField$p(DevConsolePopup $this) {
        return $this.textField;
    }

    public static final /* synthetic */ ArrayList access$getHistory(DevConsolePopup $this) {
        return $this.getHistory();
    }

    public static final /* synthetic */ void access$setCurrentHistoryEntry$p(DevConsolePopup $this, int n) {
        $this.currentHistoryEntry = n;
    }

    public static final /* synthetic */ void access$navigateHistory(DevConsolePopup $this, int delta) {
        $this.navigateHistory(delta);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/devconsole/DevConsolePopup$Companion;", "", "<init>", "()V", "maxHistorySize", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

